const char rcsid_windriver_c[] = "@(#)$KmKId: windriver.c,v 1.15 2022-02-12 01:32:03+00 kentd Exp $";

/************************************************************************/
/*			KEGS: Apple //gs Emulator			*/
/*			Copyright 2002-2022 by Kent Dickey		*/
/*									*/
/*	This code is covered by the GNU GPL v3				*/
/*	See the file COPYING.txt or https://www.gnu.org/licenses/	*/
/*	This program is provided with no warranty			*/
/*									*/
/*	The KEGS web page is kegs.sourceforge.net			*/
/*	You may contact the author at: kadickey@alumni.princeton.edu	*/
/************************************************************************/

// Based on code from Chea Chee Keong from KEGS32, which was available at
//  http://www.geocities.com/akilgard/kegs32 (geocities is gone now)

#define WIN32_LEAN_AND_MEAN	/* Tell windows we want less header gunk */
#define STRICT			/* Tell Windows we want compile type checks */

#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <winsock.h>
#include <commctrl.h>

#include "defc.h"
#include "win_dirent.h"
#include "protos_windriver.h"

extern int Verbose;

extern int g_warp_pointer;
extern int g_force_depth;

extern int g_quit_sim_now;

int	g_has_focus = 0;
int	g_auto_repeat_on = -1;

extern Kimage g_mainwin_kimage;

HDC	g_main_dc;
HDC	g_main_cdc;

int	g_win_capslock_down = 0;

extern word32 g_palette_8to1624[256];
extern word32 g_a2palette_8to1624[256];

extern word32 g_full_refresh_needed;

extern int g_border_sides_refresh_needed;
extern int g_border_special_refresh_needed;
extern int g_status_refresh_needed;

extern int g_lores_colors[];
extern int g_cur_a2_stat;

extern int g_a2vid_palette;

extern int g_screen_redraw_skip_amt;

extern word32 g_a2_screen_buffer_changed;

HWND	g_hwnd_main;
BITMAPINFO *g_bmapinfo_ptr = 0;
volatile BITMAPINFOHEADER *g_bmaphdr_ptr = 0;
HBITMAP g_mainwin_dev_handle = 0;
byte	*g_mainwin_data_ptr = 0;
int	g_mainwin_pixels_per_line = 0;

int g_num_a2_keycodes = 0;

extern char *g_status_ptrs[MAX_STATUS_LINES];

int g_win_button_states = 0;


/* this table is used to search for the Windows VK_* in col 1 or 2 */
/* flags bit 8 is or'ed into the VK, so we can distinguish keypad keys */
/* regardless of numlock */
int g_a2_key_to_wsym[][3] = {
	{ 0x35,	VK_ESCAPE,	0 },
	{ 0x7a,	VK_F1,	0 },
	{ 0x7b,	VK_F2,	0 },
	{ 0x63,	VK_F3,	0 },
	{ 0x76,	VK_F4,	0 },
	{ 0x60,	VK_F5,	0 },
	{ 0x61,	VK_F6,	0 },
	{ 0x62,	VK_F7,	0 },
	{ 0x64,	VK_F8,	0 },
	{ 0x65,	VK_F9,	0 },
	{ 0x6d,	VK_F10,	0 },
	{ 0x67,	VK_F11,	0 },
	{ 0x6f,	VK_F12,	0 },
	{ 0x69,	VK_F13,	0 },
	{ 0x6b,	VK_F14,	0 },
	{ 0x71,	VK_F15,	0 },
	{ 0x7f, VK_PAUSE, VK_CANCEL+0x100 },

	{ 0x32,	0xc0, 0 },		/* '`' */
	{ 0x12,	'1', 0 },
	{ 0x13,	'2', 0 },
	{ 0x14,	'3', 0 },
	{ 0x15,	'4', 0 },
	{ 0x17,	'5', 0 },
	{ 0x16,	'6', 0 },
	{ 0x1a,	'7', 0 },
	{ 0x1c,	'8', 0 },
	{ 0x19,	'9', 0 },
	{ 0x1d,	'0', 0 },
	{ 0x1b,	0xbd, 0 },		/* '-' */
	{ 0x18,	0xbb, 0 },		/* '=' */
	{ 0x33,	VK_BACK, 0 },		/* backspace */
	{ 0x72,	VK_INSERT+0x100, 0 },	/* Insert key */
/*	{ 0x73,	XK_Home, 0 },		alias VK_HOME to be KP_Equal! */
	{ 0x74,	VK_PRIOR+0x100, 0 },	/* pageup */
	{ 0x47,	VK_NUMLOCK, VK_NUMLOCK+0x100 },	/* clear */
	{ 0x51,	VK_HOME+0x100, 0 },		/* KP_equal is HOME key */
	{ 0x4b,	VK_DIVIDE, VK_DIVIDE+0x100 },
	{ 0x43,	VK_MULTIPLY, VK_MULTIPLY+0x100 },

	{ 0x30,	VK_TAB, 0 },
	{ 0x0c,	'Q', 0 },
	{ 0x0d,	'W', 0 },
	{ 0x0e,	'E', 0 },
	{ 0x0f,	'R', 0 },
	{ 0x11,	'T', 0 },
	{ 0x10,	'Y', 0 },
	{ 0x20,	'U', 0 },
	{ 0x22,	'I', 0 },
	{ 0x1f,	'O', 0 },
	{ 0x23,	'P', 0 },
	{ 0x21,	0xdb, 0 },	/* [ */
	{ 0x1e,	0xdd, 0 },	/* ] */
	{ 0x2a,	0xdc, 0 },	/* backslash, bar */
	{ 0x75,	VK_DELETE+0x100, 0 },
	{ 0x77,	VK_END+0x100, VK_END },
	{ 0x79,	VK_NEXT+0x100, 0 },
	{ 0x59,	VK_NUMPAD7, VK_HOME },
	{ 0x5b,	VK_NUMPAD8, VK_UP },
	{ 0x5c,	VK_NUMPAD9, VK_PRIOR },
	{ 0x4e,	VK_SUBTRACT, VK_SUBTRACT+0x100 },

	// { 0x39,	VK_CAPITAL, 0 },  // Handled specially!
	{ 0x00,	'A', 0 },
	{ 0x01,	'S', 0 },
	{ 0x02,	'D', 0 },
	{ 0x03,	'F', 0 },
	{ 0x05,	'G', 0 },
	{ 0x04,	'H', 0 },
	{ 0x26,	'J', 0 },
	{ 0x28,	'K', 0 },
	{ 0x25,	'L', 0 },
	{ 0x29,	0xba, 0 },	/* ; */
	{ 0x27,	0xde, 0 },	/* single quote */
	{ 0x24,	VK_RETURN, 0 },
	{ 0x56,	VK_NUMPAD4, VK_LEFT },
	{ 0x57,	VK_NUMPAD5, VK_CLEAR },
	{ 0x58,	VK_NUMPAD6, VK_RIGHT },
	{ 0x45,	VK_ADD, 0 },

	{ 0x38,	VK_SHIFT, 0 },
	{ 0x06,	'Z', 0 },
	{ 0x07,	'X', 0 },
	{ 0x08,	'C', 0 },
	{ 0x09,	'V', 0 },
	{ 0x0b,	'B', 0 },
	{ 0x2d,	'N', 0 },
	{ 0x2e,	'M', 0 },
	{ 0x2b,	0xbc, 0 },	/* , */
	{ 0x2f,	0xbe, 0 },	/* . */
	{ 0x2c,	0xbf, 0 },	/* / */
	{ 0x3e,	VK_UP+0x100, 0 },
	{ 0x53,	VK_NUMPAD1, VK_END },
	{ 0x54,	VK_NUMPAD2, VK_DOWN },
	{ 0x55,	VK_NUMPAD3, VK_NEXT },

	{ 0x36,	VK_CONTROL, VK_CONTROL+0x100 },
	{ 0x3a,	VK_SNAPSHOT+0x100, VK_MENU+0x100 },/* Opt=prntscrn or alt-r */
	{ 0x37,	VK_SCROLL, VK_MENU },		/* Command=scr_lock or alt-l */
	{ 0x31,	' ', 0 },
	{ 0x3b,	VK_LEFT+0x100, 0 },
	{ 0x3d,	VK_DOWN+0x100, 0 },
	{ 0x3c,	VK_RIGHT+0x100, 0 },
	{ 0x52,	VK_NUMPAD0, VK_INSERT },
	{ 0x41,	VK_DECIMAL, VK_DECIMAL },
	{ 0x4c,	VK_RETURN+0x100, 0 },
	{ -1, -1, -1 }
};

#if 0
int
win_nonblock_read_stdin(int fd, char *bufptr, int len)
{
	HANDLE	oshandle;
	DWORD	dwret;
	int	ret;

	errno = EAGAIN;
	oshandle = (HANDLE)_get_osfhandle(fd);	// get stdin handle
	dwret = WaitForSingleObject(oshandle, 1);	// wait 1msec for data
	ret = -1;
	if(dwret == WAIT_OBJECT_0) {
		ret = read(fd, bufptr, len);
	}
	return ret;
}
#endif

void
x_dialog_create_kegs_conf(const char *str)
{
}

int
x_show_alert(int is_fatal, const char *str)
{
	fprintf(stderr, "Alert! (Fatal: %d):  %s\n", is_fatal, str);
	return 0;
}

int
win_update_mouse(int x, int y, int button_states, int buttons_valid)
{
	Kimage	*kimage_ptr;
	int	buttons_changed;

	kimage_ptr = &g_mainwin_kimage;		// HACK

	buttons_changed = ((g_win_button_states & buttons_valid) !=
								button_states);
	g_win_button_states = (g_win_button_states & ~buttons_valid) |
			(button_states & buttons_valid);
	if(g_warp_pointer && (x == A2_WINDOW_WIDTH/2) &&
			(y == A2_WINDOW_HEIGHT/2) && (!buttons_changed) ) {
		/* tell adb routs to recenter but ignore this motion */
		adb_update_mouse(kimage_ptr, x, y, 0, -1);
		return 0;
	}
	return adb_update_mouse(kimage_ptr, x, y, button_states,
							buttons_valid & 7);
}

void
win_event_mouse(WPARAM wParam, LPARAM lParam)
{
	POINT	pt;
	word32	flags;
	int	buttons;
	int	x, y;
	int	motion;

	flags = wParam;
	x = LOWORD(lParam) - BASE_MARGIN_LEFT;
	y = HIWORD(lParam) - BASE_MARGIN_TOP;

	buttons = (flags & 1) +
			(((flags >> 1) & 1) << 2) +
			(((flags >> 4) & 1) << 1);
#if 0
	printf("Mouse at %d, %d fl: %08x, but: %d\n", x, y, flags, buttons);
#endif
	motion = win_update_mouse(x, y, buttons, 7);

	if(motion && g_warp_pointer) {
		/* move mouse to center of screen */
		pt.x = BASE_MARGIN_LEFT + A2_WINDOW_WIDTH/2;
		pt.y = BASE_MARGIN_TOP + A2_WINDOW_HEIGHT/2;
		ClientToScreen(g_hwnd_main, &pt);
		SetCursorPos(pt.x, pt.y);
	}
}

void
win_event_key(HWND hwnd, UINT raw_vk, BOOL down, int repeat, UINT flags)
{
	Kimage	*kimage_ptr;
	word32	vk;
	int	a2code, is_up, capslock_down;
	int	i;

	kimage_ptr = &(g_mainwin_kimage);		// HACK!

	if((flags & 0x4000) && down) {
		/* auto-repeating, just ignore it */
		return;
	}

	vk = raw_vk + (flags & 0x100);
#if 0
	printf("Key event, vk=%04x, down:%d, repeat: %d, flags: %08x\n",
			vk, down, repeat, flags);
#endif

	/* remap a few keys here.. sigh */
	if((vk & 0xff) == VK_APPS) {
		/* remap to command */
		vk = VK_MENU;
	}

	if((vk & 0xff) == VK_CAPITAL) {
		// Windows gives us up-and-down events of the actual key
		//  Use GetKeyState to get the true toggle state, and pass
		//  that on to the adb interface
		capslock_down = GetKeyState(VK_CAPITAL) & 0x01;
		if(capslock_down != g_win_capslock_down) {
			g_win_capslock_down = capslock_down;
			adb_physical_key_update(kimage_ptr, 0x39, 0,
				!capslock_down, 0, 0, capslock_down);
		}

		return;		// Do no more processing!
	}

	/* search a2key_to_wsym to find wsym in col 1 or 2 */
	i = 0;
	is_up = !down;
	for(i = g_num_a2_keycodes-1; i >= 0; i--) {
		a2code = g_a2_key_to_wsym[i][0];
		if((vk == g_a2_key_to_wsym[i][1]) ||
					(vk == g_a2_key_to_wsym[i][2])) {
			vid_printf("Found vk:%04x = %02x\n", vk, a2code);
			adb_physical_key_update(kimage_ptr, a2code, 0, is_up,
				0, 0, 0);		// HACK!
			return;
		}
	}
	printf("VK: %04x unknown\n", vk);
}

void
win_event_quit(HWND hwnd)
{
	g_quit_sim_now = 1;
	my_exit(0);
}

void
win_event_redraw()
{
	g_full_refresh_needed = -1;
	g_a2_screen_buffer_changed = -1;
	g_status_refresh_needed = 1;
	g_border_sides_refresh_needed = 1;
	g_border_special_refresh_needed = 1;
}

LRESULT CALLBACK
win_event_handler(HWND hwnd, UINT umsg, WPARAM wParam, LPARAM lParam)
{
	switch(umsg) {
	case WM_MOUSEMOVE:
	case WM_LBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_MBUTTONDOWN:
	case WM_MBUTTONUP:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
		win_event_mouse(wParam, lParam);
		return 0;
	case WM_PAINT:
		win_event_redraw();
		break;
	}
	switch(umsg) {
		HANDLE_MSG(hwnd, WM_KEYUP, win_event_key);
		HANDLE_MSG(hwnd, WM_KEYDOWN, win_event_key);
		HANDLE_MSG(hwnd, WM_SYSKEYUP, win_event_key);
		HANDLE_MSG(hwnd, WM_SYSKEYDOWN, win_event_key);
		HANDLE_MSG(hwnd, WM_DESTROY, win_event_quit);
	}

#if 0
	switch(umsg) {
	case WM_NCACTIVATE:
	case WM_NCHITTEST:
	case WM_NCMOUSEMOVE:
	case WM_SETCURSOR:
	case WM_LBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_RBUTTONDOWN:
	case WM_CONTEXTMENU:
	case WM_RBUTTONUP:
	case WM_MBUTTONDOWN:
	case WM_MBUTTONUP:
	case WM_PAINT:

		break;
	default:
		printf("Got umsg2: %d\n", umsg);
	}
#endif

	return DefWindowProc(hwnd, umsg, wParam, lParam);
}


int
main(int argc, char **argv)
{
	int	ret, mdepth;

	ret = parse_argv(argc, argv, 1);
	if(ret) {
		printf("parse_argv ret: %d, stopping\n", ret);
		exit(1);
	}

	mdepth = 32;

	video_set_blue_mask(0x0000ff);
	video_set_green_mask(0x00ff00);
	video_set_red_mask(0xff0000);
	ret = kegs_init(mdepth);
	printf("kegs_init done\n");
	if(ret) {
		printf("kegs_init ret: %d, stopping\n", ret);
		exit(1);
	}

	win_video_init(mdepth);

	printf("Entering main loop!\n");
	fflush(stdout);
	while(1) {
		ret = run_16ms();
		if(ret != 0) {
			printf("run_16ms returned: %d\n", ret);
			break;
		}
		x_update_display();
		check_input_events();
	}
	xdriver_end();
	exit(0);
}

void
check_input_events()
{
	MSG	msg;

	while(PeekMessage(&msg, g_hwnd_main, 0, 0, PM_NOREMOVE)) {
		if(GetMessage(&msg, g_hwnd_main, 0, 0) > 0) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		} else {
			printf("GetMessage returned <= 0\n");
			my_exit(2);
		}
	}

	return;
}

void
win_video_init(int mdepth)
{
	Kimage	*kimage_ptr;
	WNDCLASS wndclass;
	RECT	rect, win_rect;
	int	height, width, ret, a2code, extra_size, win_width, win_height;
	int	w_flags;
	int	i;

	video_set_palette();

	g_num_a2_keycodes = 0;
	for(i = 0; i < 0x7f; i++) {
		a2code = g_a2_key_to_wsym[i][0];
		if(a2code < 0) {
			g_num_a2_keycodes = i;
			break;
		}
	}
	wndclass.style = 0;
	wndclass.lpfnWndProc = (WNDPROC)win_event_handler;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = GetModuleHandle(NULL);
	wndclass.hIcon = LoadIcon((HINSTANCE)NULL, IDI_APPLICATION);
	wndclass.hCursor = LoadCursor((HINSTANCE) NULL, IDC_ARROW);
	wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName = NULL;
	wndclass.lpszClassName = "kegswin";

	// Register the window
	if(!RegisterClass(&wndclass)) {
		printf("Registering window failed\n");
		exit(1);
	}

	kimage_ptr = &g_mainwin_kimage;

	height = video_get_a2_height(kimage_ptr);
	width = video_get_a2_width(kimage_ptr);

	printf("Got height: %d, width:%d\n", height, width);

	// We must call CreateWindow with a width,height that accounts for
	//  the title bar and any other stuff.  Use AdjustWindowRect() to
	//  calculate this info for us
	w_flags = WS_TILED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX;
	rect.top = 0;
	rect.left = 0;
	rect.right = width;
	rect.bottom = height;
	(void)AdjustWindowRect(&rect, w_flags, 0);
	win_width = rect.right - rect.left;
	win_height = rect.bottom - rect.top;
	g_hwnd_main = CreateWindow("kegswin", "KEGSWIN - Apple //gs Emulator",
		w_flags, CW_USEDEFAULT, CW_USEDEFAULT,
		win_width, win_height,
		NULL, NULL, GetModuleHandle(NULL), NULL);

	printf("g_hwnd_main = %p, height = %d\n", g_hwnd_main, height);
	GetWindowRect(g_hwnd_main, &rect);
	printf("...rect is: %ld, %ld, %ld, %ld\n", rect.left, rect.top,
		rect.right, rect.bottom);

	g_main_dc = GetDC(g_hwnd_main);

	SetTextColor(g_main_dc, 0);
	SetBkColor(g_main_dc, 0xffffff);

	g_main_cdc = CreateCompatibleDC(g_main_dc);
	printf("g_main_cdc: %p, g_main_dc:%p\n", g_main_cdc, g_main_dc);


	printf("Getting height, kimage_ptr:%p\n", kimage_ptr);
	fflush(stdout);

	g_mainwin_data_ptr = 0;

	extra_size = sizeof(RGBQUAD);
	g_bmapinfo_ptr = (BITMAPINFO *)GlobalAlloc(GPTR,
			sizeof(BITMAPINFOHEADER) + extra_size);

	g_bmaphdr_ptr = (BITMAPINFOHEADER *)g_bmapinfo_ptr;
	g_bmaphdr_ptr->biSize = sizeof(BITMAPINFOHEADER);
	g_bmaphdr_ptr->biWidth = width;
	g_bmaphdr_ptr->biHeight = -height;
	g_bmaphdr_ptr->biPlanes = 1;
	g_bmaphdr_ptr->biBitCount = mdepth;
	g_bmaphdr_ptr->biCompression = BI_RGB;
	g_bmaphdr_ptr->biClrUsed = 0;

	// HACK: video.get.kimages() was here!!

	ShowWindow(g_hwnd_main, SW_SHOWDEFAULT);
	UpdateWindow(g_hwnd_main);

	/* Use g_bmapinfo_ptr, adjusting width, height */
	printf("g_bmaphdr_ptr:%p\n", g_bmaphdr_ptr);

	g_bmaphdr_ptr->biWidth = width;
	g_bmaphdr_ptr->biHeight = -height;
	printf("About to call CreateDIBSection, main_dc:%p\n", g_main_dc);
	fflush(stdout);
	g_mainwin_dev_handle = CreateDIBSection(g_main_dc,
				g_bmapinfo_ptr, DIB_RGB_COLORS,
				(VOID **)&(g_mainwin_data_ptr), NULL, 0);

	g_mainwin_pixels_per_line = width;
	printf("kim: %p, dev:%p data: %p\n", kimage_ptr,
			g_mainwin_dev_handle, g_mainwin_data_ptr);
	fflush(stdout);
}


void
xdriver_end()
{
	printf("xdriver_end\n");
}

void
x_update_display()
{
	Change_rect rect;
	void	*bitm_old;
	POINT	point;
	int	valid;
	int	i;

	for(i = 0; i < MAX_CHANGE_RECTS; i++) {
		valid = video_out_data(g_mainwin_data_ptr, &g_mainwin_kimage,
			g_mainwin_pixels_per_line, &rect, i);
		if(!valid) {
			break;
		}

		point.x = 0;
		point.y = 0;
		ClientToScreen(g_hwnd_main, &point);
		bitm_old = SelectObject(g_main_cdc, g_mainwin_dev_handle);

		BitBlt(g_main_dc, rect.x, rect.y, rect.width, rect.height,
			g_main_cdc, rect.x, rect.y, SRCCOPY);

		SelectObject(g_main_cdc, bitm_old);
	}
}

void
x_hide_pointer(int do_hide)
{
	if(do_hide) {
		ShowCursor(0);
	} else {
		ShowCursor(1);
	}
}

int
opendir_int(DIR *dirp, const char *in_filename)
{
	HANDLE	handle1;
	BOOL	ret;
	wchar_t	*wcstr;
	char	*filename;
	size_t	ret_val;
	int	buflen, len;
	int	i;

	printf("opendir on %s\n", in_filename);
	len = strlen(in_filename);
	buflen = len + 8;
	if(buflen >= sizeof(dirp->dirent.d_name)) {
		printf("buflen %d >= d_name %d\n", buflen,
					(int)sizeof(dirp->dirent.d_name));
		return 1;
	}
	filename = &dirp->dirent.d_name[0];
	memcpy(filename, in_filename, len + 1);
	while(len && (filename[len-1] == '/')) {
		filename[len - 1] = 0;
		len--;
	}
	cfg_strlcat(filename, "/*.*", buflen);
	for(i = 0; i < len; i++) {
		if(filename[i] == '/') {
			filename[i] = '\\';
		}
	}
	len = strlen(filename);
	wcstr = malloc(buflen * 2);
	(void)mbstowcs_s(&ret_val, wcstr, buflen, filename, _TRUNCATE);
	handle1 = FindFirstFileW(wcstr, dirp->find_data_ptr);
	dirp->win_handle = handle1;
	free(wcstr);
	if(handle1) {
		dirp->find_data_valid = 1;
		return 0;
	}
	return 1;
}

DIR *
opendir(const char *in_filename)
{
	DIR	*dirp;
	int	ret;

	dirp = calloc(1, sizeof(DIR));
	if(!dirp) {
		return 0;
	}
	dirp->find_data_valid = 1;
	dirp->find_data_ptr = calloc(1, sizeof(WIN32_FIND_DATAW));
	ret = 1;
	if(dirp->find_data_ptr) {
		ret = opendir_int(dirp, in_filename);
	}
	if(ret) {		// Bad
		free(dirp->find_data_ptr);		// free(0) is OK
		free(dirp);
		return 0;
	}
	return dirp;
}

struct dirent *
readdir(DIR *dirp)
{
	WIN32_FIND_DATAW *find_data_ptr;
	HANDLE	handle1;
	size_t	ret_val;
	BOOL	ret;

	handle1 = dirp->win_handle;
	find_data_ptr = dirp->find_data_ptr;
	if(!handle1 || !find_data_ptr) {
		return 0;
	}
	ret = 1;
	if(!dirp->find_data_valid) {
		if(handle1) {
			find_data_ptr->cFileName[MAX_PATH-1] = 0;
			ret = FindNextFileW(handle1, find_data_ptr);
		}
	}
	dirp->find_data_valid = 0;
	if(!ret) {
		return 0;
	}
	(void)wcstombs_s(&ret_val, &(dirp->dirent.d_name[0]),
				(int)sizeof(dirp->dirent.d_name),
				&(find_data_ptr->cFileName[0]), _TRUNCATE);
	printf("Returning file %s\n", &(dirp->dirent.d_name[0]));

	return &(dirp->dirent);;
}

int
closedir(DIR *dirp)
{
	FindClose(dirp->win_handle);
	free(dirp->find_data_ptr);
	free(dirp);

	return 0;
}

int
lstat(const char *path, struct stat *bufptr)
{
	return stat(path, bufptr);
}

