--
-- This file was generated using: ./OpenBTS --gensql
-- binary version: release 4.0TRUNK+GPRS P built Mar 25 2014 rev CommonLibs:rev 
--
-- Future changes should not be put in this file directly but
-- rather in the program's ConfigurationKey schema.
--
PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE IF NOT EXISTS CONFIG ( KEYSTRING TEXT UNIQUE NOT NULL, VALUESTRING TEXT, STATIC INTEGER DEFAULT 0, OPTIONAL INTEGER DEFAULT 0, COMMENTS TEXT DEFAULT '');
INSERT OR IGNORE INTO "CONFIG" VALUES('CLI.SocketPath','/var/run/OpenBTS/command',0,0,'Path for Unix domain datagram socket used for the OpenBTS console interface.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Call.QueryRRLP.Early','0',0,0,'1=enabled, 0=disabled - Query every MS for its location via RRLP during the setup of a call.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Call.QueryRRLP.Late','0',0,0,'1=enabled, 0=disabled - Query every MS for its location via RRLP during the teardown of a call.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.GSMTAP.GPRS','0',0,0,'1=enabled, 0=disabled - Capture GPRS signaling and traffic at L1/L2 interface via GSMTAP.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.GSMTAP.GSM','0',0,0,'1=enabled, 0=disabled - Capture GSM signaling at L1/L2 interface via GSMTAP.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.GSMTAP.TargetIP','127.0.0.1',0,0,'Target IP address for GSMTAP packets; the IP address of Wireshark, if you use it for real time traces.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.404RejectCause','0x04',0,0,'Reject cause for location updating failures for phones that fail authentication.  The SIP result code from the Registrar in this case is 404.  Reject causes come from GSM 04.08 10.5.3.6.  Reject cause 0x02 or 0x04 is usually the right one.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.AttachDetach','1',0,0,'1=enabled, 0=disabled - Use attach/detach procedure.  This will make initial LUR more prompt.  It will also cause an un-registration if the handset powers off and really heavy LUR loads in areas with spotty coverage.  Range Networks strongly recommends setting this to 1.  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.FailMode','ACCEPT',0,0,'Action to take after registration failure due to network failure, error in Registrar, or other unexpected error.  This does not apply to regular authorization failure handled by other config options.  If ACCEPT the handset is authorized for service.  If FAIL the handset is denied service.  If OPEN the open registration procedure is applied.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.FailedRegistration.Message','Your handset is not provisioned for this network. ',0,0,'Send this text message, followed by the IMSI, to unprovisioned handsets that are denied registration.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.FailedRegistration.ShortCode','1000',0,0,'The return address for the failed registration message.  If unset, the message will not be sent.  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.NormalRegistration.Message','',0,0,'The text message, followed by the IMSI, to be sent to provisioned handsets when they attach on Um.  By default, no message is sent.  To have a message sent, specify one.  To stop sending messages again, execute "unconfig Control.LUR.NormalRegistration.Message".  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.NormalRegistration.ShortCode','0000',0,0,'The return address for the normal registration message.  If unset, the message will not be sent.  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.OpenRegistration','',0,0,'This value is a regular expression.  Any handset with an IMSI matching the regular expression is allowed to register, even if it is not provisioned.  By default, this feature is disabled.  To enable open registration, specify a regular expression to match.  E.g. ^001, which matches any IMSI starting with 001, the MCC for test networks.  To disable open registration again, execute "unconfig Control.LUR.OpenRegistration".');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.OpenRegistration.Message','Welcome to the test network.  Your IMSI is ',0,0,'Send this text message, followed by the IMSI, to unprovisioned handsets when they attach on Um due to open registration.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.OpenRegistration.Reject','',0,0,'This value is a regular expression.  Any unprovisioned handset with an IMSI matching the regular expression is rejected for registration, even if it matches Control.LUR.OpenRegistration.  By default, this filter is disabled.  To enable the filter, specify a regular expression.  E.g. ^666 matches any IMSI starting with 666, which currently does not correspond to any known MCC.  Stay on the light side of the Force!To disable the filter again, execute "unconfig Control.LUR.OpenRegistration.Reject".  If Control.LUR.OpenRegistration is disabled, this parameter has no effect.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.OpenRegistration.ShortCode','101',0,0,'The return address for the open registration message.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.QueryClassmark','0',0,0,'1=enabled, 0=disabled - Query every MS for classmark during LUR.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.QueryIMEI','0',0,0,'1=enabled, 0=disabled - Query every MS for IMEI during initial LUR.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.QueryRRLP','0',0,0,'1=enabled, 0=disabled - Query every MS for its location via RRLP during LUR.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.RegistrationMessageFrequency','FIRST',0,0,"This option helps determine when a registration message is sent by the BTS to a handset.  If 'PLMN' the message is sent only when the handset first registers in the PLMN, as reported by the handset. If 'NORMAL' the message is sent whenever the handset enters the cell, as reported by the handset. If 'FIRST' the message is sent the first time this BTS sees this MS as determined by the WELCOME_SENT field of the TMSI_TABLE.This option is not completely reliable because the functioning of this option depends on information provided by the handset during their initial attach procedure, and some handsets set this information improperly.");
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.SendTMSIs','0',0,0,'1=enabled, 0=disabled - Send new TMSI assignments to handsets that are allowed to attach.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.TestMode','0',0,0,'Used for testing the LUR procedure.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.LUR.UnprovisionedRejectCause','0x04',0,0,'Reject cause for location updating failures for unprovisioned phones, that is, the IMSI was not found in the Registrar database.  The SIP result code from the Registrar in this case is 401.  Reject causes come from GSM 04.08 10.5.3.6.  Reject cause 0x02 or 0x04 is usually the right one.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.NumSQLTries','3',0,0,'Number of times to retry SQL queries before declaring a database access failure.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Reporting.PhysStatusTable','/var/run/OpenBTS/ChannelTable.db',1,0,'File path for channel status reporting database.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Reporting.StatsTable','/var/log/OpenBTSStats.db',1,0,'File path for statistics reporting database.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Reporting.TMSITable','/var/run/OpenBTS/TMSITable.db',1,0,'File path for TMSITable database.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Reporting.TransactionMaxCompletedRecords','100',1,0,'Maximum completed records to be stored for gathering by an external stats tool.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.Reporting.TransactionTable','/var/run/OpenBTS/TransactionTable.db',1,0,'File path for transaction table database.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.SACCHTimeout.BumpDown','1',0,0,'Decrease the RSSI by this amount to induce more power in the MS each time we fail to receive a response from it on SACCH.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.SMS.QueryRRLP','0',0,0,'1=enabled, 0=disabled - Query every MS for its location via RRLP during an SMS.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.SMSCB.Table','',1,0,'File path for SMSCB scheduling database.  By default, this feature is disabled.  To enable, specify a file path for the database e.g. /var/run/OpenBTS/SMSCB.db.  To disable again, execute "unconfig Control.SMSCB.Table".  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.TMSITable.MaxAge','576',0,0,'Maximum allowed age in hours for a TMSI entry in the TMSITable.  This is not the authorization/registration expiry period, this is how long the BTS remembers assigned TMSIs.  Currently old entries are only discarded at startup.  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.VEA','0',0,0,'1=enabled, 0=disabled - Use very early assignment for speech call establishment.  See GSM 04.08 Section 7.3.2 for a detailed explanation of assignment types.  If VEA is selected, GSM.CellSelection.NECI should be set to 1.  See GSM 04.08 Sections 9.1.8 and 10.5.2.4 for an explanation of the NECI bit.  Note that some handset models exhibit bugs when VEA is used and these bugs may affect performance.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Control.WatchdogMinutes','0',0,0,'Number of minutes before the radio watchdog expires and OpenBTS is restarted, set to 0 to disable.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.DNS','',1,0,'The list of DNS servers to be used by downstream clients.  By default, DNS servers of the host system are used.  To override, specify a space-separated list of DNS servers, in IP dotted notation, eg: 1.2.3.4 5.6.7.8.  To use the host system DNS servers again, execute "unconfig GGSN.DNS".  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.Firewall.Enable','1',1,0,'0=no firewall; 1=block MS attempted access to OpenBTS or other MS; 2=block all private IP addresses.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.IP.MaxPacketSize','1520',1,0,'Maximum size of an IP packet.  Should normally be 1520.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.IP.ReuseTimeout','180',1,0,'How long IP addresses are reserved after a session ends.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.IP.TossDuplicatePackets','0',1,0,'1=enabled, 0=disabled - Toss duplicate TCP/IP packets to prevent unnecessary traffic on the radio.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.Logfile.Name','',1,0,'If specified, internet traffic is logged to this file. E.g. ggsn.log.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.MS.IP.Base','192.168.99.1',1,0,'Base IP address assigned to MS.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.MS.IP.MaxCount','254',1,0,'Number of IP addresses to use for MS.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.MS.IP.Route','',1,0,'A route address to be used for downstream clients.  By default, OpenBTS manufactures this value from the GGSN.MS.IP.Base assuming a 24 bit mask.  To override, specify a route address in the form xxx.xxx.xxx.xxx/yy.  The address must encompass all MS IP addresses.  To use the auto-generated value again, execute "unconfig GGSN.MS.IP.Route".  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.ShellScript','',0,0,'A shell script to be invoked when MS devices attach or create IP connections.  By default, this feature is disabled.  To enable, specify an absolute path to the script you wish to execute e.g. /usr/bin/ms-attach.sh.  To disable again, execute "unconfig GGSN.ShellScript".');
INSERT OR IGNORE INTO "CONFIG" VALUES('GGSN.TunName','sgsntun',1,0,'Tunnel device name for GGSN.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.CellOptions.T3168Code','5',1,0,'Timer 3168 in the MS controls the wait time after sending a Packet Resource Request to initiate a TBF before giving up or reattempting a Packet Access Procedure, which may imply sending a new RACH.  This code is broadcast to the MS in the C0T0 beacon in the GPRS Cell Options IE.  See GSM 04.60 12.24.  Range 0..7, representing values from 0.5sec to 4sec in 0.5sec steps.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.CellOptions.T3192Code','0',1,0,'Timer 3192 in the MS specifies the time MS continues to listen on PDCH after all downlink TBFs are finished, and is used to reduce unnecessary RACH traffic.  This code is broadcast to the MS in the C0T0 beacon in the GPRS Cell Options IE. The value must be one of the codes described in GSM 04.60 12.24.  Value 0 implies 500msec; 2 implies 1500msec; 3 imples 0msec.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.ChannelCodingControl.RSSI','-40',0,0,'If the initial unlink signal strength is less than this amount in dB, GPRS uses a lower bandwidth but more robust encoding CS-1.  This value should normally be GSM.Radio.RSSITarget + 10 dB.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Channels.Congestion.Threshold','200',0,0,'The GPRS channel is considered congested if the desired bandwidth exceeds available bandwidth by this amount, specified in percent.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Channels.Congestion.Timer','60',0,0,'How long in seconds GPRS congestion exceeds the Congestion.Threshold before we attempt to allocate another channel for GPRS.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Channels.Min.C0','2',1,0,'Minimum number of channels allocated for GPRS service on ARFCN C0.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Channels.Min.CN','0',1,0,'Minimum number of channels allocated for GPRS service on ARFCNs other than C0.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Codecs.Downlink','1,4',0,0,'An empty value specifies GPRS may use all available codecs.  Otherwise list of allowed GPRS downlink codecs 1..4 for CS-1..CS-4.  Currently, only 1 and 4 are supported e.g. 1,4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Codecs.Uplink','1,4',0,0,'An empty value specifies GPRS may use all available codecs.  Otherwise list of allowed GPRS uplink codecs 1..4 for CS-1..CS-4.  Currently, only 1 and 4 are supported e.g. 1,4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.Assign','10',0,0,'Maximum number of assign messages sent.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.N3101','20',0,0,'Counts unused USF responses to detect nonresponsive MS.  Should be > 8.  See GSM04.60 Sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.N3103','8',0,0,'Counts ACK/NACK attempts to detect nonresponsive MS.  See GSM04.60 sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.N3105','12',0,0,'Counts unused RRBP responses to detect nonresponsive MS.  See GSM04.60 Sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.Reassign','6',0,0,'Maximum number of reassign messages sent.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Counters.TbfRelease','5',0,0,'Maximum number of TBF release messages sent.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Debug','0',0,0,'1=enabled, 0=disabled - Toggle GPRS debugging.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Downlink.KeepAlive','300',0,0,'How often to send keep-alive messages for persistent TBFs in milliseconds; must be long enough to avoid simultaneous in-flight duplicates, and short enough that MS gets one every 5 seconds.  GSM 5.08 10.2.2 indicates MS must get a block every 360ms');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Downlink.Persist','0',0,0,'After completion, downlink TBFs are held open for this time in milliseconds.  If non-zero, must be greater than GPRS.Downlink.KeepAlive.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Enable','0',1,0,'1=enabled, 0=disabled - If enabled, GPRS service is advertised in the C0T0 beacon, and GPRS service may be started on demand.  See also GPRS.Channels.*.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.LocalTLLI.Enable','1',0,0,'1=enabled, 0=disabled - Enable recognition of local TLLI.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.MS.KeepExpiredCount','20',0,0,'How many expired MS structs to retain; they can be viewed with gprs list ms -x');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.MS.Power.Alpha','10',0,0,'MS power control parameter, unitless, in steps of 0.1, so a parameter of 5 is an alpha value of 0.5.  Determines sensitivity of handset to variations in downlink RXLEV.  Valid range is 0...10 for alpha values of 0...1.0.  See GSM 05.08 10.2.1.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.MS.Power.Gamma','31',0,0,'MS power control parameter, in 2 dB steps.  Determines baseline of handset uplink power relative to downlink RXLEV.  The optimum value will tend to be lower for BTS units with higher power output.  This default assumes a balanced link with a BTS output of 2-4 W/ARFCN.  Valid range is 0...31 for gamma values of 0...62 dB.  See GSM 05.08 10.2.1.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.MS.Power.T_AVG_T','15',1,0,'MS power control parameter; see GSM 05.08 10.2.1.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.MS.Power.T_AVG_W','15',1,0,'MS power control parameter; see GSM 05.08 10.2.1.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Multislot.Max.Downlink','3',0,0,'Maximum number of channels used for a single MS in downlink.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Multislot.Max.Uplink','2',0,0,'Maximum number of channels used for a single MS in uplink.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.NC.NetworkControlOrder','2',1,0,'Controls measurement reports and cell reselection mode (MS autonomous or under network control); should not be changed.  See GSM 5.08 10.1.4.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.NMO','2',0,0,'Network Mode of Operation.  See GSM 03.60 Section 6.3.3.1 and 24.008 4.7.1.6.  Allowed values are 1, 2, 3 for modes I, II, III.  Mode II (2) is recommended.  Mode I implies combined routing updating procedures.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.PRIORITY-ACCESS-THR','6',1,0,'Code contols GPRS packet access priorities allowed.  See GSM04.08 table  10.5.76.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.RAC','0',1,0,'GPRS Routing Area Code, advertised in the C0T0 beacon.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.RA_COLOUR','0',0,0,'GPRS Routing Area Color as advertised in the C0T0 beacon.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.RRBP.Min','0',0,0,'Minimum value for Relative Reserved Block Period (RRBP) reservations, range 0..3.  Should normally be 0.  A non-zero value gives the MS more time to respond to the RRBP request.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Reassign.Enable','1',0,0,'1=enabled, 0=disabled - Enable TBF Reassignment.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.SendIdleFrames','0',0,0,'1=enabled, 0=disabled - Should be 0 for current transceiver or 1 for deprecated version of transceiver.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.TBF.Downlink.Poll1','10',0,0,'When the first poll is sent for a downlink tbf, measured in blocks sent.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.TBF.EST','1',0,0,'1=enabled, 0=disabled - Allow MS to request another uplink assignment at end up of uplink TBF.  See GSM 4.60 9.2.3.4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.TBF.Expire','30000',0,0,'How long in milliseconds to try before giving up on a TBF.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.TBF.KeepExpiredCount','20',0,0,'How many expired TBF structs to retain; they can be viewed with gprs list tbf -x.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.TBF.Retry','1',0,0,'If 0, no tbf retry, otherwise if a tbf fails it will be retried with this codec, numbered 1..4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.Channels.Idle','6000',0,0,'How long in milliseconds a GPRS channel is idle before being returned to the pool of channels.  Also depends on Channels.Min.  Currently the channel cannot be returned to the pool while there is any GPRS activity on any channel.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.MS.Idle','600',0,0,'How long in seconds an MS is idle before the BTS forgets about it.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.MS.NonResponsive','6000',0,0,'How long in milliseconds a TBF is non-responsive before the BTS kills it.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.T3169','5000',0,0,'Nonresponsive uplink TBF resource release timer, in milliseconds.  See GSM04.60 Sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.T3191','5000',0,0,'Nonresponsive downlink TBF resource release timer, in milliseconds.  See GSM04.60 Sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.T3193','0',0,0,'Timer T3193 (in milliseconds) in the base station corresponds to T3192 in the MS, which is set by GPRS.CellOptions.T3192Code.  The T3193 value should be slightly longer than that specified by the T3192Code.  If 0, the BTS will fill in a default value based on T3192Code.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Timers.T3195','5000',0,0,'Nonresponsive downlink TBF resource release timer, in milliseconds.  See GSM04.60 Sec 13.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Uplink.KeepAlive','300',0,0,'How often to send keep-alive messages for persistent TBFs in milliseconds; must be long enough to avoid simultaneous in-flight duplicates, and short enough that MS gets one every 5 seconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.Uplink.Persist','4000',1,0,'After completion uplink TBFs are held open for this time in milliseconds.  If non-zero, must be greater than GPRS.Uplink.KeepAlive.  This is broadcast in the beacon and cannot be changed once BTS is started.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GPRS.advanceblocks','10',0,0,'Number of advance blocks to use in the CCCH reservation.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CCCH.AGCH.QMax','3',0,0,'Maximum number of access grants to be queued for transmission on AGCH before declaring congestion.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CCCH.CCCH-CONF','1',1,0,'CCCH configuration type.  DO NOT CHANGE THIS.  Value is fixed by the implementation.  See GSM 10.5.2.11 for encoding.  Value of 1 means we are using a C-V beacon.  Any other value selects a C-IV beacon.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellOptions.RADIO-LINK-TIMEOUT','15',1,0,'Seconds before declaring a physical link dead.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellSelection.CELL-RESELECT-HYSTERESIS','3',0,0,'Cell Reselection Hysteresis.  See GSM 04.08 10.5.2.4, Table 10.5.23 for encoding.  Encoding is $2N$ dB, values of $N$ are 0...7 for 0...14 dB.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellSelection.MS-TXPWR-MAX-CCH','0',0,0,'Cell selection parameters.  See GSM 04.08 10.5.2.4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellSelection.NCCsPermitted','0',0,0,'NCCs Permitted.  An 8-bit mask of allowed NCCs.  The NCC of your own network is automatically included.  Unless you are coordinating with another carrier, this should be left at zero.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellSelection.NECI','1',0,0,'NECI, New Establishment Causes.  This must be set to 1 if you want to support very early assignment (VEA).  It can be set to 1 even if you do not use VEA, so you might as well leave it as 1.  See GSM 04.08 10.5.2.4, Table 10.5.23 and 04.08 9.1.8, Table 9.9 and the Control.VEA parameter.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.CellSelection.RXLEV-ACCESS-MIN','0',0,0,'Cell selection parameters.  See GSM 04.08 10.5.2.4.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Channels.C1sFirst','0',1,0,'1=enabled, 0=disabled - Allocate C-I slots first, starting at C0T1.  Otherwise, allocate C-VII slots first.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Channels.NumC1s','7',1,0,'Number of Combination-I timeslots to configure.  The C-I slot carries a single full-rate TCH, used for speech calling.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Channels.NumC7s','0',1,0,'Number of Combination-VII timeslots to configure.  The C-VII slot carries 8 SDCCHs, useful to handle high registration loads or SMS.  If C0T0 is C-IV, you must also have at least one C-VII.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Channels.SDCCHReserve','0',0,0,'Number of SDCCHs to reserve for non-LUR operations.  This can be used to force LUR transactions into a lower priority.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Cipher.CCHBER','0',0,0,'Probability of a bit getting toggled in a control channel burst for cracking protection.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Cipher.Encrypt','0',0,0,'1=enabled, 0=disabled - Encrypt traffic between MS and OpenBTS.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Cipher.RandomNeighbor','0',0,0,'Probability of a random neighbor being added to SI5 for cracking protection.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Cipher.ScrambleFiller','0',0,0,'1=enabled, 0=disabled - Scramble filler in layer 2 for cracking protection.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Control.GPRSMaxIgnore','5',0,0,'Ignore GPRS messages on GSM control channels.  Value is number of consecutive messages to ignore.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Handover.FailureHoldoff','5',0,0,'The number of seconds to wait before attempting another handover with a given neighbor BTS.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Handover.LocalRSSIMin','-80',0,0,'Do not handover if downlink RXLEV (reported by the MS) is above this level (in dBm), regardless of power difference.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Handover.ThresholdDelta','10',0,0,'A neighbor downlink signal must be this much stronger (in dB) than this downlink signal for handover to occur.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.BSIC.BCC','2',0,0,'GSM basestation color code; lower 3 bits of the BSIC.  BCC values in a multi-BTS network should be assigned so that BTS units with overlapping coverage do not share a BCC.  This value will also select the training sequence used for all slots on this unit.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.BSIC.NCC','0',0,0,'GSM network color code; upper 3 bits of the BSIC.  Assigned by your national regulator.  Must be distinct from NCCs of other GSM operators in your area.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.CI','10',0,0,'Cell ID, 16 bits.  In some cases, the last digit of the cell id represents the sector id. A last digit of 0 is used for an omnidirectional antenna.  A last digit of 1, 2, 3, etc indicates a sector of the multi-sector antenna.  Should be unique.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.LAC','1000',0,0,'Location area code, 16 bits, values 0xFFxx are reserved.  For multi-BTS networks, assign a unique LAC to each BTS unit.  (This is not the normal procedure in conventional GSM networks, but is the correct procedure in OpenBTS networks.)');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.MCC','001',0,0,'Mobile country code; must be three digits.  Defined in ITU-T E.212. Value of 001 for test networks.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.MNC','01',0,0,'Mobile network code, two or three digits.  Assigned by your national regulator.  01 for test networks.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Identity.ShortName','Range',0,0,'Network short name, displayed on some phones.  Optional but must be defined if you also want the network to send time-of-day.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MS.Power.Damping','75',0,0,'Damping value for MS power control loop in percent.   The ordered MS power is based on RSSI [Received Signal Strength Indication].  A value of 100 here ignores RSSI entirely;  a value of 0 causes the MS power to change instantaneously based on RSSI, which is inadvisable because it sets up power oscillations.  The ordered MS power is then clamped between GSM.MS.Power.Max and GSM.MS.Power.Min.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MS.Power.Max','33',0,0,'Maximum commanded MS power level in dBm.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MS.Power.Min','5',0,0,'Minimum commanded MS power level in dBm.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MS.TA.Damping','50',0,0,'Damping value for timing advance control loop.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MS.TA.Max','62',0,0,'Maximum allowed timing advance in symbol periods.  One symbol period of round-trip delay is about 0.55 km of distance.  Ignore RACH bursts with delays greater than this.  Can be used to limit service range.  Valid range is 1..62.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.MaxSpeechLatency','2',0,0,'Maximum allowed speech buffering latency, in 20 millisecond frames.  If the jitter is larger than this delay, frames will be lost.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Neighbors','',0,0,'A list of IP addresses of neighbor BTSs available for handover.  By default handover is disabled.  To enable, specify a space-separated list of a maximum of 31 OpenBTS IP addresses in IP dotted notation, optionally followed by a colon and the port number. E.g.: 1.2.3.4 5.6.7.8:16001.  To disable again, execute "unconfig GSM.Neighbors".');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Neighbors.Averaging','4',0,0,'If non-zero, neighbor measurement reports are averaged.  To be considered for handover a neighbor must appear in 2 of the last GSM.Neighbors.Averaging measurement reports sent by the MS.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Neighbors.NumToSend','31',0,0,'Maximum number of neighbors to send to handset in the neighbor list broadcast in the beacon.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Ny1','50',1,0,'Maximum number of repeats of the Physical Information Message during handover procedure, GSM 04.08 11.1.3.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RACH.AC','0x0400',0,0,'Access class flags.  This is the raw parameter sent on the BCCH.  See GSM 04.08 10.5.2.29 for encoding.  Set to 0 to allow full access.  Set to 0x0400 to indicate no support for emergency calls.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RACH.MaxRetrans','1',0,0,'Maximum RACH retransmission attempts.  This is the raw parameter sent on the BCCH.  See GSM 04.08 10.5.2.29 for encoding.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RACH.TxInteger','14',0,0,'Parameter to spread RACH busts over time.  This is the raw parameter sent on the BCCH.  See GSM 04.08 10.5.2.29 for encoding.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.ACCURACY','40',0,0,'Requested accuracy of location request. K in r=10(1.1**K-1), where r is the accuracy in meters. See 3GPP 03.32 Sec 6.2.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.ALMANAC.ASSIST.PRESENT','0',0,0,'1=enabled, 0=disabled - Send almanac info to mobile.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.ALMANAC.REFRESH.TIME','24.0',0,0,'How often the almanac is refreshed, in hours.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.ALMANAC.URL','http://www.navcen.uscg.gov/?pageName=currentAlmanac&format=yuma',0,0,'URL of the almanac source.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.EPHEMERIS.ASSIST.COUNT','9',0,0,'Number of satellites to include in navigation model.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.EPHEMERIS.REFRESH.TIME','1.0',0,0,'How often the ephemeris is refreshed, in hours.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.EPHEMERIS.URL','ftp://ftp.trimble.com/pub/eph/CurRnxN.nav',0,0,'URL of ephemeris source.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.RESPONSETIME','4',0,0,'Mobile timeout.  (OpenBTS timeout is 130 sec = max response time + 2.) N in 2**N. See 3GPP 04.31 Sec A.2.2.1.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.SEED.ALTITUDE','0',0,0,'Seed altitude in meters wrt geoidal surface.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.SEED.LATITUDE','37.777423',0,0,'Seed latitude in degrees: -90 (south pole) .. +90 (north pole).');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.SEED.LONGITUDE','-122.39807',0,0,'Seed longitude in degrees: -180 (west of greenwich) .. +180 (east).');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.RRLP.SERVER.URL','',0,0,'URL of RRLP server.  By default, this feature is disabled.  To enable, specify a server URL eg: http://localhost/cgi/rrlpserver.cgi.  To disable again, execute "unconfig GSM.RRLP.SERVER.URL".');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.ARFCNs','1',1,0,'The number of ARFCNs to use.  The ARFCN set will be C0, C0+2, C0+4, etc.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.Band','900',1,0,'The GSM operating band.  Valid values are 850 for GSM850, 900 for PGSM900, 1800 for DCS1800 and 1900 for PCS1900.  For non-multiband units, this value is dictated by the hardware and should not be changed.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.C0','51',1,0,'The C0 ARFCN.  Also the base ARFCN for a multi-ARFCN configuration.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.MaxExpectedDelaySpread','4',0,0,'Expected worst-case delay spread in symbol periods, roughly 3.7 us or 1.1 km per unit.  This parameter is dependent on the terrain type in the installation area.  Typical values are: 1 for open terrain and small coverage areas, a value of 4 is strongly recommended for large coverage areas.  This parameter has a large effect on computational requirements of the software radio; values greater than 4 should be avoided.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.NeedBSIC','0',0,0,'1=enabled, 0=disabled - Whether the Radio type requires the full BSIC.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.MaxAttenDB','10',0,0,'Maximum transmitter attenuation level, in dB wrt full scale on the D/A output.  This sets the minimum power output level in the output power control loop.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.MinAttenDB','0',0,0,'Minimum transmitter attenuation level, in dB wrt full scale on the D/A output.  This sets the maximum power output level in the output power control loop.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.NumSamples','10',0,0,'Number of samples averaged by the output power control loop.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.Period','6000',0,0,'Power manager control loop master period, in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.SamplePeriod','2000',0,0,'Sample period for the output power control loop in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.PowerManager.TargetT3122','5000',0,0,'Target value for T3122, the random access hold-off timer, for the power control loop.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.RSSITarget','-50',0,0,'Target uplink RSSI for MS power control loop, in dB wrt to A/D full scale.  Should be 6-10 dB above the noise floor.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Radio.RxGain','47',1,0,'Receiver gain setting in dB.  Ideal value is dictated by the hardware; 47 dB for RAD1.  This database parameter is static but the receiver gain can be modified in real time with the CLI "rxgain" command.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.ShowCountry','0',0,0,'1=enabled, 0=disabled - Tell the MS to show the country name based on the MCC.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.SpeechBuffer','1',0,0,'Size of speech buffer in milliseconds.  If set to 0, no RTP speech buffer is used.  If set to 1, the RTP speech buffer size is determined adaptively.  Any other value sets the speech buffer size.  The speech buffer is needed to overcome jitter caused by natural variation in the internet traffic delay.  Note that speech is noticeably delayed by this amount, so we want to keep it as low as possible and still have reasonably reliable delivery.  The specified delay is in addition to the intrinsic buffering inside OpenBTS.  This value is used only at the start of a call; changing it does not affect on-going calls.  ');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.Handover.Holdoff','10',1,0,'Handover will not be permitted until this time has elapsed after an initial channel seizure or handover.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3103','12000',1,0,'Handover timeout in milliseconds, GSM 04.08 11.1.2.  This is the timeout for a handset to seize a channel during handover.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3105','50',1,0,'Milliseconds for handset to respond to physical information.  GSM 04.08 11.1.2.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3113','10000',0,0,'Paging timer T3113 in milliseconds.  This is the timeout for a handset to respond to a paging request.  This should usually be the same as SIP.Timer.B in your VoIP network.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3122Max','255000',0,0,'Maximum allowed value for T3122, the RACH holdoff timer, in milliseconds.  This timer is sent to the MS with a granularity of seconds in the range 1-255.  GSM 4.08 10.5.2.43.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3122Min','10000',0,0,'Minimum allowed value for T3122, the RACH holdoff timer, in milliseconds.  GSM 4.08 10.5.2.43. This timer is sent to the MS with a granularity of seconds in the range 1-255.  The purpose is to postpone the MS RACH procedure until an SDCCH available, so there is no point making it any smaller than the expected availability of the SDCCH, which will take several seconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('GSM.Timer.T3212','0',0,0,'Registration timer T3212 period in minutes.  Should be a factor of 6.  Set to 0 to disable periodic registration.  Should be smaller than SIP registration period.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Log.Alarms.Max','20',0,0,'Maximum number of alarms to remember inside the application.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Log.File','',0,0,'Path to use for textfile based logging.  By default, this feature is disabled.  To enable, specify an absolute path to the file you wish to use, eg: /tmp/my-debug.log.  To disable again, execute "unconfig Log.File".');
INSERT OR IGNORE INTO "CONFIG" VALUES('Log.Level','NOTICE',0,0,'Default logging level when no other level is defined for a file.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Peering.Neighbor.RefreshAge','60',0,0,'Seconds before refreshing parameters from a neighbor.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Peering.NeighborTable.Path','/var/run/OpenBTS/NeighborTable.db',1,0,'File path for neighbor information database.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Peering.Port','16001',1,0,'The UDP port used by the peer interface for handover.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Peering.ResendCount','20',0,0,'Number of tries to send message over the peer interface before giving up.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Peering.ResendTimeout','100',0,0,'Milliseconds before resending a message on the peer interface.');
INSERT OR IGNORE INTO "CONFIG" VALUES('RTP.Range','98',1,0,'Range of RTP port pool.  Pool is RTP.Start to RTP.Range - 1.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('RTP.Start','16484',1,0,'Base of RTP port pool.  Pool is RTP.Start to RTP.Range - 1.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SGSN.Debug','0',0,0,'1=enabled, 0=disabled - Add layer 3 messages to the GGSN.Logfile, if any.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SGSN.Timer.ImplicitDetach','3480',0,0,'3GPP 24.008 11.2.2.  GPRS attached MS is implicitly detached in seconds.  Should be at least 240 seconds greater than SGSN.Timer.RAUpdate.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SGSN.Timer.MS.Idle','600',0,0,'How long an MS is idle before the SGSN forgets TLLI specific information.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SGSN.Timer.RAUpdate','0',0,0,'Also known as T3312, 3GPP 24.008 4.7.2.2.  How often MS reports into the SGSN when it is idle, in seconds.  Setting to 0 or >12000 deactivates entirely, i.e., sets the timer to effective infinity.  Note: to prevent GPRS Routing Area Updates you must set both this and GSM.Timer.T3212 to 0.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SGSN.Timer.Ready','44',0,0,'Also known as T3314, 3GPP 24.008 4.7.2.1.  Inactivity period required before MS may perform another routing area or cell update, in seconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.DTMF.RFC2833','1',0,0,'1=enabled, 0=disabled - Use RFC-2833 (RTP event signalling) for in-call DTMF.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.DTMF.RFC2833.PayloadType','101',0,0,'Payload type to use for RFC-2833 telephone event packets.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.DTMF.RFC2967','0',0,0,'1=enabled, 0=disabled - Obsolete; incorrect RFC number.  Use SIP.DTMF.RFC2976.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.DTMF.RFC2976','0',0,0,'1=enabled, 0=disabled - Use RFC-2976 (SIP INFO method) for in-call DTMF.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Local.IP','127.0.0.1',1,0,'IP address of the OpenBTS machine as seen by its proxies.  If these are all local, this can be localhost.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Local.Port','5062',1,0,'IP port that OpenBTS uses for its SIP interface.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.MaxForwards','70',0,0,'Maximum allowed number of referrals.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Proxy.Mode','',0,0,'If set to direct, then direct BTS to BTS calls are permitted without an intervening SIP switch, for example, no asterisk needed.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Proxy.Registration','127.0.0.1:5064',0,0,'The hostname or IP address and port of the proxy to be used for registration and authentication.  This should normally be the subscriber registry SIP interface, not Asterisk.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Proxy.SMS','127.0.0.1:5063',0,0,'The hostname or IP address and port of the proxy to be used for text messaging.  This is smqueue, for example.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Proxy.Speech','127.0.0.1:5060',0,0,'The hostname or IP address and port of the proxy to be used for normal speech calls.  This is Asterisk, for example.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Proxy.USSD','',0,0,'The hostname or IP address and port of the proxy to be used for USSD, or "testmode" to test by reflecting USSD messages back to the handset.  To disable USSD, execute "unconfig SIP.Proxy.USSD".');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.RFC3428.NoTrying','0',0,0,'1=enabled, 0=disabled - Send "100 Trying" response to SIP MESSAGE, even though that violates RFC-3428.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.RegistrationPeriod','90',0,0,'Registration period in minutes for MS SIP users.  Should be longer than GSM T3212.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.SMSC','smsc',0,0,'The SMSC handler in smqueue.  This is the entity that handles full 3GPP MIME-encapsulted TPDUs.  If not defined, use direct numeric addressing.  The value should be disabled with "unconfig SIP.SMSC" if SMS.MIMEType is "text/plain" or set to "smsc" if SMS.MIMEType is "application/vnd.3gpp".');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Timer.A','2000',0,0,'SIP timer A, the INVITE retry period, RFC-3261 Section 17.1.1.2, in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Timer.B','10000',0,0,'INVITE transaction timeout in milliseconds.  This value should usually match GSM.Timer.T3113.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Timer.E','500',0,0,'Non-INVITE initial request retransmit period in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Timer.F','5000',0,0,'Non-INVITE initial request timeout in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SIP.Timer.H','5000',0,0,'ACK timeout period in milliseconds.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SMS.FakeSrcSMSC','0000',0,0,'Use this to fill in L4 SMSC address in SMS delivery.');
INSERT OR IGNORE INTO "CONFIG" VALUES('SMS.MIMEType','application/vnd.3gpp.sms',0,0,'This is the MIME Type that OpenBTS will use for RFC-3428 SIP MESSAGE payloads.  Valid values are "application/vnd.3gpp.sms" and "text/plain".');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.Args','',0,0,'Extra arguments for the Transceiver.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.IP','127.0.0.1',1,0,'IP address of the transceiver application.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.MinimumRxRSSI','-63',0,0,'Bursts received at the physical layer below this threshold are automatically ignored.  Values in dB.  Set at the factory.  Do not adjust without proper calibration.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.Port','5700',1,0,'IP port of the transceiver application.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.RadioFrequencyOffset','128',1,0,'Fine-tuning adjustment for the Transceiver master clock.  Roughly 170 Hz/step.  Set at the factory.  Do not adjust without proper calibration.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.Timeout.Clock','10',0,0,'How long to wait during a read operation from the Transceiver before giving up.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.Timeout.Start','2',0,0,'How long to wait during system startup before checking to see if the Transceiver can be reached.');
INSERT OR IGNORE INTO "CONFIG" VALUES('TRX.TxAttenOffset','0',1,0,'Hardware-specific gain adjustment for transmitter, matched to the power amplifier, expessed as an attenuation in dB.  Set at the factory.  Do not adjust without proper calibration.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Test.GSM.SimulatedFER.Downlink','0',0,0,'Probability (0-100) of dropping any downlink frame to test robustness.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Test.GSM.SimulatedFER.Uplink','0',0,0,'Probability (0-100) of dropping any uplink frame to test robustness.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Test.GSM.UplinkFuzzingRate','0',1,0,'Probability (0-100) of flipping a bit in any uplink frame to test robustness.  Static.');
INSERT OR IGNORE INTO "CONFIG" VALUES('Test.SIP.SimulatedPacketLoss','0',1,0,'Probability (0-100) of dropping any inbound or outbound SIP packet to test robustness.  Static.');
COMMIT;


