/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import net.sf.phpeasyvcs.JSON;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synchronizer {
    private File localRoot;
    private URL remoteRoot;
    private Pattern excludePattern;
    private String cookies;
    private EventListenerList listenerList;
    private boolean running = false;
    private int progress = 0;
    private int total = 0;

    public Synchronizer(File localRoot, URL remoteRoot, String cookies) {
        this(localRoot, remoteRoot, null, cookies);
    }

    public Synchronizer(File localRoot, URL remoteRoot, Pattern excludePattern, String cookies) {
        this.localRoot = localRoot;
        this.remoteRoot = remoteRoot;
        this.excludePattern = excludePattern;
        this.cookies = cookies;
        this.listenerList = new EventListenerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> scan(String dir) throws Exception {
        Object object = this;
        synchronized (object) {
            if (this.running) {
                return null;
            }
            this.running = true;
        }
        try {
            this.progress = 0;
            this.total = this.countDirs(dir);
            object = this.scanDir(dir, true);
            return object;
        }
        finally {
            Synchronizer synchronizer = this;
            synchronized (synchronizer) {
                this.running = false;
            }
        }
    }

    private int countDirs(String dir) {
        int count = 1;
        File d = new File(this.localRoot.toString() + "/" + dir);
        File[] files = d.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                count += this.countDirs(dir == "" ? f.getName() : dir + "/" + f.getName());
            }
        }
        return count;
    }

    private List<Entry> scanDir(String dir, boolean checkRemote) throws Exception {
        File d;
        File[] localFiles;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        HashMap<String, RemoteFile> remoteFiles = new HashMap<String, RemoteFile>();
        if (checkRemote) {
            URL url = new URL(this.remoteRoot.toString() + "/" + dir + "?deleted=1&history=1");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Cookie", this.cookies);
            int status = conn.getResponseCode();
            if (status == 200) {
                String contenttype = conn.getContentType();
                int pos = contenttype.indexOf("charset=");
                String charset = pos >= 0 ? contenttype.substring(pos + 8) : "UTF-8";
                Object result = JSON.read(new InputStreamReader(conn.getInputStream(), charset));
                for (Map item : (List)result) {
                    remoteFiles.put(item.get("name").toString(), new RemoteFile(item));
                }
            }
        }
        if ((localFiles = (d = new File(this.localRoot.toString() + "/" + dir)).listFiles()) != null) {
            for (File localFile : localFiles) {
                EntrySide remote;
                EntrySide local;
                String name = localFile.getName();
                RemoteFile remoteFile = (RemoteFile)remoteFiles.remove(name);
                if (this.excludePattern != null && this.excludePattern.matcher(name).matches()) continue;
                if (localFile.isDirectory()) {
                    local = new EntrySide(true, localFile.lastModified(), null, -1);
                    if (remoteFile == null) {
                        entries.add(new Entry(dir, name, null, Action.NONE, local, null));
                        continue;
                    }
                    if (!remoteFile.isDir()) {
                        remote = new EntrySide(false, remoteFile.getDate(), remoteFile.getSize(), remoteFile.getVersion());
                        entries.add(new Entry(dir, name, null, Action.ERROR, local, remote));
                        continue;
                    }
                    if (remoteFile.isDeleted()) {
                        entries.add(new Entry(dir, name, null, Action.NONE, local, null));
                        continue;
                    }
                    remote = new EntrySide(true, remoteFile.getDate(), null, remoteFile.getVersion());
                    entries.add(new Entry(dir, name, null, Action.NONE, local, remote));
                    continue;
                }
                local = new EntrySide(false, localFile.lastModified(), (Long)localFile.length(), -1);
                if (remoteFile == null) {
                    entries.add(new Entry(dir, name, null, Action.COPY_TO_REMOTE, local, null));
                    continue;
                }
                if (remoteFile.isDir()) {
                    remote = new EntrySide(true, remoteFile.getDate(), null, remoteFile.getVersion());
                    entries.add(new Entry(dir, name, null, Action.ERROR, local, remote));
                    continue;
                }
                if (remoteFile.getVersions() == null) {
                    entries.add(new Entry(dir, name, null, Action.COPY_TO_REMOTE, local, null));
                    continue;
                }
                String md5 = null;
                String sha1 = null;
                for (int i = remoteFile.getVersions().size() - 1; i >= 0; --i) {
                    RemoteVersion version = remoteFile.getVersions().get(i);
                    if (version.isDeleted() || !local.getSize().equals(version.getSize())) continue;
                    if (md5 == null) {
                        int len;
                        MessageDigest md_md5 = MessageDigest.getInstance("MD5");
                        MessageDigest md_sha1 = MessageDigest.getInstance("SHA-1");
                        FileInputStream is = new FileInputStream(localFile);
                        byte[] buf = new byte[16384];
                        while ((len = ((InputStream)is).read(buf)) >= 0) {
                            md_md5.update(buf, 0, len);
                            md_sha1.update(buf, 0, len);
                        }
                        ((InputStream)is).close();
                        md5 = this.toHexString(md_md5.digest());
                        sha1 = this.toHexString(md_sha1.digest());
                    }
                    if (!version.getMd5().equals(md5) || !version.getSha1().equals(sha1)) continue;
                    local = new EntrySide(false, local.getDate(), local.getSize(), version.getVersion());
                    break;
                }
                Action action = null;
                if (local.getVersion() == remoteFile.getVersion()) {
                    action = Action.IDENTICAL;
                } else if (local.getVersion() >= 0) {
                    action = remoteFile.isDeleted() ? Action.DELETE_LOCAL : Action.COPY_TO_LOCAL;
                } else if (local.getDate().after(remoteFile.getDate())) {
                    action = Action.COPY_TO_REMOTE;
                } else {
                    Action action2 = action = remoteFile.isDeleted() ? Action.COPY_TO_REMOTE : Action.MERGE;
                }
                if (remoteFile.isDeleted()) {
                    entries.add(new Entry(dir, name, remoteFile.getMimetype(), action, local, null));
                    continue;
                }
                EntrySide remote2 = new EntrySide(false, remoteFile.getDate(), remoteFile.getSize(), remoteFile.getVersion());
                entries.add(new Entry(dir, name, remoteFile.getMimetype(), action, local, remote2));
            }
        }
        for (RemoteFile remoteFile : remoteFiles.values()) {
            if (remoteFile.isDeleted()) continue;
            if (remoteFile.isDir()) {
                EntrySide remote = new EntrySide(true, remoteFile.getDate(), null, remoteFile.getVersion());
                entries.add(new Entry(dir, remoteFile.getName(), remoteFile.getMimetype(), Action.NONE, null, remote));
                ++this.total;
                continue;
            }
            EntrySide remote = new EntrySide(false, remoteFile.getDate(), remoteFile.getSize(), remoteFile.getVersion());
            entries.add(new Entry(dir, remoteFile.getName(), remoteFile.getMimetype(), Action.COPY_TO_LOCAL, null, remote));
        }
        Collections.sort(entries);
        ++this.progress;
        this.fireProgress(new ProgressEvent(this, this.progress, this.total));
        for (Entry entry : entries) {
            if (entry.getLocal() == null && entry.getRemote().isDir()) {
                List<Entry> subentries = this.scanDir(dir + "/" + entry.getName(), true);
                entry.addEntries(subentries);
                continue;
            }
            if (entry.getLocal() == null || !entry.getLocal().isDir()) continue;
            if (entry.getAction() == Action.ERROR) {
                this.total -= this.countDirs(dir + "/" + entry.getName());
                continue;
            }
            List<Entry> subentries = this.scanDir(dir + "/" + entry.getName(), entry.getRemote() != null);
            entry.addEntries(subentries);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SyncAction> sync(List<SyncAction> actions, String comment) throws Exception {
        Synchronizer synchronizer = this;
        synchronized (synchronizer) {
            if (this.running) {
                return null;
            }
            this.running = true;
        }
        try {
            List<SyncAction> failedActions;
            List<SyncAction> list = failedActions = this.syncIt(actions, comment);
            return list;
        }
        finally {
            Synchronizer synchronizer2 = this;
            synchronized (synchronizer2) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<SyncAction> syncIt(List<SyncAction> actions, String comment) throws Exception {
        charset = "UTF-8";
        this.progress = 0;
        this.total = actions.size() * 100;
        failedActions = new ArrayList<SyncAction>();
        for (SyncAction sa : actions) {
            local = new File(this.localRoot.getPath() + '/' + sa.getPath());
            if (!(sa.getAction() != Action.DELETE_LOCAL && sa.getAction() != Action.DELETE_BOTH || local.delete())) {
                failedActions.add(sa);
            }
            if (sa.getAction() == Action.DELETE_REMOTE || sa.getAction() == Action.DELETE_BOTH) {
                url = new URL(this.remoteRoot.toString() + "/" + sa.getPath() + (comment != null ? "?comment=" + URLEncoder.encode(comment, "UTF-8") : ""));
                conn = (HttpURLConnection)url.openConnection();
                os = null;
                writer = null;
                try {
                    conn.setRequestMethod("DELETE");
                    conn.setRequestProperty("Cookie", this.cookies);
                    status = conn.getResponseCode();
                    if (status >= 200 && status < 300) ** GOTO lbl143
                    failedActions.add(sa);
                }
                catch (Exception e) {
                    failedActions.add(sa);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            } else if (sa.getAction() == Action.COPY_TO_LOCAL) {
                url = new URL(this.remoteRoot.toString() + "/" + sa.getPath());
                conn = (HttpURLConnection)url.openConnection();
                is = null;
                os = null;
                try {
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Cookie", this.cookies);
                    conn.connect();
                    status = conn.getResponseCode();
                    if (status == 200) {
                        is = conn.getInputStream();
                        if (!local.getParentFile().exists()) {
                            local.getParentFile().mkdirs();
                        }
                        os = new FileOutputStream(local);
                        curr = 0;
                        buf = new byte[32768];
                        while ((len = is.read(buf)) >= 0) {
                            os.write(buf, 0, len);
                            percent = (int)((long)(curr += len) < sa.getSize() ? (long)(100 * curr) / sa.getSize() : 100L);
                            this.fireProgress(new ProgressEvent(this, this.progress + percent, this.total));
                        }
                        os.close();
                        is.close();
                    }
                    failedActions.add(sa);
                }
                catch (Exception e) {
                    failedActions.add(sa);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            } else if (sa.getAction() == Action.COPY_TO_REMOTE) {
                CRLF = "\r\n";
                boundary = Long.toHexString(System.currentTimeMillis());
                url = new URL(this.remoteRoot.toString() + "/" + sa.getPath());
                conn = (HttpURLConnection)url.openConnection();
                os = null;
                writer = null;
                try {
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Cookie", this.cookies);
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    os = conn.getOutputStream();
                    writer = new PrintWriter((Writer)new OutputStreamWriter(os, charset), true);
                    writer.append("--" + boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"comment\"").append(CRLF);
                    writer.append("Content-Type: text/plain; charset=" + charset).append(CRLF);
                    writer.append(CRLF);
                    writer.append(comment).append(CRLF).flush();
                    writer.append("--" + boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + local.getName() + "\"").append(CRLF);
                    writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(local.getName())).append(CRLF);
                    writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                    writer.append(CRLF).flush();
                    is = null;
                    try {
                        is = new FileInputStream(local);
                        buffer = new byte[32768];
                        len = 0;
                        curr = 0;
                        while ((len = is.read(buffer)) >= 0) {
                            os.write(buffer, 0, len);
                            percent = (int)((long)(curr += len) < sa.getSize() ? (long)(100 * curr) / sa.getSize() : 100L);
                            this.fireProgress(new ProgressEvent(local, this.progress + percent, this.total));
                        }
                        os.flush();
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    writer.append(CRLF).flush();
                    writer.append("--" + boundary + "--").append(CRLF);
                    writer.flush();
                    status = conn.getResponseCode();
                    if (status < 200 || status >= 300) {
                        failedActions.add(sa);
                    }
                }
                catch (Exception e) {
                    failedActions.add(sa);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
            this.progress += 100;
            this.fireProgress(new ProgressEvent(this, this.progress, this.total));
        }
        return failedActions;
    }

    private String toHexString(byte[] bytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String s = Integer.toHexString(0xFF & bytes[i]);
            if (s.length() < 2) {
                hexString.append('0');
            }
            hexString.append(s);
        }
        return hexString.toString();
    }

    public void addProgressListener(ProgressListener listener) {
        this.listenerList.add(ProgressListener.class, listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listenerList.remove(ProgressListener.class, listener);
    }

    void fireProgress(ProgressEvent event) {
        for (ProgressListener listener : (ProgressListener[])this.listenerList.getListeners(ProgressListener.class)) {
            listener.progressOccurred(event);
        }
    }

    public static class SyncAction {
        private Action action;
        private String path;
        private Long size;

        public SyncAction(Action action, String path, Long size) {
            this.action = action;
            this.path = path;
            this.size = size;
        }

        public Action getAction() {
            return this.action;
        }

        public String getPath() {
            return this.path;
        }

        public Long getSize() {
            return this.size;
        }
    }

    public static class EntrySide {
        private boolean dir;
        private Date date;
        private Long size;
        private int version;

        public EntrySide(boolean dir, Date date, Long size, int version) {
            this.dir = dir;
            this.date = date;
            this.size = size;
            this.version = version;
        }

        public EntrySide(boolean dir, Long date, Long size, int version) {
            this(dir, new Date(date), size, version);
        }

        public boolean isDir() {
            return this.dir;
        }

        public Date getDate() {
            return this.date;
        }

        public Long getSize() {
            return this.size;
        }

        public int getVersion() {
            return this.version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Comparable<Entry> {
        private String dir;
        private String name;
        private String mimetype;
        private EntrySide local;
        private EntrySide remote;
        private Action action;
        private List<Entry> entries;

        public Entry(String dir, String name, String mimetype, Action action, EntrySide local, EntrySide remote) {
            this.dir = dir;
            this.name = name;
            this.mimetype = mimetype;
            this.action = action;
            this.local = local;
            this.remote = remote;
            this.entries = new ArrayList<Entry>();
        }

        public void addEntry(Entry entry) {
            this.entries.add(entry);
        }

        public void addEntries(Collection<Entry> entries) {
            this.entries.addAll(entries);
        }

        public String getDir() {
            return this.dir;
        }

        public String getName() {
            return this.name;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public Action getAction() {
            return this.action;
        }

        public EntrySide getLocal() {
            return this.local;
        }

        public EntrySide getRemote() {
            return this.remote;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        @Override
        public int compareTo(Entry o) {
            if (this.local != null && this.local.dir || this.remote != null && this.remote.dir) {
                if (o.local != null && o.local.dir || o.remote != null && o.remote.dir) {
                    return this.name.compareTo(o.name);
                }
                return -1;
            }
            if (o.local != null && o.local.dir || o.remote != null && o.remote.dir) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        NONE,
        COPY_TO_LOCAL,
        COPY_TO_REMOTE,
        DELETE_LOCAL,
        DELETE_REMOTE,
        DELETE_BOTH,
        MERGE,
        IDENTICAL,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteFile {
        private boolean deleted;
        private boolean dir;
        private String name;
        private int version;
        private Date date;
        private Long size;
        private String mimetype;
        private String md5;
        private String sha1;
        private List<RemoteVersion> versions;

        public RemoteFile(Map<String, Object> item) {
            this.deleted = item.containsKey("deleted") ? (Boolean)item.get("deleted") : false;
            this.dir = item.containsKey("directory") ? (Boolean)item.get("directory") : false;
            this.name = item.get("name").toString();
            this.version = ((Number)item.get("version")).intValue();
            this.date = new Date(((Number)item.get("date")).longValue() * 1000L);
            if (!this.dir && !this.deleted) {
                this.size = this.dir ? null : Long.valueOf(((Number)item.get("size")).longValue());
                this.mimetype = item.get("mimetype") != null ? item.get("mimetype").toString() : "application/octet-stream";
                this.md5 = item.get("md5").toString();
                this.sha1 = item.get("sha1").toString();
                this.versions = new ArrayList<RemoteVersion>();
                for (Map version : (List)item.get("versions")) {
                    this.versions.add(new RemoteVersion(version));
                }
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isDir() {
            return this.dir;
        }

        public String getName() {
            return this.name;
        }

        public int getVersion() {
            return this.version;
        }

        public Date getDate() {
            return this.date;
        }

        public Long getSize() {
            return this.size;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public String getMd5() {
            return this.md5;
        }

        public String getSha1() {
            return this.sha1;
        }

        public List<RemoteVersion> getVersions() {
            return this.versions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteVersion {
        private boolean deleted;
        private int version;
        private Date date;
        private Long size;
        private String md5;
        private String sha1;

        public RemoteVersion(Map<String, Object> item) {
            this.deleted = item.containsKey("deleted") ? (Boolean)item.get("deleted") : false;
            this.version = ((Number)item.get("version")).intValue();
            this.date = new Date(((Number)item.get("date")).longValue() * 1000L);
            if (!this.deleted) {
                this.size = ((Number)item.get("size")).longValue();
                this.md5 = item.get("md5").toString();
                this.sha1 = item.get("sha1").toString();
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public int getVersion() {
            return this.version;
        }

        public Date getDate() {
            return this.date;
        }

        public Long getSize() {
            return this.size;
        }

        public String getMd5() {
            return this.md5;
        }

        public String getSha1() {
            return this.sha1;
        }
    }
}

