/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.fife.plaf.OfficeXP.OfficeXPComboBoxUI;

public class OfficeXPArrowButton
extends JButton {
    public static final int NORMAL = 1;
    public static final int ARMED = 2;
    public static final int PRESSED = 3;
    protected OfficeXPComboBoxUI comboBoxUI;
    private int paintState;

    public OfficeXPArrowButton(OfficeXPComboBoxUI officeXPComboBoxUI) {
        this.comboBoxUI = officeXPComboBoxUI;
        this.setRequestFocusEnabled(false);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.isEnabled();
        this.paintBackground(graphics, n, n2);
        graphics.setColor(this.comboBoxUI.getBorderColor());
        graphics.drawLine(0, 0, 0, n2 - 1);
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, bl);
        graphics.setColor(color);
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        Color color;
        Color color2;
        switch (this.paintState) {
            case 2: {
                color2 = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Armed.Gradient1");
                color = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Armed.Gradient2");
                break;
            }
            case 3: {
                color2 = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Selected.Gradient1");
                color = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Selected.Gradient2");
                break;
            }
            default: {
                color2 = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Normal.Gradient1");
                color = UIManager.getColor("OfficeLnF.ComboBox.Arrow.Normal.Gradient2");
            }
        }
        this.paintBackgroundImpl(graphics, color2, color, n, n2);
    }

    protected void paintBackgroundImpl(Graphics graphics, Color color, Color color2, int n, int n2) {
        if (color2 == null || color == color2) {
            graphics.setColor(color);
            graphics.fillRect(1, 0, n - 1, n2);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2 - 1, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(new Rectangle(1, 0, n - 1, n2));
        }
    }

    protected void paintTriangle(Graphics graphics, int n, int n2, int n3, boolean bl) {
        Color color = graphics.getColor();
        int n4 = 0;
        n3 = Math.max(n3, 2);
        int n5 = n3 / 2 - 1;
        graphics.translate(n, n2);
        graphics.setColor(this.getForeground());
        n4 = 0;
        for (int i = n3 - 1; i >= 0; --i) {
            graphics.drawLine(n5 - i, n4, n5 + i, n4);
            ++n4;
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public void updatePaintState(int n) {
        this.paintState = n;
    }
}

