/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.VisualStudio2005;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.StyleContext;
import javax.swing.text.View;

public class VisualStudio2005TabbedPaneUI
extends BasicTabbedPaneUI {
    private boolean oldFocusable;
    private static final int TAB_HEIGHT = 16;
    private static final int INSETS_LEFT = 11;
    private static final int INSETS_RIGHT = 3;

    protected int calculateTabHeight(int n, int n2, int n3) {
        return 16;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        fontMetrics = this.tabPane.getFontMetrics(VisualStudio2005TabbedPaneUI.getBoldFont(this.tabPane.getFont()));
        int n3 = super.calculateTabWidth(n, n2, fontMetrics);
        return n3;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new VisualStudio2005TabbedPaneUI();
    }

    protected static Font getBoldFont(Font font) {
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        return styleContext.getFont(font.getFamily(), 1, font.getSize());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (dimension == null && this.tabPane.getTabLayoutPolicy() == 0) {
            int n = this.tabPane.getTabPlacement();
            dimension = new Dimension(this.calculateMaxTabWidth(n), this.calculateMaxTabHeight(n));
            dimension.width += this.tabAreaInsets.left + this.tabAreaInsets.right;
        }
        return dimension;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        switch (n) {
            case 1: 
            case 3: {
                return 0;
            }
        }
        return 8;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return n == 3 ? -1 : 0;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.contentBorderInsets = new Insets(1, 1, 1, 1);
        this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
        this.tabAreaInsets = new Insets(2, 11, 0, 3);
        this.oldFocusable = this.tabPane.isFocusable();
        this.tabPane.setFocusable(false);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        if (n2 == this.tabPane.getSelectedIndex()) {
            fontMetrics = this.tabPane.getFontMetrics(VisualStudio2005TabbedPaneUI.getBoldFont(this.tabPane.getFont()));
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        int n3 = n == 1 || n == 3 ? 0 : 2;
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, n3, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n, n2, bl);
        int n5 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(UIManager.getColor("VisualStudio2005.TabBorderColor"));
        n4 += n6 - 1;
        if (n != 3 || n2 == -1) {
            graphics.drawLine(n3 + 1, n4, n3 + n5 - 1, n4);
        } else {
            Rectangle rectangle = new Rectangle();
            rectangle = this.getTabBounds(n2, rectangle);
            rectangle.x -= 9;
            rectangle.width += 8;
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 1, n4);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(rectangle.x, n4, rectangle.x + rectangle.width - 1, n4);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(UIManager.getColor("VisualStudio2005.TabBorderColor"));
        if (n != 1 || n2 == -1) {
            graphics.drawLine(n3 + 1, n4, n3 + n5 - 1, n4);
        } else {
            Rectangle rectangle = new Rectangle();
            rectangle = this.getTabBounds(n2, rectangle);
            rectangle.x -= 9;
            rectangle.width += 8;
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 1, n4);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(rectangle.x, n4, rectangle.x + rectangle.width - 1, n4);
        }
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        switch (n) {
            case 3: {
                Rectangle rectangle4;
                for (n4 = 0; n4 < this.runCount; ++n4) {
                    n3 = this.tabRuns[n4];
                    rectangle4 = this.rects[n3];
                    graphics.translate(rectangle4.x, rectangle4.y);
                    graphics.translate(0, 15);
                    graphics2D.scale(1.0, -1.0);
                    this.paintTabOverlappingBackground(graphics, n, -9, 16, n3);
                    this.paintTabOverlappingBorder(graphics, n, -9, 15, n3);
                    graphics2D.setTransform(affineTransform);
                }
                break;
            }
            case 1: {
                Rectangle rectangle4;
                for (n4 = 0; n4 < this.runCount; ++n4) {
                    n3 = this.tabRuns[n4];
                    rectangle4 = this.rects[n3];
                    graphics.translate(rectangle4.x, rectangle4.y);
                    this.paintTabOverlappingBackground(graphics, n, -9, 16, n3);
                    this.paintTabOverlappingBorder(graphics, n, -9, 15, n3);
                    graphics2D.setTransform(affineTransform);
                }
                break;
            }
        }
        graphics2D.setTransform(affineTransform);
        for (n4 = this.runCount - 1; n4 >= 0; --n4) {
            n3 = this.tabRuns[n4];
            int n6 = this.tabRuns[n4 == this.runCount - 1 ? 0 : n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n5 - 1;
            for (int i = n3; i <= n7; ++i) {
                if (!this.rects[i].intersects(rectangle3)) continue;
                this.paintTab(graphics, n, this.rects, i, rectangle, rectangle2);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? UIManager.getColor("TabbedPane.selected") : UIManager.getColor("TabbedPane.background"));
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n3, n4);
        switch (n) {
            case 3: {
                graphics.translate(0, n6);
                graphics2D.scale(1.0, -1.0);
            }
            case 1: 
            case 2: 
            case 4: {
                graphics.fillRect(0, 6, n5 - 1, n6 - 6);
                graphics.drawLine(1, 6, n5 - 2, 6);
                graphics.drawLine(2, 5, n5 - 2, 5);
                graphics.drawLine(3, 4, n5 - 2, 4);
                graphics.drawLine(4, 3, n5 - 2, 3);
                graphics.drawLine(6, 2, n5 - 2, 2);
                graphics.drawLine(8, 1, n5 - 3, 1);
                int n7 = this.getNextTabIndexInRun(this.tabPane.getTabCount(), n2);
                if (n7 != n2 + 1 || n7 != this.tabPane.getSelectedIndex()) break;
                n3 = n5 - 9;
                n4 = n6;
                this.paintTabOverlappingBackground(graphics, n, n3, n4, n7);
                break;
            }
            default: {
                graphics2D.setTransform(affineTransform);
                super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? UIManager.getColor("VisualStudio2005.TabBorderColor") : UIManager.getColor("VisualStudio2005.BackgroundTabBorderColor"));
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n3, n4);
        int n7 = n == 2 || n == 4 ? n6 - 1 : 7;
        switch (n) {
            case 3: {
                graphics.translate(0, n6 - 1);
                graphics2D.scale(1.0, -1.0);
            }
            case 1: 
            case 2: 
            case 4: {
                graphics.drawLine(0, 6, 3, 3);
                graphics.drawLine(4, 2, 5, 2);
                graphics.drawLine(6, 1, 7, 1);
                graphics.drawLine(8, 0, n5 - 3, 0);
                graphics.drawLine(n5 - 2, 1, n5 - 2, 1);
                graphics.drawLine(n5 - 1, 2, n5 - 1, n7);
                int n8 = this.getNextTabIndexInRun(this.tabPane.getTabCount(), n2);
                if (n8 == n2 + 1 && n8 == this.tabPane.getSelectedIndex()) {
                    n3 = n5 - 9;
                    this.paintTabOverlappingBorder(graphics, n, n3, n6 - 1, n8);
                    break;
                }
                graphics.drawLine(n5 - 1, 8, n5 - 1, n6 - 1);
                break;
            }
            default: {
                graphics2D.setTransform(affineTransform);
                super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    protected void paintTabOverlappingBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = n4 == this.tabPane.getSelectedIndex();
        graphics.setColor(bl ? UIManager.getColor("TabbedPane.selected") : UIManager.getColor("TabbedPane.background"));
        switch (n) {
            case 1: 
            case 3: {
                int n5 = n2 + 9;
                graphics.fillPolygon(new int[]{n2, n5, n5}, new int[]{n3, n3, n3 - 9}, 3);
                break;
            }
        }
    }

    protected void paintTabOverlappingBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = n4 == this.tabPane.getSelectedIndex();
        graphics.setColor(bl ? UIManager.getColor("VisualStudio2005.TabBorderColor") : UIManager.getColor("VisualStudio2005.BackgroundTabBorderColor"));
        switch (n) {
            case 1: 
            case 3: {
                graphics.drawLine(n2, n3, n2 + 9, n3 - 9);
                break;
            }
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        if (bl) {
            font = VisualStudio2005TabbedPaneUI.getBoldFont(font);
            fontMetrics = this.tabPane.getFontMetrics(font);
        }
        super.paintText(graphics, n, font, fontMetrics, n2, string, rectangle, bl);
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = super.tabForCoordinate(jTabbedPane, n, n2);
        if (n3 == -1) {
            return n3;
        }
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 3: {
                int n4;
                if (n3 == this.tabPane.getSelectedIndex() || (n4 = this.getNextTabIndexInRun(this.tabPane.getTabCount(), n3)) != n3 + 1) break;
                break;
            }
        }
        return n3;
    }

    protected void uninstallDefaults() {
        this.tabPane.setFocusable(this.oldFocusable);
        super.uninstallDefaults();
    }
}

