/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.util.BasicResourceBridge;
import edu.xtec.util.Check;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JClicApplet
extends JApplet
implements Constants {
    private Options options = new Options(this);
    private RunnableComponent rc = null;
    private String activityPack = null;
    private String sequence = null;
    private boolean initiated = false;
    private boolean trace = false;
    private JLabel splashLabel = new JLabel(" ", ResourceManager.getImageIcon("icons/logo_applet.png"), 0);
    private boolean isInstaller;
    private static final String HTTP = "http:";
    private static final String FILE = "file:";
    private static final String STRING = "string";
    private static final String BOOL = "boolean";
    private static final String URL = "url";
    private static final String ACTIVITY_PACK = "activityPack";
    private static final String SEQUENCE = "sequence";
    private static final int NUM_PRIVATE_PARAMS = 2;
    private static final String[][] pInfo = new String[][]{{"activityPack", "string", "absolute or relative URL of the JClic project to load"}, {"sequence", "string", "optional project's starting sequence name"}, {"language", "string", "two-char language code"}, {"country", "string", "two-char country code"}, {"variant", "string", "locale variant code"}, {"skin", "string", "skin to be used"}, {"cookie", "string", "optional session cookie value. currently not used"}, {"reporter", "string", "reporter class name"}, {"reporterParams", "string", "reporter parameters"}, {"exitUrl", "url", "URL where to redirect navigation at end"}, {"infoUrlFrame", "string", "optional frame where to display info documents. If unespecified, _BLANK will be used"}, {"systemSounds", "boolean", "to play or not system sounds"}, {"compressImages", "boolean", "to compress or not images in cells"}, {"lookAndFeel", "string", "look & feel to use"}, {"audioEnabled", "boolean", "to have audio enabled or not"}, {"mediaSystem", "string", "preferred multimedia system: 'JMF' for Java Media Framework or 'QT' for QuickTime"}, {"trace", "boolean", "show debug messages in console"}};

    public JClicApplet() {
        this.splashLabel.setVerticalTextPosition(3);
        this.splashLabel.setHorizontalTextPosition(0);
        this.splashLabel.setBackground(BG_COLOR);
        this.splashLabel.setOpaque(true);
        this.getContentPane().add((Component)this.splashLabel, "Center");
    }

    public void init() {
        if (this.initiated) {
            return;
        }
        this.initiated = true;
        this.trace = "true".equals(this.getParameter("trace"));
        final StringBuffer stringBuffer = new StringBuffer();
        final JClicApplet jClicApplet = this;
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Object object;
                String string;
                for (int i = 2; i < pInfo.length; ++i) {
                    JClicApplet.this.options.put(pInfo[i][0], JClicApplet.this.getParameter(pInfo[i][0]));
                    if (!JClicApplet.this.trace) continue;
                    System.out.println(">>> param " + pInfo[i][0] + " is " + JClicApplet.this.getParameter(pInfo[i][0]));
                }
                Messages messages = null;
                try {
                    messages = PersistentSettings.getMessages(JClicApplet.this.options, "messages.JClicMessages");
                }
                catch (Exception exception) {
                    System.err.println("Unable to get default user messages language!\n" + exception);
                    messages = Messages.getMessages(JClicApplet.this.options, "messages.JClicMessages");
                }
                messages.addBundle("commonSettings");
                if (JClicApplet.this.splashLabel != null) {
                    JClicApplet.this.splashLabel.setText(messages.get("LOADING"));
                }
                if (!Check.checkSignature(JClicApplet.this.options, true)) {
                    return null;
                }
                CheckMediaSystem.check(JClicApplet.this.options, false);
                JClicApplet.this.activityPack = JClicApplet.this.getParameter(JClicApplet.ACTIVITY_PACK);
                JClicApplet.this.sequence = JClicApplet.this.getParameter(JClicApplet.SEQUENCE);
                if (JClicApplet.this.activityPack != null) {
                    if (JClicApplet.this.activityPack.indexOf("http://") < 0 && JClicApplet.this.activityPack.indexOf(":") < 1 && JClicApplet.this.activityPack.indexOf("\\\\") < 0) {
                        int n;
                        string = JClicApplet.this.getDocumentBase().toString();
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> original base is: " + string);
                        }
                        if ((n = string.indexOf("file:/")) >= 0) {
                            string = string.substring(n + 6);
                            if (JClicApplet.this.trace) {
                                System.out.println(">>> protocol is 'file', so base is: " + string);
                            }
                            if (!JClicApplet.this.options.getBoolean("Windows") && !string.startsWith(File.pathSeparator)) {
                                string = "/" + string;
                                if (JClicApplet.this.trace) {
                                    System.out.println(">>> non-Windows and not starts with '/', so base is: " + string);
                                }
                            }
                        }
                        if (string.startsWith("/localhost/")) {
                            string = string.substring(11);
                        }
                        if (string.endsWith(".htm") || string.endsWith(".html")) {
                            n = string.lastIndexOf(47);
                            if (n < 0) {
                                n = string.lastIndexOf(92);
                            }
                            if (n > 0) {
                                string = string.substring(0, n + 1);
                            }
                        }
                        JClicApplet.this.options.put("urlBase", string);
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> corrected base is: " + string);
                        }
                        JClicApplet.this.activityPack = string + JClicApplet.this.activityPack;
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> project path is: " + JClicApplet.this.activityPack);
                        }
                        if (!((object = JClicApplet.this.options.getString("skin")) == null || ((String)object).startsWith("@") || ((String)object).startsWith(JClicApplet.HTTP) || ((String)object).startsWith(JClicApplet.FILE))) {
                            JClicApplet.this.options.put("skin", string + (String)object);
                        }
                        if ((object = JClicApplet.this.options.getString("exitUrl")) != null && !((String)object).startsWith(JClicApplet.HTTP) && !((String)object).startsWith(JClicApplet.FILE)) {
                            JClicApplet.this.options.put("exitUrl", string + (String)object);
                        }
                    }
                    if (JClicApplet.this.activityPack.endsWith(".jclic.inst")) {
                        JClicApplet.this.isInstaller = true;
                        messages.addBundle("messages.PlayerMessages");
                    }
                }
                try {
                    if (JClicApplet.this.isInstaller) {
                        string = JClicApplet.this.activityPack;
                        JClicApplet.this.activityPack = null;
                        BasicResourceBridge basicResourceBridge = new BasicResourceBridge(JClicApplet.this.options);
                        object = PlayerSettings.loadPlayerSettings(basicResourceBridge);
                        if (((PlayerSettings)object).promptPassword(null, null)) {
                            ((PlayerSettings)object).checkLibrary();
                            ProjectInstallerDlg projectInstallerDlg = ProjectInstallerDlg.getProjectInstallerDlg(null, ((PlayerSettings)object).libraryManager, string);
                            if (projectInstallerDlg != null) {
                                projectInstallerDlg.setVisible(true);
                                if (!projectInstallerDlg.cancel && projectInstallerDlg.launchNow && projectInstallerDlg.pathToMainProject != null) {
                                    JClicApplet.this.activityPack = projectInstallerDlg.pathToMainProject;
                                }
                            }
                        }
                    }
                    if (JClicApplet.this.activityPack != null) {
                        JClicApplet.this.rc = new Player(JClicApplet.this.options);
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append("ERROR: ").append(exception);
                }
                return JClicApplet.this.rc;
            }

            public void finished() {
                if (this.getValue() == null) {
                    String string;
                    if (JClicApplet.this.isInstaller && JClicApplet.this.options.getString("exitUrl") != null) {
                        try {
                            string = JClicApplet.this.options.getString("exitUrl");
                            if (string.indexOf(58) < 0) {
                                string = "file://" + string;
                            }
                            JClicApplet.this.getAppletContext().showDocument(new URL(string));
                        }
                        catch (Exception exception) {
                            stringBuffer.append("ERROR: ").append(exception);
                        }
                    }
                    if (JClicApplet.this.splashLabel != null) {
                        string = stringBuffer.substring(0);
                        JClicApplet.this.splashLabel.setText(string);
                        System.err.println(string);
                    }
                } else {
                    JClicApplet.this.getContentPane().removeAll();
                    JClicApplet.this.splashLabel = null;
                    JClicApplet.this.rc.addTo(jClicApplet, "Center");
                    JClicApplet.this.getRootPane().revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JClicApplet.this.rc.start(JClicApplet.this.activityPack, JClicApplet.this.sequence);
                        }
                    });
                }
            }
        };
        if (this.trace) {
            System.out.println(">>> initializing...");
        }
        swingWorker.start();
    }

    public void start() {
        if (this.trace) {
            System.out.println(">>> applet started");
        }
    }

    public void stop() {
        if (this.rc != null) {
            this.rc.stop();
        }
        if (this.trace) {
            System.out.println(">>> applet stopped");
        }
    }

    public void destroy() {
        if (this.rc != null) {
            if (this.trace) {
                System.out.println(">>> destroying applet...");
            }
            this.getContentPane().removeAll();
            this.rc.end();
            this.rc = null;
            this.initiated = false;
        }
        if (this.trace) {
            System.out.println(">>> applet destroyed");
        }
    }

    public String getAppletInfo() {
        return "JClic applet";
    }

    public String[][] getParameterInfo() {
        return pInfo;
    }
}

