/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.memory;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jdom.Element;

public class MemoryGame
extends Activity
implements ActiveBagContentKit.Compatible {
    public MemoryGame(JClicProject jClicProject) {
        super(jClicProject);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[2];
    }

    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    public Element getJDomElement() {
        Element element = null;
        if (this.abc[0] == null) {
            return null;
        }
        Element element2 = super.getJDomElement();
        element2.addContent(this.abc[0].getJDomElement().setAttribute("id", "primary"));
        if (this.abc[1] != null) {
            element2.addContent(this.abc[1].getJDomElement().setAttribute("id", "secondary"));
        }
        element = new Element("scramble");
        element.setAttribute("times", Integer.toString(this.shuffles));
        element2.addContent(element);
        element = new Element("layout");
        element.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        element2.addContent(element);
        return element2;
    }

    public void setProperties(Element element, Object object) throws Exception {
        Element element2;
        super.setProperties(element, object);
        ActiveBagContent activeBagContent = null;
        this.abc[1] = null;
        Iterator iterator = element.getChildren("cells").iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            activeBagContent = ActiveBagContent.getActiveBagContent(element2, this.project.mediaBag);
            String string = JDomUtility.getStringAttr(element2, "id", "primary", false);
            if ("primary".equals(string)) {
                this.abc[0] = activeBagContent;
                continue;
            }
            if (!"secondary".equals(string)) continue;
            this.abc[1] = activeBagContent;
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Memory game without ActiveBagContent");
        }
        element2 = element.getChild("scramble");
        if (element2 != null) {
            this.shuffles = JDomUtility.getIntAttr(element2, "times", this.shuffles);
        }
        if ((element2 = element.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(element2, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.abc[0] = clic3Activity.createActiveBagContent(0);
        this.abc[0].setBoxBase(clic3Activity.getBoxBase(0));
        this.boxGridPos = clic3Activity.graPos;
    }

    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    public boolean hasRandom() {
        return true;
    }

    public boolean shuffleAlways() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bg;

        protected Panel(PlayStation playStation) {
            super(playStation);
            this.bc = new BoxConnector(this);
        }

        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (MemoryGame.this.abc[0] != null) {
                if (MemoryGame.this.acp != null) {
                    ActiveBagContent[] activeBagContentArray;
                    if (MemoryGame.this.abc[1] == null) {
                        ActiveBagContent[] activeBagContentArray2 = new ActiveBagContent[1];
                        activeBagContentArray = activeBagContentArray2;
                        activeBagContentArray2[0] = MemoryGame.this.abc[0];
                    } else {
                        ActiveBagContent[] activeBagContentArray3 = new ActiveBagContent[2];
                        activeBagContentArray3[0] = MemoryGame.this.abc[0];
                        activeBagContentArray = activeBagContentArray3;
                        activeBagContentArray3[1] = MemoryGame.this.abc[1];
                    }
                    ActiveBagContent[] activeBagContentArray4 = activeBagContentArray;
                    MemoryGame.this.acp.generateContent(new ActiveBagContentKit(MemoryGame.this.abc[0].nch, MemoryGame.this.abc[0].ncw, activeBagContentArray4, false), this.ps);
                }
                int n = MemoryGame.this.abc[0].ncw;
                int n2 = MemoryGame.this.abc[0].nch;
                if (MemoryGame.this.boxGridPos == 0 || MemoryGame.this.boxGridPos == 1) {
                    n *= 2;
                } else {
                    n2 *= 2;
                }
                this.bg = new ActiveBoxGrid(null, this, MemoryGame.this.margin, MemoryGame.this.margin, MemoryGame.this.abc[0].w * (double)n, MemoryGame.this.abc[0].h * (double)n2, new Rectangular(n, n2), MemoryGame.this.abc[0].bb);
                int n3 = MemoryGame.this.abc[0].getNumCells();
                this.bg.setBorder(MemoryGame.this.abc[0].border);
                this.bg.setContent(MemoryGame.this.abc[0], null, 0, 0, n3);
                this.bg.setContent(MemoryGame.this.abc[1] != null ? MemoryGame.this.abc[1] : MemoryGame.this.abc[0], null, 0, n3, n3);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        ActiveBox activeBox = this.bg.getActiveBox(i * n3 + j);
                        activeBox.setIdAss(j);
                        activeBox.setInactive(true);
                    }
                }
                this.bg.setVisible(true);
                this.invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                this.shuffle(new ActiveBoxBag[]{this.bg}, false, true);
                this.playing = true;
            }
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.bg != null) {
                this.bg.update(graphics2D, rectangle, this);
            }
            if (this.bc.active) {
                this.bc.update(graphics2D, rectangle, this);
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.bg == null || this.getSize().equals(dimension)) {
                return dimension;
            }
            return BoxBag.layoutSingle(dimension, this.bg, MemoryGame.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox activeBox;
                            this.bc.end();
                            ActiveBox activeBox2 = this.bg.findActiveBox(this.bc.origin);
                            if (activeBox2 != null && (activeBox = this.bg.findActiveBox(point)) != null && activeBox2.idAss != -1 && activeBox.idAss != -1) {
                                if (activeBox2 != activeBox) {
                                    boolean bl2 = false;
                                    if (activeBox2.idAss == activeBox.idAss || activeBox2.getContent().isEquivalent(activeBox.getContent(), true)) {
                                        bl2 = true;
                                        activeBox2.setIdAss(-1);
                                        activeBox.setIdAss(-1);
                                        activeBox2.setInactive(false);
                                        activeBox.setInactive(false);
                                    } else {
                                        activeBox2.setInactive(true);
                                        if (MemoryGame.this.dragCells) {
                                            activeBox.setInactive(true);
                                        } else {
                                            activeBox.setInactive(false);
                                            this.bc.begin(point);
                                        }
                                    }
                                    bl = activeBox.playMedia(this.ps);
                                    int n = this.bg.countCellsWithIdAss(-1);
                                    this.ps.reportNewAction(this.getActivity(), "MATCH", activeBox2.getDescription(), activeBox.getDescription(), bl2, n / 2);
                                    if (bl2 && n == this.bg.getNumCells()) {
                                        this.finishActivity(true);
                                    } else if (!bl) {
                                        this.playEvent(bl2 ? 3 : 2);
                                    }
                                } else {
                                    this.playEvent(1);
                                    activeBox2.setInactive(true);
                                }
                            } else if (activeBox2 != null) {
                                activeBox2.setInactive(true);
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox activeBox = this.bg.findActiveBox(point);
                        if (activeBox == null || activeBox.idAss == -1) break;
                        if (MemoryGame.this.dragCells) {
                            this.bc.begin(point, activeBox);
                        } else {
                            this.bc.begin(point);
                        }
                        bl = activeBox.playMedia(this.ps);
                        if (!bl) {
                            this.playEvent(1);
                        }
                        activeBox.setInactive(false);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(point);
                    }
                }
            }
        }
    }
}

