/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.StrUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.event.CaretEvent;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class Complete
extends TextActivityBase {
    Evaluator ev;

    public Complete(JClicProject jClicProject) {
        super(jClicProject);
        this.ev = new ComplexEvaluator(jClicProject);
        this.hasCheckButton = true;
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        element.addContent(this.ev.getJDomElement());
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.ev = Evaluator.getEvaluator(element.getChild("evaluator"), this.project);
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        ((ComplexEvaluator)this.ev).setProperties(clic3Activity);
        this.hasCheckButton = true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        boolean locked;
        int nActions;

        protected Panel(PlayStation playStation) {
            super(Complete.this, playStation);
            this.playDoc = null;
            this.locked = true;
            this.nActions = 0;
        }

        protected void initDocument() throws Exception {
            this.nActions = 0;
            if (Complete.this.tad != null) {
                this.playing = false;
                this.playDoc = new TextActivityDocument(Complete.this.styleContext);
                Complete.this.tad.cloneDoc(this.playDoc, true, false, false);
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEnabled(true);
                if (this.playDoc.tmb.size() > 0) {
                    this.pane.setEditable(true);
                    this.pane.requestFocus();
                    this.pane.getCaret().setVisible(true);
                    this.locked = false;
                } else {
                    this.locked = true;
                    this.pane.setEditable(false);
                    this.pane.getCaret().setVisible(false);
                }
            }
        }

        protected TextActivityPane buildPane() {
            CompletePane completePane = new CompletePane();
            completePane.setActions();
            return completePane;
        }

        protected void doCheck(boolean bl) {
            if (this.playDoc == null || this.locked) {
                return;
            }
            String string = null;
            String string2 = null;
            try {
                string = StrUtils.trimEnding(Complete.this.tad.getText(0, Complete.this.tad.getLength()));
                string2 = StrUtils.trimEnding(this.playDoc.getText(0, this.playDoc.getLength()));
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Error: unable to retrieve text:\n" + badLocationException);
                return;
            }
            byte[] byArray = Complete.this.ev.evalText(string2, string);
            int n = 0;
            if (byArray != null) {
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    while (n3 < n2 && !this.playDoc.checkBooleanAttribute(n3, "target")) {
                        ++n3;
                    }
                    if (n3 >= n2) continue;
                    ++this.nActions;
                    boolean bl2 = true;
                    int n4 = n3;
                    while (n3 < n2 && this.playDoc.checkBooleanAttribute(n3, "target")) {
                        ++n3;
                    }
                    this.playDoc.setCharacterAttributes(n4, n3 - n4, Complete.this.styleContext.getStyle("target"), true);
                    for (int i = n4; i < n3; ++i) {
                        if (byArray[i] == 0) continue;
                        bl2 = false;
                        this.playDoc.setCharacterAttributes(i, 1, Complete.this.styleContext.getStyle("targetError"), false);
                    }
                    if (!bl2) continue;
                    ++n;
                }
            }
            this.ps.setCounterValue(0, n);
            this.ps.setCounterValue(1, this.nActions);
            if (Evaluator.isOk(byArray)) {
                this.finishActivity(true);
            } else if (bl) {
                this.playEvent(4);
            }
        }

        public void finishActivity(boolean bl) {
            this.pane.setEditable(false);
            this.pane.setEnabled(false);
            super.finishActivity(bl);
        }

        class CompletePane
        extends TextActivityPane {
            Action kitDeletePrevCharAction;
            AbstractAction deletePrevCharAction;
            Action kitDeleteNextCharAction;
            AbstractAction deleteNextCharAction;

            protected CompletePane() {
                super(Panel.this);
                this.kitDeletePrevCharAction = null;
                this.deletePrevCharAction = new AbstractAction("delete-previous"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (CompletePane.this.readyForActions() && CompletePane.this.kitDeletePrevCharAction != null) {
                            CompletePane.this.invalidateSelection();
                            int n = CompletePane.this.getCaret().getDot() - 1;
                            if (n > 0 && ((CompletePane)CompletePane.this).Panel.this.playDoc.checkBooleanAttribute(n, "target")) {
                                CompletePane.this.kitDeletePrevCharAction.actionPerformed(actionEvent);
                            }
                        }
                    }
                };
                this.kitDeleteNextCharAction = null;
                this.deleteNextCharAction = new AbstractAction("delete-next"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (CompletePane.this.readyForActions() && CompletePane.this.kitDeleteNextCharAction != null) {
                            CompletePane.this.invalidateSelection();
                            int n = CompletePane.this.getCaret().getDot();
                            if (n >= 0 && n < ((CompletePane)CompletePane.this).Panel.this.playDoc.getLength() && ((CompletePane)CompletePane.this).Panel.this.playDoc.checkBooleanAttribute(n, "target")) {
                                CompletePane.this.kitDeleteNextCharAction.actionPerformed(actionEvent);
                            }
                        }
                    }
                };
            }

            public boolean processMouse(MouseEvent mouseEvent) {
                return super.processMouse(mouseEvent) && mouseEvent.getID() == 501 && Panel.this.playing && !Panel.this.locked;
            }

            protected void invalidateSelection() {
                int n = this.getCaret().getDot();
                if (this.getCaret().getMark() != n) {
                    this.getCaret().setDot(n);
                }
            }

            protected void fireCaretUpdate(CaretEvent caretEvent) {
                this.invalidateSelection();
                super.fireCaretUpdate(caretEvent);
            }

            public void replaceSelection(String string) {
                this.invalidateSelection();
                if (string != null && string.length() > 0) {
                    char c = string.charAt(0);
                    int n = this.getCaret().getDot();
                    if (c >= ' ' && c != '\u007f') {
                        try {
                            Panel.this.playDoc.insertString(n, new String(new char[]{c}), Panel.this.playDoc.getTargetAttributeSet());
                        }
                        catch (BadLocationException badLocationException) {
                            System.err.println("Text activity error:\n" + badLocationException);
                        }
                    }
                }
            }

            public void cut() {
                this.invalidateSelection();
            }

            public void paste() {
                this.invalidateSelection();
            }

            boolean readyForActions() {
                return Panel.this.playing && !Panel.this.locked && this.isEditable() && this.isEnabled();
            }

            protected void setActions() {
                this.kitDeleteNextCharAction = this.getActionMap().get("delete-next");
                this.kitDeletePrevCharAction = this.getActionMap().get("delete-previous");
                HashMap hashMap = Actions.getActionKeys(this);
                ActionMap actionMap = new ActionMap();
                actionMap.setParent(this.getActionMap());
                this.setActionMap(actionMap);
                Actions.mapAction(this, hashMap, this.deletePrevCharAction);
                Actions.mapAction(this, hashMap, this.deleteNextCharAction);
            }
        }
    }
}

