/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedActiveBox
extends ActiveBox
implements ActionListener {
    protected ActiveBagContent abc = null;
    protected ActiveBagContent altAbc = null;
    protected Timer timer = null;
    protected int delay = 50;
    protected boolean running = false;
    protected int currentFrame = 0;
    private boolean waitingForFirstFrame = false;
    protected long startTime = 0L;
    protected int startDelay = 0;
    public static final int MIN_DELAY = 50;

    public AnimatedActiveBox(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
    }

    public AnimatedActiveBox(AbstractBox abstractBox, JComponent jComponent, int n, Rectangle2D rectangle2D, BoxBase boxBase) {
        super(abstractBox, jComponent, n, rectangle2D, boxBase);
    }

    public void setStartDelay(int n) {
        this.startDelay = n;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void clear() {
        super.clear();
    }

    public void setContent(ActiveBagContent activeBagContent) {
        this.abc = activeBagContent;
        if (activeBagContent != null && !activeBagContent.isEmpty()) {
            this.setContent(activeBagContent.getActiveBoxContent(0));
        }
    }

    public void setAltContent(ActiveBagContent activeBagContent) {
        this.altAbc = activeBagContent;
    }

    private void buildTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.delay >= 50) {
            this.timer = new Timer(this.delay, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
        }
    }

    public void start() {
        this.stop(false);
        if (this.timer == null) {
            this.buildTimer();
        }
        if (this.timer != null) {
            this.startTime = System.currentTimeMillis();
            this.waitingForFirstFrame = false;
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void stop(boolean bl) {
        if (this.timer != null && this.timer.isRunning()) {
            if (bl) {
                this.waitingForFirstFrame = true;
            } else {
                this.waitingForFirstFrame = false;
                this.timer.stop();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActiveBagContent activeBagContent;
        ActiveBagContent activeBagContent2 = activeBagContent = this.isAlternative() ? this.altAbc : this.abc;
        if (activeBagContent != null && activeBagContent.getNumCells() > 0) {
            ++this.currentFrame;
            this.currentFrame %= activeBagContent.getNumCells();
            if (this.currentFrame == 0 && this.waitingForFirstFrame) {
                this.waitingForFirstFrame = false;
                this.timer.stop();
            } else if (this.isAlternative()) {
                this.setAltContent(activeBagContent, this.currentFrame);
            } else {
                this.setContent(activeBagContent, this.currentFrame);
            }
            if (!this.isVisible() && this.startDelay > 0 && System.currentTimeMillis() - this.startTime >= (long)this.startDelay) {
                this.setVisible(true);
            }
        }
    }
}

