/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.FileChooserForFiles;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.SimpleFileFilter;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class FileSystem {
    public static final String FS = "/";
    public static final String WINFS = "\\";
    public static final char FSCH = '/';
    public static final char WINFSCH = '\\';
    protected static FileChooserForFiles fileChooser;
    private static final String FS_BAK = "/..";
    public static HashMap altFileNames;
    public String root;
    protected boolean isURL = false;
    protected Boolean ISURL = new Boolean(this.isURL);
    protected ResourceBridge rb = null;
    private static final String validFileChars = "_!~0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String convertibleChars = "\u00e1\u00e0\u00e4\u00e2\u00e3\u00e9\u00e8\u00eb\u00ea\u00ed\u00ec\u00ef\u00ee\u00f3\u00f2\u00f6\u00f4\u00f5\u00fa\u00f9\u00fc\u00fb\u00f1\u00e7\u20ac\u00ba\u00aa\u00e5\u00e6\u00f8\u00fd\u00fe\u00ff";
    private static final String equivalentChars = "aaaaaeeeeiiiiooooouuuunceoaaaoypy";

    public FileSystem(ResourceBridge resourceBridge) {
        this.root = new String("");
        this.rb = resourceBridge;
    }

    public FileSystem(String string, ResourceBridge resourceBridge) {
        this.root = FileSystem.stdFn(string);
        this.rb = resourceBridge;
        if (this.root == null) {
            this.root = new String("");
        }
        if (this.root.length() > 0) {
            if (FileSystem.isStrUrl(this.root)) {
                this.isURL = true;
                this.ISURL = new Boolean(this.isURL);
                if (!this.root.endsWith(FS)) {
                    this.root = this.root + FS;
                }
                this.root = this.getCanonicalNameOf(this.root);
            } else {
                File file = new File(FileSystem.sysFn(this.root));
                String string2 = new String(this.root);
                try {
                    this.root = FileSystem.stdFn(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    this.root = string2;
                }
                if (!this.root.endsWith(FS)) {
                    this.root = this.root + FS;
                }
            }
        }
    }

    public FileSystem duplicate() throws Exception {
        return FileSystem.createFileSystem(this.root, this.rb);
    }

    protected void changeBase(String string, String string2) throws Exception {
        File file = new File(FileSystem.sysFn(string));
        String string3 = new String(this.root);
        try {
            this.root = FileSystem.stdFn(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.root = string3;
        }
        if (!this.root.endsWith(FS)) {
            this.root = this.root + FS;
        }
    }

    public static String stdFn(String string) {
        return string == null ? string : string.replace('\\', '/');
    }

    public static String sysFn(String string) {
        String string2 = string;
        if (string2 != null && (string2 = FileSystem.stdFn(string2).replace('/', File.separatorChar)).indexOf("%20") >= 0) {
            string2 = StrUtils.replace(string2, "%20", " ");
        }
        return string2;
    }

    public static final FileSystem createFileSystem(String string, String string2, ResourceBridge resourceBridge) throws Exception {
        if (string2 == null) {
            return new FileSystem(string, resourceBridge);
        }
        if (string2.endsWith(".pcc")) {
            return PCCFileSystem.createPCCFileSystem(string, string2, resourceBridge);
        }
        if (string2.endsWith(".zip")) {
            return ZipFileSystem.createZipFileSystem(string, string2, resourceBridge);
        }
        throw new Exception("unknown format " + string2);
    }

    public static final FileSystem createFileSystem(String string, ResourceBridge resourceBridge) throws Exception {
        string = FileSystem.getCanonicalNameOf(string, null);
        String string2 = null;
        String string3 = FileSystem.getPathPartOf(string);
        if (string.endsWith(".pcc") || string.endsWith(".zip")) {
            string2 = FileSystem.getFileNameOf(string);
        }
        return FileSystem.createFileSystem(string3, string2, resourceBridge);
    }

    public String getFullFileNamePath(String string) {
        if (string == null || string.length() == 0) {
            return this.root.length() > 0 ? this.root.substring(0, this.root.length() - 1) : this.root;
        }
        String string2 = this.getCanonicalNameOf(string);
        if (!this.isURL) {
            File file = new File(FileSystem.sysFn(string2));
            if (!file.isAbsolute()) {
                string2 = this.getCanonicalNameOf(this.root + string2);
            }
        } else if (!FileSystem.isStrUrl(string2)) {
            string2 = this.getCanonicalNameOf(this.root + string2);
        }
        return string2;
    }

    public String getRelativeFileNamePath(String string) {
        String string2 = FileSystem.stdFn(string);
        if (string2 == null || string2.length() < this.root.length() || !string2.substring(0, this.root.length()).equalsIgnoreCase(this.root)) {
            return string2;
        }
        return string2.substring(this.root.length());
    }

    public String getFullRoot() {
        return this.root;
    }

    public boolean isUrlBased() {
        return this.isURL;
    }

    public static final boolean isStrUrl(String string) {
        return string != null && (string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("mailto:"));
    }

    public String getUrl(String string) {
        String string2 = FileSystem.stdFn(string);
        if (string2 == null || FileSystem.isStrUrl(string2) || string2.startsWith("file:")) {
            return string2;
        }
        if (string2.charAt(1) != ':' && !string2.startsWith(FS)) {
            string2 = this.getFullFileNamePath(string2);
        }
        if (this.isURL) {
            return FileSystem.getCanonicalNameOf(string2, this.ISURL);
        }
        return "file://" + FileSystem.sysFn(FileSystem.getCanonicalNameOf(string2, this.ISURL));
    }

    public String getCanonicalNameOf(String string) {
        return FileSystem.getCanonicalNameOf(string, this.ISURL);
    }

    public static String getCanonicalNameOf(String string, Boolean bl) {
        int n;
        String string2 = FileSystem.stdFn(string);
        boolean bl2 = bl != null ? bl : FileSystem.isStrUrl(string2);
        String string3 = "";
        int n2 = -1;
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        if (FileSystem.isStrUrl(string2)) {
            n = string2.indexOf(64);
            if (n < 0) {
                n = 7;
            }
            n2 = string2.indexOf(47, n);
        } else if (string2.length() > 2 && string2.charAt(1) == ':') {
            n2 = string2.charAt(2) == '/' ? 2 : 1;
        } else if (string2.startsWith("//")) {
            n = string2.indexOf(47, 2);
            n2 = string2.indexOf(47, n + 1);
        } else if (string2.startsWith(FS)) {
            n2 = 0;
        }
        if (n2 >= 0) {
            string3 = string2.substring(0, n2 + 1);
            string2 = string2.substring(n2 + 1);
        }
        while ((n = string2.indexOf(FS_BAK)) >= 0) {
            int n3;
            for (n3 = n - 1; n3 >= 0 && string2.charAt(n3) != '/'; --n3) {
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 >= 0) {
                stringBuffer.append(string2.substring(0, n3 + 1));
            }
            if (n + 4 < string2.length()) {
                stringBuffer.append(string2.substring(n + 4));
            }
            string2 = stringBuffer.substring(0);
        }
        return string3 + string2;
    }

    public static String getPathPartOf(String string) {
        String string2 = FileSystem.stdFn(string);
        int n = string2.lastIndexOf(FS);
        return n < 0 ? "" : string2.substring(0, n + 1);
    }

    public static String getFileNameOf(String string) {
        String string2 = FileSystem.stdFn(string);
        int n = string2.lastIndexOf(FS);
        return n < 0 ? string2 : string2.substring(n + 1);
    }

    public byte[] getBytes(String string) throws IOException {
        return StreamIO.readInputStream(this.getInputStream(string));
    }

    public Image getImageFile(String string) throws Exception {
        return Toolkit.getDefaultToolkit().createImage(this.getBytes(string));
    }

    public long getFileLength(String string) throws IOException {
        long l = 0L;
        if (this.isURL) {
            URL uRL = new URL(this.getFullFileNamePath(string));
            URLConnection uRLConnection = uRL.openConnection();
            l = uRLConnection.getContentLength();
        } else {
            File file = new File(FileSystem.sysFn(this.getFullFileNamePath(string)));
            l = file.length();
        }
        return l;
    }

    public boolean fileExists(String string) {
        boolean bl = false;
        try {
            if (this.isURL) {
                URL uRL = new URL(this.getFullFileNamePath(string));
                URLConnection uRLConnection = uRL.openConnection();
                bl = uRLConnection.getContentLength() > 0;
            } else {
                File file = new File(FileSystem.sysFn(this.getFullFileNamePath(string)));
                bl = file.exists();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public InputStream getInputStream(String string) throws IOException {
        InputStream inputStream = null;
        int n = 0;
        if (this.isURL) {
            URL uRL = new URL(this.getFullFileNamePath(string));
            URLConnection uRLConnection = uRL.openConnection();
            n = uRLConnection.getContentLength();
            inputStream = uRLConnection.getInputStream();
        } else {
            String string2;
            File file = new File(FileSystem.sysFn(this.getFullFileNamePath(string)));
            if (!file.exists() && (string2 = (String)altFileNames.get(string)) != null) {
                file = new File(FileSystem.sysFn(this.getFullFileNamePath(string2)));
            }
            n = (int)file.length();
            inputStream = new FileInputStream(file);
        }
        if (inputStream != null && this.rb != null) {
            inputStream = this.rb.getProgressInputStream(inputStream, n, string);
        }
        return inputStream;
    }

    public Object getMediaDataSource(String string) throws Exception {
        if (this.isURL) {
            return this.getExtendedByteArrayInputStream(string);
        }
        return new StringBuffer("file:").append(this.getFullFileNamePath(string)).substring(0);
    }

    public ExtendedByteArrayInputStream getExtendedByteArrayInputStream(String string) throws Exception {
        return new ExtendedByteArrayInputStream(this.getBytes(string), string);
    }

    public static Document getXMLDocument(InputStream inputStream) throws Exception {
        Document document = JDomUtility.getSAXBuilder().build(inputStream);
        JDomUtility.clearNewLineElements(document.getRootElement());
        return document;
    }

    public Document getXMLDocument(String string) throws Exception {
        Document document = this.buildDoc(string, JDomUtility.getSAXBuilder());
        JDomUtility.clearNewLineElements(document.getRootElement());
        return document;
    }

    protected Document buildDoc(String string, SAXBuilder sAXBuilder) throws Exception {
        return sAXBuilder.build(this.getInputStream(string));
    }

    public void close() {
    }

    protected void open() throws Exception {
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static FileChooserForFiles getFileChooser(String string) {
        if (fileChooser == null) {
            fileChooser = new FileChooserForFiles();
            if (string != null) {
                fileChooser.setCurrentDirectory(new File(FileSystem.sysFn(string)));
            }
        }
        return fileChooser;
    }

    public String chooseFile(String string, boolean bl, int[] nArray, Options options, String string2, Component component, boolean bl2) {
        String string3 = null;
        String[] stringArray = this.chooseFiles(string, bl, nArray, options, string2, component, bl2, false);
        if (stringArray != null && stringArray.length > 0) {
            string3 = stringArray[0];
        }
        return string3;
    }

    public String[] chooseFiles(String string, boolean bl, int[] nArray, Options options, String string2, Component component, boolean bl2, boolean bl3) {
        String[] stringArray;
        block22: {
            Messages messages;
            block23: {
                block24: {
                    stringArray = null;
                    if (bl) {
                        bl3 = false;
                    }
                    if (options == null) break block22;
                    messages = options.getMessages();
                    if (!this.isURL) break block23;
                    if (!bl) break block24;
                    messages.showErrorWarning(component, "filesystem_saveURLerror", null);
                    break block22;
                }
                String string3 = messages.showInputDlg(component, "filesystem_enterURL", "URL", "http://", string2 != null ? string2 : "filesystem_openURL", false);
                if (string3 == null) break block22;
                stringArray = new String[]{string3};
                break block22;
            }
            FileChooserForFiles fileChooserForFiles = FileSystem.getFileChooser(this.root);
            if (fileChooserForFiles != null) {
                fileChooserForFiles.setApproveButtonToolTipText(messages.get(bl ? "FILE_SAVE_TOOLTIP" : "FILE_OPEN_TOOLTIP"));
                fileChooserForFiles.setDialogType(bl ? 1 : 0);
                fileChooserForFiles.setApproveButtonText(messages.get(bl ? "SAVE" : "OPEN"));
                fileChooserForFiles.setMultiSelectionEnabled(bl3);
                fileChooserForFiles.setDialogTitle(messages.get(string2 != null ? string2 : (bl ? "FILE_SAVE" : "FILE_OPEN")));
                fileChooserForFiles.resetChoosableFileFilters();
                if (nArray != null) {
                    fileChooserForFiles.setAcceptAllFileFilterUsed(false);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (i == nArray.length - 1) {
                            fileChooserForFiles.setFileFilter(Utils.getFileFilter(nArray[i], messages));
                            continue;
                        }
                        fileChooserForFiles.addChoosableFileFilter(Utils.getFileFilter(nArray[i], messages));
                    }
                } else {
                    fileChooserForFiles.setAcceptAllFileFilterUsed(true);
                }
                String string4 = StrUtils.nullableString(string);
                boolean bl4 = false;
                if (string4 == null) {
                    string4 = ".";
                    bl4 = true;
                }
                fileChooserForFiles.directSetSelectedFile(new File(FileSystem.sysFn(this.getFullFileNamePath(string4))));
                if (bl4) {
                    fileChooserForFiles.directSetSelectedFile(null);
                }
                boolean bl5 = false;
                block3: while (!bl5) {
                    int n = bl ? fileChooserForFiles.showSaveDialog(component) : fileChooserForFiles.showOpenDialog(component);
                    if (n == 0) {
                        File[] fileArray;
                        File[] fileArray2;
                        if (bl3) {
                            fileArray = fileArray2 = fileChooserForFiles.getSelectedFiles();
                        } else {
                            File[] fileArray3 = new File[1];
                            fileArray = fileArray3;
                            fileArray3[0] = fileChooserForFiles.getSelectedFile();
                        }
                        fileArray2 = fileArray;
                        stringArray = new String[fileArray2.length];
                        for (int i = 0; i < fileArray2.length; ++i) {
                            Object object;
                            File file = fileArray2[i].getAbsoluteFile();
                            stringArray[i] = this.getRelativeFileNamePath(FileSystem.stdFn(file.getAbsolutePath()));
                            if (bl) {
                                object = fileChooserForFiles.getFileFilter();
                                if (object instanceof SimpleFileFilter) {
                                    file = ((SimpleFileFilter)object).checkFileExtension(file);
                                    stringArray[i] = this.getRelativeFileNamePath(FileSystem.stdFn(file.getAbsolutePath()));
                                }
                                bl5 = messages.confirmOverwriteFile(component, file, "yn") == 1;
                            } else {
                                File file2;
                                bl5 = messages.confirmReadableFile(component, file);
                                if (bl5 && bl2 && this.root.length() > 0 && stringArray[i].indexOf(FS) >= 0 && messages.showQuestionDlgObj(component, new String[]{messages.get("filesystem_copyToRoot_1") + " " + stringArray[i], messages.get("filesystem_copyToRoot_2"), messages.get("filesystem_copyToRoot_3"), messages.get("filesystem_copyToRoot_4")}, "CONFIRM", "yn") == 1 && messages.confirmOverwriteFile(component, file2 = new File(FileSystem.sysFn(this.getFullFileNamePath((String)(object = FileSystem.stdFn(file.getName()))))), "yn") == 1) {
                                    try {
                                        FileOutputStream fileOutputStream = this.createSecureFileOutputStream((String)object);
                                        InputStream inputStream = this.getInputStream(stringArray[i]);
                                        if (StreamIO.writeStreamDlg(inputStream, fileOutputStream, (int)file.length(), messages.get("filesystem_copyFile"), component, options)) {
                                            stringArray[i] = object;
                                        } else if (file2.exists()) {
                                            file2.delete();
                                        }
                                    }
                                    catch (Exception exception) {
                                        messages.showErrorWarning(component, "ERROR", exception);
                                    }
                                }
                            }
                            if (!bl5) continue block3;
                        }
                        continue;
                    }
                    stringArray = null;
                    bl5 = true;
                }
            }
        }
        return stringArray;
    }

    public FileOutputStream createSecureFileOutputStream(String string) throws IOException {
        SecureFileOutputStream secureFileOutputStream = null;
        File file = new File(FileSystem.sysFn(this.getFullFileNamePath(string)));
        file.getParentFile().mkdirs();
        File file2 = File.createTempFile("tmp", ".tmp", file.getParentFile());
        secureFileOutputStream = new SecureFileOutputStream(file2, file);
        return secureFileOutputStream;
    }

    public static void exploreFiles(String string, File file, Vector vector, char c, FileFilter fileFilter) {
        File[] fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.setLength(0);
            if (fileArray[i].isDirectory()) {
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(fileArray[i].getName()).append(c);
                FileSystem.exploreFiles(stringBuffer.substring(0), fileArray[i], vector, c, fileFilter);
                continue;
            }
            if (string != null) {
                stringBuffer.append(string);
            }
            vector.add(stringBuffer.append(fileArray[i].getName()).substring(0));
        }
    }

    public static String getValidFileName(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                int n = Character.toLowerCase(string.charAt(i));
                if (validFileChars.indexOf(n) < 0) {
                    int n2 = convertibleChars.indexOf(n);
                    n = n2 >= 0 ? (int)equivalentChars.charAt(n2) : 95;
                }
                stringBuffer.append((char)n);
            }
            string2 = stringBuffer.substring(0);
        }
        return string2;
    }

    static {
        altFileNames = new HashMap();
    }

    class SecureFileOutputStream
    extends FileOutputStream {
        boolean closed;
        File tempFile;
        File destFile;

        private SecureFileOutputStream(File file, File file2) throws FileNotFoundException {
            super(file);
            this.tempFile = file;
            this.destFile = file2;
            this.closed = false;
        }

        public void close() throws IOException {
            super.close();
            if (!this.closed) {
                this.closed = true;
                if (this.destFile != null) {
                    boolean bl;
                    boolean bl2 = FileSystem.this.getFullRoot().equals(FileSystem.stdFn(this.destFile.getAbsolutePath()));
                    if (bl2) {
                        FileSystem.this.close();
                    }
                    if (this.destFile.exists()) {
                        this.destFile.delete();
                    }
                    if (!(bl = this.tempFile.renameTo(this.destFile))) {
                        System.err.println("WARNING: Unable to rename " + this.tempFile + " to " + this.destFile.getName());
                    }
                    if (bl2) {
                        try {
                            if (!bl) {
                                FileSystem.this.changeBase(this.tempFile.getParent(), this.tempFile.getName());
                            }
                            FileSystem.this.open();
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.getMessage());
                        }
                    }
                }
            }
        }
    }
}

