/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jdom.Element;

public class Gradient
implements Cloneable,
Domable {
    protected Color c1;
    protected Color c2;
    protected int angle = 0;
    protected GradientPaint gp = null;
    protected Rectangle2D lastRect = null;
    protected boolean transparency = false;
    protected int cycles = 1;
    public static final String ELEMENT_NAME = "gradient";
    public static final String C1 = "source";
    public static final String C2 = "dest";
    public static final String ANGLE = "angle";
    public static final String CYCLES = "cycles";

    public Gradient(Color color, Color color2, int n, int n2) {
        this.setColors(color, color2);
        this.setAngle(n);
        this.setCycles(n2);
    }

    public Gradient() {
        this(Color.black, Color.white, 0, 1);
    }

    public Object clone() {
        return new Gradient(this.c1, this.c2, this.angle, this.cycles);
    }

    public boolean hasTransparency() {
        return this.transparency;
    }

    public void setCycles(int n) {
        this.cycles = Math.max(1, n);
        this.clear();
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setAngle(int n) {
        this.angle = n % 360;
        this.clear();
    }

    public int getAngle() {
        return this.angle;
    }

    public Color[] getColors() {
        return new Color[]{this.c1, this.c2};
    }

    public void setColors(Color color, Color color2) {
        this.c1 = color;
        this.c2 = color2;
        this.transparency = color.getAlpha() != 255 || color2.getAlpha() != 255;
        this.clear();
    }

    public void clear() {
        this.gp = null;
        this.lastRect = null;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(C1, JDomUtility.colorToString(this.c1));
        element.setAttribute(C2, JDomUtility.colorToString(this.c2));
        element.setAttribute(ANGLE, Integer.toString(this.angle));
        if (this.cycles > 1) {
            element.setAttribute(CYCLES, Integer.toString(this.cycles));
        }
        return element;
    }

    public static Gradient getGradient(Element element) throws Exception {
        Gradient gradient = new Gradient();
        gradient.setProperties(element, null);
        return gradient;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.c1 = JDomUtility.getColorAttr(element, C1, this.c1);
        this.c2 = JDomUtility.getColorAttr(element, C2, this.c2);
        this.setAngle(JDomUtility.getIntAttr(element, ANGLE, this.angle));
        this.setCycles(JDomUtility.getIntAttr(element, CYCLES, this.cycles));
    }

    public void paint(Graphics2D graphics2D, Shape shape) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getGradient(shape));
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public GradientPaint getGradient(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (this.gp == null || this.lastRect == null || !this.lastRect.equals(rectangle2D)) {
            this.lastRect = rectangle2D;
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            double d3 = d / 2.0;
            double d4 = Math.PI * (double)this.angle / 180.0;
            switch (this.angle) {
                case 0: 
                case 180: {
                    break;
                }
                case 90: 
                case 270: {
                    d3 = d2 / 2.0;
                    break;
                }
                default: {
                    d3 = Math.sqrt(d * d + d2 * d2) / 2.0;
                    double d5 = this.toFirstQuadrant(Math.atan2(d2, d));
                    double d6 = Math.abs(this.toFirstQuadrant(d4) - d5);
                    d3 *= Math.cos(d6);
                }
            }
            float f = (float)(rectangle2D.getX() + d / 2.0);
            float f2 = (float)(rectangle2D.getY() + d2 / 2.0);
            float f3 = (float)(d3 * Math.cos(d4));
            float f4 = (float)(d3 * Math.sin(d4));
            this.gp = new GradientPaint(f + f3, f2 - f4, this.c1, f + f3 - 2.0f * f3 / (float)this.cycles, f2 - f4 + 2.0f * f4 / (float)this.cycles, this.c2, this.cycles > 1);
        }
        return this.gp;
    }

    protected double toFirstQuadrant(double d) {
        if (d > Math.PI) {
            d = Math.PI * 2 - d;
        }
        if (d > 1.5707963267948966) {
            d = Math.PI - d;
        }
        return d;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof Gradient) {
            Gradient gradient = (Gradient)object;
            bl = this.c1.equals(gradient.c1) && this.c2.equals(gradient.c2) && this.cycles == gradient.cycles && this.angle == gradient.angle;
        }
        return bl;
    }
}

