/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorTreePanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectLibraryEditor;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectLibrary
extends JClicProject
implements Editable {
    public static final String LIBRARY_TYPE = "library";
    public static final String MSG_ID = "library_";
    static /* synthetic */ Class class$edu$xtec$jclic$activities$panels$Menu;

    private ProjectLibrary(ResourceBridge resourceBridge, FileSystem fileSystem, String string) {
        super(resourceBridge, fileSystem, string);
        this.type = LIBRARY_TYPE;
    }

    public void setProperties(Element element, Object object) throws Exception {
        this.type = null;
        super.setProperties(element, object);
        if (!LIBRARY_TYPE.equals(this.type)) {
            throw new Exception(this.bridge.getMsg("library_badFormat"));
        }
    }

    public static ProjectLibrary createNewProjectLibrary(ResourceBridge resourceBridge, FileSystem fileSystem) {
        String string;
        ProjectLibrary projectLibrary = new ProjectLibrary(resourceBridge, fileSystem, null);
        projectLibrary.settings.title = resourceBridge.getMsg("library_newLibraryName");
        Menu menu = new Menu(projectLibrary);
        menu.name = "main";
        menu.description = string = resourceBridge.getMsg("library_mainMenu");
        ActiveBoxContent[] activeBoxContentArray = menu.getMessages();
        activeBoxContentArray[1] = new ActiveBoxContent();
        activeBoxContentArray[1].setBoxBase(new BoxBase());
        activeBoxContentArray[1].setTextContent(string);
        projectLibrary.activityBag.addActivity(menu);
        projectLibrary.activitySequence.add(new ActivitySequenceElement(menu.name, true));
        return projectLibrary;
    }

    public static ProjectLibrary getProjectLibrary(Element element, ResourceBridge resourceBridge, FileSystem fileSystem, String string) throws Exception {
        ProjectLibrary projectLibrary = new ProjectLibrary(resourceBridge, fileSystem, string);
        projectLibrary.setProperties(element, null);
        return projectLibrary;
    }

    public static ProjectLibrary loadProjectLibrary(String string, ResourceBridge resourceBridge) throws Exception {
        FileSystem fileSystem = FileSystem.createFileSystem(string, resourceBridge);
        Document document = fileSystem.getXMLDocument(FileSystem.getFileNameOf(string));
        ProjectLibrary projectLibrary = new ProjectLibrary(resourceBridge, fileSystem, string);
        projectLibrary.setProperties(document.getRootElement(), null);
        return projectLibrary;
    }

    public void save(String string) throws Exception {
        if (string == null) {
            string = this.fullPath;
        }
        FileOutputStream fileOutputStream = this.fileSystem.createSecureFileOutputStream(string);
        this.saveDocument(fileOutputStream);
        fileOutputStream.close();
    }

    public String toString() {
        return this.settings.title;
    }

    public String getPublicName() {
        return this.settings.title;
    }

    public Menu getRootMenu() {
        Menu menu = null;
        if (this.activitySequence.getSize() > 0) {
            try {
                Activity activity = null;
                ActivitySequenceElement activitySequenceElement = this.activitySequence.getElement(0, false);
                if (activitySequenceElement != null && (activity = Activity.getActivity(this.activityBag.getElement(activitySequenceElement.getActivityName()).getData(), this)) instanceof Menu) {
                    menu = (Menu)activity;
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading project library!\n" + exception);
            }
        }
        return menu;
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public boolean editProjectLibrary(Object object) {
        ProjectLibraryDialog projectLibraryDialog = object instanceof JDialog ? new ProjectLibraryDialog(true, true, (JDialog)object) : new ProjectLibraryDialog(true, true);
        projectLibraryDialog.setVisible(true);
        return projectLibraryDialog.accept;
    }

    protected JComponent getRbComponent() {
        if (this.bridge == null) {
            return null;
        }
        return this.bridge.getComponent();
    }

    protected String getRbMessage(String string) {
        if (this.bridge == null) {
            return "";
        }
        return this.bridge.getMsg(string);
    }

    class ProjectLibraryDialog
    extends ExtendedJDialog {
        ProjectLibraryEditor pled;
        EditorTreePanel etp;
        Menu result;
        boolean accept;
        boolean allowEdit;
        boolean allowNewMenu;
        Action selectAction;
        Action cancelAction;

        ProjectLibraryDialog(boolean bl, boolean bl2, JDialog jDialog) {
            super(jDialog, ProjectLibrary.this.bridge.getMsg("library_caption"), true);
            this.result = null;
            this.accept = false;
            this.allowEdit = bl2;
            this.allowNewMenu = bl;
            this.init();
        }

        ProjectLibraryDialog(boolean bl, boolean bl2) {
            super(ProjectLibrary.this.getRbComponent(), ProjectLibrary.this.getRbMessage("library_caption"), true);
            this.result = null;
            this.accept = false;
            this.allowEdit = bl2;
            this.allowNewMenu = bl;
            this.init();
        }

        protected void init() {
            this.buildActions();
            this.pled = (ProjectLibraryEditor)ProjectLibrary.this.getEditor(null);
            this.etp = new EditorTreePanel(this.pled, ProjectLibrary.this.bridge.getOptions(), !this.allowEdit, this.allowEdit ? null : (class$edu$xtec$jclic$activities$panels$Menu == null ? (class$edu$xtec$jclic$activities$panels$Menu = ProjectLibrary.class$("edu.xtec.jclic.activities.panels.Menu")) : class$edu$xtec$jclic$activities$panels$Menu)){

                protected void currentItemChanged() {
                    if (!ProjectLibraryDialog.this.allowEdit) {
                        ProjectLibraryDialog.this.selectAction.setEnabled(this.currentItem != null);
                    }
                    super.currentItemChanged();
                }
            };
            this.getContentPane().add((Component)this.etp, "Center");
            JPanel jPanel = new JPanel();
            jPanel.add(new JButton(this.selectAction));
            jPanel.add(new JButton(this.cancelAction));
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            this.centerOver(ProjectLibrary.this.bridge.getComponent());
        }

        void buildActions() {
            String string = this.allowEdit ? "select_caption_ok" : "select_caption";
            this.selectAction = new AbstractAction(ProjectLibrary.this.bridge.getMsg(ProjectLibrary.MSG_ID + string), ResourceManager.getImageIcon(this.allowEdit ? "icons/commit_changes.gif" : "icons/file_open.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ProjectLibraryDialog.this.allowEdit && ProjectLibraryDialog.this.etp.getCurrentPanel() != null) {
                        ProjectLibraryDialog.this.etp.getCurrentPanel().save();
                        if (ProjectLibraryDialog.this.pled.isModified()) {
                            ProjectLibraryDialog.this.pled.saveMenus(ProjectLibraryDialog.this.pled);
                            try {
                                ProjectLibrary.this.save(null);
                            }
                            catch (Exception exception) {
                                ((ProjectLibraryDialog)ProjectLibraryDialog.this).ProjectLibrary.this.bridge.getOptions().getMessages().showErrorWarning((Component)ProjectLibraryDialog.this.getParent(), "FILE_ERR_SAVING", ((ProjectLibraryDialog)ProjectLibraryDialog.this).ProjectLibrary.this.fullPath, exception, null);
                            }
                        }
                    }
                    if (ProjectLibraryDialog.this.etp.currentItem != null && ProjectLibraryDialog.this.etp.currentItem instanceof MenuEditor) {
                        ProjectLibraryDialog.this.result = ((MenuEditor)ProjectLibraryDialog.this.etp.currentItem).getMenu();
                    } else {
                        ProjectLibraryDialog.this.result = null;
                        if (!ProjectLibraryDialog.this.allowEdit) {
                            return;
                        }
                    }
                    ProjectLibraryDialog.this.accept = true;
                    ProjectLibraryDialog.this.setVisible(false);
                }
            };
            this.selectAction.putValue("ShortDescription", ProjectLibrary.this.bridge.getMsg(ProjectLibrary.MSG_ID + string + "_tooltip"));
            if (!this.allowEdit) {
                this.selectAction.setEnabled(false);
            }
            this.cancelAction = new AbstractAction(ProjectLibrary.this.bridge.getMsg("library_cancel_caption"), ResourceManager.getImageIcon("icons/cancel.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProjectLibraryDialog.this.result = null;
                    ProjectLibraryDialog.this.accept = false;
                    ProjectLibraryDialog.this.setVisible(false);
                }
            };
            this.cancelAction.putValue("ShortDescription", ProjectLibrary.this.bridge.getMsg("library_cancel_tooltip"));
        }
    }
}

