/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class SessionReg
implements Serializable {
    Vector sequences = new Vector();
    SequenceReg currentSequence = null;
    public Date started = new Date();
    protected long timeMillis = System.currentTimeMillis();
    String projectName;
    protected transient Info info;
    String code;

    public SessionReg(JClicProject jClicProject) {
        this(jClicProject.getName(), jClicProject.code);
    }

    public SessionReg(String string, String string2) {
        this.projectName = string;
        this.code = string2;
        this.info = new Info();
    }

    public String toHtmlString(Messages messages, boolean bl, boolean bl2) {
        String string = "report_";
        Html html = new Html(3000);
        if (bl) {
            this.info.recalc();
        }
        if (this.info.numSequences > 0) {
            if (bl2) {
                html.append("<TR STYLE=\"").append(messages.get("about_window_html_style_table_header2")).append("\">");
                html.append("<TD COLSPAN=\"6\">");
                html.bold(messages.get(string + "project") + "&nbsp;" + this.projectName);
                html.td(false).tr(false);
            }
            html.append("<TR STYLE=\"").append(messages.get("about_window_html_style_table_header")).append("\">");
            html.td(messages.get(string + "lb_sequence"), 1, true, null);
            html.td(messages.get(string + "lb_activity"), 1, true, null);
            html.td(messages.get(string + "lb_solved"), 1, true, null);
            html.td(messages.get(string + "lb_actions"), 1, true, null);
            html.td(messages.get(string + "lb_score"), 1, true, null);
            html.td(messages.get(string + "lb_time"), 1, true, null);
            html.tr(false);
            for (int i = 0; i < this.sequences.size(); ++i) {
                html.append(((SequenceReg)this.sequences.get(i)).toHtmlString(messages));
            }
            html.append("<TR STYLE=\"").append(messages.get("about_window_html_style_table_totals")).append("\">");
            html.td(messages.get(string + "lb_totals"), 0, true, null);
            html.td(messages.getNumber(this.info.nActivities), 2, true, null);
            html.td(messages.getNumber(this.info.nActSolved) + " (" + messages.getPercent(this.info.percentSolved) + ")", 2, true, null);
            html.td(messages.getNumber(this.info.nActions), 2, true, null);
            html.td(messages.getPercent(this.info.tScore), 2, true, null);
            html.td(messages.getHmsTime(this.info.tTime), 2, true, null);
            html.tr(false);
        }
        return html.toString();
    }

    public Info getInfo(boolean bl) {
        if (bl) {
            this.info.recalc();
        }
        return this.info;
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void end() {
        this.endSequence();
    }

    public void endSequence() {
        if (this.currentSequence != null && this.currentSequence.totalTime == 0L) {
            this.currentSequence.endSequence();
        }
        this.currentSequence = null;
    }

    public void newSequence(ActivitySequenceElement activitySequenceElement) {
        this.endSequence();
        this.currentSequence = new SequenceReg(activitySequenceElement);
        this.sequences.add(this.currentSequence);
    }

    public void newActivity(Activity activity) {
        if (this.currentSequence != null) {
            this.currentSequence.newActivity(activity);
        }
    }

    public void endActivity(int n, int n2, boolean bl) {
        if (this.currentSequence != null) {
            this.currentSequence.endActivity(n, n2, bl);
        }
    }

    public void newAction(String string, String string2, String string3, boolean bl) {
        if (this.currentSequence != null) {
            this.currentSequence.newAction(string, string2, string3, bl);
        }
    }

    public SequenceReg getSequenceReg(int n) {
        return n >= this.sequences.size() ? null : (SequenceReg)this.sequences.get(n);
    }

    public String getCurrentSequenceTag() {
        if (this.currentSequence == null) {
            return null;
        }
        return this.currentSequence.name;
    }

    public SequenceReg.Info getCurrentSequenceInfo() {
        return this.currentSequence == null ? null : this.currentSequence.getInfo(true);
    }

    public class Info {
        public int numSequences;
        public int nActivities;
        public int nActSolved;
        public int nActScore;
        public int percentSolved;
        public int nActions;
        public long tScore;
        public long tTime;

        protected Info() {
            this.clear();
        }

        protected void clear() {
            this.nActions = 0;
            this.percentSolved = 0;
            this.nActScore = 0;
            this.nActSolved = 0;
            this.nActivities = 0;
            this.numSequences = 0;
            this.tTime = 0L;
            this.tScore = 0L;
        }

        public void recalc() {
            this.clear();
            for (int i = 0; i < SessionReg.this.sequences.size(); ++i) {
                SequenceReg.Info info = SessionReg.this.getSequenceReg(i).getInfo(true);
                if (info.nActivities <= 0) continue;
                ++this.numSequences;
                if (info.nActClosed <= 0) continue;
                this.nActivities += info.nActClosed;
                this.nActions += info.nActions;
                if (info.nActScore > 0) {
                    this.nActScore += info.nActScore;
                    this.tScore += info.tScore * (long)info.nActScore;
                }
                this.tTime += info.tTime;
                this.nActSolved += info.nActSolved;
            }
            if (this.nActScore > 0) {
                this.tScore /= (long)this.nActScore;
            }
            if (this.nActivities > 0) {
                this.percentSolved = this.nActSolved * 100 / this.nActivities;
            }
        }
    }
}

