/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class PersistentSettings {
    public static final String BASE = ".edu.xtec.properties";
    public static final String BASE_OLD = "edu.xtec.properties";
    public static final String BUNDLE = "messages.PersistentPathsMessages";
    private static File baseFile = null;
    private static final String[] PRG_LOCATIONS = new String[]{"C:\\Archivos de programa", "C:\\Programmi", "C:\\Program", "C:\\Programme", "C:\\Programas", "C:\\Programfiler", "C:\\Program files"};

    private PersistentSettings() {
    }

    public static File getBaseFile() throws Exception {
        if (baseFile == null) {
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append(System.getProperty("user.dir"));
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(System.getProperty("java.home")).append(File.separator).append("lib");
            stringBuffer.append(File.pathSeparator).append(System.getProperty("java.ext.dirs"));
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.substring(0), File.pathSeparator);
            while (baseFile == null && stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) continue;
                File file2 = new File(file, BASE);
                if (file2.canRead()) {
                    baseFile = file2;
                    continue;
                }
                File file3 = new File(file, BASE_OLD);
                if (!file3.canRead()) continue;
                try {
                    if (!file3.renameTo(file2)) continue;
                    baseFile = file2;
                }
                catch (Exception exception) {}
            }
            if (baseFile == null) {
                baseFile = new File(System.getProperty("user.home"), BASE);
                System.out.println("Creating file " + baseFile);
                PersistentSettings.saveSettings(new Properties());
            }
        }
        return baseFile;
    }

    public static Properties getProperties() throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(PersistentSettings.getBaseFile());
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        return properties;
    }

    public static File getBasePathTo(String string, Options options) throws Exception {
        Object object;
        Properties properties = PersistentSettings.getProperties();
        String string2 = (String)properties.get(string);
        if (!(string2 == null || ((File)(object = new File(string2))).exists() && ((File)object).isDirectory())) {
            string2 = null;
        }
        if (string2 == null) {
            object = PersistentSettings.getSystemProgramsPath(options) + File.separator + string;
            Messages messages = PersistentSettings.getMessages(options, BUNDLE);
            String string3 = messages.get("cl_alert");
            int n = string3.indexOf(36);
            if (n >= 0) {
                string3 = string3.substring(0, n) + string + string3.substring(n + 1);
            }
            boolean bl = false;
            File file = new File((String)object);
            while (!bl) {
                String string4 = (String)JOptionPane.showInputDialog(options.getMainComponent(), string3, messages.get("cl_prompt_title"), 3, null, null, object);
                if (string4 == null) {
                    throw new Exception("bad user input!");
                }
                file = new File(string4);
                try {
                    if (!file.exists() || !file.isDirectory()) {
                        file.mkdirs();
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    messages.showErrorWarning(options.getMainComponent(), "cl_err_unableToCreateDir", exception);
                }
            }
            string2 = file.getAbsolutePath();
            properties.setProperty(string, string2);
            PersistentSettings.saveSettings(properties);
        }
        return new File(string2);
    }

    private static void saveSettings(Properties properties) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(baseFile);
        properties.store(fileOutputStream, null);
        ((OutputStream)fileOutputStream).close();
    }

    public static String getSystemProgramsPath(Options options) {
        String string = System.getProperty("user.home");
        File file = null;
        if (options.getBoolean("Windows")) {
            for (int i = 0; i < PRG_LOCATIONS.length; ++i) {
                file = new File(PRG_LOCATIONS[i]);
                if (!file.exists() || !file.isDirectory()) continue;
                string = file.getAbsolutePath();
                break;
            }
        } else {
            file = new File("/usr/local");
            if (file.exists() && file.isDirectory() && file.canWrite() || (file = new File("/usr")).exists() && file.isDirectory() && file.canWrite()) {
                string = file.getAbsolutePath();
            }
        }
        return string;
    }

    public static Messages getMessages(Options options, String string) throws Exception {
        Messages messages = (Messages)options.get("messages");
        if (messages == null) {
            boolean bl = false;
            String string2 = (String)options.get("language");
            Properties properties = null;
            if (string2 == null) {
                properties = PersistentSettings.getProperties();
                string2 = properties.getProperty("language");
                if (string2 != null) {
                    options.put("language", string2);
                } else {
                    bl = true;
                }
            } else {
                options.put("languageByParam", Options.BTRUE);
            }
            messages = Messages.getMessages(options, string);
            if (bl) {
                properties.setProperty("language", (String)options.get("language"));
                PersistentSettings.saveSettings(properties);
            }
        } else if (string != null) {
            messages.addBundle(string);
        }
        return messages;
    }

    public static String getFilePath(String string, String string2, Options options) {
        File file = null;
        try {
            file = PersistentSettings.getBasePathTo(string, options);
        }
        catch (Exception exception) {
            file = new File(System.getProperty("user.home"));
        }
        File file2 = new File(file, string2);
        if (!file2.canRead()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.close();
                file2.delete();
            }
            catch (Exception exception) {
                file2 = new File(string2);
            }
        }
        return file2.getAbsolutePath();
    }
}

