/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
extends Content {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.24 $ $Date: 2004/02/27 11:32:57 $ $Name: jdom_1_0 $";
    static final String EMPTY_STRING = "";
    protected String value;

    protected Text() {
    }

    public Text(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.value;
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (" \t\n\r".indexOf(cArray[i]) != -1) {
                if (bl) continue;
                cArray2[n++] = 32;
                bl = true;
                continue;
            }
            cArray2[n++] = cArray[i];
            bl = false;
        }
        if (bl && n > 0) {
            --n;
        }
        return new String(cArray2, 0, n);
    }

    public Text setText(String string) {
        if (string == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string;
        return this;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string == EMPTY_STRING ? string : this.value + string;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = this.value + text.getText();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").substring(0);
    }

    public Object clone() {
        Text text = (Text)super.clone();
        text.value = this.value;
        return text;
    }
}

