/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.lame;

import java.io.UnsupportedEncodingException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;

public class Lame {
    private static final int MPEG_VERSION_2 = 0;
    private static final int MPEG_VERSION_1 = 1;
    private static final int MPEG_VERSION_2DOT5 = 2;
    public static final int QUALITY_LOWEST = 9;
    public static final int QUALITY_LOW = 7;
    public static final int QUALITY_MIDDLE = 5;
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_HIGHEST = 1;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int CHANNEL_MODE_AUTO = -1;
    public static final int BITRATE_AUTO = -1;
    private static final int DEFAULT_PCM_BUFFER_SIZE = 32768;
    private static boolean libAvailable = false;
    private static String linkError = "";
    private static int DEFAULT_QUALITY = 5;
    private static int DEFAULT_BITRATE = -1;
    private static int DEFAULT_CHANNEL_MODE = -1;
    private static boolean DEFAULT_VBR = false;
    private static final int OUT_OF_MEMORY = -300;
    private static final int NOT_INITIALIZED = -301;
    private static final int LAME_ENC_NOT_FOUND = -302;
    private static final String PROPERTY_PREFIX = "tritonus.lame.";
    private long m_lNativeGlobalFlags;
    private int effQuality;
    private int effBitRate;
    private int effVbr;
    private int effChMode;
    private int effSampleRate;
    private int effEncoding;

    private void handleNativeException(int n) {
        this.close();
        if (n == -300) {
            throw new OutOfMemoryError("out of memory");
        }
        if (n == -301) {
            throw new RuntimeException("not initialized");
        }
        if (n == -302) {
            libAvailable = false;
            linkError = "lame_enc.dll not found";
            throw new IllegalArgumentException(linkError);
        }
    }

    public Lame(AudioFormat audioFormat) {
        this.initParams(audioFormat);
    }

    public Lame(AudioFormat audioFormat, int n, int n2, int n3, boolean bl) {
        this.initParams(audioFormat, n, n2, n3, bl);
    }

    private void initParams(AudioFormat audioFormat) {
        this.readParameters();
        this.initParams(audioFormat, DEFAULT_BITRATE, DEFAULT_CHANNEL_MODE, DEFAULT_QUALITY, DEFAULT_VBR);
    }

    private void initParams(AudioFormat audioFormat, int n, int n2, int n3, boolean bl) {
        block5: {
            int n4;
            if (audioFormat.getSampleRate() < 32000.0f && n > 160) {
                n = 160;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("LAME parameters: channels=" + audioFormat.getChannels() + "  sample rate=" + Math.round(audioFormat.getSampleRate()) + "Hz" + "  bitrate=" + n + "KBit/s");
                TDebug.out("                 channelMode=" + this.chmode2string(n2) + "   quality=" + this.quality2string(n3) + "   VBR=" + bl + "  bigEndian=" + audioFormat.isBigEndian());
            }
            if ((n4 = this.nInitParams(audioFormat.getChannels(), Math.round(audioFormat.getSampleRate()), n, n2, n3, bl, audioFormat.isBigEndian())) < 0) {
                this.handleNativeException(n4);
                throw new IllegalArgumentException("parameters not supported by LAME (returned " + n4 + ")");
            }
            try {
                System.setProperty("tritonus.lame.effective.quality", this.quality2string(this.getEffectiveQuality()));
                System.setProperty("tritonus.lame.effective.bitrate", String.valueOf(this.getEffectiveBitRate()));
                System.setProperty("tritonus.lame.effective.chmode", this.chmode2string(this.getEffectiveChannelMode()));
                System.setProperty("tritonus.lame.effective.vbr", String.valueOf(this.getEffectiveVBR()));
                System.setProperty("tritonus.lame.effective.samplerate", String.valueOf(this.getEffectiveSampleRate()));
                System.setProperty("tritonus.lame.effective.encoding", this.getEffectiveEncoding().toString());
                System.setProperty("tritonus.lame.encoder.version", this.getEncoderVersion());
            }
            catch (Throwable throwable) {
                if (!TDebug.TraceAllExceptions) break block5;
                TDebug.out(throwable);
            }
        }
    }

    private native int nInitParams(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    private native int nGetEncoderVersion(byte[] var1);

    public String getEncoderVersion() {
        byte[] byArray = new byte[300];
        int n = this.nGetEncoderVersion(byArray);
        if (n < 0) {
            if (n == -1) {
                throw new RuntimeException("Unexpected error in Lame.getEncoderVersion()");
            }
            this.handleNativeException(n);
        }
        String string = "";
        if (n > 0) {
            try {
                string = new String(byArray, 0, n, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(unsupportedEncodingException);
                }
                string = new String(byArray, 0, n);
            }
        }
        return string;
    }

    private native int nGetPCMBufferSize(int var1);

    public int getPCMBufferSize() {
        int n = this.nGetPCMBufferSize(32768);
        if (n < 0) {
            this.handleNativeException(n);
            throw new RuntimeException("Unknown error in Lame.nGetPCMBufferSize(). Resultcode=" + n);
        }
        return n;
    }

    public int getMP3BufferSize() {
        return this.getPCMBufferSize() / 2 + 1024;
    }

    private native int nEncodeBuffer(byte[] var1, int var2, int var3, byte[] var4);

    public int encodeBuffer(byte[] byArray, int n, int n2, byte[] byArray2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("inconsistent parameters");
        }
        int n3 = this.nEncodeBuffer(byArray, n, n2, byArray2);
        if (n3 < 0) {
            if (n3 == -1) {
                throw new ArrayIndexOutOfBoundsException("Encode buffer too small");
            }
            this.handleNativeException(n3);
            throw new RuntimeException("crucial error in encodeBuffer.");
        }
        return n3;
    }

    private native int nEncodeFinish(byte[] var1);

    public int encodeFinish(byte[] byArray) {
        return this.nEncodeFinish(byArray);
    }

    private native void nClose();

    public void close() {
        this.nClose();
    }

    public static boolean isLibAvailable() {
        return libAvailable;
    }

    public static String getLinkError() {
        return linkError;
    }

    public int getEffectiveQuality() {
        if (this.effQuality >= 9) {
            return 9;
        }
        if (this.effQuality >= 7) {
            return 7;
        }
        if (this.effQuality >= 5) {
            return 5;
        }
        if (this.effQuality >= 2) {
            return 2;
        }
        return 1;
    }

    public int getEffectiveBitRate() {
        return this.effBitRate;
    }

    public int getEffectiveChannelMode() {
        return this.effChMode;
    }

    public boolean getEffectiveVBR() {
        return this.effVbr != 0;
    }

    public int getEffectiveSampleRate() {
        return this.effSampleRate;
    }

    public AudioFormat.Encoding getEffectiveEncoding() {
        if (this.effEncoding == 0) {
            if (this.getEffectiveSampleRate() < 16000) {
                return Encodings.getEncoding("MPEG2DOT5L3");
            }
            return Encodings.getEncoding("MPEG2L3");
        }
        if (this.effEncoding == 2) {
            return Encodings.getEncoding("MPEG2DOT5L3");
        }
        return Encodings.getEncoding("MPEG1L3");
    }

    private void readParameters() {
        block2: {
            String string = Lame.getStringProperty("quality", this.quality2string(DEFAULT_QUALITY));
            DEFAULT_QUALITY = this.string2quality(string.toLowerCase(), DEFAULT_QUALITY);
            DEFAULT_BITRATE = Lame.getIntProperty("bitrate", DEFAULT_BITRATE);
            string = Lame.getStringProperty("chmode", this.chmode2string(DEFAULT_CHANNEL_MODE));
            DEFAULT_CHANNEL_MODE = this.string2chmode(string.toLowerCase(), DEFAULT_CHANNEL_MODE);
            DEFAULT_VBR = Lame.getBooleanProperty("vbr", DEFAULT_VBR);
            try {
                System.setProperty("tritonus.lame.quality", this.quality2string(DEFAULT_QUALITY));
                System.setProperty("tritonus.lame.bitrate", String.valueOf(DEFAULT_BITRATE));
                System.setProperty("tritonus.lame.chmode", this.chmode2string(DEFAULT_CHANNEL_MODE));
                System.setProperty("tritonus.lame.vbr", String.valueOf(DEFAULT_VBR));
            }
            catch (Throwable throwable) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(throwable);
            }
        }
    }

    private String quality2string(int n) {
        if (n >= 9) {
            return "lowest";
        }
        if (n >= 7) {
            return "low";
        }
        if (n >= 5) {
            return "middle";
        }
        if (n >= 2) {
            return "high";
        }
        return "highest";
    }

    private int string2quality(String string, int n) {
        if (string.equals("lowest")) {
            return 9;
        }
        if (string.equals("low")) {
            return 7;
        }
        if (string.equals("middle")) {
            return 5;
        }
        if (string.equals("high")) {
            return 2;
        }
        if (string.equals("highest")) {
            return 1;
        }
        return n;
    }

    private String chmode2string(int n) {
        if (n == 0) {
            return "stereo";
        }
        if (n == 1) {
            return "jointstereo";
        }
        if (n == 2) {
            return "dual";
        }
        if (n == 3) {
            return "mono";
        }
        if (n == -1) {
            return "auto";
        }
        return "auto";
    }

    private int string2chmode(String string, int n) {
        if (string.equals("stereo")) {
            return 0;
        }
        if (string.equals("jointstereo")) {
            return 1;
        }
        if (string.equals("dual")) {
            return 2;
        }
        if (string.equals("mono")) {
            return 3;
        }
        if (string.equals("auto")) {
            return -1;
        }
        return n;
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2;
        block3: {
            String string3 = PROPERTY_PREFIX + string;
            string2 = bl ? "true" : "false";
            try {
                string2 = System.getProperty(string3, string2);
            }
            catch (Throwable throwable) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(throwable);
            }
        }
        string2 = string2.toLowerCase();
        boolean bl2 = false;
        if (string2.length() > 0) {
            bl2 = bl ? string2.charAt(0) != 'f' && string2.charAt(0) != 'n' && !string2.equals("off") : string2.charAt(0) == 't' || string2.charAt(0) == 'y' || string2.equals("on");
        }
        return bl2;
    }

    private static String getStringProperty(String string, String string2) {
        String string3;
        block2: {
            String string4 = PROPERTY_PREFIX + string;
            string3 = string2;
            try {
                string3 = System.getProperty(string4, string2);
            }
            catch (Throwable throwable) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(throwable);
            }
        }
        return string3;
    }

    private static int getIntProperty(String string, int n) {
        int n2;
        block2: {
            String string2 = PROPERTY_PREFIX + string;
            n2 = n;
            try {
                String string3 = System.getProperty(string2, String.valueOf(n));
                n2 = new Integer(string3);
            }
            catch (Throwable throwable) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(throwable);
            }
        }
        return n2;
    }

    static {
        try {
            System.loadLibrary("lametritonus");
            libAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(unsatisfiedLinkError);
            }
            linkError = unsatisfiedLinkError.getMessage();
        }
    }
}

