/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditorFramePanel;
import edu.xtec.jclic.ActivityEditorMsgPanel;
import edu.xtec.jclic.ActivityEditorOptionsPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.media.EventSoundsEditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.TripleString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ActivityEditor
extends Editor {
    protected static ImageIcon icon;
    protected static final int COMMON_PANELS = 3;
    static final BasicStroke dashedStroke;
    public static final String SYSTEM_LIST = "activities.listactivities";

    public ActivityEditor(Activity activity) {
        super(activity);
    }

    protected void createChildren() {
        Activity activity = this.getActivity();
        if (activity.acp != null) {
            activity.acp.getEditor(this);
        }
    }

    public AutoContentProviderEditor getAutoContentProviderEditor() {
        return (AutoContentProviderEditor)this.getFirstChild(AutoContentProviderEditor.class);
    }

    public Class getEditorPanelClass() {
        return ActivityEditorPanel.class;
    }

    public synchronized EditorPanel createEditorPanel(Options options) {
        ActivityEditorPanel activityEditorPanel = new ActivityEditorPanel(options);
        activityEditorPanel.addInternalPanel(new ActivityEditorOptionsPanel(activityEditorPanel), null, null);
        activityEditorPanel.addInternalPanel(new ActivityEditorFramePanel(activityEditorPanel), null, null);
        activityEditorPanel.addInternalPanel(new ActivityEditorMsgPanel(activityEditorPanel), null, null);
        this.createPanels(activityEditorPanel);
        return activityEditorPanel;
    }

    public String getTitleKey() {
        return "edit_act";
    }

    protected void createPanels(ActivityEditorPanel activityEditorPanel) {
    }

    public Activity getActivity() {
        return (Activity)this.getFirstObject(Activity.class);
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public MediaBagEditor getMediaBagEditor() {
        JClicProjectEditor jClicProjectEditor = this.getProjectEditor();
        return jClicProjectEditor == null ? null : jClicProjectEditor.getMediaBagEditor();
    }

    public Options getOptions() {
        return this.getActivity().getProject().getBridge().getOptions();
    }

    public ActivityBagElementEditor getActivityBagElementEditor() {
        return (ActivityBagElementEditor)this.getFirstParent(ActivityBagElementEditor.class);
    }

    public ActivityBagEditor getActivityBagEditor() {
        return (ActivityBagEditor)this.getFirstParent(ActivityBagEditor.class);
    }

    public boolean rename(String string, Component component, Messages messages) {
        String string2 = this.getActivity().name;
        String string3 = null;
        string = string.trim();
        boolean bl = false;
        if (!string2.equals(string)) {
            if (string.length() < 1) {
                string3 = "edit_media_rename_invalid";
            } else if (this.getActivityBagEditor().getActivityBag().getElementByName(string) != null) {
                string3 = "edit_media_rename_exists";
            } else {
                bl = this.getProjectEditor().nameChanged(1, string2, string);
            }
        }
        if (string3 != null && messages != null && component != null) {
            messages.showAlert(component, string3);
        }
        return bl;
    }

    public synchronized void saveData() {
        ActivityBagElementEditor activityBagElementEditor = this.getActivityBagElementEditor();
        if (activityBagElementEditor != null) {
            ActivityBagElement activityBagElement = activityBagElementEditor.getActivityBagElement();
            String string = activityBagElement.getName();
            activityBagElement.setData(this.getActivity().getJDomElement());
            if (!activityBagElement.getName().equals(string)) {
                // empty if block
            }
            if (this.isModified()) {
                activityBagElementEditor.setModified(true);
            }
        }
    }

    public String toString() {
        return this.getActivity().name;
    }

    public void setActionsOwner() {
        if (this.getEditorParent() != null) {
            this.getEditorParent().setActionsOwner();
        }
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return ActivityEditor.getIcon();
    }

    public void drawPreview(Graphics2D graphics2D, Rectangle rectangle, int n) {
        Rectangle rectangle2 = new Rectangle(rectangle.x + n, rectangle.y + n, rectangle.width - 2 * n, rectangle.height - 2 * n);
        graphics2D.setXORMode(Color.white);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashedStroke);
        graphics2D.draw(rectangle2);
        graphics2D.setPaintMode();
        graphics2D.setStroke(stroke);
    }

    public boolean nameChanged(int n, String string, String string2) {
        int n2;
        boolean bl = false;
        Activity activity = this.getActivity();
        if ((n & 1) != 0 && string.equals(activity.name)) {
            activity.name = string2;
            bl = true;
        }
        for (n2 = 0; n2 < activity.messages.length; ++n2) {
            if (activity.messages[n2] == null) continue;
            bl |= ActiveBoxContentEditor.nameChanged(activity.messages[n2], n, string, string2);
        }
        if ((n & 0x10) != 0 && string.equals(activity.bgImageFile)) {
            activity.bgImageFile = string2;
            bl = true;
        }
        if (activity.eventSounds != null && (n & 0x60) != 0) {
            bl |= EventSoundsEditorPanel.nameChanged(activity.eventSounds, n, string, string2);
        }
        if ((n & 0x200) != 0 && string.equals(activity.skinFileName) && !string.startsWith("@")) {
            activity.skinFileName = string2;
            bl = true;
        }
        if (activity.abc != null) {
            for (n2 = 0; n2 < activity.abc.length; ++n2) {
                if (activity.abc[n2] == null) continue;
                bl |= ActiveBagContentEditor.nameChanged(activity.abc[n2], n, string, string2);
            }
        }
        if (bl) {
            this.setModified(true);
        }
        return bl;
    }

    public static Vector getSystemActivityList(Options options) {
        Vector vector = new Vector();
        try {
            vector = TripleString.getTripleList(SYSTEM_LIST, options, false, true, true);
        }
        catch (Exception exception) {
            System.err.println("Error reading list of activities!\n" + exception);
        }
        return vector;
    }

    static {
        dashedStroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f}, 0.0f);
    }
}

