/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTargetEditorPanel;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;

public class TextActivityBaseEditor
extends ActivityEditor {
    protected int from;
    protected int to;

    public TextActivityBaseEditor(TextActivityBase textActivityBase) {
        super(textActivityBase);
    }

    protected void createPanels(ActivityEditorPanel activityEditorPanel) {
        activityEditorPanel.addInternalPanel("TEXT_BASE", null, null);
    }

    protected TextActivityBase getTextActivity() {
        return (TextActivityBase)this.getActivity();
    }

    protected JPanelActiveBox createNewBox(int n, Options options, Component component) {
        JPanelActiveBox jPanelActiveBox = null;
        TextActivityBase textActivityBase = this.getTextActivity();
        AttributeSet attributeSet = textActivityBase.tad.getCharacterElement(n).getAttributes();
        if (attributeSet.isDefined("target")) {
            options.getMessages().showAlert(component, "edit_text_act_err_cellInTarget");
            return null;
        }
        ActiveBoxContent activeBoxContent = new ActiveBoxContent();
        activeBoxContent.setDimension(new Dimension(100, 40));
        activeBoxContent.setBoxBase(textActivityBase.tad.boxesContent.bb);
        activeBoxContent = ActiveBoxContentEditor.getActiveBoxContent(activeBoxContent, component, options, this.getMediaBagEditor(), null);
        if (activeBoxContent != null) {
            try {
                jPanelActiveBox = TextActivityDocument.insertBox(activeBoxContent, n, textActivityBase.tad, textActivityBase, null);
            }
            catch (Exception exception) {
                options.getMessages().showErrorWarning(component, "ERROR", exception);
            }
        }
        return jPanelActiveBox;
    }

    protected TargetMarker createNewTarget(int n, int n2, Options options, Component component) {
        TargetMarker targetMarker = null;
        TextActivityBase textActivityBase = this.getTextActivity();
        if (textActivityBase != null) {
            this.from = n;
            this.to = n2;
            if (!this.checkTargetSegment(options, component)) {
                return null;
            }
            targetMarker = new TargetMarker(textActivityBase.tad);
            targetMarker.begOffset = this.from;
            targetMarker.endOffset = this.to;
            targetMarker.setPositions();
            textActivityBase.tad.tmb.add(targetMarker);
            textActivityBase.tad.applyStyleToTarget(targetMarker, "target", false, true);
        }
        return targetMarker;
    }

    private boolean checkTargetSegment(Options options, Component component) {
        Object object;
        int n;
        int n2;
        String string = null;
        if (this.getTextActivity() == null) {
            return false;
        }
        TextActivityDocument textActivityDocument = this.getTextActivity().tad;
        String string2 = "";
        try {
            string2 = textActivityDocument.getText(0, textActivityDocument.getLength());
        }
        catch (Exception exception) {
            return false;
        }
        int n3 = string2.length();
        this.from = Math.min(Math.max(0, this.from), Math.max(0, n3 - 1));
        this.to = Math.min(Math.max(this.from, this.to), n3);
        switch (textActivityDocument.getTargetType()) {
            case 0: {
                n2 = this.from;
                n = this.to;
                while (this.from < n3 && Character.isWhitespace(string2.charAt(this.from))) {
                    ++this.from;
                }
                while (this.to >= this.from && this.to > 0 && Character.isWhitespace(string2.charAt(this.to - 1))) {
                    --this.to;
                }
                if (this.from < this.to) break;
                this.from = n2;
                this.to = n;
                break;
            }
            case 1: {
                while (this.from < n3 && Character.isWhitespace(string2.charAt(this.from))) {
                    ++this.from;
                }
                this.to = Math.min(this.from + 1, n3);
                break;
            }
            case 2: {
                while (this.from >= 0 && !Character.isWhitespace(string2.charAt(this.from))) {
                    --this.from;
                }
                ++this.from;
                this.to = this.from;
                while (this.to < n3 && !Character.isWhitespace(string2.charAt(this.to))) {
                    ++this.to;
                }
                break;
            }
            case 3: {
                object = textActivityDocument.getParagraphElement(this.from);
                if (object == null) {
                    this.to = this.from;
                    break;
                }
                this.from = Math.max(0, object.getStartOffset());
                this.to = Math.max(0, Math.min(string2.length() - 1, object.getEndOffset() - 1));
                while (this.to > this.from && (string2.charAt(this.to) == '\r' || string2.charAt(this.to) == '\n')) {
                    --this.to;
                }
                ++this.to;
                break;
            }
        }
        if (this.to == this.from) {
            string = "edit_text_act_err_noSelection";
        } else if (this.from > this.to) {
            string = "ERROR";
        } else {
            try {
                for (n2 = this.from; n2 < this.to; ++n2) {
                    n = textActivityDocument.getText(n2, 1).charAt(0);
                    if (n == 13 || n == 10 || n == 8) {
                        string = "edit_text_act_err_badCharInSelection";
                    } else {
                        object = textActivityDocument.getCharacterElement(n2).getAttributes();
                        if (object.isDefined("target")) {
                            string = "edit_text_act_err_nestedTargets";
                        } else {
                            if (object.getAttribute(StyleConstants.ComponentAttribute) == null) continue;
                            string = "edit_text_act_err_cellInTarget";
                        }
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string != null && options != null) {
            options.getMessages().showAlert(component, string);
        }
        return string == null;
    }

    protected boolean deleteTarget(TargetMarker targetMarker, Options options, Component component) {
        TextActivityBase textActivityBase = this.getTextActivity();
        if (textActivityBase != null) {
            textActivityBase.tad.tmb.remove(targetMarker);
            textActivityBase.tad.applyStyleToTarget(targetMarker, null, false, true);
        }
        return true;
    }

    protected boolean canEditTarget() {
        return false;
    }

    protected boolean editTarget(int n, Options options, Component component) {
        boolean bl = false;
        TextActivityBase textActivityBase = this.getTextActivity();
        if (this.canEditTarget() && n >= 0 && n < textActivityBase.tad.getLength()) {
            TargetMarker targetMarker = textActivityBase.tad.tmb.getElementByOffset(n, true);
            if (targetMarker != null && targetMarker.target != null) {
                bl = TextTargetEditorPanel.editTextTarget(targetMarker.target, options, this.getMediaBagEditor(), component);
            }
            if (bl) {
                this.setModified(true);
            }
        }
        return bl;
    }

    protected void editCheckOptions(Options options, Component component) {
    }

    protected boolean hasType() {
        return false;
    }

    protected boolean editType(Options options, Component component) {
        return false;
    }

    public boolean nameChanged(int n, String string, String string2) {
        boolean bl = super.nameChanged(n, string, string2);
        bl |= ActiveBagContentEditor.nameChanged(this.getTextActivity().tad.boxesContent, n, string, string2);
        if (bl |= ActiveBagContentEditor.nameChanged(this.getTextActivity().tad.popupsContent, n, string, string2)) {
            this.setModified(true);
        }
        return bl;
    }
}

