/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityBaseEditor;
import edu.xtec.jclic.activities.text.TextPrevScreenEditorPanel;
import edu.xtec.jclic.activities.text.TextStyleEditorPanel;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Resizer;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SmallButtonBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextActivityEditorTextPanel
extends ActivityEditorInternalPanel
implements Resizer.ResizerListener {
    protected Resizer resizer;
    protected boolean skipUpdate;
    protected String fontName;
    protected int fontSize;
    protected boolean changeCombos = true;
    CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            TextActivityEditorTextPanel.this.showAttributes(caretEvent.getDot());
        }
    };
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 300);
    private JToggleButton alCenterBtn;
    private JToggleButton alLeftBtn;
    private JToggleButton alRightBtn;
    private ButtonGroup alignGrp;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private JButton clearStylesBtn;
    private JButton editTargetBtn;
    private JComboBox fontFaceCombo;
    private JComboBox fontSizeCombo;
    private SmallIntEditor heightEdit;
    private JButton insertBoxBtn;
    private JToggleButton italicBtn;
    private JScrollPane mainScroll;
    private JButton optionsBtn;
    private JButton prevScreenBtn;
    private JPanel previewPanel;
    private JButton styleBtn;
    private JToggleButton targetBtn;
    private ColorButton textColorBtn;
    private JTextPane textPane;
    private JScrollPane textScroll;
    private JButton typeBtn;
    private JToggleButton underlineBtn;
    private SmallIntEditor widthEdit;

    public TextActivityEditorTextPanel(ActivityEditorPanel activityEditorPanel) {
        super(activityEditorPanel);
        this.initComponents();
        this.textScroll.setBorder(BorderFactory.createEmptyBorder());
        this.textScroll.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
        this.textPane.addCaretListener(this.caretListener);
        this.resizer = new Resizer(this.previewPanel, null, false, this);
    }

    private void initComponents() {
        this.alignGrp = new ButtonGroup();
        this.mainScroll = new JScrollPane();
        this.previewPanel = new PreviewPanel();
        this.textScroll = new JScrollPane();
        this.textPane = new JTextPane();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        this.targetBtn = new JToggleButton();
        this.editTargetBtn = new JButton();
        this.insertBoxBtn = new JButton();
        this.prevScreenBtn = new JButton();
        this.optionsBtn = new JButton();
        this.typeBtn = new JButton();
        JLabel jLabel = new JLabel();
        this.widthEdit = new SmallIntEditor();
        JLabel jLabel2 = new JLabel();
        this.heightEdit = new SmallIntEditor();
        JPanel jPanel2 = new JPanel();
        this.styleBtn = new JButton();
        this.clearStylesBtn = new JButton();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        this.underlineBtn = new JToggleButton();
        this.alLeftBtn = new JToggleButton();
        this.alCenterBtn = new JToggleButton();
        this.alRightBtn = new JToggleButton();
        JLabel jLabel3 = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel jLabel4 = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        this.setLayout(new BorderLayout());
        this.previewPanel.setPreferredSize(new Dimension(780, 580));
        this.textPane.setPreferredSize(new Dimension(400, 300));
        this.textScroll.setViewportView(this.textPane);
        this.previewPanel.add(this.textScroll);
        this.mainScroll.setViewportView(this.previewPanel);
        this.add((Component)this.mainScroll, "Center");
        jPanel.setLayout(new GridBagLayout());
        this.targetBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/text_target.gif")));
        this.targetBtn.setToolTipText(this.options.getMsg("edit_text_act_target_toggle"));
        this.targetBtn.setBorder(new SmallButtonBorder(this.targetBtn, true));
        this.targetBtn.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.targetBtn, gridBagConstraints);
        this.editTargetBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/text_target_edit.gif")));
        this.editTargetBtn.setToolTipText(this.options.getMsg("edit_text_act_edit_target"));
        this.editTargetBtn.setBorder(new SmallButtonBorder(this.editTargetBtn, true));
        this.editTargetBtn.setEnabled(false);
        this.editTargetBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel.add((Component)this.editTargetBtn, gridBagConstraints);
        this.insertBoxBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/insert_box.gif")));
        this.insertBoxBtn.setToolTipText(this.options.getMsg("edit_text_act_insertCell"));
        this.insertBoxBtn.setBorder(new SmallButtonBorder(this.prevScreenBtn, true));
        this.insertBoxBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        jPanel.add((Component)this.insertBoxBtn, gridBagConstraints);
        this.prevScreenBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/prev_screen.gif")));
        this.prevScreenBtn.setToolTipText(this.options.getMsg("edit_text_act_prevScreen_title"));
        this.prevScreenBtn.setBorder(new SmallButtonBorder(this.prevScreenBtn, true));
        this.prevScreenBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        jPanel.add((Component)this.prevScreenBtn, gridBagConstraints);
        this.optionsBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/check.gif")));
        this.optionsBtn.setToolTipText(this.options.getMsg("edit_text_act_check_bt"));
        this.optionsBtn.setBorder(new SmallButtonBorder(this.optionsBtn, true));
        this.optionsBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        jPanel.add((Component)this.optionsBtn, gridBagConstraints);
        this.typeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/type.gif")));
        this.typeBtn.setToolTipText(this.options.getMsg("edit_text_act_typeBtn"));
        this.typeBtn.setBorder(new SmallButtonBorder(this.typeBtn, true));
        this.typeBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        jPanel.add((Component)this.typeBtn, gridBagConstraints);
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        jLabel.setLabelFor(this.widthEdit);
        jLabel.setText(":");
        jLabel.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(50);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel.add((Component)this.widthEdit, gridBagConstraints);
        jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        jLabel2.setLabelFor(this.heightEdit);
        jLabel2.setText(":");
        jLabel2.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(50);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel.add((Component)this.heightEdit, gridBagConstraints);
        jTabbedPane.addTab(this.options.getMsg("edit_text_act_content"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/content.gif")), jPanel);
        jPanel2.setLayout(new GridBagLayout());
        this.styleBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/doc_styles.gif")));
        this.styleBtn.setToolTipText(this.options.getMsg("edit_text_act_editStylesBtn"));
        this.styleBtn.setBorder(new SmallButtonBorder(this.styleBtn, true));
        this.styleBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.styleBtn, gridBagConstraints);
        this.clearStylesBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/doc_styles_clear.gif")));
        this.clearStylesBtn.setToolTipText(this.options.getMsg("edit_text_act_clearStylesBtn"));
        this.clearStylesBtn.setBorder(new SmallButtonBorder(this.styleBtn, true));
        this.clearStylesBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel2.add((Component)this.clearStylesBtn, gridBagConstraints);
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(120, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel2.add((Component)this.fontFaceCombo, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel2.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setBorder(new SmallButtonBorder(this.boldBtn, true));
        this.boldBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel2.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setBorder(new SmallButtonBorder(this.italicBtn, true));
        this.italicBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.italicBtn, gridBagConstraints);
        this.underlineBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_underline.gif")));
        this.underlineBtn.setToolTipText(this.options.getMsg("edit_font_underline"));
        this.underlineBtn.setBorder(new SmallButtonBorder(this.underlineBtn, true));
        this.underlineBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel2.add((Component)this.underlineBtn, gridBagConstraints);
        this.alignGrp.add(this.alLeftBtn);
        this.alLeftBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_left.gif")));
        this.alLeftBtn.setToolTipText(this.options.getMsg("edit_text_align_left"));
        this.alLeftBtn.setBorder(new SmallButtonBorder(this.alLeftBtn, true));
        this.alLeftBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel2.add((Component)this.alLeftBtn, gridBagConstraints);
        this.alignGrp.add(this.alCenterBtn);
        this.alCenterBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_center.gif")));
        this.alCenterBtn.setToolTipText(this.options.getMsg("edit_text_align_center"));
        this.alCenterBtn.setBorder(new SmallButtonBorder(this.alCenterBtn, true));
        this.alCenterBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.alCenterBtn, gridBagConstraints);
        this.alignGrp.add(this.alRightBtn);
        this.alRightBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_right.gif")));
        this.alRightBtn.setToolTipText(this.options.getMsg("edit_text_align_right"));
        this.alRightBtn.setBorder(new SmallButtonBorder(this.alRightBtn, true));
        this.alRightBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        jPanel2.add((Component)this.alRightBtn, gridBagConstraints);
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        jLabel3.setText(":");
        jLabel3.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 6);
        jPanel2.add((Component)this.textColorBtn, gridBagConstraints);
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        jLabel4.setText(":");
        jLabel4.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.bgColorBtn, gridBagConstraints);
        jTabbedPane.addTab(this.options.getMsg("edit_text_act_style"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/styles.gif")), jPanel2);
        this.add((Component)jTabbedPane, "North");
    }

    protected TextActivityBase getTextActivity() {
        return (TextActivityBase)this.getActivity();
    }

    protected TextActivityBaseEditor getTextActivityEditor() {
        return (TextActivityBaseEditor)this.getActivityEditor();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textPane.setEnabled(bl);
        this.widthEdit.setEnabled(bl);
        this.heightEdit.setEnabled(bl);
        this.fontFaceCombo.setEnabled(bl);
        this.fontSizeCombo.setEnabled(bl);
        this.boldBtn.setEnabled(bl);
        this.italicBtn.setEnabled(bl);
        this.underlineBtn.setEnabled(bl);
        this.textColorBtn.setEnabled(bl);
        this.bgColorBtn.setEnabled(bl);
        this.targetBtn.setEnabled(bl);
        this.alCenterBtn.setEnabled(bl);
        this.alRightBtn.setEnabled(bl);
        this.alLeftBtn.setEnabled(bl);
        this.resizer.setEnabled(bl);
        if (!bl) {
            this.editTargetBtn.setEnabled(false);
            this.typeBtn.setEnabled(false);
        }
    }

    public void fillData() {
        Dimension dimension;
        TextActivityBaseEditor textActivityBaseEditor = this.getTextActivityEditor();
        TextActivityBase textActivityBase = textActivityBaseEditor == null ? null : textActivityBaseEditor.getTextActivity();
        this.typeBtn.setEnabled(textActivityBaseEditor != null && textActivityBaseEditor.hasType());
        DefaultStyledDocument defaultStyledDocument = textActivityBase == null ? new DefaultStyledDocument() : textActivityBase.tad;
        Style style = defaultStyledDocument.getStyle("default");
        AttributeSet attributeSet = style.copyAttributes();
        this.textPane.setStyledDocument(defaultStyledDocument);
        style.addAttributes(attributeSet);
        defaultStyledDocument.addDocumentListener(this);
        Dimension dimension2 = dimension = textActivityBase == null ? DEFAULT_SIZE : textActivityBase.getWindowSize();
        if (textActivityBase == null || textActivityBase.tad.getLength() == 0) {
            this.textPane.setBounds(0, 0, dimension.width, dimension.height);
        }
        this.widthEdit.setValue(dimension.width);
        this.heightEdit.setValue(dimension.height);
        this.textPane.setBackground(textActivityBase == null ? Color.white : StyleConstants.getBackground(this.textPane.getStyle("default")));
        this.textScroll.setBounds(0, 0, dimension.width, dimension.height);
        this.resizer.setRect(this.textScroll.getBounds());
        this.resizer.setEnabled(textActivityBase != null);
        if (textActivityBase != null) {
            JPanelActiveBox[] jPanelActiveBoxArray = textActivityBase.tad.getPanelBoxes();
            for (int i = 0; i < jPanelActiveBoxArray.length; ++i) {
                jPanelActiveBoxArray[i].catchMouseEvents = false;
                new Resizer(jPanelActiveBoxArray[i], null, true, this);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextActivityEditorTextPanel.this.textPane.revalidate();
                }
            });
        }
    }

    public void resizeObjectTo(Rectangle rectangle, JComponent jComponent) {
        if (jComponent == this.previewPanel) {
            TextActivityBase textActivityBase = this.getTextActivity();
            if (textActivityBase != null) {
                this.textScroll.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                textActivityBase.setWindowSize(this.textScroll.getSize());
                this.widthEdit.setValue(rectangle.width);
                this.heightEdit.setValue(rectangle.height);
                this.textScroll.revalidate();
                this.repaint();
                this.setModified(true);
            }
        } else if (jComponent instanceof JPanelActiveBox) {
            JPanelActiveBox jPanelActiveBox = (JPanelActiveBox)jComponent;
            jPanelActiveBox.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            jPanelActiveBox.getActiveBoxContent().setDimension(dimension);
            jPanelActiveBox.setPreferredSize(dimension);
            jPanelActiveBox.setMaximumSize(dimension);
            this.setModified(true);
        }
    }

    public void editObject(Rectangle rectangle, JComponent jComponent, Point point) {
        ActiveBoxContent activeBoxContent;
        JPanelActiveBox jPanelActiveBox;
        if (jComponent instanceof JPanelActiveBox && (jPanelActiveBox = (JPanelActiveBox)jComponent) != null && jPanelActiveBox.ab != null && (activeBoxContent = ActiveBoxContentEditor.getActiveBoxContent(jPanelActiveBox.ab.getContent(), jPanelActiveBox, this.options, this.getActivityEditor().getMediaBagEditor(), jPanelActiveBox.ab)) != null) {
            jPanelActiveBox.setActiveBoxContent(activeBoxContent);
            Dimension dimension = activeBoxContent.getDimension();
            if (dimension != null) {
                this.resizeObjectTo(new Rectangle(jPanelActiveBox.getX(), jPanelActiveBox.getY(), dimension.width, dimension.height), jPanelActiveBox);
            }
            this.setModified(true);
        }
    }

    public void saveData() {
        TextActivityBase textActivityBase = this.getTextActivity();
        if (textActivityBase != null) {
            // empty if block
        }
    }

    protected Icon getIcon() {
        return ResourceManager.getImageIcon("icons/text_edit.gif");
    }

    protected String getTitle() {
        return this.options.getMsg("edit_act_panels_text");
    }

    protected String getTooltip() {
        return this.options.getMsg("edit_act_panels_text_tooltip");
    }

    public boolean documentChangePerformed(DocumentEvent documentEvent) {
        if (documentEvent != null && documentEvent.getType() == DocumentEvent.EventType.REMOVE && this.getTextActivity() != null) {
            this.getTextActivity().tad.tmb.removeUnattachedElements();
        }
        return documentEvent != null;
    }

    public boolean eventPerformed(EventObject eventObject) {
        boolean bl = false;
        TextActivityBaseEditor textActivityBaseEditor = this.getTextActivityEditor();
        if (textActivityBaseEditor != null && !this.skipUpdate) {
            int n;
            TextActivityBase textActivityBase = textActivityBaseEditor.getTextActivity();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            Object object = eventObject == null ? null : eventObject.getSource();
            int n2 = this.textPane.getSelectionStart();
            int n3 = this.textPane.getSelectionEnd();
            int n4 = 0;
            if (n2 != n3) {
                if (n3 < n2) {
                    n = n2;
                    n2 = n3;
                    n3 = n;
                }
                n4 = n3 - n2;
            }
            if (object.equals(this.fontFaceCombo)) {
                this.fontName = this.fontFaceCombo.getSelectedItem().toString();
                StyleConstants.setFontFamily(simpleAttributeSet, this.fontName);
                bl3 = true;
            } else if (object.equals(this.fontSizeCombo)) {
                n = 0;
                try {
                    n = Integer.parseInt(this.fontSizeCombo.getSelectedItem().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n >= 1) {
                    this.fontSize = n;
                    StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
                    bl3 = true;
                }
            } else if (object == this.boldBtn) {
                StyleConstants.setBold(simpleAttributeSet, this.boldBtn.isSelected());
                bl3 = true;
            } else if (object == this.italicBtn) {
                StyleConstants.setItalic(simpleAttributeSet, this.italicBtn.isSelected());
                bl3 = true;
            } else if (object == this.underlineBtn) {
                StyleConstants.setUnderline(simpleAttributeSet, this.underlineBtn.isSelected());
                bl3 = true;
            } else if (object == this.textColorBtn) {
                StyleConstants.setForeground(simpleAttributeSet, this.textColorBtn.getColor());
                bl3 = true;
            } else if (object == this.targetBtn) {
                TargetMarker targetMarker;
                n = this.targetBtn.isSelected() ? 1 : 0;
                TargetMarker targetMarker2 = targetMarker = n != 0 ? this.createNewTarget() : textActivityBase.tad.tmb.getElementByOffset(n3, true);
                if (targetMarker == null) {
                    return false;
                }
                if (n == 0 && !this.deleteTarget(targetMarker)) {
                    return true;
                }
                this.textPane.setCaretPosition(n2);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TextActivityEditorTextPanel.this.showAttributes(-1);
                    }
                });
            } else if (textActivityBaseEditor.canEditTarget() && object == this.editTargetBtn) {
                textActivityBaseEditor.editTarget(n3, this.options, this);
            } else if (object == this.insertBoxBtn) {
                JPanelActiveBox jPanelActiveBox = textActivityBaseEditor.createNewBox(n2, this.options, this);
                if (jPanelActiveBox != null) {
                    jPanelActiveBox.catchMouseEvents = false;
                    new Resizer(jPanelActiveBox, null, true, this);
                }
            } else if (object == this.optionsBtn) {
                textActivityBaseEditor.editCheckOptions(this.options, this);
            } else if (object == this.typeBtn && textActivityBaseEditor.hasType()) {
                textActivityBaseEditor.editType(this.options, this);
            } else if (object == this.bgColorBtn) {
                if (n4 != 0) {
                    StyleConstants.setBackground(simpleAttributeSet, this.bgColorBtn.getColor());
                    bl3 = true;
                }
            } else if (object == this.alLeftBtn || object == this.alCenterBtn || object == this.alRightBtn) {
                n = object == this.alCenterBtn ? 1 : (object == this.alRightBtn ? 2 : 0);
                StyleConstants.setAlignment(simpleAttributeSet, n);
                bl2 = true;
            } else if (object == this.styleBtn) {
                StyleContext styleContext = TextStyleEditorPanel.editStyleContext(this.options, textActivityBase.tad.styleContext, this);
                if (styleContext != null) {
                    try {
                        textActivityBase.setStyleContext(styleContext);
                        this.setInitializing(true);
                        this.fillData();
                        this.setInitializing(false);
                    }
                    catch (Exception exception) {
                        System.err.println("error applying styles:\n" + exception);
                    }
                }
            } else if (object == this.clearStylesBtn) {
                n = this.options.getMessages().showQuestionDlg(this, "edit_text_act_clearStylesPrompt", null, "yn");
                if (n == 1) {
                    try {
                        textActivityBase.setTextActivityDocument(textActivityBase.tad.getJDomElementWithoutStyles());
                        this.setInitializing(true);
                        this.fillData();
                        this.setInitializing(false);
                    }
                    catch (Exception exception) {
                        System.err.println("Error cleaning styles:\n" + exception);
                    }
                }
            } else if (object == this.prevScreenBtn) {
                if (TextPrevScreenEditorPanel.editPrevScreen(this.options, (TextActivityBaseEditor)this.getActivityEditor(), this)) {
                    this.setModified(true);
                }
            } else if (object == this.widthEdit || object == this.heightEdit) {
                textActivityBase.setWindowSize(new Dimension(this.widthEdit.getValue(), this.heightEdit.getValue()));
                this.previewPanel.revalidate();
            }
            this.changeCombos = false;
            if (bl2) {
                textActivityBase.tad.setParagraphAttributes(n2, n4, simpleAttributeSet, bl4);
            }
            if (bl3) {
                if (n4 > 0) {
                    textActivityBase.tad.setCharacterAttributes(n2, n4, simpleAttributeSet, bl4);
                } else {
                    MutableAttributeSet mutableAttributeSet = this.textPane.getInputAttributes();
                    mutableAttributeSet.addAttributes(simpleAttributeSet);
                }
            }
            this.textPane.grabFocus();
            this.changeCombos = true;
            bl = true;
        }
        return bl;
    }

    protected TargetMarker createNewTarget() {
        TargetMarker targetMarker = null;
        TextActivityBaseEditor textActivityBaseEditor = this.getTextActivityEditor();
        if (textActivityBaseEditor != null) {
            int n = this.textPane.getSelectionStart();
            int n2 = this.textPane.getSelectionEnd();
            targetMarker = textActivityBaseEditor.createNewTarget(n, n2, this.options, this);
        }
        return targetMarker;
    }

    protected boolean deleteTarget(TargetMarker targetMarker) {
        boolean bl = false;
        TextActivityBaseEditor textActivityBaseEditor = this.getTextActivityEditor();
        if (textActivityBaseEditor != null) {
            bl = textActivityBaseEditor.deleteTarget(targetMarker, this.options, this);
        }
        return bl;
    }

    protected void showAttributes(int n) {
        TextActivityBaseEditor textActivityBaseEditor = this.getTextActivityEditor();
        if (textActivityBaseEditor != null) {
            int n2;
            AttributeSet attributeSet;
            String string;
            TextActivityBase textActivityBase = textActivityBaseEditor.getTextActivity();
            this.skipUpdate = true;
            if (n < 0) {
                n = Math.max(0, this.textPane.getCaretPosition());
            }
            if (!(string = StyleConstants.getFontFamily(attributeSet = textActivityBase.tad.getCharacterElement(n).getAttributes())).equals(this.fontName) && this.changeCombos) {
                this.fontName = string;
                this.fontFaceCombo.setSelectedItem(string);
            }
            if (this.fontSize != (n2 = StyleConstants.getFontSize(attributeSet)) && this.changeCombos) {
                this.fontSize = n2;
                this.fontSizeCombo.setSelectedItem(Integer.toString(this.fontSize));
            }
            this.boldBtn.setSelected(StyleConstants.isBold(attributeSet));
            this.italicBtn.setSelected(StyleConstants.isItalic(attributeSet));
            this.underlineBtn.setSelected(StyleConstants.isUnderline(attributeSet));
            Color color = StyleConstants.getForeground(attributeSet);
            if (!color.equals(this.textColorBtn.getColor())) {
                this.textColorBtn.setColor(color);
            }
            if (!(color = StyleConstants.getBackground(attributeSet)).equals(this.bgColorBtn.getColor())) {
                this.bgColorBtn.setColor(color);
            }
            this.targetBtn.setSelected(attributeSet.isDefined("target"));
            this.editTargetBtn.setEnabled(textActivityBaseEditor.canEditTarget() && attributeSet.isDefined("target"));
            int n3 = StyleConstants.getAlignment(attributeSet);
            this.alCenterBtn.setSelected(n3 == 1);
            this.alRightBtn.setSelected(n3 == 2);
            this.alLeftBtn.setSelected(n3 != 2 && n3 != 1);
            this.skipUpdate = false;
        }
    }

    protected class PreviewPanel
    extends ResizerPanel {
        protected PreviewPanel() {
        }

        public void doLayout() {
            if (TextActivityEditorTextPanel.this.textScroll != null) {
                TextActivityBase textActivityBase = TextActivityEditorTextPanel.this.getTextActivity();
                Dimension dimension = textActivityBase != null ? textActivityBase.getWindowSize() : new Dimension(400, 300);
                TextActivityEditorTextPanel.this.textScroll.setBounds(0, 0, dimension.width, dimension.height);
            }
        }
    }
}

