/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActivityBagEditorPanel
extends EditorPanel
implements ListSelectionListener {
    boolean modified;
    public ActivityBagElementEditor currentItem;
    protected HashMap editPanels = new HashMap();
    protected EditorPanel currentPanel;
    private JPanel edit;
    private JList list;

    public ActivityBagEditorPanel(Options options) {
        super(options);
        ActivityBagEditor.createActions(options);
        ActivityBagElementEditor.createActions(options);
        this.initComponents();
        this.postInit(250, false, true);
        this.list.getSelectionModel().addListSelectionListener(this);
        this.setEnabled(false);
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane();
        this.list = new JList();
        this.edit = new JPanel();
        this.setLayout(new BorderLayout());
        this.list.setSelectionMode(0);
        jScrollPane.setViewportView(this.list);
        jSplitPane.setLeftComponent(jScrollPane);
        this.edit.setLayout(new BorderLayout());
        this.edit.setPreferredSize(new Dimension(700, 600));
        jSplitPane.setRightComponent(this.edit);
        this.add((Component)jSplitPane, "Center");
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
        if (this.currentPanel != null) {
            this.currentPanel.setEnabled(bl);
        }
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof ActivityBagEditor;
    }

    protected ActivityBag getActivityBag() {
        if (this.editor == null) {
            return null;
        }
        return ((ActivityBagEditor)this.editor).getActivityBag();
    }

    public void fillData() {
        ActivityBagEditor activityBagEditor = this.getActivityBagEditor();
        this.list.setModel(activityBagEditor == null ? new DefaultListModel() : activityBagEditor.getListModel());
        if (activityBagEditor != null) {
            activityBagEditor.setListSelectionModel(this.list.getSelectionModel());
        } else if (this.currentPanel != null) {
            this.currentPanel.removeEditor(true);
            this.edit.remove(this.currentPanel);
            this.currentPanel = null;
        }
    }

    public void saveData() {
        ActivityBag activityBag = this.getActivityBag();
        if (activityBag != null) {
            // empty if block
        }
    }

    protected Icon getIcon() {
        return ActivityBagEditor.getIcon();
    }

    protected String getTitle() {
        return "Activity bag";
    }

    ActivityBagEditor getActivityBagEditor() {
        return (ActivityBagEditor)this.getEditor();
    }

    protected void currentItemChanged() {
        if (this.edit != null) {
            if (this.currentPanel != null) {
                this.currentPanel.removeEditor(true);
            }
            if (this.currentItem != null) {
                Class clazz = this.currentItem.getEditorPanelClass();
                EditorPanel editorPanel = (EditorPanel)this.editPanels.get(clazz);
                if (editorPanel == null) {
                    editorPanel = this.currentItem.createEditorPanel(this.options);
                    this.editPanels.put(clazz, editorPanel);
                }
                editorPanel.attachEditor(this.currentItem.getActivityEditor(), true);
                if (this.currentPanel != editorPanel) {
                    if (this.currentPanel != null) {
                        this.edit.remove(this.currentPanel);
                    }
                    this.edit.add((Component)editorPanel, "Center");
                    this.edit.revalidate();
                    this.edit.repaint();
                }
                this.currentPanel = editorPanel;
            }
        }
    }

    public boolean editActivity(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            ListModel listModel = this.list.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (e == null || !string.equals(e.toString())) continue;
                this.list.setSelectedIndex(i);
                this.list.ensureIndexIsVisible(i);
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ActivityBagEditor activityBagEditor = this.getActivityBagEditor();
        if (activityBagEditor != null && this.currentItem != null && this.currentItem.getActivityEditor() != null) {
            this.currentItem.getActivityEditor().collectData();
            this.currentItem.forgetActivityEditor();
        }
        this.currentItem = null;
        int n = this.list.getSelectedIndex();
        if (n >= 0 && n < activityBagEditor.getChildCount()) {
            this.currentItem = (ActivityBagElementEditor)activityBagEditor.getChildAt(n);
        }
        this.currentItemChanged();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.currentPanel != null) {
            this.currentPanel.focusGained(focusEvent);
        } else {
            Editor.clearBasicActionsOwner();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.currentPanel != null) {
            this.currentPanel.focusLost(focusEvent);
        }
    }

    protected void addActionsTo(Container container) {
        container.add(new SmallButton(ActivityBagEditor.newActivityBagElementAction));
        container.add(new SmallButton(ActivityBagElementEditor.testActivityAction));
        container.add(new SmallButton(Editor.moveUpAction));
        container.add(new SmallButton(Editor.moveDownAction));
        container.add(new SmallButton(Editor.copyAction));
        container.add(new SmallButton(Editor.cutAction));
        container.add(new SmallButton(Editor.pasteAction));
        container.add(new SmallButton(Editor.deleteAction));
        container.add(new SmallButton(ActivityBagEditor.copyActivityAttributesAction));
    }
}

