/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import edu.xtec.util.TripleString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectActivityClass
extends JPanel {
    Options options;
    private Vector activityClasses;
    private Vector currentSet;
    private String currentClassName;
    private static final String TYPE_STYLE = "font-family:Helvetica;font-size:12;font-weight:bold;";
    private static final String DESC_STYLE = "font-family:Helvetica;font-size:12;";
    private JLabel alertLabel;
    protected JTextField classField;
    private JList classList;
    private JEditorPane descText;
    private JSplitPane jSplitPane1;
    private JPanel promptPanel;
    private JScrollPane scroll2;

    public SelectActivityClass(Options options) {
        this.options = options;
        this.activityClasses = ActivityEditor.getSystemActivityList(options);
        this.currentSet = new Vector();
        this.initComponents();
        this.classList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectActivityClass.this.updateSelection();
                }
            }
        });
        this.setListFilter(null, true);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane();
        this.classList = new JList();
        JPanel jPanel = new JPanel();
        this.scroll2 = new JScrollPane();
        this.descText = new JEditorPane();
        this.promptPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.classField = new JTextField();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 300));
        this.setMinimumSize(new Dimension(400, 300));
        jScrollPane.setMinimumSize(new Dimension(100, 200));
        this.classList.setMinimumSize(new Dimension(200, 0));
        jScrollPane.setViewportView(this.classList);
        this.jSplitPane1.setLeftComponent(jScrollPane);
        jPanel.setLayout(new GridBagLayout());
        this.scroll2.setMinimumSize(new Dimension(200, 200));
        this.descText.setEditable(false);
        this.descText.setContentType("text/html");
        this.scroll2.setViewportView(this.descText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.scroll2, gridBagConstraints);
        this.promptPanel.setLayout(new GridBagLayout());
        jLabel.setText(this.options.getMsg("edit_act_newActivity_class"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.promptPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.promptPanel.add((Component)this.classField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.promptPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(jPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    public void setListFilter(String[] stringArray, boolean bl) {
        Vector vector = new Vector();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = TripleString.getFirstItemWithClass(this.activityClasses, stringArray[i]);
                if (n < 0) continue;
                vector.add(this.activityClasses.get(n));
            }
        } else {
            vector.addAll(this.activityClasses);
        }
        if (bl) {
            vector.add(this.options.getMsg("edit_act_newActivity_other"));
        }
        this.classList.setListData(vector);
        this.currentSet = vector;
        this.setCurrentClassName(this.currentClassName);
    }

    private void updateSelection() {
        Object e = this.classList.getSelectedValue();
        boolean bl = false;
        if (e instanceof TripleString) {
            TripleString tripleString = (TripleString)e;
            this.currentClassName = tripleString.getClassName();
            this.descText.setContentType("text/html");
            this.descText.setText(this.getFormattedHtmlText(tripleString.toString(), tripleString.getDescription(), tripleString.getClassName()));
        } else if (e != null) {
            bl = true;
            this.currentClassName = StrUtils.nullableString(this.classField.getText());
            this.descText.setContentType("text/html");
            this.descText.setText(this.getFormattedHtmlText(e.toString(), this.options.getMsg("edit_act_newActivity_info"), null));
        } else {
            this.currentClassName = null;
            this.descText.setContentType("text/html");
            this.descText.setText("");
        }
        this.promptPanel.setVisible(bl);
        if (this.classList.getSelectedIndex() >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectActivityClass.this.classList.ensureIndexIsVisible(SelectActivityClass.this.classList.getSelectedIndex());
                }
            });
        }
    }

    String getFormattedHtmlText(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        if (string != null) {
            stringBuffer.append("<p style=\"").append(TYPE_STYLE).append("\">").append(string).append("</p>");
        }
        if (string2 != null) {
            stringBuffer.append("<p style=\"").append(DESC_STYLE).append("\">").append(string2).append("</p>");
        }
        if (string3 != null) {
            stringBuffer.append("<p style=\"").append(DESC_STYLE).append("\">");
            stringBuffer.append(this.options.getMsg("edit_act_newActivity_class")).append(" <i>").append(string3);
            stringBuffer.append("</i></p>");
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.substring(0);
    }

    public String getCurrentClassName() {
        this.updateSelection();
        return StrUtils.nullableString(this.currentClassName);
    }

    public void setCurrentClassName(String string) {
        this.currentClassName = string;
        if (string != null) {
            int n = TripleString.getFirstItemWithClass(this.currentSet, string);
            if (n >= 0) {
                this.classList.setSelectedIndex(n);
            } else {
                this.classField.setText(StrUtils.secureString(string));
            }
        }
        this.updateSelection();
    }

    public void setAlertMsg(String string) {
        if (this.alertLabel != null) {
            this.remove(this.alertLabel);
        }
        this.alertLabel = new JLabel(string);
        this.add((Component)this.alertLabel, "North");
    }
}

