/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SmallIntEditor
extends JPanel
implements ActionListener {
    public static final String PROP_VALUE = "value";
    private JButton plusButton;
    private JButton minusButton;
    private NumberField textFld;
    private int max;
    private int min;
    private int lastValue;
    private Toolkit toolkit;
    private NumberFormat integerFormatter;
    private int[] values;
    boolean editable;

    public SmallIntEditor() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.editable = true;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.max = 10;
        this.min = 0;
        this.plusButton = new JButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus.gif")));
        this.plusButton.setMnemonic('+');
        this.plusButton.addActionListener(this);
        this.plusButton.setPreferredSize(new Dimension(16, 16));
        this.minusButton = new JButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus.gif")));
        this.minusButton.setMnemonic('-');
        this.minusButton.addActionListener(this);
        this.minusButton.setPreferredSize(new Dimension(16, 16));
        this.textFld = new NumberField(4);
        this.textFld.setColumns(4);
        this.textFld.setHorizontalAlignment(0);
        this.textFld.setText("0");
        this.textFld.addActionListener(this);
        this.add((Component)this.minusButton, "West");
        this.add((Component)this.textFld, "Center");
        this.add((Component)this.plusButton, "East");
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.textFld.setToolTipText(string);
        this.plusButton.setToolTipText(string);
        this.minusButton.setToolTipText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        boolean bl;
        int n2 = this.lastValue;
        boolean bl2 = this.plusButton == actionEvent.getSource();
        boolean bl3 = bl = this.minusButton == actionEvent.getSource();
        int n3 = bl2 ? 1 : (n = bl ? -1 : 0);
        if (n != 0 && this.values != null && this.values.length > 0) {
            int n4;
            for (n4 = 0; n4 < this.values.length && n2 > this.values[n4]; ++n4) {
            }
            if (n < 0 || n4 < this.values.length && this.values[n4] == n2) {
                n4 += n;
            }
            n = n4 >= 0 && n4 < this.values.length ? this.values[n4] - n2 : 0;
        }
        if (n != 0) {
            this.setValue(this.getValue() + n);
        }
        this.checkValueRanges();
        this.checkEnabled();
        this.lastValue = this.getValue();
        this.firePropertyChange(PROP_VALUE, n2, this.lastValue);
    }

    private void checkEnabled() {
        int n = this.getValue();
        this.minusButton.setEnabled(this.isEnabled() && n > this.min);
        this.plusButton.setEnabled(this.isEnabled() && n < this.max);
        this.textFld.setEnabled(this.isEnabled() && this.editable);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkEnabled();
    }

    public int getValue() {
        int n = 0;
        String string = this.textFld.getText();
        if (string != null && string.length() > 0) {
            try {
                n = this.integerFormatter.parse(this.textFld.getText()).intValue();
            }
            catch (ParseException parseException) {
                this.toolkit.beep();
                parseException.printStackTrace();
            }
        }
        return this.correctValue(n);
    }

    public void setValue(int n) {
        this.lastValue = this.correctValue(n);
        this.textFld.setText(this.integerFormatter.format(this.lastValue));
    }

    public int correctValue(int n) {
        return Math.min(this.max, Math.max(this.min, n));
    }

    private void checkValueRanges() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.textFld.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (n < this.min || n > this.max) {
            this.setValue(this.correctValue(n));
        }
    }

    public void setEditColumns(int n) {
        this.textFld.setColumns(n);
    }

    public int getEditColumns() {
        return this.textFld.getColumns();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] nArray) {
        this.values = nArray;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.checkEnabled();
    }

    class NumberField
    extends JTextField {
        public NumberField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    if (Character.isDigit(cArray[i]) || cArray[i] == '-') {
                        cArray2[n2++] = cArray[i];
                        continue;
                    }
                    SmallIntEditor.this.toolkit.beep();
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
                SmallIntEditor.this.checkEnabled();
            }

            public void remove(int n, int n2) throws BadLocationException {
                super.remove(n, n2);
                SmallIntEditor.this.checkEnabled();
            }
        }
    }
}

