/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.beans.BoxBaseButton;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import edu.xtec.util.TripleString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class ActiveBagContentControlPanel
extends CtrlPanel {
    ActiveBagContentEditor parent;
    ActiveBagContent abc;
    ActiveBagContent altAbc;
    ActiveBagContentControlPanel syncPanel;
    boolean altNull;
    Options options;
    int index;
    int altIndex;
    int visualIndex;
    boolean simpleMode;
    private JCheckBox altChk;
    private JCheckBox borderChk;
    private BoxBaseButton boxBaseButton;
    private SmallIntEditor heightEdit;
    private ImgButton imgButton;
    private JLabel imgLb;
    private SmallIntEditor nColsEdit;
    private JLabel nColsLb;
    private SmallIntEditor nRowsEdit;
    private JLabel nRowsLb;
    private JCheckBox scrambleChk;
    private JComboBox shaperCombo;
    private JButton shaperEditBtn;
    private JLabel shaperLb;
    private JToggleButton toggleAlt;
    private SmallIntEditor widthEdit;

    public ActiveBagContentControlPanel(ActiveBagContentEditor activeBagContentEditor, int n, int n2, int n3, boolean bl) {
        this.setInitializing(true);
        this.simpleMode = bl;
        this.parent = activeBagContentEditor;
        this.options = activeBagContentEditor.getOptions();
        this.index = n;
        this.altIndex = n2;
        this.visualIndex = n3;
        this.altNull = n2 >= 0;
        this.initComponents();
        if (n2 < 0 || bl) {
            this.altChk.setEnabled(false);
            this.altChk.setVisible(false);
            this.toggleAlt.setEnabled(false);
            this.toggleAlt.setVisible(false);
        }
        if (bl) {
            this.shaperLb.setVisible(false);
            this.shaperCombo.setVisible(false);
            this.shaperEditBtn.setVisible(false);
            this.scrambleChk.setVisible(false);
            this.nRowsLb.setVisible(false);
            this.nRowsEdit.setVisible(false);
            this.nColsLb.setVisible(false);
            this.nColsEdit.setVisible(false);
            this.imgLb.setVisible(false);
            this.imgButton.setVisible(false);
        }
        this.setInitializing(false);
    }

    protected void setSyncpanel(ActiveBagContentControlPanel activeBagContentControlPanel) {
        this.syncPanel = activeBagContentControlPanel;
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.shaperLb = new JLabel();
        this.shaperCombo = new JComboBox(Shaper.getSystemShaperList(this.options));
        this.shaperEditBtn = new JButton();
        this.scrambleChk = new JCheckBox();
        this.altChk = new JCheckBox();
        this.toggleAlt = new JToggleButton();
        JLabel jLabel2 = new JLabel();
        this.nRowsLb = new JLabel();
        this.nRowsEdit = new SmallIntEditor();
        this.nColsLb = new JLabel();
        this.nColsEdit = new SmallIntEditor();
        this.imgLb = new JLabel();
        this.imgButton = new ImgButton();
        this.imgButton.setOptions(this.options);
        JLabel jLabel3 = new JLabel();
        this.widthEdit = new SmallIntEditor();
        JLabel jLabel4 = new JLabel();
        this.heightEdit = new SmallIntEditor();
        JLabel jLabel5 = new JLabel();
        this.boxBaseButton = new BoxBaseButton();
        this.boxBaseButton.setOptions(this.options);
        this.borderChk = new JCheckBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jLabel, gridBagConstraints);
        this.shaperLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/select_shaper.gif")));
        this.shaperLb.setLabelFor(this.shaperCombo);
        this.shaperLb.setText(":");
        this.shaperLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shaperLb, gridBagConstraints);
        this.shaperCombo.setToolTipText(this.options.getMsg("edit_act_shaper_tooltip"));
        this.shaperCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shaperCombo, gridBagConstraints);
        this.shaperEditBtn.setText("...");
        this.shaperEditBtn.setMargin(new Insets(0, 4, 0, 4));
        this.shaperEditBtn.setEnabled(false);
        this.shaperEditBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shaperEditBtn, gridBagConstraints);
        this.scrambleChk.setText(this.options.getMsg("edit_act_scramble"));
        this.scrambleChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.scrambleChk, gridBagConstraints);
        this.altChk.setToolTipText(this.options.getMsg("edit_act_alt_tooltip"));
        this.altChk.setText(this.options.getMsg("edit_act_alt"));
        this.altChk.setHorizontalTextPosition(2);
        this.altChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.altChk, gridBagConstraints);
        this.toggleAlt.setToolTipText(this.options.getMsg("edit_act_alt_toggle_tooltip"));
        this.toggleAlt.setText(this.options.getMsg("edit_act_alt_toggle"));
        this.toggleAlt.setMargin(new Insets(0, 4, 0, 4));
        this.toggleAlt.setEnabled(false);
        this.toggleAlt.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.toggleAlt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        this.nRowsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_rows.gif")));
        this.nRowsLb.setLabelFor(this.nRowsEdit);
        this.nRowsLb.setText(":");
        this.nRowsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nRowsLb, gridBagConstraints);
        this.nRowsEdit.setToolTipText(this.options.getMsg("edit_act_num_rows_tooltip"));
        this.nRowsEdit.setMax(30);
        this.nRowsEdit.setMin(1);
        this.nRowsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nRowsEdit, gridBagConstraints);
        this.nColsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_cols.gif")));
        this.nColsLb.setLabelFor(this.nColsEdit);
        this.nColsLb.setText(":");
        this.nColsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nColsLb, gridBagConstraints);
        this.nColsEdit.setToolTipText(this.options.getMsg("edit_act_num_cols_tooltip"));
        this.nColsEdit.setMax(30);
        this.nColsEdit.setMin(1);
        this.nColsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nColsEdit, gridBagConstraints);
        this.imgLb.setLabelFor(this.imgButton);
        this.imgLb.setText(this.options.getMsg("edit_act_image"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.imgLb, gridBagConstraints);
        this.imgButton.setToolTipText(this.options.getMsg("edit_act_image_tooltip"));
        this.imgButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.imgButton, gridBagConstraints);
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        jLabel3.setLabelFor(this.widthEdit);
        jLabel3.setText(":");
        jLabel3.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel3, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_cell_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(10);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.widthEdit, gridBagConstraints);
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        jLabel4.setLabelFor(this.heightEdit);
        jLabel4.setText(":");
        jLabel4.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel4, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_cell_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(10);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.heightEdit, gridBagConstraints);
        jLabel5.setLabelFor(this.boxBaseButton);
        jLabel5.setText(this.options.getMsg("edit_act_style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel5, gridBagConstraints);
        this.boxBaseButton.setToolTipText(this.options.getMsg("edit_style_tooltip"));
        this.boxBaseButton.addPropertyChangeListener("boxBase", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.boxBaseButton, gridBagConstraints);
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderChk, gridBagConstraints);
    }

    public boolean eventPerformed(EventObject eventObject) {
        boolean bl = true;
        if (this.abc != null && eventObject != null && eventObject.getSource() != null) {
            Object object = eventObject.getSource();
            if (object == this.altChk) {
                this.altChkActionPerformed();
            } else if (object == this.toggleAlt) {
                this.toggleAltActionPerformed();
                bl = false;
            } else if (object == this.shaperCombo) {
                this.shaperComboActionPerformed();
            } else if (object == this.shaperEditBtn) {
                bl = this.shaperEditBtnActionPerformed();
            } else if (object == this.boxBaseButton) {
                this.boxBaseButtonActionPerformed();
            } else if (object == this.imgButton) {
                this.imgButtonActionPerformed();
            } else if (object == this.borderChk) {
                this.borderChkActionPerformed();
            }
            if (object == this.widthEdit || object == this.heightEdit) {
                this.parent.abcpp.doResize(this.visualIndex, this.widthEdit.getValue(), this.heightEdit.getValue(), true);
            } else {
                if (object == this.nColsEdit || object == this.nRowsEdit || object == this.shaperCombo || object == this.shaperEditBtn) {
                    this.shaperChange();
                    this.sync();
                }
                this.parent.abcpp.setActiveBagContent(this.visualIndex, this.abc, this.altNull ? null : this.altAbc, null);
                ActiveBoxBag activeBoxBag = (ActiveBoxBag)this.parent.abcpp.getAbstractBox(this.visualIndex);
                if (activeBoxBag != null) {
                    this.boxBaseButton.setPreview(activeBoxBag);
                    activeBoxBag.setAlternative(this.toggleAlt.isSelected());
                }
            }
        }
        return bl;
    }

    protected void resized() {
        if (this.abc != null) {
            this.widthEdit.setValue((int)this.abc.w);
            this.heightEdit.setValue((int)this.abc.h);
        }
    }

    public void fillData(Activity activity) {
        this.abc = activity != null && activity.abc != null && activity.abc.length > this.index ? activity.abc[this.index] : null;
        this.altAbc = activity != null && activity.abc != null && this.altIndex >= 0 && this.altIndex < activity.abc.length ? activity.abc[this.altIndex] : null;
        this.setActiveBagContent(this.abc, this.altAbc);
        this.scrambleChk.setSelected(activity != null && (activity.shuffleAlways() || activity.scramble != null && activity.scramble.length > this.index && activity.scramble[this.index]));
        this.scrambleChk.setEnabled(activity != null && !activity.shuffleAlways());
    }

    public void setActiveBagContent(ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2) {
        this.abc = activeBagContent;
        this.altAbc = activeBagContent2;
        boolean bl = this.altNull = activeBagContent2 == null;
        if (activeBagContent != null && !this.simpleMode) {
            activeBagContent.checkCells();
        }
        if (activeBagContent2 != null && !this.simpleMode) {
            activeBagContent2.checkCells();
        }
        this.altChk.setSelected(!this.altNull);
        this.altChk.setEnabled(activeBagContent != null);
        this.toggleAlt.setSelected(false);
        this.toggleAlt.setEnabled(!this.altNull);
        this.imgButton.setMediaBagEditor(this.parent.mediaBagEditor);
        this.imgButton.setImgName(activeBagContent != null ? activeBagContent.imgName : null);
        this.imgButton.setEnabled(activeBagContent != null);
        this.boxBaseButton.setBoxBase(activeBagContent != null ? activeBagContent.bb : null);
        this.parent.abcpp.setActiveBagContent(this.visualIndex, activeBagContent, activeBagContent2, null);
        this.boxBaseButton.setPreview(this.parent.abcpp.getAbstractBox(this.visualIndex));
        this.boxBaseButton.setEnabled(activeBagContent != null);
        Shaper shaper = activeBagContent != null ? activeBagContent.getShaper() : null;
        ComboBoxModel comboBoxModel = this.shaperCombo.getModel();
        int n = comboBoxModel.getSize();
        int n2 = -1;
        if (shaper != null) {
            TripleString tripleString;
            String string = shaper.getClassName();
            for (n2 = 0; n2 < n && !string.equals((tripleString = (TripleString)comboBoxModel.getElementAt(n2)).getClassName()); ++n2) {
            }
        }
        this.shaperCombo.setSelectedIndex(n2 < n ? n2 : -1);
        this.shaperCombo.setEnabled(activeBagContent != null);
        this.shaperEditBtn.setEnabled(shaper != null && shaper.getEditorPanelClassName() != null);
        this.nColsEdit.setValue(shaper != null ? shaper.getNumColumns() : 1);
        this.nColsEdit.setEnabled(activeBagContent != null);
        this.nRowsEdit.setValue(shaper != null ? shaper.getNumRows() : 1);
        this.nRowsEdit.setEnabled(activeBagContent != null);
        this.widthEdit.setValue(activeBagContent != null ? (int)activeBagContent.w : 30);
        this.widthEdit.setEnabled(activeBagContent != null);
        this.heightEdit.setValue(activeBagContent != null ? (int)activeBagContent.h : 20);
        this.heightEdit.setEnabled(activeBagContent != null);
        this.borderChk.setSelected(activeBagContent != null ? activeBagContent.border : false);
        this.borderChk.setEnabled(activeBagContent != null);
    }

    public void saveData(Activity activity) {
        if (activity != null && activity.abc != null && activity.abc.length > this.index) {
            activity.abc[this.index] = this.abc;
            activity.scramble[this.index] = this.scrambleChk.isSelected();
            if (this.altIndex >= 0 && this.altIndex < activity.abc.length) {
                activity.abc[this.altIndex] = this.altNull ? null : this.altAbc;
            }
        }
    }

    private void altChkActionPerformed() {
        if (this.toggleAlt.isSelected()) {
            this.toggleAlt.setSelected(false);
            this.toggleAltActionPerformed();
        }
        boolean bl = this.altNull = !this.altChk.isSelected();
        if (this.abc != null && !this.altNull && this.altAbc == null) {
            this.altAbc = ActiveBagContent.initNew(this.abc.ncw, this.abc.nch, 65);
            if (this.parent.abcpp != null) {
                this.parent.abcpp.setActiveBagContent(this.visualIndex, this.abc, this.altAbc, null);
            }
        }
        this.toggleAlt.setEnabled(!this.altNull);
    }

    private void toggleAltActionPerformed() {
        if (this.abc != null && !this.altNull && this.altAbc != null && this.parent.abcpp != null && this.parent.abcpp.getAbstractBox(this.visualIndex) != null) {
            boolean bl = this.toggleAlt.isSelected();
            ((ActiveBoxGrid)this.parent.abcpp.getAbstractBox(this.visualIndex)).setAlternative(bl);
            this.imgButton.setImgName(bl ? this.altAbc.imgName : this.abc.imgName);
        }
    }

    private void shaperComboActionPerformed() {
        TripleString tripleString = (TripleString)this.shaperCombo.getSelectedItem();
    }

    private boolean shaperEditBtnActionPerformed() {
        if (this.abc == null) {
            return false;
        }
        AbstractBox abstractBox = this.parent.abcpp.getAbstractBox(this.visualIndex);
        Dimension dimension = new Dimension((int)abstractBox.getWidth(), (int)abstractBox.getHeight());
        Dimension dimension2 = (Dimension)dimension.clone();
        Shaper shaper = this.abc.shaper.edit(this, this.options, dimension, this.abc.img, abstractBox.getBoxBaseResolve());
        if (shaper == null) {
            return false;
        }
        this.abc.setShaper(shaper);
        this.abc.ncw = Math.max(1, shaper.getNumColumns());
        this.abc.nch = Math.max(1, shaper.getNumRows());
        this.nColsEdit.setValue(this.abc.ncw);
        this.nRowsEdit.setValue(this.abc.nch);
        this.abc.checkCells();
        if (!dimension2.equals(dimension)) {
            this.abc.w = dimension.width / this.abc.ncw;
            this.abc.h = dimension.height / this.abc.nch;
        }
        return true;
    }

    private void boxBaseButtonActionPerformed() {
        BoxBase boxBase = this.boxBaseButton.getBoxBase();
        if (this.abc != null && boxBase != null) {
            this.abc.setBoxBase(boxBase);
            if (this.altAbc != null && this.simpleMode) {
                this.altAbc.setBoxBase(boxBase);
            }
        }
    }

    private void imgButtonActionPerformed() {
        if (this.abc != null) {
            ActiveBagContent activeBagContent;
            ActiveBagContent activeBagContent2 = activeBagContent = this.toggleAlt.isSelected() ? this.altAbc : this.abc;
            if (activeBagContent.imgName != null) {
                activeBagContent.img = null;
            }
            activeBagContent.imgName = this.imgButton.getImgName();
            if (this.parent.mediaBagEditor != null) {
                try {
                    if (activeBagContent.imgName != null) {
                        activeBagContent.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(activeBagContent.imgName), true);
                    } else {
                        activeBagContent.setImgContent(null, false);
                    }
                }
                catch (Exception exception) {
                    this.options.getMessages().showErrorWarning(this, "ERROR", exception);
                }
            }
        }
    }

    protected void sync() {
        if (this.abc != null && this.syncPanel != null && this.syncPanel.abc != null) {
            this.syncPanel.nColsEdit.setValue(this.nColsEdit.getValue());
            this.syncPanel.nRowsEdit.setValue(this.nRowsEdit.getValue());
            this.syncPanel.shaperCombo.setSelectedItem(this.shaperCombo.getSelectedItem());
            this.syncPanel.shaperChange();
        }
    }

    private void shaperChange() {
        if (this.abc == null) {
            return;
        }
        try {
            this.abc.ncw = this.nColsEdit.getValue();
            this.abc.nch = this.nRowsEdit.getValue();
            TripleString tripleString = (TripleString)this.shaperCombo.getSelectedItem();
            String string = tripleString.getClassName();
            if (!this.abc.getShaper().getClassName().equals(string)) {
                this.abc.setShaper(Shaper.createShaper(string, this.abc.ncw, this.abc.nch));
                this.abc.checkCells();
            } else {
                this.abc.getShaper().reset(this.abc.ncw, this.abc.nch);
                this.abc.checkCells();
            }
            if (this.abc.imgName != null) {
                this.abc.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(this.abc.imgName), true);
            }
            if (this.altAbc != null) {
                this.altAbc.setShaper(this.abc.getShaper());
                this.altAbc.checkCells();
                if (this.altAbc.imgName != null) {
                    this.altAbc.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(this.altAbc.imgName), true);
                }
            }
            this.shaperEditBtn.setEnabled(this.abc.getShaper().getEditorPanelClassName() != null);
        }
        catch (Exception exception) {
            this.options.getMessages().showErrorWarning(this, "edit_act_shaper_err", exception);
        }
    }

    private void borderChkActionPerformed() {
        if (this.abc != null) {
            this.abc.border = this.borderChk.isSelected();
        }
    }
}

