/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.Resizable;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.ResourceManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class ActiveBagContentPreviewPanel
extends ResizerPanel
implements FocusListener {
    public static final int MARGIN = 10;
    AbstractBox[] bg = new AbstractBox[2];
    ActiveBoxBag[] abg = new ActiveBoxBag[2];
    TextGrid[] grid = new TextGrid[2];
    ActiveBagContent[] abc = new ActiveBagContent[2];
    ActiveBagContent[] altAbc = new ActiveBagContent[2];
    ActiveBagContent[][] allAbc = new ActiveBagContent[][]{this.abc, this.altAbc};
    TextGridContent[] tgc = new TextGridContent[2];
    MediaBagEditor mbe;
    boolean[] allowResize = new boolean[2];
    boolean dragCursorX = false;
    boolean dragCursorY = false;
    boolean dragging = false;
    int margin = 10;
    private int cgrid = 0;
    int boxGridPos = 0;
    ActiveBagContentEditor parent;
    int editMode;
    int currentLine;
    int highlightLine;
    BoxConnector bc;
    boolean showAllArrows = true;
    boolean crossWord = false;
    ActiveBox hClue;
    ActiveBox vClue;
    Color softLineColor = Color.blue;
    Color activeLineColor = Color.red;
    Color arrowColor = BoxConnector.DEFAULT_XOR_COLOR;
    public static final int EDIT_GRIDS = 0;
    public static final int EDIT_LINKS = 1;
    public static final int EDIT_BOOL = 2;
    public static final float ARROW_WIDTH = 2.0f;

    public ActiveBagContentPreviewPanel(ActiveBagContentEditor activeBagContentEditor, boolean bl) {
        this.parent = activeBagContentEditor;
        this.crossWord = bl;
        this.bc = new BoxConnector(this);
        this.bc.arrow = true;
        this.bc.line_width = 2.0f;
        this.bc.lineColor = this.activeLineColor;
        this.currentLine = -1;
        this.highlightLine = -1;
        this.editMode = 0;
        this.enableEvents(56L);
        this.addFocusListener(this);
    }

    public AbstractBox getAbstractBox(int n) {
        return this.bg[n];
    }

    public boolean isCrossWord() {
        return this.crossWord;
    }

    public void setActiveBagContent(int n, ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2, TextGridContent textGridContent) {
        this.abc[n] = activeBagContent;
        this.altAbc[n] = activeBagContent2;
        this.tgc[n] = textGridContent;
        this.bg[n] = null;
        this.grid[n] = null;
        this.abg[n] = null;
        if (this.tgc[n] != null) {
            this.grid[n] = TextGrid.createEmptyGrid(null, this, this.margin, this.margin, this.tgc[n], false);
            this.bg[n] = this.grid[n];
            this.grid[n].setChars(this.tgc[n].text);
            if (this.crossWord) {
                this.grid[n].setCellAttributes(true, false);
            }
            this.grid[n].setCursorAt(0, 0, false);
            this.grid[n].setCursorEnabled(true);
            this.checkCursor(false);
            this.allowResize[n] = true;
        } else if (this.crossWord && n == 1 && this.abc[n] != null && this.altAbc[n] != null) {
            this.abg[1] = new ActiveBoxBag(null, this, this.abc[1].bb);
            this.bg[1] = this.abg[1];
            ActiveBox activeBox = new ActiveBox(this.abg[1], this, null);
            ActiveBoxContent activeBoxContent = new ActiveBoxContent();
            activeBoxContent.setImgContent(ResourceManager.getImageIcon("buttons/textright.png").getImage(), null);
            activeBox.setContent(activeBoxContent);
            this.abg[1].addActiveBox(activeBox);
            this.hClue = new ActiveBox(this.abg[1], this, null);
            this.abg[1].addActiveBox(this.hClue);
            activeBox = new ActiveBox(this.abg[1], this, null);
            activeBoxContent = new ActiveBoxContent();
            activeBoxContent.setImgContent(ResourceManager.getImageIcon("buttons/textdown.png").getImage(), null);
            activeBox.setContent(activeBoxContent);
            this.abg[1].addActiveBox(activeBox);
            this.vClue = new ActiveBox(this.abg[1], this, null);
            this.abg[1].addActiveBox(this.vClue);
            this.abg[1].setBorder(true);
            this.resizeCrossWordPanel((int)this.abc[1].w, (int)this.abc[1].h);
            this.cursorPosChanged();
            this.allowResize[1] = true;
        } else if (this.abc[n] != null) {
            this.abg[n] = ActiveBoxGrid.createEmptyGrid(null, this, this.margin, this.margin, this.abc[n]);
            this.bg[n] = this.abg[n];
            this.abg[n].setContent(this.abc[n], this.altAbc[n]);
            boolean bl = this.allowResize[n] = this.abc[n].img == null;
        }
        if (this.bg[n] != null) {
            this.bg[n].setVisible(true);
        }
        if (this.bc.active) {
            this.bc.end();
        }
        this.currentLine = -1;
        this.highlightLine = -1;
        this.dragCursorX = false;
        this.dragCursorY = false;
        this.setCursor(null);
        this.revalidate();
        BoxBase.resetAllFonts();
        this.repaint();
    }

    protected void resizeCrossWordPanel(int n, int n2) {
        if (this.crossWord && this.abg[1] != null && this.abg[1].getNumCells() == 4) {
            boolean bl = this.boxGridPos == 2 || this.boxGridPos == 3;
            int n3 = (int)this.abg[1].getX();
            int n4 = (int)this.abg[1].getY();
            ActiveBox activeBox = this.abg[1].getActiveBox(0);
            activeBox.setBounds(n3, n4, 40.0, n2);
            activeBox = this.abg[1].getActiveBox(1);
            activeBox.setBounds(n3 + 40, n4, n, n2);
            int n5 = bl ? n3 + 40 + n : n3;
            int n6 = bl ? n4 : n4 + n2;
            activeBox = this.abg[1].getActiveBox(2);
            activeBox.setBounds(n5, n6, 40.0, n2);
            activeBox = this.abg[1].getActiveBox(3);
            activeBox.setBounds(n5 + 40, n6, n, n2);
            this.abg[1].recalcSize();
        }
    }

    public void doLayout() {
        if (this.bg[0] != null) {
            if (this.bg[1] != null) {
                BoxBag.layoutDouble(this.getSize(), (Resizable)((Object)this.bg[0]), (Resizable)((Object)this.bg[1]), this.boxGridPos, this.margin);
            } else {
                BoxBag.layoutSingle(this.getSize(), (Resizable)((Object)this.bg[0]), this.margin);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.bg[0] != null) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            do {
                BoxBase.flagFontReduced = false;
                for (n = 0; n < 2; ++n) {
                    if (this.bg[n] == null) continue;
                    this.bg[n].update(graphics2D, graphics2D.getClipBounds(), this);
                }
            } while (BoxBase.flagFontReduced);
            if (this.editMode == 1 && this.abg[1] != null && this.abc[0] != null) {
                for (n = 0; n < this.abc[0].getNumCells(); ++n) {
                    if (!this.showAllArrows || n == this.currentLine || n == this.highlightLine) continue;
                    this.drawArrow(graphics2D, n);
                }
                if (this.highlightLine >= 0) {
                    this.drawArrow(graphics2D, this.highlightLine);
                }
                this.bc.update(graphics2D, graphics2D.getClipBounds(), this);
            }
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    private void drawArrow(Graphics2D graphics2D, int n) {
        if (this.abg[0] == null || this.abg[1] == null) {
            return;
        }
        ActiveBox activeBox = this.abg[0].getActiveBox(n);
        int n2 = this.abc[0].getActiveBoxContent((int)n).id;
        if (n2 >= 0 && n2 < this.abc[1].getNumCells()) {
            ActiveBox activeBox2 = this.abg[1].getActiveBox(n2);
            if (activeBox != null && activeBox2 != null) {
                BoxConnector.drawLine(graphics2D, new Point2D.Double(activeBox.getX() + activeBox.getWidth() / 2.0, activeBox.getY() + activeBox.getHeight() / 2.0), new Point2D.Double(activeBox2.getX() + activeBox2.getWidth() / 2.0, activeBox2.getY() + activeBox2.getHeight() / 2.0), true, n == this.highlightLine ? this.activeLineColor : this.softLineColor, this.arrowColor, 10.0, 0.5235987755982988, n == this.highlightLine ? 2.0f : 1.5f);
            }
        }
    }

    public void setMediaBagEditor(MediaBagEditor mediaBagEditor) {
        this.mbe = mediaBagEditor;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        boolean bl = false;
        if (this.bg[0] != null) {
            if (aWTEvent instanceof MouseEvent) {
                switch (this.editMode) {
                    case 0: {
                        bl = this.processMouseGrids((MouseEvent)aWTEvent);
                        break;
                    }
                    case 1: {
                        bl = this.processMouseLinks((MouseEvent)aWTEvent);
                        break;
                    }
                    case 2: {
                        bl = this.processMouseBool((MouseEvent)aWTEvent);
                    }
                }
            } else if (aWTEvent instanceof KeyEvent && (this.grid[0] != null || this.grid[1] != null)) {
                bl = this.processKey((KeyEvent)aWTEvent);
            }
        }
        if (!bl) {
            super.processEvent(aWTEvent);
        }
    }

    private boolean processMouseGrids(MouseEvent mouseEvent) {
        ActiveBoxBag activeBoxBag;
        AbstractBox abstractBox;
        boolean bl = false;
        Point point = mouseEvent.getPoint();
        int n = mouseEvent.getID();
        int n2 = this.cgrid;
        if (!(this.dragging || n != 503 && n != 501)) {
            n2 = this.bg[0] != null && this.bg[0].contains(point) ? 0 : (this.bg[1] != null && this.bg[1].contains(point) ? 1 : -1);
        }
        AbstractBox abstractBox2 = abstractBox = n2 >= 0 ? this.bg[n2] : null;
        ActiveBoxBag activeBoxBag2 = this.abg[0] == abstractBox ? this.abg[0] : (activeBoxBag = this.abg[1] == abstractBox ? this.abg[1] : null);
        TextGrid textGrid = this.grid[0] == abstractBox ? this.grid[0] : (this.grid[1] == abstractBox ? this.grid[1] : null);
        switch (mouseEvent.getID()) {
            case 503: {
                if (this.dragging) break;
                Cursor cursor = null;
                if (abstractBox != null && this.allowResize[n2]) {
                    this.dragCursorX = Math.abs((double)point.x - abstractBox.x - abstractBox.width) < 5.0 && (double)point.y >= abstractBox.y && (double)point.y < abstractBox.y + abstractBox.height + 5.0;
                    boolean bl2 = this.dragCursorY = Math.abs((double)point.y - abstractBox.y - abstractBox.height) < 5.0 && (double)point.x >= abstractBox.x && (double)point.x < abstractBox.x + abstractBox.width + 5.0;
                    if (this.dragCursorX && this.dragCursorY) {
                        cursor = Cursor.getPredefinedCursor(6);
                    } else if (this.dragCursorY) {
                        cursor = Cursor.getPredefinedCursor(8);
                    } else if (this.dragCursorX) {
                        cursor = Cursor.getPredefinedCursor(11);
                    }
                }
                if (cursor == null && activeBoxBag != null && activeBoxBag.findActiveBox(point) != null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                this.setCursor(cursor);
                break;
            }
            case 501: {
                Point point2;
                if (abstractBox == null) break;
                this.setPanelSelected(n2);
                if (this.dragCursorX || this.dragCursorY) {
                    this.dragging = true;
                    this.resizeByDrag(point, false);
                } else if (textGrid != null && textGrid.contains(point) && (point2 = textGrid.getLogicalCoords(point)) != null) {
                    this.setCursorAt(point2.x, point2.y);
                }
                bl = true;
                break;
            }
            case 502: {
                ActiveBox activeBox;
                if (abstractBox == null) break;
                if (this.dragging) {
                    this.resizeByDrag(point, true);
                    this.dragging = false;
                } else if (activeBoxBag != null && (activeBox = activeBoxBag.findActiveBox(point)) != null) {
                    ActiveBoxContent activeBoxContent;
                    ActiveBoxContent activeBoxContent2 = activeBox.getCurrentContent();
                    int n3 = -1;
                    int n4 = -1;
                    int n5 = -1;
                    for (int i = 0; i < this.allAbc.length && n5 < 0; ++i) {
                        for (int j = 0; j < this.allAbc[i].length && n5 < 0; ++j) {
                            if (this.allAbc[i][j] == null || (n5 = this.allAbc[i][j].indexOf(activeBoxContent2)) < 0) continue;
                            n4 = j;
                            n3 = i;
                        }
                    }
                    if (n5 >= 0 && (activeBoxContent = ActiveBoxContentEditor.getActiveBoxContent(activeBoxContent2, this, this.parent.getOptions(), this.mbe, activeBox)) != null) {
                        this.allAbc[n3][n4].setActiveBoxContentAt(activeBoxContent, n5);
                        this.setModified(true);
                        if (!activeBox.isAlternative()) {
                            activeBox.setContent(activeBoxContent);
                        } else {
                            activeBox.setAltContent(activeBoxContent);
                        }
                        BoxBase.resetAllFonts();
                        this.repaint();
                    }
                }
                bl = true;
                break;
            }
            case 506: {
                if (abstractBox == null || !this.dragging) break;
                this.resizeByDrag(point, false);
                bl = true;
            }
        }
        return bl;
    }

    protected boolean processMouseLinks(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.abg[0] != null && this.abg[1] != null) {
            Point point = mouseEvent.getPoint();
            switch (mouseEvent.getID()) {
                case 503: 
                case 506: {
                    if (this.bc.active) {
                        this.bc.moveTo(point);
                    } else {
                        int n = -1;
                        ActiveBox activeBox = this.abg[0].findActiveBox(point);
                        if (activeBox != null) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                            n = activeBox.idOrder;
                        } else {
                            this.setCursor(null);
                        }
                        if (n != this.highlightLine) {
                            this.highlightLine = n;
                            this.repaint();
                        }
                    }
                    bl = true;
                    break;
                }
                case 501: {
                    if (this.bc.active) {
                        this.bc.end();
                        ActiveBox activeBox = this.abg[1].findActiveBox(this.bc.dest);
                        ActiveBoxContent activeBoxContent = this.abc[0].getActiveBoxContent(this.currentLine);
                        activeBoxContent.id = activeBox == null ? -1 : activeBox.idOrder;
                        this.highlightLine = this.currentLine;
                        this.currentLine = -1;
                        this.setModified(true);
                        this.repaint();
                    } else {
                        ActiveBox activeBox = this.abg[0].findActiveBox(point);
                        if (activeBox != null) {
                            this.highlightLine = -1;
                            this.currentLine = activeBox.idOrder;
                            this.repaint();
                            this.bc.begin(point);
                        }
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void resizeByDrag(Point point, boolean bl) {
        if (this.cgrid >= 0 && this.bg[this.cgrid] != null) {
            int n = 0;
            int n2 = 0;
            if (this.abg[this.cgrid] == this.bg[this.cgrid] && this.abc[this.cgrid] != null) {
                if (this.crossWord) {
                    n = 1;
                    n2 = 1;
                } else {
                    n = this.abc[this.cgrid].ncw;
                    n2 = this.abc[this.cgrid].nch;
                }
            } else if (this.grid[this.cgrid] == this.bg[this.cgrid] && this.tgc[this.cgrid] != null) {
                n = this.tgc[this.cgrid].ncw;
                n2 = this.tgc[this.cgrid].nch;
            }
            if (n > 0 && n2 > 0) {
                int n3 = (int)(this.bg[this.cgrid].width / (double)n);
                int n4 = (int)(this.bg[this.cgrid].height / (double)n2);
                if (this.dragCursorX) {
                    n3 = (int)(((double)point.x - this.bg[this.cgrid].x) / (double)n);
                }
                if (this.dragCursorY) {
                    n4 = (int)(((double)point.y - this.bg[this.cgrid].y) / (double)n2);
                }
                if (this.crossWord && this.cgrid == 1) {
                    if (this.boxGridPos == 2 || this.boxGridPos == 3) {
                        n3 = (n3 - 80) / 2;
                    } else {
                        n3 -= 40;
                        n4 /= 2;
                    }
                }
                if (n3 > 10 && n4 > 10) {
                    this.doResize(this.cgrid, n3, n4, bl);
                    if (bl && this.crossWord) {
                        this.cursorPosChanged();
                    }
                }
            }
        }
    }

    protected void doResize(int n, int n2, int n3, boolean bl) {
        AbstractBox abstractBox;
        AbstractBox abstractBox2 = abstractBox = n >= 0 ? this.bg[n] : null;
        if (abstractBox != null) {
            int n4;
            this.setModified(true);
            if (this.tgc[n] != null) {
                this.tgc[n].w = n2;
                this.tgc[n].h = n3;
            } else if (this.abc[n] != null) {
                this.abc[n].w = n2;
                this.abc[n].h = n3;
            }
            if (this.crossWord && n == 1) {
                this.altAbc[n].w = n2;
                this.altAbc[n].h = n3;
                this.resizeCrossWordPanel(n2, n3);
            } else {
                n4 = this.tgc[n] != null ? this.tgc[n].ncw : this.abc[n].ncw;
                int n5 = this.tgc[n] != null ? this.tgc[n].nch : this.abc[n].nch;
                Rectangle rectangle = new Rectangle((int)this.bg[n].getX(), (int)this.bg[n].getY(), n2 * n4, n3 * n5);
                abstractBox.setBounds(rectangle);
            }
            if (bl) {
                n4 = 0;
                ActiveBoxBag activeBoxBag = abstractBox == this.abg[0] ? this.abg[0] : (abstractBox == this.abg[1] ? this.abg[1] : null);
                n4 = activeBoxBag != null && activeBoxBag.isAlternative() ? 1 : 0;
                this.setActiveBagContent(n, this.abc[n], this.altAbc[n], this.tgc[n]);
                if (n4 != 0 && this.abg[n] != null) {
                    this.abg[n].setAlternative(true);
                }
            }
            this.parent.resized(n);
        }
        this.repaint();
    }

    protected boolean processMouseBool(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.abg[0] != null) {
            ActiveBox activeBox = this.abg[0].findActiveBox(mouseEvent.getPoint());
            switch (mouseEvent.getID()) {
                case 503: {
                    this.setCursor(activeBox != null ? Cursor.getPredefinedCursor(12) : null);
                    bl = true;
                    break;
                }
                case 502: {
                    if (activeBox == null) break;
                    int n = activeBox.getContent().id;
                    activeBox.getContent().id = n = n > 0 ? 0 : 1;
                    activeBox.setInverted(n > 0);
                    activeBox.setMarked(n > 0);
                    this.setModified(true);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void setModified(boolean bl) {
        this.parent.setModified(bl);
    }

    public int getBoxGridPos() {
        return this.boxGridPos;
    }

    public void setBoxGridPos(int n) {
        this.boxGridPos = n;
        if (this.crossWord && this.abc[1] != null) {
            this.resizeCrossWordPanel((int)this.abc[1].w, (int)this.abc[1].h);
        }
        BoxBase.resetAllFonts();
        this.revalidate();
    }

    public int getEditMode() {
        return this.editMode;
    }

    public void setEditMode(int n) {
        boolean bl = n == 2 || this.editMode == 2;
        this.editMode = n;
        if (bl && this.abg[0] != null) {
            for (int i = 0; i < this.abg[0].getNumCells(); ++i) {
                ActiveBox activeBox = this.abg[0].getActiveBox(i);
                if (activeBox != null) {
                    activeBox.setInverted(n == 2 ? activeBox.getContent().id > 0 : false);
                }
                activeBox.setMarked(n == 2 ? activeBox.getContent().id > 0 : false);
            }
        }
        this.repaint();
    }

    public boolean isShowAllArrows() {
        return this.showAllArrows;
    }

    public void setShowAllArrows(boolean bl) {
        this.showAllArrows = bl;
        this.repaint();
    }

    protected void moveCursor(int n, int n2) {
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null) {
            this.grid[this.cgrid].moveCursor(n, n2, false);
            this.cursorPosChanged();
        }
    }

    protected void setCursorAt(int n, int n2) {
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null) {
            this.grid[this.cgrid].setCursorAt(n, n2, false);
        }
        this.cursorPosChanged();
    }

    protected void cursorPosChanged() {
        Point point;
        Point point2;
        if (this.crossWord && this.grid[0] != null && this.hClue != null && this.vClue != null && (point2 = this.grid[0].getCursor()) != null && (point = this.grid[0].getItemFor(point2.x, point2.y)) != null) {
            ActiveBoxContent activeBoxContent = this.abc[1].getActiveBoxContentWith(point2.y, point.x);
            if (activeBoxContent == null) {
                this.abc[1].insertActiveBoxContentWith(point2.y, point.x);
                activeBoxContent = this.abc[1].getActiveBoxContentWith(point2.y, point.x);
            }
            this.hClue.setContent(activeBoxContent);
            activeBoxContent = this.altAbc[1].getActiveBoxContentWith(point2.x, point.y);
            if (activeBoxContent == null) {
                this.altAbc[1].insertActiveBoxContentWith(point2.x, point.y);
                activeBoxContent = this.altAbc[1].getActiveBoxContentWith(point2.x, point.y);
            }
            this.vClue.setContent(activeBoxContent);
        }
    }

    public boolean processKey(KeyEvent keyEvent) {
        boolean bl = false;
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null && this.tgc[this.cgrid] != null) {
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            Point point = this.grid[this.cgrid].getCursor();
            char c = '\u0000';
            switch (keyEvent.getID()) {
                case 401: {
                    switch (keyEvent.getKeyCode()) {
                        case 39: {
                            n = 1;
                            break;
                        }
                        case 37: {
                            n = -1;
                            break;
                        }
                        case 40: {
                            n2 = 1;
                            break;
                        }
                        case 38: {
                            n2 = -1;
                            break;
                        }
                        case 8: {
                            n = -1;
                            bl2 = true;
                            bl3 = true;
                            break;
                        }
                        case 127: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                case 400: {
                    char c2 = keyEvent.getKeyChar();
                    int n3 = keyEvent.getKeyCode();
                    if (point == null) break;
                    n = 1;
                    if (Character.isLetterOrDigit(c2)) {
                        c = Character.toUpperCase(c2);
                        break;
                    }
                    if (c2 == this.tgc[this.cgrid].wild || Character.isSpaceChar(c2)) {
                        bl2 = true;
                        break;
                    }
                    n = 0;
                }
            }
            if (bl3 && (n != 0 || n2 != 0)) {
                this.moveCursor(n, n2);
                point = this.grid[this.cgrid].getCursor();
                bl = true;
            }
            if (bl2) {
                c = this.tgc[this.cgrid].wild;
            }
            if (c != '\u0000') {
                if (this.crossWord) {
                    this.checkWildChanges(point, c);
                }
                this.grid[this.cgrid].setCharAt(point.x, point.y, c);
                this.tgc[this.cgrid].setCharAt(point.x, point.y, c);
                this.setModified(true);
                bl = true;
            }
            if (!(bl3 || n == 0 && n2 == 0)) {
                this.moveCursor(n, n2);
                bl = true;
            }
        }
        return bl;
    }

    protected void checkWildChanges(Point point, char c) {
        Point point2;
        boolean bl;
        if (!this.crossWord) {
            return;
        }
        char c2 = this.grid[this.cgrid].getCharAt(point.x, point.y);
        boolean bl2 = c2 == this.tgc[this.cgrid].wild && c != c2;
        boolean bl3 = bl = !bl2 && c == this.tgc[this.cgrid].wild && c != c2;
        if ((bl || bl2) && (point2 = this.grid[this.cgrid].getItemFor(point.x, point.y)) != null) {
            boolean bl4 = this.grid[this.cgrid].isIntoWhites(point, true);
            boolean bl5 = this.grid[this.cgrid].isIntoWhites(point, false);
            boolean bl6 = this.grid[this.cgrid].isIntoBlacks(point, true);
            boolean bl7 = this.grid[this.cgrid].isIntoBlacks(point, false);
            if (bl2) {
                if (bl4) {
                    this.abc[1].deleteActiveBoxContentWith(point.y, point2.x);
                } else if (bl6) {
                    this.abc[1].insertActiveBoxContentWith(point.y, point2.x);
                }
                if (bl5) {
                    this.altAbc[1].deleteActiveBoxContentWith(point.x, point2.y);
                } else if (bl7) {
                    this.altAbc[1].insertActiveBoxContentWith(point.x, point2.y);
                }
            } else {
                if (bl4) {
                    this.abc[1].insertActiveBoxContentWith(point.y, point2.x);
                } else if (bl6) {
                    this.abc[1].deleteActiveBoxContentWith(point.y, point2.x);
                }
                if (bl5) {
                    this.altAbc[1].insertActiveBoxContentWith(point.x, point2.y);
                } else if (bl7) {
                    this.altAbc[1].deleteActiveBoxContentWith(point.x, point2.y);
                }
            }
            this.grid[this.cgrid].setCellLocked(point.x, point.y, bl);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.checkCursor(false);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.checkCursor(true);
    }

    public void checkCursor(boolean bl) {
        for (int i = 0; i < 2; ++i) {
            if (this.grid[i] == null) continue;
            if (this.cgrid == i && !bl && this.hasFocus()) {
                this.grid[i].startCursorBlink();
                continue;
            }
            this.grid[i].stopCursorBlink();
        }
    }

    private void setPanelSelected(int n) {
        this.cgrid = n;
        this.parent.panelSelected(this.cgrid);
        if (!this.hasFocus()) {
            this.requestFocus();
        } else {
            this.checkCursor(false);
        }
    }
}

