/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientEditor
extends JPanel {
    Options options;
    Gradient gradient;
    private static HashMap panels = new HashMap();
    private ColorButton startColorBtn;
    private JTextField cyclesTxt;
    private ColorButton endColorBtn;
    private JSlider cyclesSlider;
    private JPanel previewPanel;
    private JSlider orientationSlider;
    private JTextField orientationTxt;

    public GradientEditor(Options options, Gradient gradient) {
        this.options = options;
        this.initComponents();
        this.setGradient(gradient);
    }

    private void initComponents() {
        this.previewPanel = new GradientPreview();
        JLabel jLabel = new JLabel();
        this.startColorBtn = new ColorButton();
        this.startColorBtn.setOptions(this.options);
        JLabel jLabel2 = new JLabel();
        this.endColorBtn = new ColorButton();
        this.endColorBtn.setOptions(this.options);
        JLabel jLabel3 = new JLabel();
        this.cyclesTxt = new JTextField();
        this.cyclesSlider = new JSlider();
        JLabel jLabel4 = new JLabel();
        this.orientationTxt = new JTextField();
        this.orientationSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.previewPanel.setBorder(new SoftBevelBorder(0));
        this.previewPanel.setPreferredSize(new Dimension(100, 100));
        this.previewPanel.setMinimumSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.previewPanel, gridBagConstraints);
        jLabel.setText(this.options.getMsg("edit_gradient_startColor"));
        jLabel.setLabelFor(this.startColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints);
        this.startColorBtn.setToolTipText(this.options.getMsg("edit_gradient_startColor_tooltip"));
        this.startColorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientEditor.this.startColorBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.startColorBtn, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_gradient_endColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel2, gridBagConstraints);
        this.endColorBtn.setToolTipText(this.options.getMsg("edit_gradient_endColor_tooltip"));
        this.endColorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientEditor.this.endColorBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.endColorBtn, gridBagConstraints);
        jLabel3.setText(this.options.getMsg("edit_gradient_cycles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel3, gridBagConstraints);
        this.cyclesTxt.setToolTipText(this.options.getMsg("edit_gradient_cycles_tooltip"));
        this.cyclesTxt.setPreferredSize(new Dimension(40, 21));
        this.cyclesTxt.setMinimumSize(new Dimension(40, 21));
        this.cyclesTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientEditor.this.cyclesTxtActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cyclesTxt, gridBagConstraints);
        this.cyclesSlider.setMinorTickSpacing(10);
        this.cyclesSlider.setPaintTicks(true);
        this.cyclesSlider.setMinimum(1);
        this.cyclesSlider.setMajorTickSpacing(10);
        this.cyclesSlider.setToolTipText(this.options.getMsg("edit_gradient_cycles_tooltip"));
        this.cyclesSlider.setMaximum(50);
        this.cyclesSlider.setPreferredSize(new Dimension(100, 27));
        this.cyclesSlider.setMinimumSize(new Dimension(100, 27));
        this.cyclesSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GradientEditor.this.cyclesSliderStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cyclesSlider, gridBagConstraints);
        jLabel4.setText(this.options.getMsg("edit_gradient_orientation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel4, gridBagConstraints);
        this.orientationTxt.setToolTipText(this.options.getMsg("edit_gradient_orientation_tooltip"));
        this.orientationTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientEditor.this.orientationTxtActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.orientationTxt, gridBagConstraints);
        this.orientationSlider.setMinorTickSpacing(30);
        this.orientationSlider.setPaintTicks(true);
        this.orientationSlider.setMajorTickSpacing(90);
        this.orientationSlider.setToolTipText(this.options.getMsg("edit_gradient_orientation_tooltip"));
        this.orientationSlider.setMaximum(360);
        this.orientationSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GradientEditor.this.orientationSliderStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.orientationSlider, gridBagConstraints);
    }

    private void endColorBtnActionPerformed(ActionEvent actionEvent) {
        this.gradient.setColors(this.startColorBtn.getColor(), this.endColorBtn.getColor());
        this.previewPanel.repaint();
    }

    private void startColorBtnActionPerformed(ActionEvent actionEvent) {
        this.gradient.setColors(this.startColorBtn.getColor(), this.endColorBtn.getColor());
        this.previewPanel.repaint();
    }

    private void orientationSliderStateChanged(ChangeEvent changeEvent) {
        int n = this.orientationSlider.getValue();
        this.orientationTxt.setText(Integer.toString(n));
        this.orientationSlider.setValue(n);
        this.gradient.setAngle(n);
        this.previewPanel.repaint();
    }

    private void cyclesSliderStateChanged(ChangeEvent changeEvent) {
        int n = this.cyclesSlider.getValue();
        this.cyclesTxt.setText(Integer.toString(n));
        this.cyclesSlider.setValue(n);
        this.gradient.setCycles(n);
        this.previewPanel.repaint();
    }

    private void orientationTxtActionPerformed(ActionEvent actionEvent) {
        int n = this.gradient.angle;
        try {
            n = Math.max(0, Integer.parseInt(this.orientationTxt.getText())) % 360;
        }
        catch (Exception exception) {
            this.options.getMessages().showErrorWarning(this, "ERROR", exception);
        }
        this.orientationTxt.setText(Integer.toString(n));
        this.orientationSlider.setValue(n);
        this.gradient.setAngle(n);
        this.previewPanel.repaint();
    }

    private void cyclesTxtActionPerformed(ActionEvent actionEvent) {
        int n = this.gradient.cycles;
        try {
            n = Math.max(1, Integer.parseInt(this.cyclesTxt.getText()));
        }
        catch (Exception exception) {
            this.options.getMessages().showErrorWarning(this, "ERROR", exception);
        }
        this.cyclesTxt.setText(Integer.toString(n));
        this.cyclesSlider.setValue(n);
        this.gradient.setCycles(n);
        this.previewPanel.repaint();
    }

    public void setGradient(Gradient gradient) {
        if (gradient == null) {
            gradient = new Gradient();
        }
        this.gradient = new Gradient(gradient.getColors()[0], gradient.getColors()[1], gradient.getAngle(), gradient.getCycles());
        this.startColorBtn.setColor(this.gradient.c1);
        this.endColorBtn.setColor(this.gradient.c2);
        this.cyclesSlider.setValue(this.gradient.cycles);
        this.cyclesTxt.setText(Integer.toString(this.gradient.cycles));
        this.orientationSlider.setValue(this.gradient.angle);
        this.orientationTxt.setText(Integer.toString(this.gradient.angle));
    }

    public static Gradient getGradient(Gradient gradient, Component component, Options options) {
        Messages messages = options.getMessages();
        GradientEditor gradientEditor = (GradientEditor)panels.get(options);
        if (gradientEditor == null) {
            gradientEditor = new GradientEditor(options, gradient);
            panels.put(options, gradientEditor);
        } else {
            gradientEditor.setGradient(gradient);
        }
        boolean bl = messages.showInputDlg(component, gradientEditor, "edit_gradient_title");
        return bl ? gradientEditor.gradient : null;
    }

    class GradientPreview
    extends JPanel {
        GradientPreview() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            GradientEditor.this.gradient.paint(graphics2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            graphics2D.setRenderingHints(renderingHints);
        }
    }
}

