/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableCubicCurve2D;
import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableQuadCurve2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class EditableEllipse2D
extends EditableRectangle
implements Cloneable {
    public EditableEllipse2D(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
    }

    public EditableEllipse2D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void paintWithColor(Graphics graphics, int n, Color color) {
        graphics.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(graphics);
        if (this.selected) {
            this.paintSelection(graphics);
        } else if (n == 4) {
            graphics.setColor(Color.red);
            this.drawBorders(graphics);
            graphics.setColor(color);
        } else {
            graphics.setColor(color);
        }
        graphics.drawOval((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public boolean contains(double d, double d2) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).contains(d, d2, d3, d4);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).getPathIterator(affineTransform);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).intersects(d, d2, d3, d4);
    }

    public EditableShape[] divide(double d, double d2, boolean bl) {
        return this.divide(d, d2);
    }

    public EditableShape[] divide(double d, double d2) {
        EditableShape[] editableShapeArray = new EditableShape[10];
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        PathIterator pathIterator = this.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 1: {
                    editableShapeArray[n] = new EditableLine2D(d3, d4, dArray[0], dArray[1]);
                    ++n;
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 3: {
                    editableShapeArray[n] = new EditableCubicCurve2D(d3, d4, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    ++n;
                    d3 = dArray[4];
                    d4 = dArray[5];
                    break;
                }
                case 2: {
                    editableShapeArray[n] = new EditableQuadCurve2D(d3, d4, dArray[0], dArray[1], dArray[2], dArray[3]);
                    ++n;
                    d3 = dArray[2];
                    d4 = dArray[3];
                }
            }
            pathIterator.next();
        }
        return editableShapeArray;
    }

    public Ellipse2D getEllipse() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Object clone() {
        return new EditableEllipse2D(this.getLocation(), new Point2D.Double(this.getLocation().getX() + this.getWidth(), this.getLocation().getY() + this.getHeight()));
    }
}

