/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EditableLine2D
extends Line2D.Double
implements EditableShape {
    private boolean selected = false;
    private int border = 0;
    private int selectedBorder = -1;

    public EditableLine2D(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public EditableLine2D(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void drawBorders(Graphics graphics) {
        graphics.drawRect((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.drawRect((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            graphics.fillRect((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            graphics.fillRect((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    public boolean hasClickedBorder(double d, double d2, boolean bl) {
        boolean bl2 = false;
        if (!bl || this.selected) {
            Rectangle rectangle = new Rectangle((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle2 = new Rectangle((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (rectangle.contains(d, d2)) {
                this.border = 1;
                bl2 = true;
            } else if (rectangle2.contains(d, d2)) {
                this.border = 2;
                bl2 = true;
            }
        }
        return bl2;
    }

    public void aproximateNearestBorder(double d, double d2) {
        if (this.getP1().distance(d, d2) < this.getP2().distance(d, d2)) {
            this.x1 = d;
            this.y1 = d2;
        } else {
            this.x2 = d;
            this.y2 = d2;
        }
    }

    public Point2D getNearestBorder(double d, double d2) {
        return this.getP1().distance(d, d2) < this.getP2().distance(d, d2) ? this.getP1() : this.getP2();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void paintWithColor(Graphics graphics, int n, Color color) {
        graphics.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(graphics);
        if (this.selected && n != 2) {
            this.paintSelection(graphics);
        } else if (n == 4) {
            graphics.setColor(Color.red);
            this.drawBorders(graphics);
            graphics.setColor(color);
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine((int)this.getX1(), (int)this.getY1(), (int)this.getX2(), (int)this.getY2());
    }

    public void paint(Graphics graphics, int n) {
        this.paintWithColor(graphics, n, EditableShapeConstants.defaultColor);
    }

    public void paintSelection(Graphics graphics) {
        graphics.setColor(Color.black);
        this.drawBorders(graphics);
        graphics.setColor(EditableShapeConstants.selectedColor);
    }

    public void changeBorder(double d, double d2) {
        if (this.border == 1) {
            this.x1 = d;
            this.y1 = d2;
        } else {
            this.x2 = d;
            this.y2 = d2;
        }
    }

    public double distanceTo(double d, double d2) {
        return this.ptSegDist(d, d2);
    }

    public boolean isInto(Rectangle2D rectangle2D) {
        return rectangle2D.intersectsLine(this);
    }

    public void move(double d, double d2) {
        this.x1 += d;
        this.x2 += d;
        this.y1 += d2;
        this.y2 += d2;
    }

    public void transform(AffineTransform affineTransform) {
        Point2D point2D = this.getP1();
        Point2D point2D2 = this.getP2();
        affineTransform.transform(point2D, point2D);
        affineTransform.transform(point2D2, point2D2);
        this.setLine(point2D, point2D2);
    }

    public EditableShape[] divide(double d, double d2) {
        EditableShape[] editableShapeArray = new EditableShape[2];
        Point2D.Double double_ = new Point2D.Double(d, d2);
        editableShapeArray[0] = new EditableLine2D(double_, this.getP2());
        editableShapeArray[1] = new EditableLine2D(this.getP1(), double_);
        return editableShapeArray;
    }

    public boolean isAdjacentTo(Point2D point2D) {
        if (this.getP1().equals(point2D)) {
            return true;
        }
        if (this.getP2().equals(point2D)) {
            this.setLine(this.getP2(), this.getP1());
            return true;
        }
        return false;
    }

    public Point2D getEndPoint() {
        return this.getP2();
    }

    public Point2D getInitialPoint() {
        return this.getP1();
    }

    public Object clone() {
        EditableLine2D editableLine2D = new EditableLine2D(this.getInitialPoint(), this.getEndPoint());
        editableLine2D.setSelected(this.isSelected());
        return editableLine2D;
    }

    public Point2D[] getBorders() {
        return new Point2D[]{this.getP1(), this.getP2()};
    }

    public void selectBorder(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.selectedBorder = this.getP1().equals(double_) ? 1 : (this.getP2().equals(double_) ? 2 : -1);
    }

    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.getP2();
        }
        return this.getP1();
    }
}

