/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.EditableEllipse2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import edu.xtec.jclic.shapers.Holes;
import edu.xtec.jclic.shapers.PointListener;
import edu.xtec.jclic.shapers.PolygonDrawPanel;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HolesEditorPanel
extends JPanel
implements PointListener,
ActionListener,
PropertyChangeListener {
    public static final double ROTATE_UNIT = 0.2617993877991494;
    Options options;
    Holes shaper;
    Image img;
    Rectangle previewArea;
    BoxBase previewBb;
    ListModel listModel;
    ListSelectionListener listSelectionListener;
    boolean modified;
    int currentShape;
    protected PolygonDrawPanel pdp;
    private boolean shapeDrawn = false;
    double xFactor = 1.0;
    double yFactor = 1.0;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    Dimension previewDim;
    private boolean initializing;
    private int zoomFactor = 1;
    public static final int MAX_ZOOM = 10;
    public static final int MIN_ZOOM = -2;
    private ButtonGroup bgMode;
    private JButton btBezier;
    private JButton btContract;
    private JButton btCopy;
    private JButton btDelete;
    private JToggleButton btDivide;
    private JToggleButton btEllipse;
    private JButton btExpand;
    private JToggleButton btGrid;
    private JButton btLine;
    private JToggleButton btMagnet;
    private JButton btPaste;
    private JToggleButton btPolygon;
    private JButton btQuad;
    private JToggleButton btRect;
    private JButton btRotateLeft;
    private JButton btRotateRight;
    private JToggleButton btSelect;
    private JToggleButton btShowDrawnPoints;
    private JButton btZoomIn;
    private JButton btZoomOut;
    private SmallIntEditor gridSizeEdit;
    private JTextField lbZoom;
    private JScrollPane listScroll;
    private SmallIntEditor magnetRadiusEdit;
    private JScrollPane previewPanel;
    private JList shapesList;
    private JTextField tfName;

    public HolesEditorPanel(Options options, Holes holes, Dimension dimension, Image image, BoxBase boxBase) {
        this.options = options;
        this.shaper = holes;
        this.img = image;
        this.previewDim = dimension;
        this.initializing = true;
        this.currentShape = holes.getNumCells() + 1;
        this.previewArea = new Rectangle(image == null ? dimension : new Dimension(image.getWidth(this), image.getHeight(this)));
        this.previewBb = boxBase;
        this.initMembers();
        this.initComponents();
        this.customizeComponents();
        this.pdp = new PolygonDrawPanel(image == null ? (int)dimension.getWidth() : image.getWidth(this), image == null ? (int)dimension.getHeight() : image.getHeight(this), this, image == null);
        this.pdp.addPointListener(this);
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.addMouseMotionListener(this.pdp);
            ((PreviewPanel)this.previewPanel).vp.addMouseListener(this.pdp);
        }
        this.initializing = false;
        this.shapeChanged();
    }

    public void setCursor(Cursor cursor) {
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.setCursor(cursor);
        }
    }

    public void setCursor(Cursor cursor, boolean bl) {
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.setCursor(cursor);
        }
    }

    private void initMembers() {
        this.listModel = new AbstractListModel(){

            public int getSize() {
                return HolesEditorPanel.this.shaper.shapeData.length;
            }

            public Object getElementAt(int n) {
                ShapeData shapeData = HolesEditorPanel.this.shaper.shapeData[n];
                return shapeData.comment == null || shapeData.comment.length() == 0 ? Integer.toString(n) : shapeData.comment;
            }
        };
        this.listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = HolesEditorPanel.this.shapesList.getSelectedIndex();
                if (n != HolesEditorPanel.this.currentShape && n >= 0) {
                    if (HolesEditorPanel.this.pdp.getNumShapes() > 0) {
                        HolesEditorPanel.this.pdp.endPolygon(true, false, n);
                    }
                    if (n >= 0 && HolesEditorPanel.this.getHoles().getShapeData(n) != null) {
                        HolesEditorPanel.this.tfName.setText(HolesEditorPanel.this.getHoles().getShapeData((int)n).comment);
                    } else {
                        HolesEditorPanel.this.tfName.setText("");
                    }
                    HolesEditorPanel.this.setCurrentShapeNoList(n);
                } else {
                    HolesEditorPanel.this.tfName.setText("");
                }
            }
        };
    }

    protected void confirmChanges() {
        this.pdp.endPolygon();
    }

    protected void customizeComponents() {
        this.btShowDrawnPoints.setSelected(EditableShapeConstants.showDrawnPoints);
        this.btGrid.setSelected(EditableShapeConstants.gridWidth != -1);
        this.gridSizeEdit.setEnabled(this.btGrid.isSelected());
        this.btMagnet.setSelected(EditableShapeConstants.pointsOnGrid);
        this.magnetRadiusEdit.setEnabled(this.btMagnet.isSelected());
        this.btSelect.setSelected(true);
    }

    public void updateList() {
        this.initMembers();
        this.shapesList.setModel(this.listModel);
    }

    protected void setCurrentShape(int n) {
        if (this.shapesList.getSelectedIndex() != n) {
            this.shapesList.setSelectedIndex(n);
        }
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
        this.updateTransformingButtons();
        this.currentShape = n;
    }

    protected void setCurrentShapeNoList(int n) {
        this.currentShape = n;
        this.pdp.selectShape(n);
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void initComponents() {
        this.bgMode = new ButtonGroup();
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar();
        this.btShowDrawnPoints = new JToggleButton();
        this.btShowDrawnPoints.addActionListener(this);
        JToolBar.Separator separator = new JToolBar.Separator();
        this.btGrid = new JToggleButton();
        this.btGrid.addActionListener(this);
        this.gridSizeEdit = new SmallIntEditor();
        this.gridSizeEdit.addPropertyChangeListener(this);
        JToolBar.Separator separator2 = new JToolBar.Separator();
        this.btDelete = new JButton();
        this.btDelete.addActionListener(this);
        this.btCopy = new JButton();
        this.btCopy.addActionListener(this);
        this.btPaste = new JButton();
        this.btPaste.addActionListener(this);
        JToolBar.Separator separator3 = new JToolBar.Separator();
        this.btMagnet = new JToggleButton();
        this.btMagnet.addActionListener(this);
        this.magnetRadiusEdit = new SmallIntEditor();
        this.magnetRadiusEdit.addPropertyChangeListener(this);
        JToolBar.Separator separator4 = new JToolBar.Separator();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.btZoomOut = new JButton();
        this.btZoomOut.addActionListener(this);
        this.lbZoom = new JTextField();
        this.btZoomIn = new JButton();
        this.btZoomIn.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel3 = new JPanel();
        JToolBar jToolBar2 = new JToolBar();
        this.btSelect = new JToggleButton();
        this.btSelect.addActionListener(this);
        this.btDivide = new JToggleButton();
        this.btDivide.addActionListener(this);
        JToolBar.Separator separator5 = new JToolBar.Separator();
        this.btRect = new JToggleButton();
        this.btRect.addActionListener(this);
        this.btEllipse = new JToggleButton();
        this.btEllipse.addActionListener(this);
        this.btPolygon = new JToggleButton();
        this.btPolygon.addActionListener(this);
        this.btLine = new JButton();
        this.btLine.addActionListener(this);
        this.btBezier = new JButton();
        this.btBezier.addActionListener(this);
        this.btQuad = new JButton();
        this.btQuad.addActionListener(this);
        JToolBar.Separator separator6 = new JToolBar.Separator();
        this.btExpand = new JButton();
        this.btExpand.addActionListener(this);
        this.btContract = new JButton();
        this.btContract.addActionListener(this);
        JToolBar.Separator separator7 = new JToolBar.Separator();
        this.btRotateRight = new JButton();
        this.btRotateRight.addActionListener(this);
        this.btRotateLeft = new JButton();
        this.btRotateLeft.addActionListener(this);
        JLabel jLabel3 = new JLabel();
        JSplitPane jSplitPane = new JSplitPane();
        this.previewPanel = new PreviewPanel();
        this.previewPanel.addPropertyChangeListener(this);
        JPanel jPanel4 = new JPanel();
        this.listScroll = new JScrollPane();
        this.shapesList = new JList();
        this.tfName = new JTextField();
        this.tfName.addActionListener(this);
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        this.btShowDrawnPoints.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/vertex_off.gif")));
        this.btShowDrawnPoints.setToolTipText(this.options.getMsg("edit_shape_showPoints_tooltip"));
        this.btShowDrawnPoints.setSelectedIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/vertex_on.gif")));
        jToolBar.add(this.btShowDrawnPoints);
        separator.setOrientation(1);
        jToolBar.add(separator);
        this.btGrid.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/grid.gif")));
        this.btGrid.setToolTipText(this.options.getMsg("edit_shape_hideGrid"));
        jToolBar.add(this.btGrid);
        this.gridSizeEdit.setToolTipText(this.options.getMsg("edit_shape_gridSize_tooltip"));
        this.gridSizeEdit.setEditColumns(2);
        this.gridSizeEdit.setMax(50);
        this.gridSizeEdit.setMin(5);
        this.gridSizeEdit.setValue(10);
        this.gridSizeEdit.setValues(new int[]{5, 10, 15, 20, 30, 50});
        jToolBar.add(this.gridSizeEdit);
        separator2.setOrientation(1);
        jToolBar.add(separator2);
        this.btDelete.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.btDelete.setToolTipText(this.options.getMsg("edit_shape_deletePoint"));
        this.btDelete.setMaximumSize(new Dimension(32, 32));
        this.btDelete.setMinimumSize(new Dimension(32, 32));
        jToolBar.add(this.btDelete);
        this.btCopy.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/copy.gif")));
        this.btCopy.setToolTipText(this.options.getMsg("COPY"));
        jToolBar.add(this.btCopy);
        this.btPaste.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/paste.gif")));
        this.btPaste.setToolTipText(this.options.getMsg("PASTE"));
        jToolBar.add(this.btPaste);
        separator3.setOrientation(1);
        jToolBar.add(separator3);
        this.btMagnet.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/imant.gif")));
        this.btMagnet.setToolTipText(this.options.getMsg("edit_shape_aproxPoints"));
        jToolBar.add(this.btMagnet);
        this.magnetRadiusEdit.setToolTipText(this.options.getMsg("edit_shape_magnetRadius_tooltip"));
        this.magnetRadiusEdit.setEditColumns(2);
        this.magnetRadiusEdit.setMax(15);
        this.magnetRadiusEdit.setMin(1);
        this.magnetRadiusEdit.setValue(4);
        this.magnetRadiusEdit.setValues(new int[]{1, 2, 4, 6, 10, 15});
        jToolBar.add(this.magnetRadiusEdit);
        separator4.setOrientation(1);
        jToolBar.add(separator4);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setOpaque(false);
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/zoom.gif")));
        jLabel.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        jPanel2.add(jLabel);
        this.btZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus.gif")));
        this.btZoomOut.setToolTipText(this.options.getMsg("edit_shape_zoomOut"));
        this.btZoomOut.setPreferredSize(new Dimension(16, 16));
        jPanel2.add(this.btZoomOut);
        this.lbZoom.setColumns(3);
        this.lbZoom.setEditable(false);
        this.lbZoom.setHorizontalAlignment(0);
        this.lbZoom.setText("1x");
        jPanel2.add(this.lbZoom);
        this.btZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus.gif")));
        this.btZoomIn.setToolTipText(this.options.getMsg("edit_shape_zoomIn"));
        this.btZoomIn.setPreferredSize(new Dimension(16, 16));
        jPanel2.add(this.btZoomIn);
        jToolBar.add(jPanel2);
        jPanel.add((Component)jToolBar, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)jSeparator, gridBagConstraints);
        jPanel3.setLayout(new GridBagLayout());
        jToolBar2.setFloatable(false);
        jToolBar2.setOrientation(1);
        this.btSelect.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/selectionMode.gif")));
        this.btSelect.setToolTipText(this.options.getMsg("edit_shape_select"));
        this.bgMode.add(this.btSelect);
        this.btSelect.setMaximumSize(new Dimension(32, 32));
        this.btSelect.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btSelect);
        this.btDivide.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/add_point.gif")));
        this.btDivide.setToolTipText(this.options.getMsg("edit_shape_addPoint"));
        this.bgMode.add(this.btDivide);
        this.btDivide.setMaximumSize(new Dimension(32, 32));
        this.btDivide.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btDivide);
        jToolBar2.add(separator5);
        this.btRect.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rect.gif")));
        this.btRect.setToolTipText(this.options.getMsg("edit_shape_drawRect"));
        this.bgMode.add(this.btRect);
        this.btRect.setMaximumSize(new Dimension(32, 32));
        this.btRect.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btRect);
        this.btEllipse.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rodona.gif")));
        this.btEllipse.setToolTipText(this.options.getMsg("edit_shape_drawEllipse"));
        this.bgMode.add(this.btEllipse);
        this.btEllipse.setMaximumSize(new Dimension(32, 32));
        this.btEllipse.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btEllipse);
        this.btPolygon.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/pent.gif")));
        this.btPolygon.setToolTipText(this.options.getMsg("edit_shape_drawPoly"));
        this.bgMode.add(this.btPolygon);
        this.btPolygon.setMaximumSize(new Dimension(32, 32));
        this.btPolygon.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btPolygon);
        this.btLine.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/line.gif")));
        this.btLine.setToolTipText(this.options.getMsg("edit_shape_toLine"));
        this.btLine.setMaximumSize(new Dimension(32, 32));
        this.btLine.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btLine);
        this.btBezier.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bezier.gif")));
        this.btBezier.setToolTipText(this.options.getMsg("edit_shape_toBezier"));
        this.btBezier.setMaximumSize(new Dimension(32, 32));
        this.btBezier.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btBezier);
        this.btQuad.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/quad.gif")));
        this.btQuad.setToolTipText(this.options.getMsg("edit_shape_toQuad"));
        this.btQuad.setMaximumSize(new Dimension(32, 32));
        this.btQuad.setMinimumSize(new Dimension(32, 32));
        jToolBar2.add(this.btQuad);
        jToolBar2.add(separator6);
        this.btExpand.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/expand.gif")));
        this.btExpand.setToolTipText(this.options.getMsg("edit_shape_expand"));
        jToolBar2.add(this.btExpand);
        this.btContract.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/contract.gif")));
        this.btContract.setToolTipText(this.options.getMsg("edit_shape_contract"));
        jToolBar2.add(this.btContract);
        jToolBar2.add(separator7);
        this.btRotateRight.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rotate_right.gif")));
        this.btRotateRight.setToolTipText(this.options.getMsg("edit_shape_rRight"));
        jToolBar2.add(this.btRotateRight);
        this.btRotateLeft.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rotate_left.gif")));
        this.btRotateLeft.setToolTipText(this.options.getMsg("edit_shape_rLeft"));
        jToolBar2.add(this.btRotateLeft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)jToolBar2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jPanel3, gridBagConstraints);
        jSplitPane.setResizeWeight(1.0);
        this.previewPanel.setHorizontalScrollBarPolicy(32);
        this.previewPanel.setVerticalScrollBarPolicy(22);
        jSplitPane.setLeftComponent(this.previewPanel);
        jPanel4.setLayout(new BorderLayout(10, 8));
        this.listScroll.setToolTipText(this.options.getMsg("edit_shape_elements"));
        this.listScroll.setPreferredSize(new Dimension(80, 100));
        this.shapesList.setModel(this.listModel);
        this.shapesList.addListSelectionListener(this.listSelectionListener);
        this.listScroll.setViewportView(this.shapesList);
        jPanel4.add((Component)this.listScroll, "Center");
        this.tfName.setToolTipText(this.options.getMsg("edit_shape_elemName"));
        jPanel4.add((Component)this.tfName, "South");
        jSplitPane.setRightComponent(jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jSplitPane, gridBagConstraints);
    }

    private void setDrawingRectangleMode() {
        this.deselectAll();
        this.btRect.setSelected(true);
        this.pdp.setDrawingMode(5);
        this.pdp.deSelectAll();
        this.repaint(0L);
    }

    private void deselectAll() {
        this.pdp.cancelCurrentOperations();
        this.btSelect.setSelected(false);
        this.btRect.setSelected(false);
        this.btEllipse.setSelected(false);
        this.btPolygon.setSelected(false);
        this.btBezier.setSelected(false);
        this.btQuad.setSelected(false);
        this.btDivide.setSelected(false);
    }

    public void setDrawingMode(int n) {
        this.pdp.setDrawingMode(n);
        switch (n) {
            case 1: {
                this.btSelect.setSelected(true);
                break;
            }
            case 4: {
                this.btDivide.setSelected(true);
            }
        }
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
    }

    public void shapeChanged() {
        if (this.pdp.getNumShapes() > 0) {
            this.btDelete.setEnabled(true);
            this.shapeDrawn = true;
            this.repaint(0L);
        } else {
            this.btDelete.setEnabled(this.pdp.hasSelectedPoint());
            this.clean();
        }
        if (!this.btDivide.isSelected()) {
            this.pdp.setDrawingMode(1);
            this.deselectAll();
            this.btSelect.setSelected(true);
        } else {
            this.btSelect.setSelected(false);
        }
        this.updateTransformingButtons();
    }

    protected void updateTransformingButtons() {
        Vector vector = this.pdp.getSelectedShapes();
        if (vector.size() == 1) {
            Enumeration enumeration = vector.elements();
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            if (!(editableShape instanceof EditableRectangle)) {
                this.btBezier.setEnabled(true);
                this.btQuad.setEnabled(true);
            }
            if (!(editableShape instanceof EditableEllipse2D)) {
                this.btLine.setEnabled(true);
            }
        } else {
            this.btBezier.setEnabled(false);
            this.btQuad.setEnabled(false);
            this.btLine.setEnabled(false);
            this.repaint(0L);
        }
    }

    public PreviewPanel getPreviewPanel() {
        return (PreviewPanel)this.previewPanel;
    }

    private void clean() {
        this.pdp.deleteSelected(false);
        this.shapeDrawn = false;
        this.deselectAll();
        this.btRect.setEnabled(true);
        this.btEllipse.setEnabled(true);
        this.btPolygon.setEnabled(true);
    }

    public void updateView() {
        ((PreviewPanel)this.previewPanel).updateView();
    }

    public Holes getHoles() {
        return this.shaper;
    }

    public Rectangle getPreviewArea() {
        return this.previewArea;
    }

    public void setPreviewArea(Rectangle rectangle) {
        this.previewArea = rectangle;
    }

    public int getNumShapes() {
        return this.shaper.getNumCells();
    }

    public static Shaper getShaper(Shaper shaper, Component component, Options options, Dimension dimension, Image image, BoxBase boxBase) {
        Messages messages = options.getMessages();
        if (shaper == null || !(shaper instanceof Holes)) {
            return null;
        }
        Holes holes = null;
        try {
            holes = (Holes)shaper.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            messages.showErrorWarning(component, "edit_act_shaper_err", cloneNotSupportedException);
            return null;
        }
        HolesEditorPanel holesEditorPanel = new HolesEditorPanel(options, holes, dimension, image, boxBase);
        boolean bl = messages.showInputDlg(component, holesEditorPanel, "edit_act_shaper_properties");
        if (bl) {
            holesEditorPanel.confirmChanges();
        }
        return bl ? holes : null;
    }

    public void updatePreviewArea(double d, double d2) {
        if (this.lastWidth != -1.0) {
            this.lastWidth *= d;
            this.lastHeight *= d2;
        } else {
            this.lastWidth = this.previewArea.getWidth() * d;
            this.lastHeight = this.previewArea.getHeight() * d2;
        }
        this.xFactor *= d;
        this.yFactor *= d2;
        this.previewArea = new Rectangle(new Dimension((int)this.lastWidth, (int)this.lastHeight));
        this.updateView();
    }

    public void incDrawingArea(double d, double d2) {
        this.modifyDrawingArea((double)this.previewArea.width + d, (double)this.previewArea.height + d2);
    }

    protected void modifyDrawingArea(double d, double d2) {
        if (d > 0.0 && d2 > 0.0) {
            double d3 = d / (double)this.previewArea.width;
            double d4 = d2 / (double)this.previewArea.height;
            for (int i = 0; i < this.shaper.getNumCells(); ++i) {
                ShapeData shapeData = this.shaper.getShapeData(i);
                shapeData.scaleTo(d3, d4);
            }
            this.previewArea.setSize((int)d, (int)d2);
            this.previewDim.setSize(this.previewArea.getSize());
            this.shaper.scaleW = d;
            this.shaper.scaleH = d2;
            this.updateView();
        }
    }

    public void pointMoved(Point2D point2D) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.initializing && actionEvent != null) {
            Object object = actionEvent.getSource();
            if (object == this.btDivide) {
                this.deselectAll();
                this.requestFocus();
                this.btDivide.setSelected(true);
                this.pdp.setDrawingMode(4);
                this.pdp.deSelectAll();
                this.repaint(0L);
            } else if (object == this.btDelete) {
                this.clean();
                this.shapeChanged();
                this.repaint(0L);
            } else if (object == this.btEllipse) {
                this.requestFocus();
                this.pdp.setDrawingMode(6);
            } else if (object == this.btRect) {
                this.requestFocus();
                this.pdp.setDrawingMode(5);
            } else if (object == this.btLine) {
                this.requestFocus();
                this.pdp.convertToLine();
                this.repaint(0L);
            } else if (object == this.btBezier) {
                this.requestFocus();
                this.pdp.convertToBezier();
                this.repaint(0L);
            } else if (object == this.btQuad) {
                this.requestFocus();
                this.pdp.convertToQuad();
                this.repaint(0L);
            } else if (object == this.btPolygon) {
                this.requestFocus();
                this.pdp.setDrawingMode(7);
            } else if (object == this.btSelect) {
                this.requestFocus();
                this.pdp.setDrawingMode(1);
            } else if (object == this.btShowDrawnPoints) {
                EditableShapeConstants.showDrawnPoints = this.btShowDrawnPoints.isSelected();
                this.repaint(0L);
            } else if (object == this.btGrid) {
                EditableShapeConstants.gridWidth = this.btGrid.isSelected() ? this.gridSizeEdit.getValue() : -1;
                this.gridSizeEdit.setEnabled(this.btGrid.isSelected());
                this.repaint();
            } else if (object == this.btMagnet) {
                EditableShapeConstants.pointsOnGrid = this.btMagnet.isSelected();
                this.magnetRadiusEdit.setEnabled(this.btMagnet.isSelected());
                this.repaint(0L);
            } else if (object == this.btRotateRight) {
                this.pdp.rotate(0.2617993877991494, false, false);
            } else if (object == this.btRotateLeft) {
                this.pdp.rotate(-0.2617993877991494, false, false);
            } else if (object == this.btExpand) {
                this.pdp.scale(EditableShapeConstants.scaleXFactor, EditableShapeConstants.scaleYFactor, false, false);
            } else if (object == this.btContract) {
                if (EditableShapeConstants.scaleXFactor != 0.0 && EditableShapeConstants.scaleYFactor != 0.0) {
                    this.pdp.scale(1.0 / EditableShapeConstants.scaleXFactor, 1.0 / EditableShapeConstants.scaleYFactor, false, false);
                }
            } else if (object == this.btZoomIn) {
                this.doZoom(true);
            } else if (object == this.btZoomOut) {
                this.doZoom(false);
            } else if (object == this.btCopy) {
                this.pdp.copy(false);
                this.updateView();
            } else if (object == this.btPaste) {
                this.pdp.endPolygon();
                this.pdp.paste();
                this.updateView();
            } else if (object == this.tfName) {
                ShapeData shapeData = null;
                if (this.currentShape >= 0) {
                    shapeData = this.getHoles().getShapeData(this.currentShape);
                    String string = this.tfName.getText().trim();
                    if (shapeData != null && string.length() > 0) {
                        shapeData.comment = string;
                    }
                    this.updateList();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.initializing && propertyChangeEvent != null) {
            Object object = propertyChangeEvent.getSource();
            if (object == this.gridSizeEdit) {
                int n;
                int n2 = n = this.btGrid.isSelected() ? this.gridSizeEdit.getValue() : -1;
                if (n != EditableShapeConstants.gridWidth) {
                    EditableShapeConstants.gridWidth = n;
                    this.repaint();
                }
            } else if (object == this.magnetRadiusEdit) {
                int n = this.magnetRadiusEdit.getValue() * 2;
                if (n != EditableShapeConstants.selectLength) {
                    EditableShapeConstants.selectLength = n;
                    this.pdp.initDrawnBorders();
                    this.repaint();
                }
            } else if (object == this.previewPanel) {
                this.repaint(0L);
            }
        }
    }

    protected void doZoom(boolean bl) {
        double d;
        double d2 = 1.0;
        if (bl) {
            if (this.zoomFactor < 10) {
                if (this.zoomFactor >= 1) {
                    d2 = ((double)this.zoomFactor + 1.0) / (double)this.zoomFactor;
                } else {
                    d = Math.abs(this.zoomFactor - 2);
                    d2 = 1.0 / (d - 1.0) / (1.0 / d);
                }
                ++this.zoomFactor;
            }
        } else if (this.zoomFactor > -2) {
            if (this.zoomFactor > 1) {
                d2 = ((double)this.zoomFactor - 1.0) / (double)this.zoomFactor;
            } else {
                d = Math.abs(this.zoomFactor - 2);
                d2 = 1.0 / (d + 1.0) / (1.0 / d);
            }
            --this.zoomFactor;
        }
        if (d2 != 1.0) {
            this.pdp.endPolygon();
            this.updatePreviewArea(d2, d2);
        }
        this.btZoomIn.setEnabled(this.zoomFactor < 10);
        this.btZoomOut.setEnabled(this.zoomFactor > -2);
        String string = this.zoomFactor >= 1 ? Integer.toString(this.zoomFactor) : "1/" + Math.abs(this.zoomFactor - 2);
        this.lbZoom.setText(string + "x");
    }

    class VP
    extends JPanel {
        private int xBak = -1;
        private int yBak = -1;
        private int wBak = -1;
        private int hBak = -1;
        Vector shapes = new Vector();

        VP() {
        }

        public void updateView() {
            this.setSize(this.getSize());
            this.setPreferredSize(this.getSize());
            this.updateComponentsView();
        }

        public void updateComponentsView() {
            this.shapes.removeAllElements();
            for (int i = 0; i < HolesEditorPanel.this.shaper.getNumCells(); ++i) {
                this.shapes.add(HolesEditorPanel.this.shaper.getShape(i, HolesEditorPanel.this.previewArea));
            }
            if (HolesEditorPanel.this.pdp != null) {
                HolesEditorPanel.this.pdp.updateView();
            }
            super.updateUI();
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            Color color = graphics2D.getBackground();
            Color color2 = graphics2D.getColor();
            graphics2D.setColor(HolesEditorPanel.this.previewBb.backColor);
            graphics2D.fill(HolesEditorPanel.this.previewArea);
            graphics2D.setBackground(HolesEditorPanel.this.previewBb.backColor);
            graphics2D.setColor(HolesEditorPanel.this.previewBb.borderColor);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(HolesEditorPanel.this.previewBb.getBorder());
            if (HolesEditorPanel.this.img != null) {
                graphics2D.drawImage(HolesEditorPanel.this.img, HolesEditorPanel.this.previewArea.x, HolesEditorPanel.this.previewArea.y, HolesEditorPanel.this.previewArea.width, HolesEditorPanel.this.previewArea.height, this);
            }
            HolesEditorPanel.this.pdp.drawGrid(graphics, EditableShapeConstants.gridWidth);
            graphics2D.setColor(Color.black);
            for (int i = 0; i < this.shapes.size(); ++i) {
                if (i == HolesEditorPanel.this.currentShape) continue;
                graphics2D.draw((Shape)this.shapes.get(i));
            }
            graphics2D.setColor(Color.red);
            HolesEditorPanel.this.pdp.paint(graphics2D);
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color2);
            graphics2D.setBackground(color);
            graphics2D.setRenderingHints(renderingHints);
        }

        protected void drawBorder(Graphics graphics, Color color) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, (int)HolesEditorPanel.this.previewArea.getX(), this.getHeight());
        }

        public void doLayout() {
            HolesEditorPanel.this.previewArea.x = (this.getBounds().width - HolesEditorPanel.this.previewArea.width) / 2;
            HolesEditorPanel.this.previewArea.y = (this.getBounds().height - HolesEditorPanel.this.previewArea.height) / 2;
            if (HolesEditorPanel.this.previewArea.x != this.xBak || HolesEditorPanel.this.previewArea.y != this.yBak || HolesEditorPanel.this.previewArea.width != this.wBak || HolesEditorPanel.this.previewArea.height != this.hBak) {
                this.xBak = HolesEditorPanel.this.previewArea.x;
                this.yBak = HolesEditorPanel.this.previewArea.y;
                this.wBak = HolesEditorPanel.this.previewArea.width;
                this.hBak = HolesEditorPanel.this.previewArea.height;
                HolesEditorPanel.this.pdp.initDrawnBorders();
            }
            this.updateComponentsView();
        }

        public Dimension getSize() {
            return new Dimension(HolesEditorPanel.this.previewArea.x + (int)HolesEditorPanel.this.previewArea.getBounds().getWidth(), HolesEditorPanel.this.previewArea.y + (int)HolesEditorPanel.this.previewArea.getBounds().getHeight());
        }
    }

    class PreviewPanel
    extends JScrollPane {
        public VP vp;

        public PreviewPanel() {
            this.vp = new VP();
            this.setViewportView(this.vp);
            this.updateView();
        }

        public void updateView() {
            this.vp.updateView();
        }
    }
}

