/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.servlet.RequestProcessor;
import edu.xtec.util.Html;
import edu.xtec.util.StrUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class HTTPRequest {
    public Socket socket;
    public BufferedReader in;
    public OutputStream os;
    public PrintWriter pw;
    public HashMap cookies = new HashMap();
    public HashMap params = new HashMap();
    public String method;
    public String urlBase;
    public String protocol;
    public boolean commited;
    public String firstLine;
    public InputStream inputStream;
    ResponseHead head = new ResponseHead();
    public static final int OK = 200;
    public static final int BAD_REQUEST = 400;
    public static final int MOVED_PERM = 301;
    public static final int FOUND = 302;
    public static final int NOT_FOUND = 404;
    public static final int SERVER_ERROR = 500;
    public static final String MIME_HTML = "text/html";

    public HTTPRequest(Socket socket) throws Exception {
        Object object;
        this.socket = socket;
        this.buildStreams();
        int n = -1;
        try {
            this.firstLine = this.in.readLine();
            if (this.firstLine == null) {
                while (this.in.ready()) {
                    this.in.readLine();
                }
                return;
            }
            object = new StringTokenizer(this.firstLine, " ");
            this.method = ((StringTokenizer)object).nextToken();
            String string = ((StringTokenizer)object).nextToken();
            int n2 = string.indexOf(63);
            if (n2 < 0) {
                this.urlBase = string;
            } else {
                this.urlBase = string.substring(0, n2);
                HTTPRequest.processParamsLine(string.substring(n2 + 1), this.params, '&', '=', true);
            }
            this.protocol = ((StringTokenizer)object).nextToken();
            if (this.protocol == null || !this.protocol.equals("HTTP/1.0") && !this.protocol.equals("HTTP/1.1")) {
                this.error(400, null);
                throw new Exception("Bad request!");
            }
        }
        catch (Exception exception) {
            this.error(400, null);
            throw exception;
        }
        while ((object = StrUtils.nullableString(this.in.readLine())) != null) {
            if (((String)object).toLowerCase().startsWith("cookie:")) {
                int n3 = ((String)object).indexOf(32);
                if (n3 <= 0) continue;
                HTTPRequest.processParamsLine(((String)object).substring(n3 + 1), this.cookies, ';', '=', false);
                continue;
            }
            if (!((String)object).toLowerCase().startsWith("content-length:")) continue;
            n = Integer.parseInt(((String)object).substring(16));
        }
        if (n >= 0) {
            object = new char[n];
            int n4 = this.in.read((char[])object);
            String string = String.copyValueOf((char[])object);
            this.inputStream = new ByteArrayInputStream(string.getBytes());
            if (!string.startsWith("<")) {
                HTTPRequest.processParamsLine(string, this.params, '&', '=', true);
            }
        } else {
            while (this.in.ready() && (object = StrUtils.nullableString(this.in.readLine())) != null) {
                HTTPRequest.processParamsLine((String)object, this.params, '&', '=', true);
            }
        }
    }

    private void buildStreams() throws IOException {
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
        this.pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "ISO-8859-1"));
    }

    private void buildStreamsDebug(final PrintStream printStream) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream())){

            public String readLine() throws IOException {
                String string = super.readLine();
                if (string != null) {
                    printStream.println("< " + string);
                }
                return string;
            }

            public int read(char[] cArray) throws IOException {
                int n = super.read(cArray);
                if (n > 0) {
                    printStream.println("< " + new String(cArray, 0, n));
                }
                return n;
            }
        };
        this.os = new BufferedOutputStream(this.socket.getOutputStream()){

            public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                if (byArray != null) {
                    printStream.println("> " + new String(byArray, n, n2));
                }
                super.write(byArray, n, n2);
            }
        };
        this.pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "ISO-8859-1")){

            public void write(String string, int n, int n2) {
                printStream.println("> " + string);
                super.write(string, n, n2);
            }
        };
    }

    public static void processParamsLine(String string, HashMap hashMap, char c, char c2, boolean bl) {
        if (string != null && string.length() > 0 && hashMap != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = null;
                String string4 = null;
                int n = string2.indexOf(c2);
                if (n > 0) {
                    string3 = Html.decode(string2.substring(0, n).replace('+', ' '));
                    if (n < string2.length() - 1) {
                        string4 = Html.decode(string2.substring(n + 1).replace('+', ' '));
                    }
                } else {
                    string3 = Html.decode(string2.replace('+', ' '));
                }
                if (bl) {
                    String[] stringArray = (String[])hashMap.get(string3);
                    if (stringArray == null) {
                        stringArray = new String[]{string4};
                    } else {
                        String[] stringArray2 = new String[stringArray.length + 1];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray2[i] = stringArray[i];
                        }
                        stringArray2[i] = string4;
                        stringArray = stringArray2;
                    }
                    hashMap.put(string3, stringArray);
                    continue;
                }
                hashMap.put(string3, string4);
            }
        }
    }

    public void error(int n, String string) throws Exception {
        String string2 = null;
        switch (n) {
            case 400: {
                string2 = "Bad Request";
                break;
            }
            case 301: {
                string2 = "Moved permanently";
                break;
            }
            case 404: {
                string2 = "File not found";
                break;
            }
            case 500: {
                string2 = "Server error";
                break;
            }
            default: {
                string2 = "Undefined error";
            }
        }
        this.head.code = n;
        this.head.title = string2;
        this.head.write();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<B>").append(string2).append("</B>\n<BR>&nbsp;<BR>\n");
        if (string != null) {
            stringBuffer.append(string);
        }
        this.minimalPage("ERROR: " + string2, stringBuffer.substring(0));
    }

    public void redirect(String string) throws Exception {
        this.head.contentType = null;
        this.head.code = 301;
        this.head.title = "Moved permanently";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("http://");
        String string2 = this.socket.getLocalAddress().getHostAddress();
        if (string2 == null || "0.0.0.0".equals(string2)) {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        stringBuffer.append(string2);
        stringBuffer.append(":").append(this.socket.getLocalPort()).append("/").append(string);
        String string3 = stringBuffer.substring(0);
        stringBuffer.setLength(0);
        stringBuffer.append("Location: ").append(string3);
        this.head.extra = stringBuffer.substring(0);
        this.head.write();
        stringBuffer.setLength(0);
        stringBuffer.append("redirected to: <A HREF=\"").append(string3).append("\">").append(string3).append("</A>");
        this.minimalPage("redirect", stringBuffer.substring(0));
    }

    public void minimalPage(String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n");
        stringBuffer.append("<HTTP>\n<HEAD>\n");
        if (string != null) {
            stringBuffer.append("<TITLE>").append(string).append("</TITLE>\n");
        }
        stringBuffer.append("</HEAD>\n<BODY>\n");
        stringBuffer.append("<H2>").append(string).append("</H2>\n");
        stringBuffer.append(string2);
        stringBuffer.append("\n</BODY>\n</HTML>");
        this.pw.println(stringBuffer.substring(0));
        this.os.flush();
        this.commited = true;
    }

    public class ResponseHead {
        public String contentType = "text/html";
        public int code = 200;
        public int contentLength = -1;
        public String title;
        public String extra;
        public boolean cache = true;
        public boolean commited = false;

        public void write() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("HTTP/1.0 ");
            stringBuffer.append(this.code).append(" ").append(this.title == null ? "OK" : this.title);
            HTTPRequest.this.pw.println(stringBuffer.substring(0));
            if (this.extra != null) {
                HTTPRequest.this.pw.println(this.extra);
            }
            if (this.contentType != null) {
                stringBuffer.setLength(0);
                HTTPRequest.this.pw.println(stringBuffer.append("Content-Type: ").append(this.contentType).substring(0));
            }
            stringBuffer.setLength(0);
            HTTPRequest.this.pw.println(stringBuffer.append("Date: ").append(RequestProcessor.httpDate(new Date())).substring(0));
            HTTPRequest.this.pw.println("Server: JClicHttpServer 1.0");
            if (!this.cache) {
                HTTPRequest.this.pw.println("Pragma: no-cache");
                HTTPRequest.this.pw.println("Cache-Control: no-cache");
                HTTPRequest.this.pw.println("Expires: 0");
            }
            if (HTTPRequest.this.cookies.size() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append("Set-Cookie: ");
                Iterator iterator = HTTPRequest.this.cookies.keySet().iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!bl) {
                        stringBuffer.append(";");
                    } else {
                        bl = false;
                    }
                    stringBuffer.append(string).append("=").append(HTTPRequest.this.cookies.get(string));
                }
                HTTPRequest.this.pw.println(stringBuffer.substring(0));
            }
            if (this.contentLength > 0) {
                stringBuffer.setLength(0);
                HTTPRequest.this.pw.println(stringBuffer.append("Content-Length: ").append(this.contentLength).substring(0));
            }
            HTTPRequest.this.pw.println("");
            HTTPRequest.this.pw.flush();
            this.commited = true;
        }
    }
}

