/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.rp.Login;
import edu.xtec.jclic.report.rp.ReportsRequestProcessor;
import edu.xtec.util.CompoundObject;
import edu.xtec.util.Encryption;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Basic
extends ReportsRequestProcessor {
    public static final String BUNDLE = "edu.xtec.resources.messages.reportMessages";
    public static final String LANG = "lang";
    public static final long DEFAULT_SESSION_LIFETIME = 20L;
    public static final String ACTION = "action";
    public static final String PWD = "pwd";
    public static final String RETRY = "retry";
    public static final String ON = "on";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String MAIN_FORM = "mainForm";
    public static final String AUTH = "AUTH";
    protected static HashMap localeObjects = new HashMap();
    protected static HashMap sessions = new HashMap();
    protected boolean retry;
    protected String auth;
    protected ResourceBundle bundle;
    protected String[] months;
    protected DateFormat shortDateFormat;
    protected DateFormat veryShortDateFormat;
    protected NumberFormat numberFormat;
    protected String lang;
    private static String[] F_NUMBERS;

    public static String[] getFormattedNumbers() {
        if (F_NUMBERS == null) {
            DecimalFormat decimalFormat = new DecimalFormat("00");
            Vector<String> vector = new Vector<String>(100);
            for (int i = 0; i < 100; ++i) {
                vector.add(decimalFormat.format(i));
            }
            F_NUMBERS = vector.toArray(new String[100]);
        }
        return F_NUMBERS;
    }

    public abstract String getTitle(ResourceBundle var1);

    public abstract String getUrl();

    public String getMsg(String string) {
        return Basic.filter(this.bundle.getString(string));
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.lang = this.getParam(LANG);
        this.lang = this.lang == null || this.lang.length() != 2 ? prop.getProperty("language", Locale.getDefault().getLanguage()) : this.lang.toLowerCase();
        Object[] objectArray = (Object[])localeObjects.get(this.lang);
        if (objectArray != null) {
            this.bundle = (ResourceBundle)objectArray[0];
            this.months = (String[])objectArray[1];
            this.shortDateFormat = (DateFormat)objectArray[2];
            this.veryShortDateFormat = (DateFormat)objectArray[3];
            this.numberFormat = (NumberFormat)objectArray[4];
        } else {
            Locale locale = new Locale(this.lang, "");
            this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
            if (this.bundle == null) {
                throw new Exception("Internal error!");
            }
            this.months = new String[12];
            for (int i = 0; i < 12; ++i) {
                this.months[i] = this.bundle.getString("month_" + (i + 1));
            }
            this.shortDateFormat = DateFormat.getDateInstance(3, locale);
            this.veryShortDateFormat = new SimpleDateFormat("dd/MM", locale);
            this.numberFormat = NumberFormat.getInstance(locale);
            objectArray = new Object[]{this.bundle, this.months, this.shortDateFormat, this.veryShortDateFormat, this.numberFormat};
            localeObjects.put(this.lang, objectArray);
        }
        this.checkAuth();
        if (this.auth != null) {
            this.setCookie(AUTH, this.auth);
        }
        return this.auth != null;
    }

    protected boolean checkAuth() {
        this.auth = this.getCookie(AUTH);
        if (this.auth != null) {
            Long l = (Long)sessions.get(this.auth);
            if (l != null) {
                long l2 = 20L;
                try {
                    l2 = Long.parseLong(prop.getProperty("session_lifetime", Long.toString(20L)));
                }
                catch (NumberFormatException numberFormatException) {
                    l2 = 20L;
                }
                l2 = Math.max(1L, l2);
                if (l < System.currentTimeMillis() - l2 * 60L * 1000L) {
                    this.auth = null;
                    sessions.remove(this.auth);
                } else {
                    sessions.put(this.auth, new Long(System.currentTimeMillis()));
                }
            } else {
                this.auth = null;
            }
        }
        if (this.auth == null) {
            Object object;
            boolean bl = false;
            try {
                object = bridge.getProperty("PASSWORD", null);
                if (object != null && ((String)object).length() > 0) {
                    String string = this.getParam(PWD);
                    if (string != null && ((String)object).equals(Encryption.Encrypt(string))) {
                        bl = true;
                    } else {
                        this.retry = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                object = new char[12];
                for (int i = 0; i < 12; ++i) {
                    char c = (char)(Math.random() * 36.0);
                    object[i] = c < '\n' ? (Object)((char)(48 + c)) : (Object)((char)(65 + c - 10));
                }
                this.auth = new String((char[])object);
                sessions.put(this.auth, new Long(System.currentTimeMillis()));
            }
        }
        return this.auth != null;
    }

    public void header(Vector vector) {
        super.header(vector);
        if (!this.checkAuth()) {
            vector.add(new String[]{"REDIRECT", Basic.urlParam(Login.URL, RETRY, this.retry ? TRUE : FALSE)});
        }
    }

    public void head(PrintWriter printWriter) throws Exception {
        super.head(printWriter);
        this.title(this.bundle.getString("jclic_reports"), this.getTitle(this.bundle), printWriter);
        this.linkStyle(Basic.resourceUrl("basic.css"), Basic.resourceUrl("basic_print.css"), printWriter);
    }

    public void standardHeader(PrintWriter printWriter, String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<h1>").append(this.getMsg("jclic_reports")).append("<br>").append(string).append("</h1>\n");
        stringBuffer.append("<p class=\"topMenu\">").append(string2).append("</p>");
        printWriter.println(stringBuffer.substring(0));
    }

    protected boolean getBoolParam(String string, String string2) {
        boolean bl = false;
        String string3 = this.getParam(string);
        if (string3 != null && string3.length() > 0) {
            bl = string2 == null ? true : string2.toLowerCase().equals(string3.trim().toLowerCase());
        }
        return bl;
    }

    public static String linkTo(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 200);
        stringBuffer.append("<a href=\"");
        stringBuffer.append(string).append("\"");
        if (string3 != null) {
            stringBuffer.append(" class=\"").append(string3).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(Basic.filter(string2));
        stringBuffer.append("</a>");
        return stringBuffer.substring(0);
    }

    public static String buttonAction(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 200);
        stringBuffer.append("<input type=\"button\" value=\"").append(Basic.filter(string2)).append("\"");
        if (string != null) {
            stringBuffer.append(" onClick=\"").append(string).append("\"");
        }
        if (string3 != null) {
            stringBuffer.append(" ").append(string3);
        }
        stringBuffer.append(" id=\"noPrint\">");
        return stringBuffer.substring(0);
    }

    public static String buttonTo(String string, String string2, String string3) {
        return Basic.buttonAction("window.location.href='" + Basic.escape(string) + "'", string2, string3);
    }

    protected static String urlParam(String string, String string2, String string3) {
        return Basic.urlParamSb(new StringBuffer(string.length() + 100).append(string), string2, string3, string.indexOf(63) < 0).substring(0);
    }

    protected static StringBuffer urlParamSb(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(bl ? "?" : "&");
            stringBuffer.append(string).append("=").append(ReportUtils.urlEncode(string2, false, false));
        }
        return stringBuffer;
    }

    protected int getAction(String[] stringArray, int n) {
        String string = this.getParam(ACTION);
        int n2 = n;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public String[][] vectorToArray(Vector vector, boolean bl) {
        return this.vectorToArray(vector, bl, null, null);
    }

    public String[][] vectorToArray(Vector vector, boolean bl, String string, String string2) {
        String[][] stringArray = null;
        if (string != null || vector != null && vector.size() > 0) {
            int n = vector != null ? vector.size() : 0;
            stringArray = new String[n + (string != null ? 1 : 0)][];
            int n2 = 0;
            if (string != null) {
                String string3 = string;
                if (string2 != null) {
                    string3 = this.getMsg(string2);
                }
                stringArray[n2++] = new String[]{string, string3};
            }
            if (vector != null) {
                for (int i = 0; i < n; ++i) {
                    String string4 = null;
                    String string5 = null;
                    if (bl) {
                        CompoundObject compoundObject = (CompoundObject)vector.get(i);
                        string4 = compoundObject.getId();
                        string5 = compoundObject.getText();
                    } else {
                        string5 = string4 = ((String)vector.get(i)).trim();
                    }
                    stringArray[n2++] = new String[]{string4, string5};
                }
            }
        }
        return stringArray;
    }
}

