/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.jclic.report.rp.UserAdmin;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class GroupAdmin
extends Basic {
    public static String TITLE = "group_admin_title";
    public static String URL = "groupAdmin";
    public static final String GROUP = "group";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final int MENU = 0;
    public static final int GROUP_MENU = 1;
    public static final int EDIT = 2;
    public static final int EDIT_UPDATE = 3;
    public static final int CREATE = 4;
    public static final int CREATE_UPDATE = 5;
    public static final int DELETE = 6;
    public static final int DELETE_UPDATE = 7;
    public static final int CLEAR = 8;
    public static final int CLEAR_UPDATE = 9;
    public static final int ERROR = 10;
    public static final String[] ACTIONS = new String[]{"", "group", "edit", "editUpd", "create", "createUpd", "del", "delUpd", "clear", "clearUpd"};
    protected int page;
    protected DateManager dm;
    protected Vector groups;
    protected Vector users;
    protected GroupData gd;
    protected String errMsg;
    protected String returnUrl;

    public String getTitle(ResourceBundle resourceBundle) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(resourceBundle.getString(TITLE));
        if (this.gd != null && this.gd.getText() != null && this.gd.getText().length() > 0) {
            stringBuffer.append(": ").append(GroupAdmin.filter(this.gd.getText()));
        }
        return stringBuffer.substring(0);
    }

    public String getUrl() {
        return GroupAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int n) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(URL);
        GroupAdmin.urlParamSb(stringBuffer, "lang", this.lang, true);
        GroupAdmin.urlParamSb(stringBuffer, "action", ACTIONS[n], false);
        if (this.gd != null) {
            GroupAdmin.urlParamSb(stringBuffer, GROUP, this.gd.getId(), false);
        }
        return stringBuffer.substring(0);
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        String string = this.getParamNotNull(GROUP);
        if (string.length() > 0) {
            this.gd = bridge.getGroupData(string);
        }
        this.page = this.getAction(ACTIONS, 0);
        if (this.page == 8 || this.page == 9) {
            this.dm = new DateManager(this);
            if (!this.dm.init()) {
                return false;
            }
        }
        switch (this.page) {
            case 3: {
                this.edit();
                break;
            }
            case 5: {
                this.create();
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 9: {
                this.clear();
            }
        }
        if (this.page == 0) {
            this.groups = bridge.getGroups();
        } else if (this.page == 1 && this.gd != null) {
            this.users = bridge.getUsers(this.gd.getId());
        }
        return true;
    }

    protected void edit() throws Exception {
        this.returnUrl = this.getUrl(1);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String string = this.getParamNotNull(NAME).trim();
        if (string.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_name");
        } else {
            this.gd.setText(string);
            this.gd.setIconUrl(this.getParamNotNull(ICON).trim());
            try {
                bridge.updateGroup(this.gd, false);
                this.page = 1;
            }
            catch (Exception exception) {
                this.errMsg = this.errMsg + exception.getLocalizedMessage();
            }
        }
    }

    protected void create() throws Exception {
        this.returnUrl = this.getUrl(0);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String string = this.getParamNotNull(NAME).trim();
        String string2 = this.getParamNotNull(ID).trim();
        String string3 = this.getParamNotNull(ICON).trim();
        if (string.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_name");
        } else if (string2.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_id");
        } else {
            this.gd = bridge.getGroupData(string2);
            if (this.gd != null) {
                this.returnUrl = GroupAdmin.urlParam(GroupAdmin.urlParam(this.getUrl(4), NAME, string), ICON, string3);
                this.errMsg = this.errMsg + this.getMsg("group_admin_id_already_exists");
            } else {
                try {
                    this.gd = new GroupData(string2, string, string3, null);
                    bridge.updateGroup(this.gd, true);
                    this.page = 1;
                }
                catch (Exception exception) {
                    this.gd = null;
                    this.errMsg = this.errMsg + exception.getLocalizedMessage();
                }
            }
        }
    }

    protected void delete() throws Exception {
        this.returnUrl = this.getUrl(1);
        try {
            bridge.deleteGroup(this.gd.getId());
            this.gd = null;
            this.page = 0;
        }
        catch (Exception exception) {
            this.returnUrl = this.getUrl(1);
            this.errMsg = this.getMsg("db_error") + "<BR>" + exception.getLocalizedMessage();
        }
    }

    protected void clear() throws Exception {
        this.returnUrl = this.getUrl(1);
        try {
            bridge.clearGroupReportData(this.gd.getId(), this.dm.dFrom, this.dm.dTo);
            this.page = 1;
        }
        catch (Exception exception) {
            this.errMsg = this.getMsg("db_error") + "<BR>" + exception.getLocalizedMessage();
        }
    }

    public void head(PrintWriter printWriter) throws Exception {
        super.head(printWriter);
        if (this.page == 8) {
            StringBuffer stringBuffer = new StringBuffer(200);
            this.dm.writeDateScript(stringBuffer);
            printWriter.println(stringBuffer.substring(0));
        }
    }

    public void body(PrintWriter printWriter) throws Exception {
        super.body(printWriter);
        StringBuffer stringBuffer = new StringBuffer(2000);
        StringBuffer stringBuffer2 = new StringBuffer(500);
        boolean bl = false;
        stringBuffer.append(GroupAdmin.linkTo(GroupAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        if (this.page != 0) {
            stringBuffer.append(" | ").append(GroupAdmin.linkTo(this.getUrl(), this.getMsg(TITLE), null));
        }
        this.standardHeader(printWriter, GroupAdmin.filter(this.getTitle(this.bundle)), stringBuffer.substring(0));
        stringBuffer.setLength(0);
        if (this.gd == null && this.page != 4 && this.page != 0) {
            this.page = 10;
            if (this.errMsg == null) {
                this.errMsg = this.getMsg("bad_data");
            }
        }
        switch (this.page) {
            case 0: {
                stringBuffer.append("<table class=\"tblA\" width=400>\n");
                stringBuffer.append("<tr><th>").append(this.getMsg("group_admin_groups")).append("</th></tr>\n");
                Iterator iterator = this.groups.iterator();
                while (iterator.hasNext()) {
                    GroupData groupData = (GroupData)iterator.next();
                    String string = GroupAdmin.urlParam(this.getUrl(1), GROUP, groupData.getId());
                    stringBuffer.append("<tr><td><a href=\"").append(string).append("\">").append(GroupAdmin.filter(groupData.getText()));
                    stringBuffer.append("</a></td></tr>\n");
                }
                stringBuffer.append("</table>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                stringBuffer.append("<form>");
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(4), this.getMsg("group_admin_new_button"), null));
                stringBuffer.append("</form>");
                break;
            }
            case 1: {
                stringBuffer.append("<form class=\"info\">\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_id")).append("</strong> ").append(GroupAdmin.filter(this.gd.getId())).append("</p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_name")).append("</strong> ").append(GroupAdmin.filter(this.gd.getText())).append("</p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_icon")).append(" ");
                if (this.gd.getIconUrl() != null && this.gd.getIconUrl().length() > 0) {
                    stringBuffer.append("<img src=\"").append(GroupAdmin.filter(this.gd.getIconUrl())).append("\" title=\"");
                    stringBuffer.append(GroupAdmin.filter(this.gd.getIconUrl())).append("\">");
                } else {
                    stringBuffer.append("---");
                }
                stringBuffer.append("</p>\n");
                stringBuffer.append("<p>");
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(2), this.getMsg("group_admin_edit_button"), null));
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(6), this.getMsg("group_admin_delete_button"), null));
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(8), this.getMsg("group_admin_clear_button"), null));
                stringBuffer.append("</p>\n");
                stringBuffer.append("</form>\n<br clear=\"all\">\n");
                if (this.users != null && this.users.size() > 0) {
                    stringBuffer.append("<table class=\"tblA\" width=500>\n");
                    stringBuffer.append("<tr><th>").append(this.getMsg("group_admin_users")).append("</th></tr>\n");
                    Iterator iterator = this.users.iterator();
                    while (iterator.hasNext()) {
                        UserData userData = (UserData)iterator.next();
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(UserAdmin.URL);
                        GroupAdmin.urlParamSb(stringBuffer2, "lang", this.lang, true);
                        GroupAdmin.urlParamSb(stringBuffer2, GROUP, this.gd.getId(), false);
                        GroupAdmin.urlParamSb(stringBuffer2, "user", userData.getId(), false);
                        stringBuffer.append("<tr><td><a href=\"").append(stringBuffer2.substring(0)).append("\">").append(GroupAdmin.filter(userData.getText()));
                        stringBuffer.append("</a></td></tr>\n");
                    }
                    stringBuffer.append("</table>\n");
                    stringBuffer.append("<br clear=\"all\">");
                } else {
                    stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_no_users")).append("</strong></p>\n");
                }
                stringBuffer.append("<form>");
                stringBuffer2.setLength(0);
                stringBuffer2.append(UserAdmin.URL);
                GroupAdmin.urlParamSb(stringBuffer2, "lang", this.lang, true);
                GroupAdmin.urlParamSb(stringBuffer2, "action", UserAdmin.ACTIONS[3], false);
                GroupAdmin.urlParamSb(stringBuffer2, GROUP, this.gd.getId(), false);
                stringBuffer.append(GroupAdmin.buttonTo(stringBuffer2.substring(0), this.getMsg("group_admin_create_user_button"), null));
                stringBuffer.append("</form>\n");
                break;
            }
            case 2: {
                bl = true;
            }
            case 4: {
                String string = this.gd != null ? this.gd.getId() : this.getParamNotNull(ID).trim();
                String string2 = this.gd != null ? this.gd.getText() : this.getParamNotNull(NAME).trim();
                String string3 = this.gd != null ? this.gd.getIconUrl() : this.getParamNotNull(ICON).trim();
                stringBuffer.append("<form class=\"inputForm\" method=\"post\" action=\"").append(this.getUrl(bl ? 3 : 5)).append("\">\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_id")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(ID).append("\" value=\"").append(GroupAdmin.filter(string)).append("\" size=40");
                if (bl) {
                    stringBuffer.append(" readonly");
                }
                stringBuffer.append("></p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_name")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(NAME).append("\" value=\"").append(GroupAdmin.filter(string2)).append("\" size=40></p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_icon")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(ICON).append("\" value=\"").append(GroupAdmin.filter(string3)).append("\" size=40></p>\n");
                stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"> ");
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(bl ? 1 : 0), this.getMsg("cancel"), null));
                stringBuffer.append("</p>\n");
                stringBuffer.append("</form>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                break;
            }
            case 6: {
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_delete_group")).append(" \"").append(GroupAdmin.filter(this.gd.getText())).append("\"</strong></p>\n");
                stringBuffer.append("<p>").append(this.getMsg("group_admin_delete_group_explain")).append("</p>\n");
                stringBuffer.append("<p>").append(this.getMsg("report_areyousure")).append("</p>\n");
                stringBuffer.append("<form method=\"post\" action=\"").append(this.getUrl(7)).append("\">\n");
                stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("YES")).append("\" width=50>\n");
                stringBuffer.append(GroupAdmin.buttonTo(this.getUrl(1), this.getMsg("NOT"), " width=50"));
                stringBuffer.append("</p>\n");
                stringBuffer.append("</form>\n");
                break;
            }
            case 8: {
                stringBuffer.append("<p><strong>").append(this.getMsg("group_admin_clear_group")).append(" \"").append(GroupAdmin.filter(this.gd.getText())).append("\"</strong></p>\n");
                stringBuffer.append("<p>").append(this.getMsg("group_admin_clear_group_explain")).append("</p>\n");
                stringBuffer.append("<form class=\"inputForm\" action=\"").append(this.getUrl(9)).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
                this.dm.writeHiddenFields(stringBuffer);
                stringBuffer2.setLength(0);
                stringBuffer2.append("document.").append("mainForm").append(".submit()");
                this.dm.zonaData(stringBuffer, GroupAdmin.buttonAction(stringBuffer2.substring(0), this.getMsg("db_clear_reports_date"), null));
                stringBuffer.append("</form>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                break;
            }
            default: {
                stringBuffer.append("<p><strong>").append(this.getMsg("error")).append("</strong></p>\n");
                if (this.errMsg != null) {
                    stringBuffer.append("<p>").append(this.errMsg).append("</p>\n");
                }
                if (this.returnUrl == null) break;
                stringBuffer.append("<p><a href=\"").append(this.returnUrl).append("\">").append(this.getMsg("return")).append("</a></p>\n");
            }
        }
        printWriter.println(stringBuffer.substring(0));
    }
}

