/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.servlet.RequestProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServlet
extends HttpServlet {
    public AbstractServlet() {
        RequestProcessor.setDirectResources(true);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Enumeration enumeration = servletConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            HashMap hashMap = new HashMap();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = servletConfig.getInitParameter(string);
            }
            RequestProcessor.config(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        RequestProcessor requestProcessor = null;
        try {
            String[] stringArray;
            Object object;
            Object object2;
            requestProcessor = this.createRP();
            if (requestProcessor.wantsInputStream()) {
                requestProcessor.setInputStream((InputStream)httpServletRequest.getInputStream());
            } else {
                requestProcessor.setParams(httpServletRequest.getParameterMap());
            }
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray != null) {
                for (int i = 0; i < cookieArray.length; ++i) {
                    requestProcessor.setCookie(cookieArray[i].getName(), cookieArray[i].getValue());
                }
            }
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = httpServletRequest.getHeaders((String)object2);
                stringArray = new Vector();
                while (object.hasMoreElements()) {
                    stringArray.add(object.nextElement());
                }
                hashMap.put(((String)object2).toLowerCase(), stringArray);
            }
            requestProcessor.setHeaders(hashMap);
            requestProcessor.init();
            if (requestProcessor.noCache()) {
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setHeader("Cache-Control", "no-cache");
                httpServletResponse.setHeader("Expires", "0");
            }
            object2 = new Vector();
            requestProcessor.header((Vector)object2);
            if (!((Vector)object2).isEmpty()) {
                object = ((Vector)object2).iterator();
                while (object.hasNext() && !httpServletResponse.isCommitted()) {
                    stringArray = (String[])object.next();
                    if (stringArray[0].equals("ERROR")) {
                        int n = Integer.parseInt(stringArray[1]);
                        httpServletResponse.sendError(n, stringArray[2]);
                    }
                    if (stringArray[0].equals("REDIRECT")) {
                        httpServletResponse.sendRedirect(stringArray[1]);
                        break;
                    }
                    if (stringArray[0].equals("CONTENT_TYPE")) {
                        httpServletResponse.setContentType(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("CONTENT_LENGTH")) {
                        httpServletResponse.setContentLength(Integer.parseInt(stringArray[1]));
                        continue;
                    }
                    if (stringArray[0].equals("EXTRA")) {
                        httpServletResponse.setHeader(stringArray[1], stringArray[2]);
                        continue;
                    }
                    if (!stringArray[0].equals("COOKIE")) continue;
                    httpServletResponse.addCookie(new Cookie(stringArray[1], stringArray[2]));
                }
            }
            if (!httpServletResponse.isCommitted()) {
                if (requestProcessor.usesWriter()) {
                    object = httpServletResponse.getWriter();
                    requestProcessor.process((PrintWriter)object);
                    try {
                        ((PrintWriter)object).flush();
                        ((PrintWriter)object).close();
                    }
                    catch (Exception exception) {}
                } else {
                    object = httpServletResponse.getOutputStream();
                    requestProcessor.process((OutputStream)object);
                    try {
                        ((OutputStream)object).flush();
                        ((OutputStream)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            requestProcessor.end();
            requestProcessor = null;
        }
        catch (Exception exception) {
            String string;
            int n = requestProcessor.errCode >= 0 ? requestProcessor.errCode : 500;
            String string2 = string = requestProcessor.errMsg != null ? requestProcessor.errMsg : exception.getMessage();
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(n, string);
            }
            System.err.println("ERROR " + n + ": " + string);
            exception.printStackTrace(System.err);
        }
        finally {
            if (requestProcessor != null) {
                requestProcessor.end();
            }
        }
    }

    protected abstract RequestProcessor createRP() throws Exception;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }
}

