/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"
#include "mltlang.h"

#define	ID_DUMMY	ID_CNSKIPBLANK

UIFinDetailsDlg* CreateFinDetailsDlg(UIDialog *parent)
{
	UIFinDetailsDlg *dialog;

	dialog = (UIFinDetailsDlg *)CreateDialog(sizeof(UIFinDetailsDlg), parent);

	if(dialog == NULL)
		return NULL;

	UI_DIALOG(dialog)->window = create_FinDetail_dialog();

	ComboSignalConnect(UI_DIALOG(dialog)->window, "FinDetail_Img_combo", GTK_SIGNAL_FUNC(on_FinDetail_Img_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "FinDetail_Fix_combo", GTK_SIGNAL_FUNC(on_FinDetail_Fix_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "FinDetail_RevicePostcard_combo", GTK_SIGNAL_FUNC(on_FinDetail_RevicePostcard_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "CaptFinishingCurlCorrection_combo", GTK_SIGNAL_FUNC(on_CaptFinishingCurlCorrection_combo_popwin_event));
	ConnectTextViewSignal(UI_DIALOG(dialog)->window, "JobDetails_textview", GTK_SIGNAL_FUNC(on_JobDetails_textbuffer_changed));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "CaptFinDetail_Wrinkles_combo", GTK_SIGNAL_FUNC(on_CaptFinDetail_Wrinkles_combo_popwin_event));

	return dialog;
}

void ShowFinDetailsDlg(UIFinDetailsDlg *dialog)
{
	dialog->code = GetCharSet();
	SigDisable();
	UpdateFinDetailsDlgWidgets(dialog, NULL);
	SigEnable();
	ShowDialog((UIDialog *)dialog, "FinDetail_button");
}

void HideFinDetailsDlg(UIFinDetailsDlg *dialog, int apply)
{
	char *text;
	text = cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "FinDetail");
	UpdateWidget(ID_DUMMY, text);
	HideDialog((UIDialog *)dialog);
}

void UpdateFinDetailsDlgWidgets(UIFinDetailsDlg *detail, char *except_name)
{
	GtkWidget *window;
	gchar *cur;
	int active = 0;
	int sep1 = 0, sep2 = 0;
	int printer_type;
	int sepupper = 0, seplower = 0;
	char *trust_print = NULL;

	window = UI_DIALOG(detail)->window;

	printer_type = GetCurrOptInt(ID_PRINTERTYPE, 0);
	if(printer_type == PRINTER_TYPE_CAPT){
		if((cur = GetCurrOpt(ID_CNFIXINGMODE, NULL)) != NULL){
			ShowWidget(window, "FinDetail_AdvancedSetting_frame");
			ShowWidget(window, "FinDetail_FiximgMode_hbox");
			memFree(cur);
			GetOptToGList(window, ID_CNFIXINGMODE, "FinDetail_Fix_combo");
			sep2++;
		}

		if((cur = GetCurrOpt(ID_CNSUPERSMOOTH, NULL)) != NULL){
			ShowWidget(window, "FinDetail_AdvancedSetting_frame");
			ShowWidget(window, "FinDetail_ImgRef_hbox");
			memFree(cur);
			GetOptToGList(window, ID_CNSUPERSMOOTH, "FinDetail_Img_combo");
			sep2++;
		}

		if((cur = GetCurrOpt(ID_CNREVICEPOSTCARD, NULL)) != NULL){
			ShowWidget(window, "FinDetail_AdvancedSetting_frame");
			ShowWidget(window, "FinDetail_RevicePostcard_hbox");
			memFree(cur);
			GetOptToGList(window, ID_CNREVICEPOSTCARD, "FinDetail_RevicePostcard_combo");
			sep2++;
		}
		if((cur = GetCurrOpt(ID_CNWRINKLESCORRECTIONOUTPUT, NULL)) != NULL){
			ShowWidget(window, "FinDetail_AdvancedSetting_frame");
			ShowWidget(window, "CaptFinDetail_Wrinkles_hbox");
			memFree(cur);
			GetOptToGList(window, ID_CNWRINKLESCORRECTIONOUTPUT, "CaptFinDetail_Wrinkles_combo");
			sep2++;
		}

		cur = GetCurrOpt(ID_CNBACKPAPERPRINT, NULL);
		if(cur != NULL){
			char *label = cngplpGetData(CNGPLP_DATA(), ID_BACKPAPERPRINT_LABEL);
			char *text = NameToText(ID_BACKPAPERPRINT_LABEL, label);

			ShowWidget(window, "FinDetail_AdvancedSetting_frame");
			ShowWidget(window, "FinDetail_BackPrint_checkbutton");
			active = (strcmp(cur, "True") == 0) ? 1 : 0;
			SetActiveCheckButton(window, "FinDetail_BackPrint_checkbutton", active);
			if(text != NULL)
				SetButtonLabel(window, "FinDetail_BackPrint_checkbutton", text);
			memFree(cur);
			memFree(label);
			if(sep2)
				ShowWidget(window, "hseparator18");
			sepupper++;
		}

		if((cur = GetCurrOpt(ID_CNCURLCORRECTION, NULL)) != NULL){
			ShowWidget(window, "CaptFinishingCurlCorrection_frame");
			ShowWidget(window, "CaptFinishingCurlCorrection_hbox");
			memFree(cur);
			GetOptToGList(window, ID_CNCURLCORRECTION, "CaptFinishingCurlCorrection_combo");
			sepupper++;
		}

		cur = GetCurrOpt(ID_CNROTATEPRINT, NULL);
		if(cur != NULL){
			ShowWidget(window, "FinDetail_RotatePrint_checkbutton");
			active = (strcmp(cur, "True") == 0) ? 1 : 0;
			SetActiveCheckButton(window, "FinDetail_RotatePrint_checkbutton", active);
			memFree(cur);
			sep1++;
		}

		cur = GetCurrOpt(ID_CNSKIPBLANK, NULL);
		if(cur != NULL){
			ShowWidget(window, "FinDetail_SkipBlank_checkbutton");
			active = (strcmp(cur, "True") == 0) ? 1 : 0;
			SetActiveCheckButton(window, "FinDetail_SkipBlank_checkbutton", active);
			memFree(cur);
			sep1++;
		}

		cur = GetCurrOpt(ID_CNDETECTPAPERSIZE, NULL);
		if(cur != NULL){
			char *label = cngplpGetData(CNGPLP_DATA(), ID_DETECTPAPER_LABEL);
			char *text = NameToText(ID_DETECTPAPER_LABEL, label);
			ShowWidget(window, "FinDetail_DetectPaper_checkbutton");
			active = (strcmp(cur, "True") == 0) ? 1 : 0;
			SetActiveCheckButton(window, "FinDetail_DetectPaper_checkbutton", active);
			if(text != NULL)
				SetButtonLabel(window, "FinDetail_DetectPaper_checkbutton", text);
			memFree(cur);
			memFree(label);
			sep1++;
		}
		if(sep1)
		ShowWidget(window, "hseparator17");
	}else{
		cur = GetCurrOpt(ID_CNJOBNOTE, NULL);
		if(cur != NULL){
			ShowWidget(window, "JobNote_frame");
			SetTextEntry(window, "JobNote_entry", cur);
			memFree(cur);
			sepupper++;
		}
		cur = GetCurrOpt(ID_CNJOBDETAILS, NULL);
		if(cur != NULL){
			SetTextofTextView(window, "JobDetails_textview", cur, -1);
			memFree(cur);
		}

		SetWidgetSensitive(window, "JobNote_frame", TRUE);
		cur = GetCurrOpt(ID_CNJOBEXECMODE, NULL);
		if(cur != NULL){
			if(strcmp(cur, "store") == 0 ||strcmp(cur, "hold") == 0)
				SetWidgetSensitive(window, "JobNote_frame", FALSE);
			memFree(cur);
		}
		trust_print = GetCurrOpt(ID_CNTRUSTPRINT, NULL);
		if(trust_print != NULL){
			ShowWidget(window, "TrustPrint_checkbutton");
			SetCpcaWidgetSensitive(UI_DLG_TOP(detail)->prop, ID_CNTRUSTPRINT, "TrustPrint_checkbutton");
			memFree(trust_print);
			seplower++;
		}
	}

	cur = GetCurrOpt(ID_CNCOPYSETNUMBERING, NULL);
	if(cur != NULL){
		UpdateCopySetNumbering(UI_DLG_TOP(detail)->prop);
		memFree(cur);
		seplower++;
	}

	sepupper =  sepupper + sep1 + sep2;
	if(sepupper == 0 || seplower == 0)
		HideWidget(window, "hseparator29");
}
