/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2 Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"

UIFrontBackCvrDlg* CreateFrontBackCvrDlg(UIDialog *parent)
{
	UIFrontBackCvrDlg *dialog;

	dialog = (UIFrontBackCvrDlg *)CreateDialog(sizeof(UIFrontBackCvrDlg), parent);

	if(dialog == NULL)
		return NULL;

	UI_DIALOG(dialog)->window = create_FrontBackCvrSetDlg();

	ComboSignalConnect(UI_DIALOG(dialog)->window, "FrontCvrPrintSide_combo", GTK_SIGNAL_FUNC(on_FrontCvrPrintSide_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "FrontCvrPaperSrc_combo", GTK_SIGNAL_FUNC(on_FrontCvrPaperSrc_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "BackCvrPrintSide_combo", GTK_SIGNAL_FUNC(on_BackCvrPrintSide_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "BackCvrPaperSrc_combo", GTK_SIGNAL_FUNC(on_BackCvrPaperSrc_combo_popwin_event));

	return dialog;
}

void ShowFrontBackCvrDlg(UIFrontBackCvrDlg *dialog)
{
	cngplpSetData(UI_DLG_TOP(dialog)->data, ID_SHOWDLG, "FrontBackCvr");
	SigDisable();
	UpdateFrontBackCvrDlgWidgets(dialog);
	SigEnable();
	ShowDialog((UIDialog *)dialog, "FrontBackCvrSet_button");
}

void HideFrontBackCvrDlg(UIFrontBackCvrDlg *dialog, int apply)
{
	HideDialog((UIDialog *)dialog);
	cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "FrontBackCvr");
}

void UpdateFrontBackCvrDlgWidgets(UIFrontBackCvrDlg *dialog)
{
	GtkWidget *window;
	gchar *cur;
	int active_front = 0;
	int active_back = 0;

	window = UI_DIALOG(dialog)->window;

	if((cur = GetCurrOpt(ID_CNSET_FRONT_COVER, NULL)) != NULL){
		ShowWidget(window, "FrontCvr_frame");
		ShowWidget(window, "FrontCvr_checkbutton");
		active_front = (strcmp(cur, "True") == 0) ? 1 : 0;
		SetActiveCheckButton(window, "FrontCvr_checkbutton", active_front);
		memFree(cur);
	}

	if((cur = GetCurrOpt(ID_CNFRONT_PRINT_SHEET, NULL)) != NULL){
		ShowWidget(window, "FrontCvr_frame");
		ShowWidget(window, "FrontCvrPrintSide_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNFRONT_PRINT_SHEET, "FrontCvrPrintSide_combo");
		SetWidgetSensitive(window, "FrontCvrPrintSide_hbox", active_front);
		if(active_front == 0)
			SetTextEntry(window, "FrontCvrPrintSide_combo_entry", "------------");
	}

	if((cur = GetCurrOpt(ID_CNFRONT_PAPER_SRC, NULL)) != NULL){
		ShowWidget(window, "FrontCvr_frame");
		ShowWidget(window, "FrontCvrPaperSrc_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNFRONT_PAPER_SRC, "FrontCvrPaperSrc_combo");
		SetWidgetSensitive(window, "FrontCvrPaperSrc_hbox", active_front);
		if(active_front == 0)
			SetTextEntry(window, "FrontCvrPaperSrc_combo_entry", "------------");
	}

	if((cur = GetCurrOpt(ID_CNSET_BACK_COVER, NULL)) != NULL){
		ShowWidget(window, "BackCvr_frame");
		ShowWidget(window, "BackCvr_checkbutton");
		active_back = (strcmp(cur, "True") == 0) ? 1 : 0;
		SetActiveCheckButton(window, "BackCvr_checkbutton", active_back);
		memFree(cur);
	}

	if((cur = GetCurrOpt(ID_CNBACK_PRINT_SHEET, NULL)) != NULL){
		ShowWidget(window, "BackCvr_frame");
		ShowWidget(window, "BackCvrPrintSide_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNBACK_PRINT_SHEET, "BackCvrPrintSide_combo");
		SetWidgetSensitive(window, "BackCvrPrintSide_hbox", active_back);
		if(active_back == 0)
			SetTextEntry(window, "BackCvrPrintSide_combo_entry", "------------");
	}

	if((cur = GetCurrOpt(ID_CNBACK_PAPER_SRC, NULL)) != NULL){
		ShowWidget(window, "BackCvr_frame");
		ShowWidget(window, "BackCvrPaperSrc_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNBACK_PAPER_SRC, "BackCvrPaperSrc_combo");
		SetWidgetSensitive(window, "BackCvrPaperSrc_hbox", active_back);
		if(active_back == 0)
			SetTextEntry(window, "BackCvrPaperSrc_combo_entry", "------------");
	}
}

