/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class ActiveBoxBag
extends BoxBag
implements Cloneable {
    private static final int NOT_USED = -12345;

    public ActiveBoxBag(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
    }

    public final void addActiveBox(ActiveBox activeBox) {
        activeBox.idOrder = activeBox.idLoc = this.cells.size();
        super.addBox(activeBox);
    }

    public ActiveBox getActiveBox(int n) {
        return (ActiveBox)super.getBox(n);
    }

    public ActiveBox getBackgroundActiveBox() {
        return (ActiveBox)this.getBackgroundBox();
    }

    public void setContent(ActiveBagContent activeBagContent) {
        this.setContent(activeBagContent, null);
    }

    public void setContent(ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2) {
        this.setContent(activeBagContent, activeBagContent2, 0, 0, this.getNumCells());
    }

    public void setContent(ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2, int n, int n2, int n3) {
        ActiveBox activeBox;
        for (int i = 0; i < n3; ++i) {
            activeBox = this.getActiveBox(n2 + i);
            activeBox.setContent(activeBagContent, n + i);
            activeBox.setAlternative(false);
            if (activeBagContent2 == null) continue;
            activeBox.setAltContent(activeBagContent2, n + i);
        }
        if (activeBagContent.backgroundContent != null && (activeBox = this.getBackgroundActiveBox()) != null) {
            activeBox.setContent(activeBagContent.backgroundContent);
            if (activeBagContent.bb != activeBox.getBoxBaseX()) {
                activeBox.setBoxBase(activeBagContent.bb);
            }
        }
    }

    public ActiveBox findActiveBox(Point2D point2D) {
        return (ActiveBox)super.findBox(point2D);
    }

    public void clearAll() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getActiveBox(i).clear();
        }
        if (this.backgroundBox != null) {
            this.getBackgroundActiveBox().clear();
        }
    }

    public int countCellsAtPlace() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getActiveBox(i).isAtPlace()) continue;
            ++n;
        }
        return n;
    }

    public ActiveBox getActiveBoxWithIdLoc(int n) {
        for (int i = 0; i < this.cells.size(); ++i) {
            ActiveBox activeBox = this.getActiveBox(i);
            if (activeBox.idLoc != n) continue;
            return activeBox;
        }
        return null;
    }

    public boolean cellIsAtEquivalentPlace(ActiveBox activeBox, boolean bl) {
        return activeBox.isAtPlace() || activeBox.isEquivalent(this.getActiveBoxWithIdLoc(activeBox.idOrder), bl);
    }

    public int countCellsAtEquivalentPlace(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.cellIsAtEquivalentPlace(this.getActiveBox(i), bl)) continue;
            ++n;
        }
        return n;
    }

    public int countCellsWithIdAss(int n) {
        int n2 = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (this.getActiveBox((int)i).idAss != n) continue;
            ++n2;
        }
        return n2;
    }

    public int countInactiveCells() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getActiveBox(i).isInactive()) continue;
            ++n;
        }
        return n;
    }

    public void setDefaultIdAss() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getActiveBox(i).setDefaultIdAss();
        }
    }

    public void scrambleCells(int n, boolean bl) {
        int n2 = this.cells.size();
        if (n2 >= 2) {
            Point2D[] point2DArray = new Point2D[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                ActiveBox activeBox = this.getActiveBox(i);
                point2DArray[i] = new Point2D.Double();
                point2DArray[i].setLocation(activeBox.getLocation());
                nArray[i] = activeBox.idLoc;
            }
            Point2D.Double double_ = new Point2D.Double();
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4 = (int)(Math.random() * (double)n2);
                if (n4 == (n3 = (int)(Math.random() * (double)n2))) continue;
                double_.setLocation(point2DArray[n4]);
                point2DArray[n4].setLocation(point2DArray[n3]);
                point2DArray[n3].setLocation(double_);
                int n5 = nArray[n4];
                nArray[n4] = nArray[n3];
                nArray[n3] = n5;
            }
            double d = this.x + this.width;
            double d2 = this.y + this.height;
            for (int i = 0; i < n2; ++i) {
                ActiveBox activeBox = this.getActiveBox(i);
                double d3 = point2DArray[i].getX();
                double d4 = point2DArray[i].getY();
                if (bl) {
                    d3 = Math.min(Math.max(d3, this.x), d - activeBox.width);
                    d4 = Math.min(Math.max(d4, this.y), d2 - activeBox.height);
                }
                activeBox.setLocation(d3, d4);
                activeBox.idLoc = nArray[i];
            }
        }
    }

    public void resetIds() {
        for (int i = 0; i < this.cells.size(); ++i) {
            ActiveBox activeBox = (ActiveBox)this.cells.get(i);
            if (activeBox == null) continue;
            activeBox.idOrder = i;
            activeBox.idAss = i;
            activeBox.idLoc = i;
        }
    }

    public int getNextItem(int n) {
        return this.getNextItem(n, -12345);
    }

    public int getNextItem(int n, int n2) {
        ActiveBox activeBox;
        int n3;
        for (n3 = n + 1; n3 < this.cells.size() && (activeBox = (ActiveBox)this.cells.get(n3)) != null && !(n2 != -12345 ? n2 == activeBox.idAss : activeBox.idAss >= 0); ++n3) {
        }
        return n3;
    }
}

