/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.StrUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class ActiveBoxGrid
extends ActiveBoxBag
implements Cloneable {
    public int nCols;
    public int nRows;

    public ActiveBoxGrid(AbstractBox abstractBox, JComponent jComponent, double d, double d2, double d3, double d4, Shaper shaper, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
        Shape shape;
        this.nCols = shaper.getNumColumns();
        this.nRows = shaper.getNumRows();
        Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 / (double)this.nCols) * this.nCols, (int)(d4 / (double)this.nRows) * this.nRows);
        this.ensureCapacity(shaper.getNumCells());
        for (int i = 0; i < shaper.getNumCells(); ++i) {
            shape = shaper.getShape(i, rectangle);
            ActiveBox activeBox = new ActiveBox(this, null, i, shape.getBounds2D(), null);
            if (!shaper.rectangularShapes()) {
                activeBox.setShape(shape);
            }
            this.addActiveBox(activeBox);
        }
        if (shaper.hasRemainder()) {
            Shape shape2 = shaper.getRemainderShape(rectangle);
            shape = new ActiveBox(this, null, 0, shape2.getBounds2D(), null);
            ((AbstractBox)shape).setShape(shape2);
            this.setBackgroundBox((AbstractBox)shape);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(10 * this.nCols, 10 * this.nRows);
    }

    public Dimension getScaledSize(double d) {
        return new Dimension(StrUtils.roundTo(d * this.preferredBounds.getWidth(), this.nCols), StrUtils.roundTo(d * this.preferredBounds.getHeight(), this.nRows));
    }

    public static ActiveBoxGrid createEmptyGrid(AbstractBox abstractBox, JComponent jComponent, double d, double d2, ActiveBagContent activeBagContent, Shaper shaper, BoxBase boxBase) {
        ActiveBoxGrid activeBoxGrid = null;
        if (activeBagContent != null) {
            activeBoxGrid = new ActiveBoxGrid(abstractBox, jComponent, d, d2, activeBagContent.getTotalWidth(), activeBagContent.getTotalHeight(), shaper == null ? activeBagContent.getShaper() : shaper, boxBase == null ? activeBagContent.bb : boxBase);
            activeBoxGrid.setBorder(activeBagContent.border);
        }
        return activeBoxGrid;
    }

    public static ActiveBoxGrid createEmptyGrid(ActiveBox activeBox, JComponent jComponent, double d, double d2, ActiveBagContent activeBagContent) {
        return ActiveBoxGrid.createEmptyGrid(activeBox, jComponent, d, d2, activeBagContent, null, null);
    }

    public Point getCoord(ActiveBox activeBox) {
        int n = activeBox.idLoc / this.nCols;
        int n2 = activeBox.idLoc % this.nCols;
        return new Point(n2, n);
    }

    public Point getCoordDist(ActiveBox activeBox, ActiveBox activeBox2) {
        Point point = this.getCoord(activeBox);
        Point point2 = this.getCoord(activeBox2);
        return new Point(point2.x - point.x, point2.y - point.y);
    }
}

