/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.SystemColor;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class Editor
extends DefaultMutableTreeNode {
    protected HashSet listeners = new HashSet();
    protected DefaultTreeModel treeModel;
    protected JTree currentTree;
    protected ListSelectionModel listSelectionModel;
    protected LModel listModel;
    private boolean modified;
    public static EditorAction moveUpAction;
    public static EditorAction moveDownAction;
    public static EditorAction copyAction;
    public static EditorAction cutAction;
    public static EditorAction pasteAction;
    public static EditorAction deleteAction;
    protected static Editor clip;
    protected static boolean clipCutted;
    protected static boolean basicActionsCreated;
    protected boolean restrictMoveToSameType = true;
    protected boolean allowCopy = false;
    protected boolean allowCut = false;
    protected boolean allowPaste = false;
    protected boolean allowDelete = false;

    protected Editor(Object object) {
        super(object);
    }

    public static Editor createEditor(String string, Object object, Editor editor) {
        Editor editor2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray == null || classArray.length != 1 || !classArray[0].isInstance(object)) continue;
                constructor = constructorArray[i];
                break;
            }
            editor2 = (Editor)constructor.newInstance(object);
            if (editor != null) {
                editor.add(editor2);
            }
            editor2.createChildren();
        }
        catch (Exception exception) {
            System.err.println("Unable to create " + string + " for " + object + "\n" + exception);
        }
        return editor2;
    }

    protected abstract void createChildren();

    public String getTitleKey() {
        return "edit_data";
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (bl) {
            Editor editor = this.getEditorParent();
            if (editor != null) {
                editor.setModified(true);
            }
        } else {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                ((Editor)enumeration.nextElement()).setModified(false);
            }
        }
    }

    public DefaultTreeModel getTreeModel() {
        if (this.isRoot()) {
            if (this.treeModel == null) {
                this.setTreeModel(new DefaultTreeModel(this));
            }
            return this.treeModel;
        }
        return this.treeModel != null ? this.treeModel : this.getEditorParent().getTreeModel();
    }

    public void setTreeModel(DefaultTreeModel defaultTreeModel) {
        this.treeModel = defaultTreeModel;
    }

    public void setCurrentTree(JTree jTree) {
        this.currentTree = jTree;
    }

    public JTree getCurrentTree() {
        return this.currentTree != null ? this.currentTree : (this.isRoot() ? null : this.getEditorParent().getCurrentTree());
    }

    public JTree createJTree() {
        this.setCurrentTree(new JTree(this.getTreeModel()));
        this.currentTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof Editor) {
                    Icon icon = ((Editor)object).getIcon(bl3, bl2);
                    if (icon != null) {
                        this.setIcon(icon);
                    }
                    if (clip == object && clipCutted) {
                        this.setForeground(SystemColor.textInactiveText);
                    }
                }
                return this;
            }
        });
        return this.currentTree;
    }

    public AbstractListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new LModel();
        }
        return this.listModel;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        super.insert(mutableTreeNode, n);
        if (this.listModel != null) {
            this.listModel.fireIntervalAdded(this.listModel, n, n);
        }
    }

    public void remove(int n) {
        super.remove(n);
        if (this.listModel != null) {
            this.listModel.fireIntervalRemoved(this.listModel, n, n);
        }
    }

    public void select() {
        int n;
        Editor editor;
        JTree jTree = this.getCurrentTree();
        if (jTree != null) {
            jTree.getSelectionModel().setSelectionPath(new TreePath(this.getPath()));
        }
        if (this.getListSelectionModel() != null && (editor = this.getEditorParent()) != null && (n = editor.getIndex(this)) >= 0) {
            this.getListSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void reselect() {
        int n;
        Editor editor;
        JTree jTree = this.getCurrentTree();
        if (jTree != null) {
            jTree.getSelectionModel().clearSelection();
            jTree.getSelectionModel().setSelectionPath(new TreePath(this.getPath()));
        }
        if (this.getListSelectionModel() != null && (editor = this.getEditorParent()) != null && (n = editor.getIndex(this)) >= 0) {
            this.getListSelectionModel().removeIndexInterval(n, n);
            this.getListSelectionModel().setSelectionInterval(n, n);
        }
    }

    public int getNearestIndex(Editor editor, boolean bl) {
        int n;
        int n2;
        int n3 = n2 = bl ? this.getChildCount() : 0;
        if (editor != null && (n = this.getIndex(editor)) >= 0) {
            n2 = n + (bl ? 1 : 0);
        }
        return n2;
    }

    protected boolean canClone() {
        return false;
    }

    protected Editor getClone() throws Exception {
        return null;
    }

    protected boolean delete(boolean bl) {
        boolean bl2 = false;
        Editor editor = this.getEditorParent();
        if (editor != null) {
            int n;
            editor.setModified(true);
            if (clip == this) {
                Editor.setClip(null, false);
            }
            if ((n = editor.getIndex(this)) == editor.getChildCount() - 1) {
                --n;
            }
            this.getTreeModel().removeNodeFromParent(this);
            if (bl) {
                Editor editor2;
                Editor editor3 = editor2 = n >= 0 ? (Editor)editor.getChildAt(n) : editor;
                if (editor2 != null) {
                    editor2.select();
                }
            }
            bl2 = true;
        }
        return bl2;
    }

    public boolean moveToIndex(int n, boolean bl) {
        boolean bl2 = false;
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        Editor editor = this.getEditorParent();
        if (editor != null && defaultTreeModel != null && (n = Math.min(Math.max(0, n), editor.getChildCount())) != editor.getIndex(this)) {
            editor.setModified(true);
            defaultTreeModel.removeNodeFromParent(this);
            defaultTreeModel.insertNodeInto(this, editor, n);
            bl2 = true;
            if (bl) {
                this.select();
            }
        }
        return bl2;
    }

    public boolean moveUp(boolean bl) {
        boolean bl2 = false;
        Editor editor = this.getEditorParent();
        if (editor != null) {
            int n = this.parent.getIndex(this);
            bl2 = this.moveToIndex(n - 1, bl);
        }
        return bl2;
    }

    public boolean moveDown(boolean bl) {
        boolean bl2 = false;
        Editor editor = this.getEditorParent();
        if (editor != null) {
            int n = this.parent.getIndex(this);
            bl2 = this.moveToIndex(n + 1, bl);
        }
        return bl2;
    }

    public boolean copy() {
        boolean bl = false;
        if (this.allowCopy && this.canClone()) {
            Editor.setClip(this, false);
            bl = true;
        }
        return bl;
    }

    protected static void setClip(Editor editor, boolean bl) {
        if (clip != null) {
            Editor editor2 = clip;
            clip = null;
            clipCutted = false;
            editor2.getTreeModel().nodeChanged(editor2);
        }
        clip = editor;
        clipCutted = bl;
        if (clip != null) {
            clip.getTreeModel().nodeChanged(clip);
        }
    }

    public boolean cut() {
        boolean bl = false;
        if (this.allowCut) {
            Editor.setClip(this, true);
            bl = true;
        }
        return bl;
    }

    public boolean canBeParentOf(Editor editor) {
        return !this.getClass().isInstance(editor);
    }

    public boolean canBeSiblingOf(Editor editor) {
        return true;
    }

    public boolean insertEditor(Editor editor, boolean bl, int n, boolean bl2) {
        boolean bl3 = false;
        if (editor != null) {
            if (bl) {
                this.setModified(true);
                if (n < 0) {
                    n = this.getChildCount();
                }
                this.getTreeModel().insertNodeInto(editor, this, n);
                bl3 = true;
                if (bl2) {
                    editor.select();
                }
            } else {
                Editor editor2 = this.getEditorParent();
                if (editor2 != null) {
                    editor2.setModified(true);
                    if (n < 0) {
                        n = editor2.getIndex(this);
                    }
                    bl3 = editor2.insertEditor(editor, true, n, bl2);
                }
            }
        }
        return bl3;
    }

    protected boolean canPasteHere() {
        return !(!this.allowPaste || clip == null || clipCutted && clip == this || !clipCutted && !clip.canClone() || !this.canBeParentOf(clip) && (!this.canBeSiblingOf(clip) || this.getEditorParent() == null));
    }

    public boolean paste(boolean bl) {
        boolean bl2 = false;
        if (this.canPasteHere()) {
            Editor editor = clip;
            if (clipCutted) {
                clip.delete(false);
            } else {
                try {
                    editor = clip.getClone();
                }
                catch (Exception exception) {
                    System.err.println("Unable to clone " + clip + "\n" + exception);
                    return false;
                }
            }
            bl2 = this.insertEditor(editor, this.canBeParentOf(editor), -1, bl);
            if (bl2) {
                Editor.setClip(clipCutted ? null : editor, false);
                if (bl) {
                    editor.select();
                }
            }
        }
        return bl2;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return null;
    }

    public Editor getEditorParent() {
        return (Editor)this.getParent();
    }

    public Editor getFirstParent(Class clazz) {
        Editor editor = this.getEditorParent();
        if (editor != null && !clazz.isInstance(editor)) {
            editor = editor.getFirstParent(clazz);
        }
        return editor;
    }

    public Editor getFirstChild(Class clazz) {
        Editor editor = null;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Editor editor2 = (Editor)enumeration.nextElement();
            if (!clazz.isInstance(editor2)) continue;
            editor = editor2;
            break;
        }
        return editor;
    }

    public Object getFirstObject(Class clazz) {
        Object object = this.getUserObject();
        if (!(object != null && clazz.isInstance(object) || this.isRoot())) {
            object = this.getEditorParent().getFirstObject(clazz);
        }
        return object;
    }

    public abstract Class getEditorPanelClass();

    public abstract EditorPanel createEditorPanel(Options var1);

    public String toString() {
        return "generic Editor component";
    }

    public Editor getChildByName(String string) {
        Editor editor = null;
        if (string != null) {
            Enumeration<TreeNode> enumeration = this.children();
            while (editor == null && enumeration.hasMoreElements()) {
                Editor editor2 = (Editor)enumeration.nextElement();
                if (!string.equals(editor2.toString())) continue;
                editor = editor2;
            }
        }
        return editor;
    }

    public static void createBasicActions(Options options) {
        if (!basicActionsCreated) {
            moveUpAction = new EditorAction("editor_moveUp", "icons/up.gif", "editor_moveUp_tooltip", options){

                protected void doAction(Editor editor) {
                    editor.moveUp(true);
                }
            };
            moveDownAction = new EditorAction("editor_moveDown", "icons/down.gif", "editor_moveDown_tooltip", options){

                protected void doAction(Editor editor) {
                    editor.moveDown(true);
                }
            };
            copyAction = new EditorAction("COPY", "icons/copy.gif", "COPY", options){

                protected void doAction(Editor editor) {
                    editor.copy();
                }
            };
            cutAction = new EditorAction("CUT", "icons/cut.gif", "CUT", options){

                protected void doAction(Editor editor) {
                    editor.cut();
                }
            };
            pasteAction = new EditorAction("PASTE", "icons/paste.gif", "PASTE", options){

                protected void doAction(Editor editor) {
                    editor.paste(true);
                }
            };
            deleteAction = new EditorAction("DELETE", "icons/delete.gif", "DELETE", options){

                protected void doAction(Editor editor) {
                    editor.delete(true);
                }
            };
            basicActionsCreated = true;
        }
    }

    public static void clearBasicActionsOwner() {
        if (basicActionsCreated) {
            moveUpAction.setActionOwner(null);
            moveDownAction.setActionOwner(null);
            copyAction.setActionOwner(null);
            cutAction.setActionOwner(null);
            pasteAction.setActionOwner(null);
            deleteAction.setActionOwner(null);
        }
    }

    public void setActionsOwner() {
        if (basicActionsCreated) {
            boolean bl = false;
            boolean bl2 = false;
            Editor editor = this.getEditorParent();
            if (editor != null) {
                int n = editor.getIndex(this);
                bl = n > 0;
                boolean bl3 = bl2 = n < editor.getChildCount() - 1;
                if (this.restrictMoveToSameType) {
                    bl = bl && this.getClass().isInstance(editor.getChildAt(n - 1));
                    bl2 = bl2 && this.getClass().isInstance(editor.getChildAt(n + 1));
                }
            }
            moveUpAction.setActionOwner(bl ? this : null);
            moveDownAction.setActionOwner(bl2 ? this : null);
            copyAction.setActionOwner(this.allowCopy && this.canClone() ? this : null);
            cutAction.setActionOwner(this.allowCut ? this : null);
            pasteAction.setActionOwner(this.canPasteHere() ? this : null);
            deleteAction.setActionOwner(this.allowDelete ? this : null);
        }
    }

    public void clearActionsOwner() {
        Editor.clearBasicActionsOwner();
    }

    protected static Component findParentForDlg(AWTEvent aWTEvent) {
        if (aWTEvent != null && aWTEvent.getSource() instanceof Component) {
            return (Component)aWTEvent.getSource();
        }
        return null;
    }

    public void addEditorListener(EditorListener editorListener) {
        this.listeners.add(editorListener);
    }

    public void removeEditorListener(EditorListener editorListener) {
        this.listeners.remove(editorListener);
    }

    public void fireEditorDataChanged(EditorListener editorListener) {
        this.setModified(true);
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        if (defaultTreeModel != null) {
            defaultTreeModel.nodeChanged(this);
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            EditorListener editorListener2 = (EditorListener)iterator.next();
            if (editorListener2 == editorListener) continue;
            editorListener2.editorDataChanged(this);
        }
    }

    public void collectData() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EditorPanel)) continue;
            ((EditorPanel)e).save();
            break;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode treeNode = this.getChildAt(i);
            if (!(treeNode instanceof Editor)) continue;
            ((Editor)treeNode).collectData();
        }
    }

    public ListSelectionModel getListSelectionModel() {
        ListSelectionModel listSelectionModel = this.listSelectionModel;
        if (listSelectionModel == null && this.getEditorParent() != null) {
            listSelectionModel = this.getEditorParent().getListSelectionModel();
        }
        return listSelectionModel;
    }

    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        this.listSelectionModel = listSelectionModel;
    }

    public boolean editData(Component component, Options options) {
        boolean bl = false;
        EditorPanel editorPanel = this.createEditorPanel(options);
        if (editorPanel != null) {
            editorPanel.attachEditor(this, false);
            bl = options.getMessages().showInputDlg(component, editorPanel, this.getTitleKey());
            editorPanel.attachEditor(null, bl);
            if (bl) {
                this.setModified(true);
            }
        }
        return bl;
    }

    static {
        basicActionsCreated = false;
    }

    public static interface EditorListener {
        public void editorDataChanged(Editor var1);
    }

    protected class LModel
    extends AbstractListModel {
        protected LModel() {
        }

        public Object getElementAt(int n) {
            return n >= 0 && n < Editor.this.getChildCount() ? Editor.this.getChildAt(n) : null;
        }

        public int getSize() {
            return Editor.this.getChildCount();
        }

        public void fireIntervalAdded(Object object, int n, int n2) {
            super.fireIntervalAdded(object, n, n2);
        }

        public void fireIntervalRemoved(Object object, int n, int n2) {
            super.fireIntervalRemoved(object, n, n2);
        }

        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

