/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import java.awt.Point;
import java.util.HashMap;
import org.jdom.Element;

public class MediaContent
implements Cloneable,
Domable {
    public static final int UNKNOWN = 0;
    public static final int PLAY_AUDIO = 1;
    public static final int PLAY_VIDEO = 2;
    public static final int PLAY_MIDI = 3;
    public static final int PLAY_CDAUDIO = 4;
    public static final int RECORD_AUDIO = 5;
    public static final int PLAY_RECORDED_AUDIO = 6;
    public static final int RUN_CLIC_ACTIVITY = 7;
    public static final int RUN_CLIC_PACKAGE = 8;
    public static final int RUN_EXTERNAL = 9;
    public static final int URL = 10;
    public static final int EXIT = 11;
    public static final int RETURN = 12;
    public static final int NUM_MEDIA_TYPES = 13;
    public static final String[] mediaName = new String[]{"UNKNOWN", "PLAY_AUDIO", "PLAY_VIDEO", "PLAY_MIDI", "PLAY_CDAUDIO", "RECORD_AUDIO", "PLAY_RECORDED_AUDIO", "RUN_CLIC_ACTIVITY", "RUN_CLIC_PACKAGE", "RUN_EXTERNAL", "URL", "EXIT", "RETURN"};
    public static final int FROM_BOX = 0;
    public static final int FROM_WINDOW = 1;
    public static final int FROM_FRAME = 2;
    public static final String[] fromName = new String[]{"BOX", "WINDOW", "FRAME"};
    public int mediaType = 0;
    public int level = 1;
    public String mediaFileName = null;
    public String externalParam = null;
    public int from = -1;
    public int to = -1;
    public int length = 3;
    public String cdFrom = null;
    public String cdTo = null;
    public int recBuffer = 0;
    public boolean stretch = false;
    public boolean free = false;
    public Point absLocation = null;
    public int absLocationFrom = 0;
    public boolean loop = false;
    public boolean catchMouseEvents = false;
    public boolean autoStart = false;
    public static final String ELEMENT_NAME = "media";
    protected static final String TYPE = "type";
    protected static final String LEVEL = "level";
    protected static final String FILE = "file";
    protected static final String PARAMS = "params";
    protected static final String FROM = "from";
    protected static final String TO = "to";
    protected static final String CDFROM = "cdFrom";
    protected static final String CDTO = "cdTo";
    protected static final String BUFFER = "buffer";
    protected static final String LENGTH = "length";
    protected static final String STRETCH = "stretch";
    protected static final String FREE = "free";
    protected static final String PX = "px";
    protected static final String PY = "py";
    protected static final String PFROM = "pFrom";
    protected static final String LOOP = "loop";
    protected static final String CATCH_MOUSE = "catchMouseEvents";
    protected static final String AUTOSTART = "autoStart";

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(TYPE, mediaName[this.mediaType]);
        element.setAttribute(LEVEL, Integer.toString(this.level));
        if (this.mediaFileName != null) {
            element.setAttribute(FILE, this.mediaFileName);
        }
        if (this.externalParam != null) {
            element.setAttribute(PARAMS, this.externalParam);
        }
        if (this.from != -1) {
            element.setAttribute(FROM, Integer.toString(this.from));
        }
        if (this.to != -1) {
            element.setAttribute(TO, Integer.toString(this.to));
        }
        if (this.cdFrom != null) {
            element.setAttribute(CDFROM, this.cdFrom);
        }
        if (this.cdTo != null) {
            element.setAttribute(CDTO, this.cdTo);
        }
        if (this.mediaType == 5 || this.mediaType == 6) {
            element.setAttribute(BUFFER, Integer.toString(this.recBuffer));
            if (this.mediaType == 5) {
                element.setAttribute(LENGTH, Integer.toString(this.length));
            }
        }
        if (this.mediaType == 2) {
            element.setAttribute(STRETCH, JDomUtility.boolString(this.stretch));
            element.setAttribute(FREE, JDomUtility.boolString(this.free));
            if (this.catchMouseEvents) {
                element.setAttribute(CATCH_MOUSE, JDomUtility.boolString(this.catchMouseEvents));
            }
            if (this.absLocation != null) {
                element.setAttribute(PX, Integer.toString(this.absLocation.x));
                element.setAttribute(PY, Integer.toString(this.absLocation.y));
                element.setAttribute(PFROM, fromName[this.absLocationFrom]);
            }
        }
        if (this.loop) {
            element.setAttribute(LOOP, JDomUtility.boolString(this.loop));
        }
        if (this.autoStart) {
            element.setAttribute(AUTOSTART, JDomUtility.boolString(this.autoStart));
        }
        return element;
    }

    public static MediaContent getMediaContent(Element element) throws Exception {
        MediaContent mediaContent = new MediaContent();
        mediaContent.setProperties(element, null);
        return mediaContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.mediaType = JDomUtility.getStrIndexAttr(element, TYPE, mediaName, -1);
        if (this.mediaType == -1) {
            throw new IllegalArgumentException("Unknown media type: " + mediaName);
        }
        this.level = JDomUtility.getIntAttr(element, LEVEL, this.level);
        this.mediaFileName = FileSystem.stdFn(element.getAttributeValue(FILE));
        this.externalParam = element.getAttributeValue(PARAMS);
        this.from = JDomUtility.getIntAttr(element, FROM, this.from);
        this.to = JDomUtility.getIntAttr(element, TO, this.to);
        this.cdFrom = element.getAttributeValue(CDFROM);
        this.cdTo = element.getAttributeValue(CDTO);
        this.recBuffer = JDomUtility.getIntAttr(element, BUFFER, this.recBuffer);
        this.length = JDomUtility.getIntAttr(element, LENGTH, this.length);
        this.stretch = JDomUtility.getBoolAttr(element, STRETCH, this.stretch);
        this.stretch = JDomUtility.getBoolAttr(element, "retainAspect", this.stretch);
        this.free = JDomUtility.getBoolAttr(element, FREE, this.free);
        this.absLocationFrom = JDomUtility.getStrIndexAttr(element, PFROM, fromName, this.absLocationFrom);
        this.absLocation = JDomUtility.getPointAttr(element, PX, PY, this.absLocation);
        this.loop = JDomUtility.getBoolAttr(element, LOOP, this.loop);
        this.catchMouseEvents = JDomUtility.getBoolAttr(element, CATCH_MOUSE, this.catchMouseEvents);
        this.autoStart = JDomUtility.getBoolAttr(element, AUTOSTART, this.autoStart);
    }

    public static void listReferences(Element element, HashMap hashMap) {
        if (element != null) {
            String string = element.getAttributeValue(FILE);
            String string2 = element.getAttributeValue(PARAMS);
            int n = 0;
            if (string != null && string.length() > 0) {
                int n2 = -1;
                try {
                    n2 = JDomUtility.getStrIndexAttr(element, TYPE, mediaName, -1);
                }
                catch (Exception exception) {
                    System.err.println("error:\n" + exception);
                    return;
                }
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        hashMap.put(string, ELEMENT_NAME);
                        break;
                    }
                    case 7: {
                        n = 1;
                    }
                    case 8: {
                        hashMap.put(string, string2 != null ? "external" : (n > 0 ? "activity" : "sequence"));
                        if (string2 == null) break;
                        hashMap.put(string2, "external");
                        break;
                    }
                    case 9: {
                        hashMap.put(string2 == null ? string : string + " " + string2, "external");
                        break;
                    }
                    case 10: {
                        hashMap.put(string, "url");
                    }
                }
            }
        }
    }

    public String getIconName() {
        String string = "unknown.gif";
        switch (this.mediaType) {
            case 1: {
                string = "icowave.png";
                break;
            }
            case 3: {
                string = "icomidi.png";
                break;
            }
            case 2: {
                string = "icomci.png";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                string = "ico00.png";
                break;
            }
            case 5: {
                string = "icorec.png";
                break;
            }
            case 6: {
                string = "icorplay.png";
                break;
            }
            case 11: {
                string = "icoexit.png";
                break;
            }
            case 9: 
            case 10: {
                string = "icoexe.png";
                break;
            }
        }
        return string;
    }

    public void registerContentTo(MediaBag mediaBag) throws Exception {
        if (this.mediaFileName != null) {
            switch (this.mediaType) {
                case 1: 
                case 2: 
                case 3: {
                    mediaBag.registerElement(this.mediaFileName, null);
                    break;
                }
            }
        }
    }

    public boolean isEquivalent(MediaContent mediaContent) {
        return mediaContent != null && this.mediaType == mediaContent.mediaType && StrUtils.compareStringsIgnoreCase(this.mediaFileName, mediaContent.mediaFileName) && StrUtils.compareStringsIgnoreCase(this.externalParam, mediaContent.externalParam) && this.from == mediaContent.from && this.to == mediaContent.to && StrUtils.compareStringsIgnoreCase(this.cdFrom, mediaContent.cdFrom) && StrUtils.compareStringsIgnoreCase(this.cdTo, mediaContent.cdTo) && this.recBuffer == mediaContent.recBuffer && this.stretch == mediaContent.stretch && this.free == mediaContent.free && StrUtils.compareObjects(this.absLocation, mediaContent.absLocation) && this.absLocationFrom == mediaContent.absLocationFrom && this.loop == mediaContent.loop && this.level == mediaContent.level;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(mediaName[this.mediaType]);
        if (this.mediaFileName != null) {
            stringBuffer.append(" ").append(this.mediaFileName);
            if (this.from >= 0) {
                stringBuffer.append(" ").append("from:").append(this.from);
            }
            if (this.to >= 0) {
                stringBuffer.append(" ").append("to:").append(this.to);
            }
        } else if (this.externalParam != null) {
            stringBuffer.append(" ").append(this.externalParam);
        }
        return stringBuffer.substring(0);
    }

    public Object clone() {
        MediaContent mediaContent = null;
        try {
            mediaContent = (MediaContent)super.clone();
            if (this.absLocation != null) {
                mediaContent.absLocation = (Point)this.absLocation.clone();
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected error cloning MediaContent!");
        }
        return mediaContent;
    }
}

