/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class PooledConnectionBeanProvider
extends ConnectionBeanProvider
implements Runnable {
    public static final String MIN_CONNS = "dbMinConns";
    private static final String DEFAULT_MIN_CONNS = "1";
    public static final String MAX_CONNS = "dbMaxConns";
    private static final String DEFAULT_MAX_CONNS = "3";
    public static final String LOG_FILE = "dbLogFile";
    private static final String DEFAULT_LOG_FILE = "connectionPool.log";
    public static final String MAX_CONN_TIME = "dbMaxConnDays";
    private static final String DEFAULT_MAX_CONN_TIME = "1.0";
    public static final String LOG_APPEND = "dbLogAppend";
    private static final String DEFAULT_LOG_APPEND = "true";
    public static final String MAX_CHECKOUT_SECONDS = "dbMaxCheckoutSeconds";
    private static final String DEFAULT_MAX_CHECKOUT_SECONDS = "60";
    public static final String DEBUG_LEVEL = "dbDebugLevel";
    private static final String DEFAULT_DEBUG_LEVEL = "2";
    private Thread runner;
    private ConnectionBean[] connPool;
    private int[] connStatus;
    private long[] connLockTime;
    private long[] connCreateDate;
    private String[] connID;
    private String logFileString;
    private String logPIDFileString;
    private int currConnections;
    private int connLast;
    private int minConns;
    private int maxConns;
    private int maxConnMSec;
    private int maxCheckoutSeconds;
    private int debugLevel;
    private boolean available = true;
    private PrintWriter log;
    private SQLWarning currSQLWarning;
    private String pid;
    public int globalUsageCount;

    protected void setUp(Map map) throws Exception {
        super.setUp(map);
        if (this.dbDriver == null || this.dbDriver.length() == 0) {
            throw new Exception("Parameter dbDriver is null!");
        }
        Class.forName(this.dbDriver);
        if (this.dbServer == null || this.dbServer.length() == 0) {
            throw new Exception("Parameter dbServer is null!");
        }
        this.minConns = Math.max(1, Integer.parseInt(this.getValue(map, MIN_CONNS, DEFAULT_MIN_CONNS)));
        this.maxConns = Math.max(this.minConns, Math.min(15, Integer.parseInt(this.getValue(map, MAX_CONNS, DEFAULT_MAX_CONNS))));
        this.logFileString = this.getValue(map, LOG_FILE, DEFAULT_LOG_FILE);
        double d = new Double(this.getValue(map, MAX_CONN_TIME, DEFAULT_MAX_CONN_TIME));
        boolean bl = new Boolean(this.getValue(map, LOG_APPEND, DEFAULT_LOG_APPEND));
        this.maxCheckoutSeconds = Integer.parseInt(this.getValue(map, MAX_CHECKOUT_SECONDS, DEFAULT_MAX_CHECKOUT_SECONDS));
        this.debugLevel = Integer.parseInt(this.getValue(map, DEBUG_LEVEL, DEFAULT_DEBUG_LEVEL));
        this.connPool = new ConnectionBean[this.maxConns];
        this.connStatus = new int[this.maxConns];
        this.connLockTime = new long[this.maxConns];
        this.connCreateDate = new long[this.maxConns];
        this.connID = new String[this.maxConns];
        this.currConnections = this.minConns;
        File file = new File(this.logFileString);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.home"));
            file = new File(file, this.logFileString);
            this.logFileString = file.getAbsolutePath();
        }
        this.logPIDFileString = this.logFileString + ".pid";
        this.maxConnMSec = (int)(d * 8.64E7);
        if (this.maxConnMSec < 30000) {
            this.maxConnMSec = 30000;
        }
        if (this.debugLevel > 0) {
            try {
                this.log = new PrintWriter(new FileOutputStream(this.logFileString, bl), true);
            }
            catch (IOException iOException) {
                try {
                    this.log = new PrintWriter(new FileOutputStream("DBConn_" + System.currentTimeMillis() + ".log", bl), true);
                }
                catch (IOException iOException2) {
                    throw new IOException("Can't open any log file");
                }
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
        Date date = new Date();
        this.pid = simpleDateFormat.format(date);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.logPIDFileString));
        bufferedWriter.write(this.pid);
        bufferedWriter.close();
        if (this.log != null) {
            this.log.println("-----------------------------------------");
            this.log.println(new Date());
            this.log.println("Starting DbConnectionBeanBroker Version 1.0.13:");
            this.log.println("dbDriver = " + this.dbDriver);
            this.log.println("dbServer = " + this.dbServer);
            this.log.println("dbLogin = " + this.dbLogin);
            this.log.println("log file = " + this.logFileString);
            this.log.println("minconnections = " + this.minConns);
            this.log.println("maxconnections = " + this.maxConns);
            this.log.println("Total refresh interval = " + d + " days");
            this.log.println("logAppend = " + bl);
            this.log.println("maxCheckoutSeconds = " + this.maxCheckoutSeconds);
            this.log.println("debugLevel = " + this.debugLevel);
            this.log.println("mapStatements = " + this.mapStatements);
            this.log.println("-----------------------------------------");
        }
        boolean bl2 = false;
        Exception exception = null;
        int n = 3;
        for (int i = 1; i < n; ++i) {
            try {
                for (int j = 0; j < this.currConnections; ++j) {
                    this.createConn(j);
                }
                bl2 = true;
                break;
            }
            catch (SQLException sQLException) {
                exception = sQLException;
                if (this.log != null && this.debugLevel > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(new Date()).append(" ->Attempt (").append(i);
                    stringBuffer.append(" of ").append(n).append(") failed to create new connections set at startup:\n");
                    stringBuffer.append(sQLException).append("\n");
                    stringBuffer.append("Will try again in 15 seconds...");
                    this.log.println(stringBuffer.substring(0));
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!bl2) {
            if (this.log != null && this.debugLevel > 0) {
                this.log.println("\r\nAll attempts at connecting to Database exhausted");
            }
            if (exception == null) {
                exception = new IOException("Unable to connect to Database");
            }
            throw exception;
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        boolean bl = true;
        Statement statement = null;
        Object var3_3 = null;
        long l = this.maxCheckoutSeconds * 1000;
        while (bl) {
            int n;
            for (n = 0; n < this.currConnections; ++n) {
                try {
                    this.currSQLWarning = this.connPool[n].getConnection().getWarnings();
                    if (this.currSQLWarning == null) continue;
                    if (this.log != null && this.debugLevel > 1) {
                        this.log.println(new Date().toString() + " - Warnings on connection " + String.valueOf(n) + " " + this.currSQLWarning);
                    }
                    this.connPool[n].getConnection().clearWarnings();
                    continue;
                }
                catch (SQLException sQLException) {
                    if (this.log == null || this.debugLevel <= 1) continue;
                    this.log.println("Cannot access Warnings: " + sQLException);
                }
            }
            for (n = 0; n < this.currConnections; ++n) {
                long l2 = System.currentTimeMillis() - this.connCreateDate[n];
                try {
                    int[] nArray = this.connStatus;
                    // MONITORENTER : this.connStatus
                    if (this.connStatus[n] > 0) {
                        long l3 = System.currentTimeMillis() - this.connLockTime[n];
                        if (this.log != null && this.debugLevel > 2) {
                            this.log.println(new Date().toString() + " - Warning. Connection " + n + " in use for " + l3 + " ms");
                        }
                        if (l != 0L && l3 > l) {
                            if (this.log == null) throw new SQLException();
                            if (this.debugLevel <= 1) throw new SQLException();
                            this.log.println(new Date().toString() + " Warning. Connection " + n + " failed to be returned in time.  Recycling...");
                            throw new SQLException();
                        }
                        // MONITOREXIT : nArray
                        continue;
                    }
                    this.connStatus[n] = 2;
                    // MONITOREXIT : nArray
                    if (l2 > (long)this.maxConnMSec) {
                        throw new SQLException();
                    }
                    statement = this.connPool[n].getConnection().createStatement();
                    this.connStatus[n] = 0;
                    if (!this.connPool[n].getConnection().isClosed()) continue;
                    throw new SQLException();
                }
                catch (SQLException sQLException) {
                    block36: {
                        if (this.log != null && this.debugLevel > 1) {
                            this.log.println(new Date().toString() + " ***** Recycling connection " + String.valueOf(n) + ":");
                        }
                        try {
                            this.connPool[n].closeConnection();
                        }
                        catch (SQLException sQLException2) {
                            if (this.log == null || this.debugLevel <= 0) break block36;
                            this.log.println(new Date().toString() + " - Error! Can't close connection! Might have been closed already. Trying to recycle anyway... (" + sQLException2 + ")");
                        }
                    }
                    try {
                        this.createConn(n);
                    }
                    catch (SQLException sQLException3) {
                        if (this.log != null && this.debugLevel > 0) {
                            this.log.println(new Date().toString() + " - Failed to create connection: " + sQLException3);
                        }
                        this.connStatus[n] = 0;
                    }
                    continue;
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ConnectionBean getConnectionBean() {
        ConnectionBean connectionBean = null;
        if (!this.available) {
            if (this.log != null && this.debugLevel > 0) {
                this.log.println(new Date().toString() + " - Unsuccessful getConnection() request during destroy()");
            }
        } else {
            boolean bl = false;
            for (int i = 1; i <= 10; ++i) {
                block21: {
                    block20: {
                        try {
                            int n = 0;
                            int n2 = this.connLast + 1;
                            if (n2 >= this.currConnections) {
                                n2 = 0;
                            }
                            do {
                                int[] nArray = this.connStatus;
                                // MONITORENTER : this.connStatus
                                if (this.connStatus[n2] < 1 && !this.connPool[n2].getConnection().isClosed()) {
                                    connectionBean = this.connPool[n2];
                                    this.connStatus[n2] = 1;
                                    this.connLockTime[n2] = System.currentTimeMillis();
                                    this.connLast = n2;
                                    bl = true;
                                    // MONITOREXIT : nArray
                                    break;
                                }
                                ++n;
                                if (++n2 >= this.currConnections) {
                                    n2 = 0;
                                }
                                // MONITOREXIT : nArray
                            } while (!bl && n < this.currConnections);
                        }
                        catch (SQLException sQLException) {
                            if (this.log == null) break block20;
                            this.log.println(new Date().toString() + " - Error: " + sQLException);
                        }
                    }
                    if (bl) break;
                    PooledConnectionBeanProvider pooledConnectionBeanProvider = this;
                    // MONITORENTER : pooledConnectionBeanProvider
                    if (this.currConnections < this.maxConns) {
                        try {
                            this.createConn(this.currConnections);
                            ++this.currConnections;
                        }
                        catch (SQLException sQLException) {
                            if (this.log == null || this.debugLevel <= 0) break block21;
                            this.log.println(new Date().toString() + " - Error: Unable to create new connection: " + sQLException);
                        }
                    }
                }
                // MONITOREXIT : pooledConnectionBeanProvider
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.log == null || this.debugLevel <= 0) continue;
                this.log.println(new Date().toString() + " --> Connections Exhausted!  Will wait and try again in loop " + String.valueOf(i));
            }
        }
        if (this.log != null && this.debugLevel > 2) {
            this.log.println(new Date().toString() + " - Handing out connection " + this.idOfConnection(connectionBean));
        }
        if (connectionBean == null) return connectionBean;
        ++connectionBean.usageCount;
        return connectionBean;
    }

    public int idOfConnection(ConnectionBean connectionBean) {
        String string;
        try {
            string = connectionBean.getConnection().toString();
        }
        catch (NullPointerException nullPointerException) {
            string = "none";
        }
        int n = -1;
        for (int i = 0; i < this.currConnections; ++i) {
            if (!this.connID[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public String freeConnectionBean(ConnectionBean connectionBean) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.idOfConnection(connectionBean);
        if (n >= 0) {
            this.connStatus[n] = 0;
            stringBuffer.append("freed ").append(connectionBean.getConnection().toString());
        } else if (this.log != null && this.debugLevel > 0) {
            this.log.println(new Date().toString() + " --> Error: Could not free connection!!!");
        }
        return stringBuffer.substring(0);
    }

    public long getAge(ConnectionBean connectionBean) {
        int n = this.idOfConnection(connectionBean);
        return System.currentTimeMillis() - this.connLockTime[n];
    }

    private void createConn(int n) throws SQLException {
        Date date;
        block4: {
            if (this.connPool[n] != null) {
                this.globalUsageCount += this.connPool[n].usageCount;
            }
            date = new Date();
            try {
                Class.forName(this.dbDriver);
                this.connPool[n] = new ConnectionBean(DriverManager.getConnection(this.dbServer, this.dbLogin, this.dbPassword), this.mapStatements);
                this.connStatus[n] = 0;
                this.connID[n] = this.connPool[n].getConnection().toString();
                this.connLockTime[n] = 0L;
                this.connCreateDate[n] = date.getTime();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.log == null || this.debugLevel <= 0) break block4;
                this.log.println(date.toString() + " - Error creating connection: " + classNotFoundException);
            }
        }
        if (this.log != null) {
            this.log.println(date.toString() + "  Opening connection " + String.valueOf(n) + " " + this.connPool[n].getConnection().toString() + ":");
        }
    }

    public void destroy(int n) throws SQLException {
        int n2;
        this.available = false;
        this.runner.interrupt();
        try {
            this.runner.join(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        while ((n2 = this.getUseCount()) > 0 && System.currentTimeMillis() - l <= (long)n) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this.currConnections; ++i) {
            try {
                this.connPool[i].closeConnection();
                continue;
            }
            catch (SQLException sQLException) {
                if (this.log == null || this.debugLevel <= 0) continue;
                this.log.println(new Date().toString() + " - Cannot close connections on Destroy");
            }
        }
        if (n2 > 0) {
            String string = new Date().toString() + " - Unsafe shutdown: Had to close " + n2 + " active DB connections after " + n + "ms";
            if (this.log != null) {
                this.log.println(string);
                this.log.close();
            }
            throw new SQLException(string);
        }
        if (this.log != null) {
            this.log.close();
        }
    }

    protected void destroy() {
        try {
            this.destroy(10000);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount() {
        int n = 0;
        int[] nArray = this.connStatus;
        synchronized (this.connStatus) {
            for (int i = 0; i < this.currConnections; ++i) {
                if (this.connStatus[i] <= 0) continue;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    public int getSize() {
        return this.currConnections;
    }

    public String getInfo() {
        int n = this.globalUsageCount;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>PooledConnectionBeanProvider ").append(this.hashCode()).append("</b><br>\n");
        stringBuffer.append(super.getInfo());
        stringBuffer.append("PID: ").append(this.pid).append("<br>\n");
        stringBuffer.append("LogFileString: ").append(this.logFileString).append("<br>\n");
        stringBuffer.append("currConnections: ").append(this.currConnections).append("<br>\n");
        stringBuffer.append("connLast: ").append(this.connLast).append("<br>\n");
        stringBuffer.append("minConns: ").append(this.minConns).append("<br>\n");
        stringBuffer.append("maxConns: ").append(this.maxConns).append("<br>\n");
        stringBuffer.append("maxConnMSec: ").append(this.maxConnMSec).append("<br>\n");
        stringBuffer.append("maxCheckoutSeconds: ").append(this.maxCheckoutSeconds).append("<br>\n");
        stringBuffer.append("debugLevel: ").append(this.debugLevel).append("<br>\n");
        stringBuffer.append("CURRENT CONNECTIONS:<br>\n");
        stringBuffer.append("<hr>\n");
        for (int i = 0; i < this.maxConns; ++i) {
            ConnectionBean connectionBean = this.connPool[i];
            if (connectionBean == null) {
                stringBuffer.append("Empty ConnectionBean<br>\n");
            } else {
                stringBuffer.append("Id: " + this.connID[i] + "<br>\n");
                stringBuffer.append("Status: " + this.connStatus[i] + "<br>\n");
                stringBuffer.append("LockTime: " + this.connLockTime[i] + "<br>\n");
                stringBuffer.append("CreateDate: " + new Date(this.connCreateDate[i]) + "<br>\n");
                stringBuffer.append("------------\n");
                stringBuffer.append(connectionBean.getInfo());
                n += connectionBean.usageCount;
            }
            stringBuffer.append("<hr>\n");
        }
        stringBuffer.append("TOTAL STATEMENTS USED: ").append(n).append("<br>\n");
        return stringBuffer.substring(0);
    }
}

