/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

public class TConversionTool {
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] exp_lut1 = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static short[] u2l = new short[]{-32124, -31100, -30076, -29052, -28028, -27004, -25980, -24956, -23932, -22908, -21884, -20860, -19836, -18812, -17788, -16764, -15996, -15484, -14972, -14460, -13948, -13436, -12924, -12412, -11900, -11388, -10876, -10364, -9852, -9340, -8828, -8316, -7932, -7676, -7420, -7164, -6908, -6652, -6396, -6140, -5884, -5628, -5372, -5116, -4860, -4604, -4348, -4092, -3900, -3772, -3644, -3516, -3388, -3260, -3132, -3004, -2876, -2748, -2620, -2492, -2364, -2236, -2108, -1980, -1884, -1820, -1756, -1692, -1628, -1564, -1500, -1436, -1372, -1308, -1244, -1180, -1116, -1052, -988, -924, -876, -844, -812, -780, -748, -716, -684, -652, -620, -588, -556, -524, -492, -460, -428, -396, -372, -356, -340, -324, -308, -292, -276, -260, -244, -228, -212, -196, -180, -164, -148, -132, -120, -112, -104, -96, -88, -80, -72, -64, -56, -48, -40, -32, -24, -16, -8, 0, 32124, 31100, 30076, 29052, 28028, 27004, 25980, 24956, 23932, 22908, 21884, 20860, 19836, 18812, 17788, 16764, 15996, 15484, 14972, 14460, 13948, 13436, 12924, 12412, 11900, 11388, 10876, 10364, 9852, 9340, 8828, 8316, 7932, 7676, 7420, 7164, 6908, 6652, 6396, 6140, 5884, 5628, 5372, 5116, 4860, 4604, 4348, 4092, 3900, 3772, 3644, 3516, 3388, 3260, 3132, 3004, 2876, 2748, 2620, 2492, 2364, 2236, 2108, 1980, 1884, 1820, 1756, 1692, 1628, 1564, 1500, 1436, 1372, 1308, 1244, 1180, 1116, 1052, 988, 924, 876, 844, 812, 780, 748, 716, 684, 652, 620, 588, 556, 524, 492, 460, 428, 396, 372, 356, 340, 324, 308, 292, 276, 260, 244, 228, 212, 196, 180, 164, 148, 132, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};
    private static final byte QUANT_MASK = 15;
    private static final byte SEG_SHIFT = 4;
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static short[] a2l = new short[]{-5504, -5248, -6016, -5760, -4480, -4224, -4992, -4736, -7552, -7296, -8064, -7808, -6528, -6272, -7040, -6784, -2752, -2624, -3008, -2880, -2240, -2112, -2496, -2368, -3776, -3648, -4032, -3904, -3264, -3136, -3520, -3392, -22016, -20992, -24064, -23040, -17920, -16896, -19968, -18944, -30208, -29184, -32256, -31232, -26112, -25088, -28160, -27136, -11008, -10496, -12032, -11520, -8960, -8448, -9984, -9472, -15104, -14592, -16128, -15616, -13056, -12544, -14080, -13568, -344, -328, -376, -360, -280, -264, -312, -296, -472, -456, -504, -488, -408, -392, -440, -424, -88, -72, -120, -104, -24, -8, -56, -40, -216, -200, -248, -232, -152, -136, -184, -168, -1376, -1312, -1504, -1440, -1120, -1056, -1248, -1184, -1888, -1824, -2016, -1952, -1632, -1568, -1760, -1696, -688, -656, -752, -720, -560, -528, -624, -592, -944, -912, -1008, -976, -816, -784, -880, -848, 5504, 5248, 6016, 5760, 4480, 4224, 4992, 4736, 7552, 7296, 8064, 7808, 6528, 6272, 7040, 6784, 2752, 2624, 3008, 2880, 2240, 2112, 2496, 2368, 3776, 3648, 4032, 3904, 3264, 3136, 3520, 3392, 22016, 20992, 24064, 23040, 17920, 16896, 19968, 18944, 30208, 29184, 32256, 31232, 26112, 25088, 28160, 27136, 11008, 10496, 12032, 11520, 8960, 8448, 9984, 9472, 15104, 14592, 16128, 15616, 13056, 12544, 14080, 13568, 344, 328, 376, 360, 280, 264, 312, 296, 472, 456, 504, 488, 408, 392, 440, 424, 88, 72, 120, 104, 24, 8, 56, 40, 216, 200, 248, 232, 152, 136, 184, 168, 1376, 1312, 1504, 1440, 1120, 1056, 1248, 1184, 1888, 1824, 2016, 1952, 1632, 1568, 1760, 1696, 688, 656, 752, 720, 560, 528, 624, 592, 944, 912, 1008, 976, 816, 784, 880, 848};
    private static byte[] u2a = new byte[]{-86, -85, -88, -87, -82, -81, -84, -83, -94, -93, -96, -95, -90, -89, -92, -91, -70, -69, -72, -71, -66, -65, -68, -67, -78, -77, -80, -79, -74, -73, -76, -75, -118, -117, -120, -119, -114, -113, -116, -115, -126, -125, -128, -127, -122, -121, -124, -123, -101, -104, -103, -98, -97, -100, -99, -110, -109, -112, -111, -106, -105, -108, -107, -22, -24, -23, -18, -17, -20, -19, -30, -29, -32, -31, -26, -25, -28, -27, -6, -8, -2, -1, -4, -3, -14, -13, -16, -15, -10, -9, -12, -11, -53, -55, -49, -51, -62, -61, -64, -63, -58, -57, -60, -59, -38, -37, -40, -39, -34, -33, -36, -35, -46, -46, -45, -45, -48, -48, -47, -47, -42, -42, -41, -41, -44, -44, -43, -43, 42, 43, 40, 41, 46, 47, 44, 45, 34, 35, 32, 33, 38, 39, 36, 37, 58, 59, 56, 57, 62, 63, 60, 61, 50, 51, 48, 49, 54, 55, 52, 53, 10, 11, 8, 9, 14, 15, 12, 13, 2, 3, 0, 1, 6, 7, 4, 5, 27, 24, 25, 30, 31, 28, 29, 18, 19, 16, 17, 22, 23, 20, 21, 106, 104, 105, 110, 111, 108, 109, 98, 99, 96, 97, 102, 103, 100, 101, 122, 120, 126, 127, 124, 125, 114, 115, 112, 113, 118, 119, 116, 117, 75, 73, 79, 77, 66, 67, 64, 65, 70, 71, 68, 69, 90, 91, 88, 89, 94, 95, 92, 93, 82, 82, 83, 83, 80, 80, 81, 81, 86, 86, 87, 87, 84, 84, 85, 85};
    private static byte[] a2u = new byte[]{-86, -85, -88, -87, -82, -81, -84, -83, -94, -93, -96, -95, -90, -89, -92, -91, -71, -70, -73, -72, -67, -66, -69, -68, -79, -78, -80, -80, -75, -74, -77, -76, -118, -117, -120, -119, -114, -113, -116, -115, -126, -125, -128, -127, -122, -121, -124, -123, -102, -101, -104, -103, -98, -97, -100, -99, -110, -109, -112, -111, -106, -105, -108, -107, -30, -29, -32, -31, -26, -25, -28, -27, -35, -35, -36, -36, -33, -33, -34, -34, -12, -10, -16, -14, -4, -2, -8, -6, -22, -21, -24, -23, -18, -17, -20, -19, -56, -55, -58, -57, -52, -51, -54, -53, -64, -63, -65, -65, -60, -59, -62, -61, -42, -41, -44, -43, -38, -37, -40, -39, -49, -49, -50, -50, -46, -45, -48, -47, 42, 43, 40, 41, 46, 47, 44, 45, 34, 35, 32, 33, 38, 39, 36, 37, 57, 58, 55, 56, 61, 62, 59, 60, 49, 50, 48, 48, 53, 54, 51, 52, 10, 11, 8, 9, 14, 15, 12, 13, 2, 3, 0, 1, 6, 7, 4, 5, 26, 27, 24, 25, 30, 31, 28, 29, 18, 19, 16, 17, 22, 23, 20, 21, 98, 99, 96, 97, 102, 103, 100, 101, 93, 93, 92, 92, 95, 95, 94, 94, 116, 118, 112, 114, 124, 126, 120, 122, 106, 107, 104, 105, 110, 111, 108, 109, 72, 73, 70, 71, 76, 77, 74, 75, 64, 65, 63, 63, 68, 69, 66, 67, 86, 87, 84, 85, 90, 91, 88, 89, 79, 79, 78, 78, 82, 83, 80, 81};

    public static void convertSign8(byte[] byArray, int n, int n2) {
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] + 128);
        }
    }

    public static void swapOrder16(byte[] byArray, int n, int n2) {
        int n3 = n2 * 2 + n - 1;
        int n4 = n;
        while (n4 < n3) {
            byte by = byArray[n4];
            byArray[n4++] = byArray[n4];
            byArray[n4++] = by;
        }
    }

    public static void swapOrder24(byte[] byArray, int n, int n2) {
        int n3 = n2 * 3 + n - 2;
        for (int i = n; i < n3; ++i) {
            byte by = byArray[i];
            byArray[i++] = byArray[i + 1];
            byArray[++i] = by;
        }
    }

    public static void swapOrder32(byte[] byArray, int n, int n2) {
        int n3 = n2 * 4 + n - 3;
        for (int i = n; i < n3; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 3];
            byArray[i + 3] = by;
            by = byArray[++i];
            byArray[i++] = byArray[i];
            byArray[i++] = by;
        }
    }

    public static void convertSign8(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = (byte)(byArray[n++] + 128);
            --n3;
        }
    }

    public static void swapOrder16(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n++];
            ++n;
            --n3;
        }
    }

    public static void swapOrder24(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 2];
            int n4 = ++n2;
            ++n2;
            byArray2[n4] = byArray[n++];
            ++n;
            ++n;
            --n3;
        }
    }

    public static void swapOrder32(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 3];
            byArray2[n2++] = byArray[n + 2];
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n++];
            ++n;
            ++n;
            ++n;
            --n3;
        }
    }

    public static short bytesToShort16(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    public static short bytesToShort16(byte[] byArray, int n, boolean bl) {
        return bl ? (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF) : (short)(byArray[n + 1] << 8 | byArray[n] & 0xFF);
    }

    public static int bytesToInt16(byte by, byte by2) {
        return by << 8 | by2 & 0xFF;
    }

    public static int bytesToInt16(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 8 | byArray[n + 1] & 0xFF : byArray[n + 1] << 8 | byArray[n] & 0xFF;
    }

    public static int bytesToInt24(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF : byArray[n + 2] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int bytesToInt32(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF : byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static void shortToBytes16(short s, byte[] byArray, int n, boolean bl) {
        TConversionTool.intToBytes16(s, byArray, n, bl);
    }

    public static void intToBytes16(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2] = (byte)(n >> 8);
        }
    }

    public static void intToBytes24(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n >> 16);
        }
    }

    public static void intToBytes32(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 24);
            byArray[n2++] = (byte)(n >>> 16 & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2++] = (byte)(n >>> 16 & 0xFF);
            byArray[n2] = (byte)(n >> 24);
        }
    }

    public static byte linear2ulaw(int n) {
        int n2;
        int n3;
        int n4;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n5 = n >> 8 & 0x80;
        if (n5 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((n4 = ~(n5 | (n3 = exp_lut1[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> n3 + 3 & 0xF))) == 0) {
            n4 = 2;
        }
        return (byte)n4;
    }

    public static short ulaw2linear(byte by) {
        return u2l[by & 0xFF];
    }

    public static void pcm162ulaw(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = n;
        if (bl) {
            while (n2 > 0) {
                byArray[n4++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(byArray[n3], byArray[n3 + 1]));
                ++n3;
                ++n3;
                --n2;
            }
        } else {
            while (n2 > 0) {
                byArray[n4++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(byArray[n3 + 1], byArray[n3]));
                ++n3;
                ++n3;
                --n2;
            }
        }
    }

    public static void pcm162ulaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2;
        if (bl) {
            while (n3 > 0) {
                byArray2[n5++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(byArray[n4], byArray[n4 + 1]));
                ++n4;
                ++n4;
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n5++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(byArray[n4 + 1], byArray[n4]));
                ++n4;
                ++n4;
                --n3;
            }
        }
    }

    public static void pcm82ulaw(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = TConversionTool.linear2ulaw(byArray[i] << 8);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                byArray[i] = TConversionTool.linear2ulaw((byte)(byArray[i] + 128) << 8);
            }
        }
    }

    public static void pcm82ulaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        if (bl) {
            while (n3 > 0) {
                byArray2[n4++] = TConversionTool.linear2ulaw(byArray[n5++] << 8);
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n4++] = TConversionTool.linear2ulaw((byte)(byArray[n5++] + 128) << 8);
                --n3;
            }
        }
    }

    public static void ulaw2pcm16(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            TConversionTool.intToBytes16(u2l[byArray[n5++] & 0xFF], byArray2, n4++, bl);
            ++n4;
            --n3;
        }
    }

    public static void ulaw2pcm8(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = (byte)(u2l[byArray[i] & 0xFF] >> 8 & 0xFF);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                byArray[i] = (byte)((u2l[byArray[i] & 0xFF] >> 8) + 128);
            }
        }
    }

    public static void ulaw2pcm8(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2;
        if (bl) {
            while (n3 > 0) {
                byArray2[n5++] = (byte)(u2l[byArray[n4++] & 0xFF] >> 8 & 0xFF);
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n5++] = (byte)((u2l[byArray[n4++] & 0xFF] >> 8) + 128);
                --n3;
            }
        }
    }

    public static byte linear2alaw(short s) {
        int n;
        int n2 = 8;
        if (s >= 0) {
            n = -43;
        } else {
            n = 85;
            s = (short)(-s - 8);
        }
        for (int i = 0; i < 8; ++i) {
            if (s > seg_end[i]) continue;
            n2 = (byte)i;
            break;
        }
        if (n2 >= 8) {
            return (byte)((0x7F ^ n) & 0xFF);
        }
        byte by = (byte)(n2 << 4);
        by = n2 < 2 ? (byte)(by | s >> 4 & 0xF) : (byte)(by | s >> n2 + 3 & 0xF);
        return (byte)((by ^ n) & 0xFF);
    }

    public static short alaw2linear(byte by) {
        return a2l[by & 0xFF];
    }

    public static void pcm162alaw(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = n;
        if (bl) {
            while (n2 > 0) {
                byArray[n4++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(byArray[n3], byArray[n3 + 1]));
                ++n3;
                ++n3;
                --n2;
            }
        } else {
            while (n2 > 0) {
                byArray[n4++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(byArray[n3 + 1], byArray[n3]));
                ++n3;
                ++n3;
                --n2;
            }
        }
    }

    public static void pcm162alaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2;
        if (bl) {
            while (n3 > 0) {
                byArray2[n5++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(byArray[n4], byArray[n4 + 1]));
                ++n4;
                ++n4;
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n5++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(byArray[n4 + 1], byArray[n4]));
                ++n4;
                ++n4;
                --n3;
            }
        }
    }

    public static void pcm82alaw(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = TConversionTool.linear2alaw((short)(byArray[i] << 8));
            }
        } else {
            for (int i = n; i < n2; ++i) {
                byArray[i] = TConversionTool.linear2alaw((short)((byte)(byArray[i] + 128) << 8));
            }
        }
    }

    public static void pcm82alaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        if (bl) {
            while (n3 > 0) {
                byArray2[n4++] = TConversionTool.linear2alaw((short)(byArray[n5++] << 8));
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n4++] = TConversionTool.linear2alaw((short)((byte)(byArray[n5++] + 128) << 8));
                --n3;
            }
        }
    }

    public static void alaw2pcm8(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = (byte)(a2l[byArray[i] & 0xFF] >> 8 & 0xFF);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                byArray[i] = (byte)((a2l[byArray[i] & 0xFF] >> 8) + 128);
            }
        }
    }

    public static void alaw2pcm8(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2;
        if (bl) {
            while (n3 > 0) {
                byArray2[n5++] = (byte)(a2l[byArray[n4++] & 0xFF] >> 8 & 0xFF);
                --n3;
            }
        } else {
            while (n3 > 0) {
                byArray2[n5++] = (byte)((a2l[byArray[n4++] & 0xFF] >> 8) + 128);
                --n3;
            }
        }
    }

    public static void alaw2pcm16(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            TConversionTool.intToBytes16(a2l[byArray[n5++] & 0xFF], byArray2, n4++, bl);
            ++n4;
            --n3;
        }
    }

    public static byte ulaw2alaw(byte by) {
        return u2a[by & 0xFF];
    }

    public static void ulaw2alaw(byte[] byArray, int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            byArray[i] = u2a[byArray[i] & 0xFF];
        }
    }

    public static void ulaw2alaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            byArray2[n5++] = u2a[byArray[n4++] & 0xFF];
            --n3;
        }
    }

    public static byte alaw2ulaw(byte by) {
        return a2u[by & 0xFF];
    }

    public static void alaw2ulaw(byte[] byArray, int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            byArray[i] = a2u[byArray[i] & 0xFF];
        }
    }

    public static void alaw2ulaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            byArray2[n4++] = a2u[byArray[n5++] & 0xFF];
            --n3;
        }
    }

    public static void changeOrderOrSign(byte[] byArray, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                TConversionTool.convertSign8(byArray, n, n2);
                break;
            }
            case 2: {
                TConversionTool.swapOrder16(byArray, n, n2 / 2);
                break;
            }
            case 3: {
                TConversionTool.swapOrder24(byArray, n, n2 / 3);
                break;
            }
            case 4: {
                TConversionTool.swapOrder32(byArray, n, n2 / 4);
            }
        }
    }

    public static void changeOrderOrSign(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                TConversionTool.convertSign8(byArray, n, byArray2, n2, n3);
                break;
            }
            case 2: {
                TConversionTool.swapOrder16(byArray, n, byArray2, n2, n3 / 2);
                break;
            }
            case 3: {
                TConversionTool.swapOrder24(byArray, n, byArray2, n2, n3 / 3);
                break;
            }
            case 4: {
                TConversionTool.swapOrder32(byArray, n, byArray2, n2, n3 / 4);
            }
        }
    }
}

