/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.Options;
import edu.xtec.util.Resizer;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.StrUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TextTargetEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
Resizer.ResizerListener {
    protected Options options;
    TextTarget textTarget;
    JPanelActiveBox jpab;
    Resizer resizer;
    MediaBagEditor mbe;
    protected static final int[] popValues = new int[]{0, 1, 2, 3};
    protected static final String[] popKeys = new String[]{"no", "always", "onError", "onDemand"};
    protected String[] popItems;
    protected static final HashMap panels = new HashMap(1);
    private JLabel answerLb;
    private TextListEditor answerListEditor;
    private JPanel cardPanel;
    private SmallIntEditor delayEditor;
    private JLabel delayLb;
    private JTextField fillingCh;
    private JLabel fillingChLb;
    private SmallIntEditor iniLenEditor;
    private JLabel iniLenLb;
    private JTextField iniText;
    private JLabel iniTextLb;
    private JCheckBox listChk;
    private TextListEditor listEditor;
    private SmallIntEditor maxLenEditor;
    private SmallIntEditor maxTimeEditor;
    private JLabel maxTimeLb;
    private JLabel maxlenLb;
    private JCheckBox onlyPlayChk;
    private ButtonGroup popupOptions;
    private JPanel popupPreview;
    private JComboBox typeCombo;

    public TextTargetEditorPanel(Options options, MediaBagEditor mediaBagEditor) {
        this.options = options;
        this.mbe = mediaBagEditor;
        this.popItems = new String[popKeys.length];
        for (int i = 0; i < this.popItems.length; ++i) {
            this.popItems[i] = options.getMsg("edit_text_act_popup_" + popKeys[i]);
        }
        this.initComponents();
        this.jpab = new JPanelActiveBox(null, null, this.popupPreview);
        this.jpab.catchMouseEvents = false;
        this.jpab.setPreferredSize(this.popupPreview.getPreferredSize());
        this.popupPreview.setBounds(0, 0, this.popupPreview.getPreferredSize().width, this.popupPreview.getPreferredSize().height);
        this.popupPreview.add(this.jpab);
        this.resizer = new Resizer(this.jpab, null, true, this);
    }

    private void initComponents() {
        this.popupOptions = new ButtonGroup();
        JPanel jPanel = new JPanel();
        this.answerLb = new JLabel();
        this.answerListEditor = new TextListEditor(this.options);
        this.maxlenLb = new JLabel();
        this.maxLenEditor = new SmallIntEditor();
        this.fillingChLb = new JLabel();
        this.fillingCh = new JTextField();
        this.iniLenLb = new JLabel();
        this.iniLenEditor = new SmallIntEditor();
        this.iniTextLb = new JLabel();
        this.iniText = new JTextField();
        this.listChk = new JCheckBox();
        this.listEditor = new TextListEditor(this.options);
        JPanel jPanel2 = new JPanel();
        this.typeCombo = new JComboBox<String>(this.popItems);
        this.cardPanel = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.popupPreview = new ResizerPanel();
        this.onlyPlayChk = new JCheckBox();
        this.delayLb = new JLabel();
        this.delayEditor = new SmallIntEditor();
        this.maxTimeLb = new JLabel();
        this.maxTimeEditor = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        this.answerLb.setText(this.options.getMsg("edit_text_act_answer_label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.answerLb, gridBagConstraints);
        this.answerListEditor.setPreferredSize(new Dimension(180, 100));
        this.answerListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.answerListEditor, gridBagConstraints);
        this.maxlenLb.setText(this.options.getMsg("edit_text_act_maxLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.maxlenLb, gridBagConstraints);
        this.maxLenEditor.setToolTipText(this.options.getMsg("edit_text_act_maxLen_tooltip"));
        this.maxLenEditor.setMax(999);
        this.maxLenEditor.setMin(1);
        this.maxLenEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.maxLenEditor, gridBagConstraints);
        this.fillingChLb.setText(this.options.getMsg("edit_text_act_fillingChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fillingChLb, gridBagConstraints);
        this.fillingCh.setToolTipText(this.options.getMsg("edit_text_act_maxLen_tooltip"));
        this.fillingCh.setColumns(1);
        this.fillingCh.setText("_");
        this.fillingCh.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fillingCh, gridBagConstraints);
        this.iniLenLb.setText(this.options.getMsg("edit_text_act_iniLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.iniLenLb, gridBagConstraints);
        this.iniLenEditor.setToolTipText(this.options.getMsg("edit_text_act_iniLen_tooltip"));
        this.iniLenEditor.setMax(999);
        this.iniLenEditor.setMin(1);
        this.iniLenEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.iniLenEditor, gridBagConstraints);
        this.iniTextLb.setText(this.options.getMsg("edit_text_act_iniText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.iniTextLb, gridBagConstraints);
        this.iniText.setToolTipText(this.options.getMsg("edit_text_act_iniText_tooltip"));
        this.iniText.setPreferredSize(new Dimension(140, 21));
        this.iniText.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.iniText, gridBagConstraints);
        this.listChk.setToolTipText(this.options.getMsg("edit_text_act_list_tooltip"));
        this.listChk.setText(this.options.getMsg("edit_text_act_list"));
        this.listChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        jPanel.add((Component)this.listChk, gridBagConstraints);
        this.listEditor.setPreferredSize(new Dimension(180, 100));
        this.listEditor.setEnabled(false);
        this.listEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.listEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_popup")));
        this.typeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.typeCombo, gridBagConstraints);
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.add((Component)jPanel3, "card2");
        jPanel4.setLayout(new GridBagLayout());
        jScrollPane.setPreferredSize(new Dimension(200, 40));
        this.popupPreview.setLayout(null);
        this.popupPreview.setPreferredSize(new Dimension(300, 300));
        jScrollPane.setViewportView(this.popupPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)jScrollPane, gridBagConstraints);
        this.onlyPlayChk.setText(this.options.getMsg("edit_text_act_popup_onlyPlay"));
        this.onlyPlayChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.onlyPlayChk, gridBagConstraints);
        this.delayLb.setText(this.options.getMsg("edit_text_act_popup_delay"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.delayLb, gridBagConstraints);
        this.delayEditor.setMax(9999);
        this.delayEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        jPanel4.add((Component)this.delayEditor, gridBagConstraints);
        this.maxTimeLb.setText(this.options.getMsg("edit_text_act_popup_maxTime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.maxTimeLb, gridBagConstraints);
        this.maxTimeEditor.setMax(9999);
        this.maxTimeEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        jPanel4.add((Component)this.maxTimeEditor, gridBagConstraints);
        this.cardPanel.add((Component)jPanel4, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.cardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    public TextTarget getTextTarget() {
        this.collectData();
        return this.textTarget;
    }

    public void setTextTarget(TextTarget textTarget) {
        ActiveBoxContent activeBoxContent;
        this.textTarget = textTarget;
        this.answerListEditor.setTextList(textTarget != null ? textTarget.answer : null);
        this.listChk.setSelected(textTarget != null && textTarget.isList);
        this.maxLenEditor.setValue(textTarget != null ? textTarget.maxLenResp : 1);
        this.fillingCh.setText(textTarget != null ? new String(new char[]{textTarget.iniChar}) : "_");
        this.iniLenEditor.setValue(textTarget != null ? textTarget.numIniChars : 1);
        this.iniText.setText(textTarget != null ? (textTarget.iniText != null ? textTarget.iniText : "") : "");
        this.listEditor.setTextList(textTarget != null ? textTarget.options : null);
        int n = 0;
        if (textTarget != null) {
            n = Math.max(Arrays.binarySearch(popValues, textTarget.infoMode), 0);
        }
        this.typeCombo.setSelectedIndex(n);
        this.delayEditor.setValue(textTarget != null ? textTarget.popupDelay : 0);
        this.maxTimeEditor.setValue(textTarget != null ? textTarget.popupMaxTime : 0);
        this.onlyPlayChk.setSelected(textTarget != null && textTarget.onlyPlay);
        ActiveBoxContent activeBoxContent2 = activeBoxContent = textTarget != null ? textTarget.popupContent : null;
        if (activeBoxContent == null && textTarget != null) {
            activeBoxContent = new ActiveBoxContent();
            activeBoxContent.setDimension(new Dimension(100, 40));
        }
        this.jpab.setActiveBoxContent(activeBoxContent);
        if (activeBoxContent != null && activeBoxContent.dimension != null) {
            this.jpab.setBounds(0, 0, activeBoxContent.dimension.width, activeBoxContent.dimension.height);
        }
        this.checkEnabled();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.checkEnabled();
        }
    }

    public void checkEnabled() {
        this.answerListEditor.setEnabled(this.textTarget != null);
        this.maxLenEditor.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.fillingCh.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.iniLenEditor.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.iniText.setEnabled(this.textTarget != null);
        this.listChk.setEnabled(this.textTarget != null);
        this.listEditor.setEnabled(this.textTarget != null && this.listChk.isSelected());
        this.typeCombo.setEnabled(this.textTarget != null);
        int n = this.typeCombo.getSelectedIndex();
        this.delayEditor.setEnabled(this.textTarget != null && n > 0);
        this.maxTimeEditor.setEnabled(this.textTarget != null && n > 0);
        this.onlyPlayChk.setEnabled(this.textTarget != null && n > 0);
        this.resizer.setEnabled(this.textTarget != null && n > 0);
        if (this.typeCombo.isEnabled() && this.typeCombo.getSelectedIndex() > 0) {
            ((CardLayout)this.cardPanel.getLayout()).last(this.cardPanel);
        } else {
            ((CardLayout)this.cardPanel.getLayout()).first(this.cardPanel);
        }
    }

    public void collectData() {
        if (this.textTarget != null) {
            String[] stringArray = this.answerListEditor.getTextList();
            if (stringArray.length > 0) {
                this.textTarget.answer = stringArray;
            }
            if (this.listChk.isSelected()) {
                String[] stringArray2 = this.listEditor.getTextList();
                if (stringArray2.length > 0) {
                    this.textTarget.isList = true;
                    this.textTarget.options = stringArray2;
                }
            } else {
                this.textTarget.isList = false;
                this.textTarget.options = null;
                this.textTarget.numIniChars = Math.max(1, this.iniLenEditor.getValue());
                this.textTarget.maxLenResp = Math.max(1, this.maxLenEditor.getValue());
                this.textTarget.iniText = StrUtils.nullableString(this.iniText.getText());
                String string = this.fillingCh.getText();
                this.textTarget.iniChar = (char)(string != null && string.length() > 0 ? (int)string.charAt(0) : 95);
            }
            this.textTarget.infoMode = popValues[Math.max(0, this.typeCombo.getSelectedIndex())];
            this.textTarget.popupDelay = this.delayEditor.getValue();
            this.textTarget.popupMaxTime = this.maxTimeEditor.getValue();
            this.textTarget.onlyPlay = this.onlyPlayChk.isSelected();
            if (this.textTarget.infoMode != 0) {
                this.textTarget.popupContent = this.jpab.getActiveBoxContent();
            }
        }
    }

    public void resizeObjectTo(Rectangle rectangle, JComponent jComponent) {
        if (jComponent == this.jpab) {
            this.jpab.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            this.jpab.getActiveBoxContent().setDimension(dimension);
            this.jpab.setPreferredSize(dimension);
            this.jpab.setMaximumSize(dimension);
        }
    }

    public void editObject(Rectangle rectangle, JComponent jComponent, Point point) {
        ActiveBoxContent activeBoxContent;
        if (jComponent == this.jpab && (activeBoxContent = ActiveBoxContentEditor.getActiveBoxContent(this.jpab.ab.getContent(), this.jpab, this.options, this.mbe, this.jpab.ab)) != null) {
            Dimension dimension = activeBoxContent.getDimension();
            this.jpab.setActiveBoxContent(activeBoxContent);
            if (dimension != null) {
                this.jpab.setBounds(0, 0, dimension.width, dimension.height);
            }
        }
    }

    public static boolean editTextTarget(TextTarget textTarget, Options options, MediaBagEditor mediaBagEditor, Component component) {
        TextTargetEditorPanel textTargetEditorPanel = (TextTargetEditorPanel)panels.get(options);
        if (textTargetEditorPanel == null) {
            textTargetEditorPanel = new TextTargetEditorPanel(options, mediaBagEditor);
            panels.put(options, textTargetEditorPanel);
        }
        textTargetEditorPanel.setTextTarget(textTarget);
        boolean bl = options.getMessages().showInputDlg(component, textTargetEditorPanel, "edit_text_act_target");
        if (bl) {
            textTargetEditorPanel.collectData();
        }
        textTargetEditorPanel.setTextTarget(null);
        return bl;
    }
}

