/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.beans.EventSoundsButton;
import edu.xtec.jclic.beans.RollPanel;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.AuthorEditPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.OrganizationEditPanel;
import edu.xtec.jclic.project.ProjectSettings;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.jclic.project.Revision;
import edu.xtec.jclic.project.RevisionEditPanel;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class ProjectSettingsEditorPanel
extends EditorPanel {
    private static JScrollPane langListPanel;
    private static JList langList;
    private AuthorEditPanel authorEditPanel;
    private OrganizationEditPanel organizationEditPanel;
    private RevisionEditPanel revisionEditPanel;
    private JTextField areaText;
    private RollPanel authPanel;
    private TextListEditor authorListEditor;
    private RollPanel descPanel;
    private JTextPane descText;
    private RollPanel descrPanel;
    private JTextField descriptorsText;
    private EventSoundsButton evSoundsBtn;
    private TextListEditor langListEditor;
    private JTextField levelText;
    private JPanel mainPanel;
    private TextListEditor orgListEditor;
    private TextListEditor revListEditor;
    private JScrollPane scroll;
    private JComboBox skinCombo;
    private JTextField titleText;
    private RollPanel uiPanel;

    public ProjectSettingsEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.evSoundsBtn.setOptions(options);
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.mainPanel = new JPanel();
        this.descrPanel = new RollPanel();
        JLabel jLabel = new JLabel();
        this.titleText = new JTextField();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descText = new JTextPane();
        this.authPanel = new RollPanel();
        JLabel jLabel3 = new JLabel();
        this.authorListEditor = new TextListEditor(this.options){

            protected Object editItem(Object object, boolean bl) {
                return ProjectSettingsEditorPanel.this.editAuthor(object, bl);
            }
        };
        JLabel jLabel4 = new JLabel();
        this.orgListEditor = new TextListEditor(this.options){

            protected Object editItem(Object object, boolean bl) {
                return ProjectSettingsEditorPanel.this.editOrg(object, bl);
            }
        };
        JLabel jLabel5 = new JLabel();
        this.revListEditor = new TextListEditor(this.options){

            protected Object editItem(Object object, boolean bl) {
                return ProjectSettingsEditorPanel.this.editRevision(object, bl);
            }
        };
        this.descPanel = new RollPanel();
        JLabel jLabel6 = new JLabel();
        this.levelText = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.areaText = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.descriptorsText = new JTextField();
        JLabel jLabel9 = new JLabel();
        this.langListEditor = new TextListEditor(this.options){

            protected Object editItem(Object object, boolean bl) {
                return ProjectSettingsEditorPanel.this.editLanguage(object, bl);
            }
        };
        this.uiPanel = new RollPanel();
        JLabel jLabel10 = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(false));
        this.skinCombo.setSelectedItem(null);
        JLabel jLabel11 = new JLabel();
        this.evSoundsBtn = new EventSoundsButton();
        JLabel jLabel12 = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.descrPanel.getMainPanel().setLayout(new GridBagLayout());
        this.descrPanel.setTitle(this.options.getMsg("edit_project_description_block"));
        jLabel.setLabelFor(this.titleText);
        jLabel.setText(this.options.getMsg("edit_project_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)jLabel, gridBagConstraints);
        this.titleText.setToolTipText(this.options.getMsg("edit_project_title_tooltip"));
        this.titleText.setPreferredSize(new Dimension(400, 21));
        this.titleText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)this.titleText, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_project_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)jLabel2, gridBagConstraints);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        this.descText.setToolTipText(this.options.getMsg("edit_project_description_tooltip"));
        this.descText.getDocument().addDocumentListener(this);
        jScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descrPanel, gridBagConstraints);
        this.authPanel.getMainPanel().setLayout(new GridBagLayout());
        this.authPanel.setTitle(this.options.getMsg("edit_project_author_group"));
        jLabel3.setLabelFor(this.authorListEditor);
        jLabel3.setText(this.options.getMsg("edit_project_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)jLabel3, gridBagConstraints);
        this.authorListEditor.setToolTipText(this.options.getMsg("edit_project_authors_tooltip"));
        this.authorListEditor.setPreferredSize(new Dimension(400, 80));
        this.authorListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.authPanel.getMainPanel().add((Component)this.authorListEditor, gridBagConstraints);
        jLabel4.setLabelFor(this.orgListEditor);
        jLabel4.setText(this.options.getMsg("edit_project_org"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)jLabel4, gridBagConstraints);
        this.orgListEditor.setToolTipText(this.options.getMsg("edit_project_org_tooltip"));
        this.orgListEditor.setPreferredSize(new Dimension(400, 80));
        this.orgListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.orgListEditor, gridBagConstraints);
        jLabel5.setLabelFor(this.revListEditor);
        jLabel5.setText(this.options.getMsg("edit_project_rev"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)jLabel5, gridBagConstraints);
        this.revListEditor.setToolTipText(this.options.getMsg("edit_project_rev_tooltip"));
        this.revListEditor.setPreferredSize(new Dimension(400, 80));
        this.revListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.revListEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.authPanel, gridBagConstraints);
        this.descPanel.getMainPanel().setLayout(new GridBagLayout());
        this.descPanel.setTitle(this.options.getMsg("edit_project_descriptors_block"));
        jLabel6.setLabelFor(this.levelText);
        jLabel6.setText(this.options.getMsg("edit_project_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)jLabel6, gridBagConstraints);
        this.levelText.setToolTipText(this.options.getMsg("edit_project_level_tooltip"));
        this.levelText.setPreferredSize(new Dimension(400, 21));
        this.levelText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.levelText, gridBagConstraints);
        jLabel7.setLabelFor(this.areaText);
        jLabel7.setText(this.options.getMsg("edit_project_area"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)jLabel7, gridBagConstraints);
        this.areaText.setToolTipText(this.options.getMsg("edit_project_area_tooltip"));
        this.areaText.setPreferredSize(new Dimension(400, 21));
        this.areaText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.areaText, gridBagConstraints);
        jLabel8.setLabelFor(this.descriptorsText);
        jLabel8.setText(this.options.getMsg("edit_project_descriptors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)jLabel8, gridBagConstraints);
        this.descriptorsText.setToolTipText(this.options.getMsg("edit_project_descriptors_tooltip"));
        this.descriptorsText.setPreferredSize(new Dimension(400, 21));
        this.descriptorsText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.descriptorsText, gridBagConstraints);
        jLabel9.setLabelFor(this.langListEditor);
        jLabel9.setText(this.options.getMsg("edit_project_languages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)jLabel9, gridBagConstraints);
        this.langListEditor.setToolTipText(this.options.getMsg("edit_project_languages_tooltip"));
        this.langListEditor.setPreferredSize(new Dimension(200, 80));
        this.langListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.descPanel.getMainPanel().add((Component)this.langListEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descPanel, gridBagConstraints);
        this.uiPanel.getMainPanel().setLayout(new GridBagLayout());
        this.uiPanel.setTitle(this.options.getMsg("edit_project_ui_block"));
        jLabel10.setLabelFor(this.skinCombo);
        jLabel10.setText(this.options.getMsg("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)jLabel10, gridBagConstraints);
        this.skinCombo.setToolTipText(this.options.getMsg("settings_skin_tooltip"));
        this.skinCombo.setEditable(true);
        this.skinCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.skinCombo, gridBagConstraints);
        jLabel11.setLabelFor(this.revListEditor);
        jLabel11.setText(this.options.getMsg("edit_project_evsounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)jLabel11, gridBagConstraints);
        this.evSoundsBtn.setToolTipText(this.options.getMsg("edit_project_evsounds_tooltip"));
        this.evSoundsBtn.addPropertyChangeListener("eventSounds", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.evSoundsBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.uiPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)jLabel12, gridBagConstraints);
        this.scroll.setViewportView(this.mainPanel);
        this.add((Component)this.scroll, "Center");
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof ProjectSettingsEditor;
    }

    protected ProjectSettingsEditor getProjectSettingsEditor() {
        return (ProjectSettingsEditor)this.getEditor();
    }

    protected ProjectSettings getProjectSettings() {
        ProjectSettings projectSettings = null;
        ProjectSettingsEditor projectSettingsEditor = this.getProjectSettingsEditor();
        if (projectSettingsEditor != null) {
            projectSettings = projectSettingsEditor.getProjectSettings();
        }
        return projectSettings;
    }

    protected void fillData() {
        int n;
        JClicProjectEditor jClicProjectEditor;
        ProjectSettings projectSettings = this.getProjectSettings();
        JClicProjectEditor jClicProjectEditor2 = jClicProjectEditor = projectSettings == null ? null : this.getProjectSettingsEditor().getProjectEditor();
        if (jClicProjectEditor != null) {
            this.evSoundsBtn.setMediaBagEditor(jClicProjectEditor.getMediaBagEditor());
        }
        this.evSoundsBtn.setEventSounds(projectSettings == null ? null : projectSettings.eventSounds);
        this.titleText.setText(projectSettings == null || projectSettings.title == null ? this.options.getMsg("UNNAMED") : projectSettings.title);
        this.descText.setText(projectSettings == null ? "" : StrUtils.secureString(projectSettings.description));
        this.areaText.setText(projectSettings == null ? "" : StrUtils.secureString(projectSettings.area));
        this.levelText.setText(projectSettings == null ? "" : StrUtils.secureString(projectSettings.level));
        this.descriptorsText.setText(projectSettings == null ? "" : StrUtils.secureString(projectSettings.descriptors));
        this.skinCombo.setSelectedItem(projectSettings == null ? null : projectSettings.skinFileName);
        Vector<Object> vector = new Vector<Object>();
        if (projectSettings != null && projectSettings.languages != null) {
            for (n = 0; n < projectSettings.languages.length; ++n) {
                String string = (String)Messages.getNamesToCodes().get(projectSettings.languages[n].toLowerCase());
                if (string != null) {
                    vector.add(Messages.getDescriptiveLanguageCode(string));
                    continue;
                }
                vector.add(projectSettings.languages[n]);
            }
        }
        this.langListEditor.setListData(vector);
        vector.removeAllElements();
        if (projectSettings != null && projectSettings.authors != null) {
            for (n = 0; n < projectSettings.authors.length; ++n) {
                vector.add(projectSettings.authors[n]);
            }
        }
        this.authorListEditor.setListData(vector);
        vector.removeAllElements();
        if (projectSettings != null && projectSettings.organizations != null) {
            for (n = 0; n < projectSettings.organizations.length; ++n) {
                vector.add(projectSettings.organizations[n]);
            }
        }
        this.orgListEditor.setListData(vector);
        vector.removeAllElements();
        if (projectSettings != null && projectSettings.revisions != null) {
            for (n = 0; n < projectSettings.revisions.length; ++n) {
                vector.add(projectSettings.revisions[n]);
            }
        }
        this.revListEditor.setListData(vector);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.evSoundsBtn.setEnabled(bl);
        this.titleText.setEnabled(bl);
        this.descText.setEnabled(bl);
        this.areaText.setEnabled(bl);
        this.levelText.setEnabled(bl);
        this.descriptorsText.setEnabled(bl);
        this.skinCombo.setEnabled(bl);
        this.langListEditor.setEnabled(bl);
        this.authorListEditor.setEnabled(bl);
        this.orgListEditor.setEnabled(bl);
        this.revListEditor.setEnabled(bl);
    }

    protected void saveData() {
        ProjectSettings projectSettings = this.getProjectSettings();
        if (projectSettings != null) {
            projectSettings.title = StrUtils.secureString(this.titleText.getText(), this.options.getMsg("UNNAMED"));
            projectSettings.description = StrUtils.nullableString(this.descText.getText());
            Vector vector = this.authorListEditor.getListData();
            projectSettings.authors = vector.toArray(new Author[vector.size()]);
            vector = this.orgListEditor.getListData();
            projectSettings.organizations = vector.toArray(new Organization[vector.size()]);
            vector = this.revListEditor.getListData();
            projectSettings.revisions = vector.toArray(new Revision[vector.size()]);
            projectSettings.level = StrUtils.nullableString(this.levelText.getText());
            projectSettings.area = StrUtils.nullableString(this.areaText.getText());
            projectSettings.descriptors = StrUtils.nullableString(this.descriptorsText.getText());
            String[] stringArray = this.langListEditor.getTextList();
            projectSettings.languages = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = string.length();
                if (n > 5) {
                    String string2 = string.substring(n - 3, n - 1);
                    string = (String)Messages.getNamesToCodes().get(string2);
                }
                projectSettings.languages[i] = string == null ? stringArray[i] : string;
            }
            projectSettings.skinFileName = StrUtils.nullableString(this.skinCombo.getSelectedItem());
            EventSounds eventSounds = this.evSoundsBtn.getEventSounds();
            projectSettings.eventSounds = eventSounds == null ? new EventSounds(null) : eventSounds;
        }
    }

    private Object editLanguage(final Object object, boolean bl) {
        if (langList == null || langListPanel == null) {
            langList = new JList<String>(this.options.getMessages().getDescriptiveLanguageCodes());
            langListPanel = new JScrollPane(langList);
        }
        Object var3_3 = null;
        if (!bl && object != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    langList.setSelectedValue(object, true);
                }
            });
        } else {
            langList.setSelectedIndex(-1);
        }
        if (this.options.getMessages().showInputDlg(this, new String[]{"edit_project_languages_select"}, null, new JComponent[]{langListPanel}, bl ? "edit_project_languages_add" : "edit_project_languages_modify")) {
            var3_3 = langList.getSelectedValue();
        }
        return var3_3;
    }

    private Object editAuthor(Object object, boolean bl) {
        Author author = null;
        if (this.authorEditPanel == null) {
            this.authorEditPanel = new AuthorEditPanel(this.options);
        }
        if (bl) {
            object = null;
        }
        this.authorEditPanel.setAuthor((Author)object);
        if (this.options.getMessages().showInputDlg(this, new String[]{"edit_project_author_info"}, null, new JComponent[]{this.authorEditPanel}, bl ? "edit_project_author_add" : "edit_project_author_edit")) {
            author = this.authorEditPanel.getAuthor();
            if (author.name.length() < 1) {
                author = null;
            }
        }
        return author;
    }

    private Object editOrg(Object object, boolean bl) {
        Organization organization = null;
        if (this.organizationEditPanel == null) {
            this.organizationEditPanel = new OrganizationEditPanel(this.options);
        }
        if (bl) {
            object = null;
        }
        this.organizationEditPanel.setOrganization((Organization)object);
        if (this.options.getMessages().showInputDlg(this, new String[]{"edit_project_org_info"}, null, new JComponent[]{this.organizationEditPanel}, bl ? "edit_project_org_add" : "edit_project_org_edit")) {
            organization = this.organizationEditPanel.getOrganization();
            if (organization.name.length() < 1) {
                organization = null;
            }
        }
        return organization;
    }

    private Object editRevision(Object object, boolean bl) {
        Revision revision = null;
        if (this.revisionEditPanel == null) {
            this.revisionEditPanel = new RevisionEditPanel(this.options);
        }
        if (bl) {
            object = null;
        }
        this.revisionEditPanel.setRevision((Revision)object);
        if (this.options.getMessages().showInputDlg(this, new String[]{"edit_project_rev_info"}, null, new JComponent[]{this.revisionEditPanel}, bl ? "edit_project_rev_add" : "edit_project_rev_edit") && (revision = this.revisionEditPanel.getRevision()) != null && revision.description.length() < 1) {
            revision = null;
        }
        return revision;
    }
}

