/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditorPanel;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.jclic.project.ProjectLibraryEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MenuEditor
extends Editor {
    protected static ImageIcon icon;
    public static EditorAction newMenuElementAction;
    public static EditorAction newMenuAction;
    public static boolean actionsCreated;
    protected ProjectLibrary projectLibrary;

    public MenuEditor(Menu menu) {
        super(menu);
    }

    @Override
    protected void createChildren() {
        Menu m = this.getMenu();
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null && !m.menuElements.isEmpty()) {
            for (int i = 0; i < m.getMenuElementCount(); ++i) {
                MenuElement me = m.getMenuElement(i);
                if (me.projectPath == null && me.sequence != null && !"@RETURN".equals(me.sequence)) {
                    try {
                        Activity act = Activity.getActivity(pl.activityBag.getElement(me.sequence).getData(), pl);
                        if (!(act instanceof Menu)) continue;
                        ((Menu)act).getEditor(this);
                    }
                    catch (Exception ex) {
                        System.err.println("Error reading activity:\n" + ex);
                    }
                    continue;
                }
                me.getEditor(this);
            }
        }
    }

    @Override
    public Class getEditorPanelClass() {
        return MenuEditorPanel.class;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new MenuEditorPanel(options);
    }

    public Menu getMenu() {
        return (Menu)this.getUserObject();
    }

    public Options getOptions() {
        return this.getMenu().getProject().getBridge().getOptions();
    }

    protected void saveData() {
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null) {
            pl.activityBag.addActivity(this.getMenu());
        }
    }

    public ProjectLibrary getProjectLibrary() {
        Editor p;
        if (this.projectLibrary == null && (p = this.getEditorParent()) != null) {
            if (p instanceof ProjectLibraryEditor) {
                this.projectLibrary = ((ProjectLibraryEditor)p).getProjectLibrary();
            } else if (p instanceof MenuEditor) {
                this.projectLibrary = ((MenuEditor)p).getProjectLibrary();
            }
        }
        return this.projectLibrary;
    }

    @Override
    public String toString() {
        return this.getMenu().description;
    }

    @Override
    protected boolean canClone() {
        return true;
    }

    @Override
    protected Editor getClone() throws Exception {
        Menu menu = (Menu)this.getMenu().duplicate();
        menu.name = Long.toString(System.currentTimeMillis());
        MenuEditor me = (MenuEditor)menu.getEditor(null);
        me.projectLibrary = this.getProjectLibrary();
        me.createChildren();
        return me;
    }

    @Override
    public void setActionsOwner() {
        Editor e = this.getEditorParent();
        this.allowCut = e != null && !(e instanceof ProjectLibraryEditor);
        this.allowDelete = this.allowCut;
        this.allowDelete = this.allowCut && this.getChildCount() == 0;
        this.allowPaste = true;
        this.allowCopy = true;
        super.setActionsOwner();
        newMenuElementAction.setActionOwner(this);
        newMenuAction.setActionOwner(e != null ? this : null);
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        newMenuAction.setActionOwner(null);
        newMenuElementAction.setActionOwner(null);
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/file_open.gif");
        }
        return icon;
    }

    public void setDescription(String description) {
        Menu m = this.getMenu();
        m.description = StrUtils.secureString(description, this.getOptions().getMsg("UNNAMED"));
        ActiveBoxContent[] messages = m.getMessages();
        if (messages[1] == null) {
            messages[1] = new ActiveBoxContent();
            messages[1].setBoxBase(new BoxBase());
        }
        messages[1].setTextContent(m.description);
        MenuElement me = this.checkParentMenuElementRef(false, false, false, 0);
        if (me != null) {
            me.caption = m.description;
        }
    }

    protected MenuElement checkParentMenuElementRef(boolean remove, boolean create, boolean move, int index) {
        MenuElement result = null;
        Menu m = this.getMenu();
        if (this.getEditorParent() instanceof MenuEditor) {
            Menu pm = ((MenuEditor)this.getEditorParent()).getMenu();
            for (int i = 0; i < pm.getMenuElementCount(); ++i) {
                MenuElement me = pm.getMenuElement(i);
                if (me.projectPath != null || me.sequence == null || !me.sequence.equals(m.name)) continue;
                result = me;
                break;
            }
            if (result != null && (remove || move)) {
                pm.menuElements.remove(result);
                if (move) {
                    pm.menuElements.add(index, result);
                }
            } else if (result == null && create) {
                index = Math.max(0, Math.min(index, m.getMenuElementCount()));
                result = new MenuElement();
                result.sequence = m.name;
                result.caption = m.description;
                pm.menuElements.add(index, result);
            }
        }
        return result;
    }

    @Override
    public boolean moveUp(boolean updateSelection) {
        boolean result = super.moveUp(updateSelection);
        if (result) {
            this.checkParentMenuElementRef(false, false, true, this.getParent().getIndex(this));
        }
        return result;
    }

    @Override
    public boolean moveDown(boolean updateSelection) {
        boolean result = super.moveDown(updateSelection);
        if (result) {
            this.checkParentMenuElementRef(false, false, true, this.getParent().getIndex(this));
        }
        return result;
    }

    @Override
    public boolean insertEditor(Editor e, boolean asChild, int index, boolean updateSelection) {
        boolean result = false;
        if (!asChild) {
            result = super.insertEditor(e, asChild, index, updateSelection);
        } else if (e instanceof MenuEditor) {
            ProjectLibrary pl = this.getProjectLibrary();
            if (pl != null) {
                int i;
                Menu m = ((MenuEditor)e).getMenu();
                for (i = 0; i < this.getChildCount() && this.getChildAt(i) instanceof MenuEditor; ++i) {
                }
                index = index < 0 ? i : Math.min(index, i);
                pl.activityBag.addActivity(m);
                pl.activitySequence.add(new ActivitySequenceElement(m.name, true));
                MenuEditor med = (MenuEditor)m.getEditor(this);
                med.checkParentMenuElementRef(false, true, false, index);
                result = super.insertEditor(med, true, index, updateSelection);
            }
        } else if (e instanceof MenuElementEditor) {
            MenuElement me = ((MenuElementEditor)e).getMenuElement();
            index = index < 0 ? this.getChildCount() : Math.min(index, this.getChildCount());
            this.getMenu().menuElements.add(index, me);
            result = super.insertEditor(me.getEditor(this), true, index, updateSelection);
        }
        return result;
    }

    public boolean createNewMenu(int index, boolean prompt, Component dlgParent) {
        boolean result = false;
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null) {
            JTree ct = this.getCurrentTree();
            TreePath savePath = null;
            if (ct != null) {
                savePath = ct.getSelectionPath();
            }
            Menu nm = new Menu(pl);
            nm.name = Long.toString(System.currentTimeMillis());
            MenuEditor med = (MenuEditor)nm.getEditor(null);
            med.setDescription(this.getOptions().getMsg("menu_newMenuName"));
            result = prompt ? med.createEditorPanel(this.getOptions()).showDialog(med, "menu_newMenuElement_caption", dlgParent, true) : true;
            if (result) {
                result = this.insertEditor(med, true, index, true);
            } else if (savePath != null && ct != null) {
                ct.clearSelection();
                ct.setSelectionPath(savePath);
            }
        }
        return result;
    }

    public boolean createNewMenuElement(int index, boolean prompt, Component dlgParent) {
        MenuElement me = new MenuElement();
        TreePath savePath = null;
        JTree ct = this.getCurrentTree();
        me.caption = this.getOptions().getMsg("menu_newMenuElementName");
        if (ct != null) {
            savePath = ct.getSelectionPath();
        }
        MenuElementEditor mee = (MenuElementEditor)me.getEditor(null);
        mee.projectLibrary = this.getProjectLibrary();
        mee.createChildren();
        boolean result = prompt ? mee.createEditorPanel(this.getOptions()).showDialog(mee, "menu_newMenuElement_caption", dlgParent, true) : true;
        index = index < 0 ? this.getChildCount() : Math.min(index, this.getChildCount());
        if (result) {
            result = this.insertEditor(mee, true, index, true);
        } else if (savePath != null && ct != null) {
            ct.clearSelection();
            ct.setSelectionPath(savePath);
        }
        return result;
    }

    @Override
    public boolean delete(boolean updateSelection) {
        boolean result = false;
        ProjectLibrary pl = this.getProjectLibrary();
        String name = this.getMenu().name;
        Editor saveParent = this.getEditorParent();
        if (name != null && (result = super.delete(updateSelection))) {
            this.parent = saveParent;
            if (pl != null) {
                ActivitySequenceElement ase = pl.activitySequence.getElementByTag(name, false);
                if (ase != null) {
                    pl.activitySequence.remove(ase);
                }
                pl.activityBag.removeElementByName(name);
            }
            this.checkParentMenuElementRef(true, false, false, 0);
            this.parent = null;
        }
        return result;
    }

    @Override
    public boolean canBeParentOf(Editor e) {
        return e instanceof MenuElementEditor || e instanceof MenuEditor;
    }

    @Override
    public boolean canBeSiblingOf(Editor e) {
        if (this.getEditorParent() instanceof MenuEditor) {
            return this.canBeParentOf(e);
        }
        return e instanceof MenuElementEditor;
    }

    public static void createActions(Options options) {
        MenuEditor.createBasicActions(options);
        if (!actionsCreated) {
            newMenuElementAction = new EditorAction("menu_newMenuElement_caption", "icons/new_miniclic.png", "menu_newMenuElement_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    Editor ch = null;
                    if (e instanceof MenuElementEditor) {
                        ch = e;
                        e = e.getEditorParent();
                    }
                    if (e instanceof MenuEditor) {
                        ((MenuEditor)e).createNewMenuElement(e.getNearestIndex(ch, true), true, this.getComponentSrc());
                    }
                }
            };
            newMenuAction = new EditorAction("menu_newMenu_caption", "icons/new_folder.gif", "menu_newMenu_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof MenuElementEditor) {
                        e = e.getEditorParent();
                    }
                    if (e instanceof MenuEditor) {
                        ((MenuEditor)e).createNewMenu(-1, true, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    static {
        actionsCreated = false;
    }
}

