/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import java.util.ArrayList;
import java.util.Iterator;

public class TargetMarkerBag
extends ArrayList<TargetMarker> {
    private TargetMarker currentTarget = null;

    public TargetMarkerBag() {
        super(10);
    }

    @Override
    public boolean add(TargetMarker tm) {
        int i;
        for (i = 0; i < this.size() && this.getElement((int)i).begOffset < tm.begOffset; ++i) {
        }
        if (i == this.size()) {
            return super.add(tm);
        }
        super.add(i, tm);
        return true;
    }

    public TargetMarker getElement(int n) {
        try {
            return (TargetMarker)this.get(n);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParentPane(TextActivityPane parent) {
        for (int i = 0; i < this.size(); ++i) {
            TargetMarker tm = this.getElement(i);
            if (tm.target == null) continue;
            tm.target.setParentPane(parent);
        }
    }

    public void setPositions() {
        for (int i = 0; i < this.size(); ++i) {
            this.getElement(i).setPositions();
        }
    }

    public void updateOffsets() {
        for (int i = 0; i < this.size(); ++i) {
            this.getElement(i).updateOffsets();
        }
    }

    public void removeUnattachedElements() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            TargetMarker tm = (TargetMarker)it.next();
            tm.updateOffsets();
            if (tm.begOffset >= 0 && tm.endOffset >= 0 && tm.begOffset != tm.endOffset) continue;
            it.remove();
        }
    }

    public int checkTargets(Evaluator ev) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getElement(i).checkText(ev)) continue;
            ++result;
        }
        return result;
    }

    public int countSolvedTargets() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            TextTarget tt = this.getElement((int)i).target;
            if (tt == null || tt.targetStatus != 2) continue;
            ++result;
        }
        return result;
    }

    public void reset() {
        for (int i = 0; i < this.size(); ++i) {
            this.getElement(i).reset();
        }
    }

    public TargetMarker getElementByOffset(int offset, boolean includeEndPos) {
        for (int i = 0; i < this.size(); ++i) {
            TargetMarker tm = this.getElement(i);
            if (!tm.contains(offset, includeEndPos)) continue;
            return tm;
        }
        return null;
    }

    public TargetMarker getNearestElement(int offset, boolean searchForward) {
        TargetMarker prev = null;
        TargetMarker next = null;
        for (int i = 0; i < this.size(); ++i) {
            TargetMarker tm = this.getElement(i);
            if (tm.begPos.getOffset() <= offset) {
                prev = tm;
            }
            if (tm.endPos.getOffset() < offset) continue;
            next = tm;
            break;
        }
        return searchForward ? next : prev;
    }

    public void setCurrentTarget(TargetMarker tm, TextActivityBase.Panel tabp) {
        if (this.currentTarget != null) {
            this.currentTarget.lostFocus(tabp);
        }
        if (tm != null && this.contains(tm)) {
            this.currentTarget = tm;
            if (this.currentTarget.target != null) {
                this.currentTarget.target.setModified(false);
            }
            this.currentTarget.requestFocus(tabp);
        } else {
            this.currentTarget = null;
        }
    }

    public TargetMarker getCurrentTarget() {
        return this.currentTarget;
    }

    public TargetMarker getElement(TextTarget tt) {
        for (int i = 0; i < this.size(); ++i) {
            TargetMarker tm = this.getElement(i);
            if (tm.target != tt) continue;
            return tm;
        }
        return null;
    }

    public TargetMarker getNextTarget(TargetMarker tm) {
        return this.getElement(Math.min(this.indexOf(tm == null ? this.currentTarget : tm) + 1, this.size() - 1));
    }

    public TargetMarker getPrevTarget(TargetMarker tm) {
        return this.getElement(Math.max(this.indexOf(tm == null ? this.currentTarget : tm) - 1, 0));
    }

    public void swapTargets(TargetMarker tm1, TargetMarker tm2) {
        TextActivityDocument doc = tm1.doc;
        if (doc != tm2.doc) {
            System.err.println("Error: unable to swap among different documents");
            return;
        }
        try {
            tm1.updateOffsets();
            String tx1 = doc.getText(tm1.begOffset, tm1.getLength());
            tm2.updateOffsets();
            String tx2 = doc.getText(tm2.begOffset, tm2.getLength());
            doc.remove(tm1.begOffset, tx1.length());
            doc.insertString(tm1.begOffset, tx2, doc.getTargetAttributeSet());
            tm1.endOffset = tm1.begOffset + tx2.length();
            tm1.setPositions();
            tm2.updateOffsets();
            doc.remove(tm2.begOffset, tx2.length());
            doc.insertString(tm2.begOffset, tx1, doc.getTargetAttributeSet());
            tm2.endOffset = tm2.begOffset + tx1.length();
            tm2.setPositions();
        }
        catch (Exception ex) {
            System.err.println("Error: unable to swap target texts:\n" + ex);
        }
        this.updateOffsets();
    }

    public int[] getParagragraphOffsets() {
        if (this.size() == 0) {
            return null;
        }
        int[] pOffsets = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            pOffsets[i] = this.getElement(i).getParagraphBegOffset();
        }
        return pOffsets;
    }
}

