/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.FontCheck;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StreamIO;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public class MediaBag
implements Editable,
Domable,
StreamIO.InputStreamProvider {
    protected JClicProject project;
    protected List<MediaBagElement> elements;
    protected Set<Listener> listeners;
    public static String ELEMENT_NAME = "mediaBag";

    public MediaBag(JClicProject project) {
        this.project = project;
        this.elements = new ArrayList<MediaBagElement>(30);
        this.listeners = new HashSet<Listener>(1);
    }

    public JClicProject getProject() {
        return this.project;
    }

    public List<MediaBagElement> getElements() {
        return new ArrayList<MediaBagElement>(this.elements);
    }

    public void clear() {
        this.elements.clear();
    }

    public List<MediaBagElement> getElementsByName() {
        List<MediaBagElement> v = this.getElements();
        Collections.sort(v, new Comparator<MediaBagElement>(){

            @Override
            public int compare(MediaBagElement o1, MediaBagElement o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return v;
    }

    public List<MediaBagElement> getElementsByType() {
        final StringBuilder sb1 = new StringBuilder(200);
        final StringBuilder sb2 = new StringBuilder(200);
        List<MediaBagElement> v = this.getElements();
        Collections.sort(v, new Comparator<MediaBagElement>(){

            @Override
            public int compare(MediaBagElement o1, MediaBagElement o2) {
                sb1.setLength(0);
                String fName = o1.getFileName();
                String name = o1.getName();
                int dot = fName.lastIndexOf(46);
                sb1.append(dot > 0 ? fName.substring(dot) : ".zzz");
                sb1.append(name);
                sb2.setLength(0);
                fName = o2.getFileName();
                name = o2.getName();
                dot = fName.lastIndexOf(46);
                sb2.append(dot > 0 ? fName.substring(dot) : ".zzz");
                sb2.append(name);
                return sb1.substring(0).compareToIgnoreCase(sb2.substring(0));
            }
        });
        return v;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        Iterator<MediaBagElement> it = this.getElementsByType().iterator();
        while (it.hasNext()) {
            e.addContent(it.next().getJDomElement());
        }
        return e;
    }

    public void clearData() {
        Iterator<MediaBagElement> it = this.elements.iterator();
        while (it.hasNext()) {
            it.next().clearData();
        }
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        Iterator it = e.getChildren("media").iterator();
        while (it.hasNext()) {
            this.elements.add(MediaBagElement.getMediaBagElement((Element)it.next()));
        }
    }

    public boolean addElement(MediaBagElement mbe) {
        boolean result;
        boolean bl = result = mbe != null && this.getElement(mbe.getName()) == null;
        if (result) {
            this.elements.add(mbe);
        }
        return result;
    }

    public MediaBagElement getElement(String name) {
        MediaBagElement result = null;
        if (name != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                MediaBagElement mbe = this.elements.get(i);
                if (!name.equals(mbe.getName())) continue;
                result = mbe;
                break;
            }
        }
        return result;
    }

    public MediaBagElement getElementByFileName(String fileName) {
        MediaBagElement result = null;
        if (fileName != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                MediaBagElement mbe = this.elements.get(i);
                if (!fileName.equals(mbe.getFileName())) continue;
                result = mbe;
                break;
            }
        }
        return result;
    }

    public MediaBagElement registerElement(String name, String fileName) {
        MediaBagElement result = this.getElement(name);
        if (result == null) {
            result = new MediaBagElement(FileSystem.stdFn(fileName == null ? name : fileName), null, name);
            this.elements.add(result);
        }
        return result;
    }

    public boolean removeElement(MediaBagElement mbe) {
        return this.elements.remove(mbe);
    }

    public Object getMediaDataSource(String name) throws Exception {
        Object result = null;
        String normalizedName = this.project.getFileSystem().getCanonicalNameOf(name);
        MediaBagElement mbe = this.registerElement(normalizedName, null);
        if (mbe != null) {
            if (mbe.getData() != null) {
                result = mbe.getData() instanceof ExtendedByteArrayInputStream ? ((ExtendedByteArrayInputStream)mbe.getData()).duplicate() : mbe.getData();
            } else {
                result = this.project.getFileSystem().getMediaDataSource(mbe.getFileName());
                mbe.setData(result);
            }
        }
        return result;
    }

    @Override
    public InputStream getInputStream(String name) throws Exception {
        InputStream result = null;
        String normalizedName = this.project.getFileSystem().getCanonicalNameOf(name);
        MediaBagElement mbe = this.registerElement(normalizedName, null);
        if (mbe != null) {
            if (mbe.getData() instanceof ExtendedByteArrayInputStream) {
                ExtendedByteArrayInputStream ebais = (ExtendedByteArrayInputStream)mbe.getData();
                mbe.setData(ebais);
                result = ebais.duplicate();
            } else {
                result = this.project.getFileSystem().getInputStream(mbe.getFileName());
                if (result instanceof ExtendedByteArrayInputStream) {
                    mbe.setData(result);
                }
            }
        }
        return result;
    }

    public MediaBagElement getImageElement(String name) throws Exception {
        String normalizedName = this.project.getFileSystem().getCanonicalNameOf(name);
        MediaBagElement result = this.registerElement(normalizedName, null);
        if (result != null) {
            result = result.prepareImage(this.project.getFileSystem()) ? result : null;
        }
        return result;
    }

    public void buildFonts() {
        HashMap<String, MediaBagElement> fonts = new HashMap<String, MediaBagElement>();
        for (MediaBagElement mbe : this.elements) {
            String name = mbe.getName();
            if (name == null || mbe.getData() != null || !mbe.getFileName().endsWith(".ttf")) continue;
            fonts.put(name, mbe);
        }
        if (!fonts.isEmpty()) {
            String[] fontList = FontCheck.getFontList(false);
            int nFontsList = fontList.length;
            for (String name : fonts.keySet()) {
                int i;
                for (i = 0; i < nFontsList && !fontList[i].equalsIgnoreCase(name); ++i) {
                }
                if (i != nFontsList) continue;
                MediaBagElement mbe = (MediaBagElement)fonts.get(name);
                try {
                    mbe.setData(FontCheck.buildNewFont(mbe.getFileName(), this, name));
                }
                catch (Exception ex) {
                    System.err.println("Unable to create font:\n" + ex);
                }
            }
        }
    }

    public Skin getSkinElement(String name, PlayStation ps) {
        block7: {
            if (name.startsWith("@")) {
                try {
                    return Skin.getSkin(name, this.project.getFileSystem(), ps);
                }
                catch (Exception e) {
                    System.err.println("Error loading skin \"" + name + "\":\n" + e);
                    break block7;
                }
            }
            String normalizedName = this.project.getFileSystem().getCanonicalNameOf(name);
            MediaBagElement mbe = this.registerElement(normalizedName, null);
            if (mbe != null) {
                if (mbe.getData() == null || !(mbe.getData() instanceof Skin)) {
                    try {
                        Skin sk = Skin.getSkin(mbe.getFileName(), this.project.getFileSystem(), ps);
                        mbe.setData(sk);
                    }
                    catch (Exception e) {
                        System.err.println("Error loading skin \"" + mbe.getFileName() + "\":\n" + e);
                    }
                }
                return (Skin)mbe.getData();
            }
        }
        return null;
    }

    public long getTotalFileSize() {
        long result = 0L;
        for (MediaBagElement mbe : this.elements) {
            result += mbe.getFileSize(this.project.getFileSystem());
        }
        return result;
    }

    public boolean isWaitingForImages() {
        for (MediaBagElement mbe : this.elements) {
            if (mbe == null || !mbe.isWaitingForImage()) continue;
            return true;
        }
        return false;
    }

    public void waitForAllImages() {
        while (this.isWaitingForImages()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                System.err.println("error waiting for images!\n" + ex);
                return;
            }
        }
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    public void addListener(Listener lst) {
        if (!this.listeners.contains(lst)) {
            this.listeners.add(lst);
        }
    }

    public void removeListener(Listener lst) {
        this.listeners.remove(lst);
    }

    public void listReferencesTo(String name, String type, Map<String, String> map) {
        Iterator<Listener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().listReferencesTo(name, type, map);
        }
    }

    public void setNormalizedFileNames() {
        HashSet<String> currentNames = new HashSet<String>();
        for (MediaBagElement mbe : this.elements) {
            String fn = mbe.getFileName();
            String fnv = FileSystem.getValidFileName(fn);
            if (fnv.charAt(0) == '.') {
                fnv = "_" + fnv;
            }
            if (!fnv.equals(fn)) {
                String fn0 = fnv;
                int n = 0;
                while (currentNames.contains(fnv)) {
                    fnv = Integer.toString(n++) + fn0;
                }
                mbe.normalizedFileName = fnv;
            }
            currentNames.add(fnv);
        }
    }

    public static interface Listener {
        public void listReferences(String var1, Map<String, String> var2);

        public void listReferencesTo(String var1, String var2, Map<String, String> var3);
    }
}

