/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.BoxBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public abstract class AbstractBox
extends Rectangle2D.Double
implements Cloneable {
    private AbstractBox parent;
    private JComponent container;
    private BoxBase boxBase;
    protected boolean border;
    protected Shape shape;
    protected boolean specialShape;
    private boolean visible;
    private boolean temporaryHidden;
    private boolean inactive;
    private boolean inverted;
    private boolean alternative;
    private boolean marked;
    private boolean focused;
    private Component hostedComponent;

    public AbstractBox(AbstractBox parent, JComponent container, BoxBase boxBase) {
        this.parent = parent;
        this.container = container;
        this.shape = this;
        this.specialShape = false;
        this.boxBase = boxBase;
        this.visible = true;
    }

    @Override
    public Object clone() {
        AbstractBox bx = (AbstractBox)super.clone();
        bx.shape = this.specialShape ? new Area(this.shape) : bx;
        if (this.hostedComponent != null) {
            if (this.hostedComponent instanceof JLabel) {
                JLabel lb = (JLabel)this.hostedComponent;
                bx.hostedComponent = new JLabel(lb.getText(), lb.getIcon(), lb.getHorizontalAlignment());
                JComponent jc = bx.getContainerResolve();
                if (jc != null) {
                    jc.add(this.hostedComponent);
                }
            } else {
                bx.hostedComponent = null;
            }
        }
        return bx;
    }

    public void setParent(AbstractBox parent) {
        this.parent = parent;
    }

    public AbstractBox getParent() {
        return this.parent;
    }

    public void end() {
        this.setHostedComponent(null);
    }

    public void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void setContainer(JComponent newContainer) {
        this.container = newContainer;
        if (this.hostedComponent != null) {
            if (this.hostedComponent.getParent() != null) {
                this.hostedComponent.getParent().remove(this.hostedComponent);
            }
            if (this.container != null) {
                this.container.add(this.hostedComponent);
            }
        }
    }

    public JComponent getContainerX() {
        return this.container;
    }

    public JComponent getContainerResolve() {
        AbstractBox ab = this;
        while (ab.container == null && ab.parent != null) {
            ab = ab.parent;
        }
        return ab.container;
    }

    public void setBoxBase(BoxBase boxBase) {
        this.boxBase = boxBase;
        this.repaint();
        this.setHostedComponentColors();
        this.setHostedComponentBorder();
    }

    public BoxBase getBoxBaseResolve() {
        AbstractBox ab = this;
        while (ab.boxBase == null && ab.parent != null) {
            ab = ab.parent;
        }
        return ab.boxBase == null ? BoxBase.DEFAULT_BOX_BASE : ab.boxBase;
    }

    public BoxBase getBoxBaseX() {
        return this.boxBase;
    }

    public void setHostedComponent(Component jc) {
        if (this.hostedComponent != null && this.hostedComponent.getParent() != null) {
            this.hostedComponent.getParent().remove(this.hostedComponent);
        }
        this.hostedComponent = jc;
        if (this.hostedComponent != null) {
            this.hostedComponent.setVisible(false);
            JComponent cmp = this.getContainerResolve();
            if (cmp != null) {
                cmp.add(jc);
            }
            this.setHostedComponentColors();
            this.setHostedComponentBorder();
            this.setHostedComponentBounds();
            this.hostedComponent.setVisible(this.visible);
        }
    }

    public Component getHostedComponent() {
        return this.hostedComponent;
    }

    public void setShape(Shape setSh) {
        this.shape = setSh;
        this.specialShape = true;
        this.repaint();
        super.setRect(this.shape.getBounds2D());
        this.setHostedComponentBounds();
        this.repaint();
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape == this ? super.contains(p) : this.shape.contains(p);
    }

    public boolean update(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        if (this.hostedComponent != null) {
            return false;
        }
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (dirtyRegion != null && !this.shape.intersects(dirtyRegion)) {
            return false;
        }
        Area saveClip = new Area(g2.getClip());
        Area clip = new Area(saveClip);
        clip.intersect(new Area(this.shape));
        g2.setClip(clip);
        BoxBase bb = this.getBoxBaseResolve();
        if (!bb.transparent) {
            if (bb.bgGradient == null || bb.bgGradient.hasTransparency()) {
                g2.setColor(this.inactive ? bb.inactiveColor : (this.inverted ? bb.textColor : bb.backColor));
                g2.fill(this.shape);
                g2.setColor(Color.black);
            }
            if (bb.bgGradient != null) {
                bb.bgGradient.paint(g2, this.shape);
            }
        }
        this.updateContent(g2, dirtyRegion, io);
        g2.setClip(saveClip);
        this.drawBorder(g2);
        return true;
    }

    public abstract boolean updateContent(Graphics2D var1, Rectangle var2, ImageObserver var3);

    protected void drawBorder(Graphics2D g2) {
        if (this.border || this.marked || this.focused) {
            BoxBase bb = this.getBoxBaseResolve();
            g2.setColor(bb.borderColor);
            g2.setStroke(this.marked || this.focused ? bb.getMarker() : bb.getBorder());
            if (this.marked || this.focused) {
                g2.setXORMode(Color.white);
            }
            g2.draw(this.shape);
            if (this.marked || this.focused) {
                g2.setPaintMode();
            }
            g2.setColor(Color.black);
            g2.setStroke(BoxBase.DEFAULT_STROKE);
        }
    }

    public Rectangle getBorderBounds() {
        if (!(this.border || this.marked || this.focused)) {
            return this.getBounds();
        }
        BoxBase bb = this.getBoxBaseResolve();
        Stroke strk = this.marked || this.focused ? bb.getMarker() : bb.getBorder();
        return strk.createStrokedShape(this.shape).getBounds();
    }

    public boolean hasBorder() {
        return this.border;
    }

    public void setBorder(boolean newVal) {
        if (!newVal) {
            this.repaint();
        }
        this.border = newVal;
        this.setHostedComponentBorder();
        if (newVal) {
            this.repaint();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVal) {
        this.visible = newVal;
        if (this.hostedComponent != null) {
            this.hostedComponent.setVisible(newVal);
        }
        this.repaint();
    }

    public boolean isTemporaryHidden() {
        return this.temporaryHidden;
    }

    public void setTemporaryHidden(boolean newVal) {
        this.temporaryHidden = newVal;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean newVal) {
        this.inactive = newVal;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean newVal) {
        this.inverted = newVal;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean newVal) {
        if (!newVal) {
            this.repaint();
        }
        this.marked = newVal;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        if (newVal) {
            this.repaint();
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean newVal) {
        if (!newVal) {
            this.repaint();
        }
        this.focused = newVal;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        if (newVal) {
            this.repaint();
        }
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public void setAlternative(boolean newVal) {
        this.alternative = newVal;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    private void setHostedComponentColors() {
        if (this.hostedComponent != null) {
            BoxBase bb = this.getBoxBaseResolve();
            this.hostedComponent.setFont(bb.getFont());
            this.hostedComponent.setBackground(this.inactive ? bb.inactiveColor : (this.inverted ? bb.textColor : bb.backColor));
            this.hostedComponent.setForeground(this.inverted ? bb.backColor : (this.alternative ? bb.alternativeColor : bb.textColor));
            if (this.hostedComponent instanceof JComponent) {
                ((JComponent)this.hostedComponent).setOpaque(true);
                if (this.hostedComponent instanceof JTextComponent) {
                    ((JTextComponent)this.hostedComponent).setCaretColor(bb.textColor);
                }
            }
        }
    }

    private void setHostedComponentBorder() {
        if (this.hostedComponent != null && this.hostedComponent instanceof JComponent) {
            ((JComponent)this.hostedComponent).setBorder(this.border ? BorderFactory.createLineBorder(this.getBoxBaseResolve().borderColor, 1) : BorderFactory.createEmptyBorder());
        }
    }

    private void setHostedComponentBounds() {
        if (this.hostedComponent != null) {
            Rectangle r = this.getBounds();
            this.hostedComponent.setBounds(r);
            if (this.hostedComponent instanceof JComponent) {
                ((JComponent)this.hostedComponent).setPreferredSize(r.getSize());
            }
        }
    }

    public void repaint() {
        JComponent jc = this.getContainerResolve();
        if (jc != null) {
            jc.repaint(this.getBorderBounds());
        }
        if (this.hostedComponent != null) {
            this.hostedComponent.repaint();
        }
    }

    public void setBounds(Rectangle2D r) {
        if (r.equals(this)) {
            return;
        }
        if (this.specialShape) {
            AffineTransform tx = null;
            if (this.getWidth() != r.getWidth() || this.getHeight() != r.getHeight()) {
                tx = AffineTransform.getTranslateInstance(-this.getX(), -this.getY());
                this.shape = tx.createTransformedShape(this.shape);
                tx = AffineTransform.getScaleInstance(r.getWidth() / this.getWidth(), r.getHeight() / this.getHeight());
                this.shape = tx.createTransformedShape(this.shape);
                tx = AffineTransform.getTranslateInstance(this.getX(), this.getY());
                this.shape = tx.createTransformedShape(this.shape);
            }
            if (this.getX() != r.getX() || this.getY() != r.getY()) {
                tx = AffineTransform.getTranslateInstance(r.getX() - this.getX(), r.getY() - this.getY());
                this.shape = tx.createTransformedShape(this.shape);
            }
            if (tx != null) {
                this.setShape(this.shape);
            }
        } else {
            this.repaint();
            this.setRect(r);
            this.repaint();
        }
        this.setHostedComponentBounds();
    }

    public void setBounds(double newX, double newY, double newWidth, double newHeight) {
        this.setBounds(new Rectangle2D.Double(newX, newY, newWidth, newHeight));
        this.setHostedComponentBounds();
    }

    public void setLocation(Point2D p) {
        this.setBounds(p.getX(), p.getY(), this.width, this.height);
    }

    public void setLocation(double newX, double newY) {
        this.setBounds(newX, newY, this.width, this.height);
    }

    public void translate(double dx, double dy) {
        this.setBounds(this.x + dx, this.y + dy, this.width, this.height);
    }

    public void setSize(Dimension2D d) {
        this.setBounds(this.x, this.y, d.getWidth(), d.getHeight());
    }

    public void setSize(double newWidth, double newHeight) {
        this.setBounds(this.x, this.y, newWidth, newHeight);
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.x, this.y);
    }

    protected void checkHostedComponent() {
    }

    public Point2D getAbsoluteLocation() {
        Point result = null;
        JComponent jc = this.getContainerResolve();
        if (jc != null) {
            result = new Point(jc.getLocationOnScreen());
            ((Point2D)result).setLocation(((Point2D)result).getX() + this.getX(), ((Point2D)result).getY() + this.getY());
        }
        return result;
    }

    public Point2D getAbsoulteMiddleLocation() {
        Point2D result = this.getAbsoluteLocation();
        if (result != null) {
            result.setLocation(result.getX() + this.getWidth() / 2.0, result.getY() + this.getHeight() / 2.0);
        }
        return result;
    }
}

