/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.text.AttributedString;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ActiveBox
extends AbstractBox
implements Cloneable {
    public static boolean compressImages = true;
    public static boolean USE_TRANSFORM = false;
    public int idOrder;
    public int idLoc;
    public int idAss;
    protected ActiveBoxContent content;
    protected ActiveBoxContent altContent;
    public boolean hasHostedComponent;
    protected ActiveMediaPlayer hostedMediaPlayer;

    public ActiveBox(AbstractBox parent, JComponent container, BoxBase boxBase) {
        super(parent, container, boxBase);
        this.clear();
        this.idLoc = -1;
        this.idOrder = -1;
        this.idAss = -1;
        this.hasHostedComponent = false;
    }

    public ActiveBox(AbstractBox parent, JComponent container, int setIdLoc, Rectangle2D r, BoxBase boxBase) {
        super(parent, container, boxBase);
        this.clear();
        this.idLoc = setIdLoc;
        this.setBounds(r);
    }

    public void setHostedMediaPlayer(ActiveMediaPlayer amp) {
        ActiveMediaPlayer old = this.hostedMediaPlayer;
        this.hostedMediaPlayer = amp;
        if (old != null && old != amp) {
            old.linkTo(null);
        }
    }

    public ActiveBoxContent getCurrentContent() {
        return this.isAlternative() ? this.altContent : this.content;
    }

    public ActiveBoxContent getContent() {
        if (this.content == null) {
            this.setContent(new ActiveBoxContent());
        }
        return this.content;
    }

    public void clear() {
        this.content = null;
        this.altContent = null;
        this.idOrder = -1;
        this.setInactive(true);
        if (!this.hasHostedComponent) {
            this.setHostedComponent(null);
        }
        this.setHostedMediaPlayer(null);
    }

    public boolean isEquivalent(ActiveBox bx, boolean checkCase) {
        return bx != null && this.content != null && this.content.isEquivalent(bx.content, checkCase);
    }

    public boolean isCurrentContentEquivalent(ActiveBox bx, boolean checkCase) {
        return bx != null && this.getCurrentContent() != null && this.getCurrentContent().isEquivalent(bx.getCurrentContent(), checkCase);
    }

    public void exchangeLocation(ActiveBox bx) {
        Point2D.Double pt = new Point2D.Double(this.x, this.y);
        int idLoc0 = this.idLoc;
        this.setLocation(bx.getLocation());
        bx.setLocation(pt);
        this.idLoc = bx.idLoc;
        bx.idLoc = idLoc0;
    }

    public void copyContent(ActiveBox bx) {
        this.idOrder = bx.idOrder;
        this.idAss = bx.idAss;
        this.content = bx.content;
        this.altContent = bx.altContent;
        if (this.content != null) {
            if (this.content.bb != null) {
                this.setBoxBase(this.content.bb);
            }
            if (this.content.border != null && bx.hasBorder() != this.content.border.booleanValue()) {
                this.setBorder(this.content.border);
            }
            if (this.content.img != null && this.content.animated) {
                Utils.refreshAnimatedImage(this.content.img);
            }
        }
        this.setInactive(bx.isInactive());
        this.setInverted(bx.isInverted());
        this.setAlternative(bx.isAlternative());
        this.setHostedComponent(bx.getHostedComponent());
        this.hasHostedComponent = bx.hasHostedComponent;
        this.setHostedMediaPlayer(bx.hostedMediaPlayer);
        if (this.hostedMediaPlayer != null) {
            this.hostedMediaPlayer.setVisualComponentVisible(!this.isInactive() && this.isVisible());
        }
    }

    public void exchangeContent(ActiveBox bx) {
        ActiveBox bx0 = new ActiveBox(this.getParent(), this.getContainerX(), this.getBoxBaseX());
        bx0.copyContent(this);
        this.copyContent(bx);
        bx.copyContent(bx0);
    }

    public void setTextContent(String tx) {
        if (tx == null) {
            tx = "";
        }
        if (this.content == null) {
            this.content = new ActiveBoxContent();
        }
        this.content.rawText = tx;
        this.content.text = tx;
        this.content.mediaContent = null;
        this.content.img = null;
        this.setHostedComponent(null);
        this.setInactive(false);
        this.checkHostedComponent();
        this.setHostedMediaPlayer(null);
    }

    public void setIdOrder(int newIdOrder) {
        this.idOrder = newIdOrder;
    }

    public void setIdAss(int newIdAss) {
        this.idAss = newIdAss;
    }

    public void setDefaultIdAss() {
        this.idAss = this.content == null ? -1 : this.content.id;
    }

    public boolean isAtPlace() {
        return this.idOrder == this.idLoc;
    }

    public void setContent(ActiveBoxContent abc) {
        this.setHostedComponent(null);
        this.setHostedMediaPlayer(null);
        this.content = abc;
        if (this.content != null) {
            if (this.content.bb != this.getBoxBaseX()) {
                this.setBoxBase(this.content.bb);
            }
            if (this.content.border != null && this.hasBorder() != this.content.border.booleanValue()) {
                this.setBorder(this.content.border);
            }
            this.setInactive(false);
            if (abc.img != null && abc.animated) {
                Utils.refreshAnimatedImage(abc.img);
            }
            this.checkHostedComponent();
            this.checkAutoStartMedia();
        } else {
            this.clear();
        }
    }

    public void checkAutoStartMedia() {
        ActiveBoxContent cnt = this.getContent();
        if (cnt != null && cnt.mediaContent != null && cnt.mediaContent.autoStart && cnt.amp != null) {
            final ActiveMediaPlayer amp = cnt.amp;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    amp.play(ActiveBox.this);
                }
            });
        }
    }

    public void setAltContent(ActiveBoxContent abc) {
        this.altContent = abc;
        this.checkHostedComponent();
        if (this.isAlternative() && this.hostedMediaPlayer != null) {
            this.setHostedMediaPlayer(null);
        }
    }

    public void setCurrentContent(ActiveBoxContent abc) {
        if (this.isAlternative()) {
            this.setAltContent(abc);
        } else {
            this.setContent(abc);
        }
        this.repaint();
    }

    public void setContent(ActiveBagContent abc, int i) {
        if (i < 0) {
            i = this.idOrder;
        }
        if (abc == null || i >= abc.getNumCells()) {
            return;
        }
        if (abc.bb != this.getBoxBaseX()) {
            this.setBoxBase(abc.bb);
        }
        this.setContent(abc.getActiveBoxContent(i));
    }

    public void setAltContent(ActiveBagContent abc, int i) {
        if (i < 0) {
            i = this.idOrder;
        }
        if (abc == null || abc.isEmpty() || i > abc.getNumCells()) {
            return;
        }
        this.setAltContent(abc.getActiveBoxContent(i));
    }

    public boolean switchToAlt(ResourceBridge rb) {
        if (this.isAlternative() || this.altContent == null || this.altContent.isEmpty()) {
            return false;
        }
        this.setHostedComponent(null);
        this.setHostedMediaPlayer(null);
        this.setAlternative(true);
        this.checkHostedComponent();
        this.checkAutoStartMedia();
        return true;
    }

    @Override
    protected void checkHostedComponent() {
        if (this.hasHostedComponent) {
            return;
        }
        ActiveBoxContent abc = this.getCurrentContent();
        BoxBase bb = this.getBoxBaseResolve();
        Component jc = null;
        if (!this.isInactive() && abc != null && abc.htmlText != null) {
            String s = abc.htmlText;
            if (abc.innerHtmlText != null) {
                Color backColor;
                Color color = this.isInactive() ? bb.inactiveColor : (backColor = this.isInverted() ? bb.textColor : bb.backColor);
                Color foreColor = this.isInverted() ? bb.backColor : (this.isAlternative() ? bb.alternativeColor : bb.textColor);
                Font f = bb.getOriginalFont();
                s = "<html><body bgcolor=\"#" + Integer.toHexString(backColor.getRGB() & 0xFFFFFF) + "\"><div style=\"background: #" + Integer.toHexString(backColor.getRGB() & 0xFFFFFF) + "; color: #" + Integer.toHexString(foreColor.getRGB() & 0xFFFFFF) + "; font-family: " + f.getFontName() + "; font-size: " + f.getSize() + "pt; " + (f.isBold() ? "font-weight: bold;" : "") + "text-align: " + (abc.txtAlign[0] == 0 ? "left" : (abc.txtAlign[0] == 2 ? "right" : "center")) + "; width: 100%; \">" + abc.innerHtmlText + "</div></body></html>";
            }
            if ((jc = this.getHostedComponent()) != null && jc instanceof JLabel) {
                ((JLabel)jc).setText(s);
                return;
            }
            jc = new JLabel(s);
        }
        this.setHostedComponent(jc);
    }

    @Override
    public boolean updateContent(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        ActiveBoxContent abc = this.getCurrentContent();
        BoxBase bb = this.getBoxBaseResolve();
        if (this.isInactive() || abc == null || this.width < 2.0 || this.height < 2.0) {
            return true;
        }
        Rectangle2D.Double imgRect = null;
        if (abc.img != null) {
            if (abc.imgClip != null) {
                Rectangle r = abc.imgClip.getBounds();
                if (USE_TRANSFORM) {
                    if (r.width > 0 && r.height > 0) {
                        AffineTransform at;
                        if ((double)r.width != this.width || (double)r.height != this.height) {
                            double sx = this.width / (double)r.width;
                            double sy = this.height / (double)r.height;
                            at = AffineTransform.getScaleInstance(sx, sy);
                            at.translate(this.x / sx - (double)r.x, this.y / sy - (double)r.y);
                        } else {
                            at = AffineTransform.getTranslateInstance(this.x - (double)r.x, this.y - (double)r.y);
                        }
                        g2.drawImage(abc.img, at, io);
                    }
                } else {
                    g2.drawImage(abc.img, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), r.x, r.y, r.x + r.width, r.y + r.height, io);
                }
            } else {
                double ys;
                double xs;
                double imgh;
                boolean compress = false;
                double imgw = abc.img.getWidth(io);
                if (imgw == 0.0) {
                    imgw = this.width;
                }
                if ((imgh = (double)abc.img.getHeight(io)) == 0.0) {
                    imgh = this.height;
                }
                double scale = 1.0;
                if (compressImages && this.width > 0.0 && this.height > 0.0 && (imgw > this.width || imgh > this.height)) {
                    scale = Math.min(this.width / imgw, this.height / imgh);
                    imgw *= scale;
                    imgh *= scale;
                    compress = true;
                }
                double d = abc.imgAlign[0] == 0 ? 0.0 : (xs = abc.imgAlign[0] == 2 ? this.width - imgw : (this.width - imgw) / 2.0);
                double d2 = abc.imgAlign[1] == 0 ? 0.0 : (ys = abc.imgAlign[1] == 2 ? this.height - imgh : (this.height - imgh) / 2.0);
                if (compress) {
                    if (USE_TRANSFORM) {
                        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
                        at.translate((this.x + xs) / scale, (this.y + ys) / scale);
                        g2.drawImage(abc.img, at, io);
                    } else {
                        g2.drawImage(abc.img, (int)(this.x + xs), (int)(this.y + ys), (int)imgw, (int)imgh, io);
                    }
                } else {
                    g2.drawImage(abc.img, (int)(this.x + xs), (int)(this.y + ys), io);
                }
                if (abc.avoidOverlapping && abc.text != null) {
                    imgRect = new Rectangle2D.Double(Math.max(0.0, xs), Math.max(0.0, ys), Math.min(this.width, imgw), Math.min(this.height, imgh));
                }
            }
        }
        if (abc.text != null && abc.text.length() > 0) {
            TextLayout layout;
            int rt;
            double h;
            LineBreakMeasurer lbm;
            double px = this.x;
            double py = this.y;
            double pWidth = this.width;
            double pHeight = this.height;
            if (imgRect != null) {
                double[] prx = new double[]{0.0, imgRect.x, imgRect.x + imgRect.width, pWidth};
                double[] pry = new double[]{0.0, imgRect.y, imgRect.y + imgRect.height, pHeight};
                Rectangle2D.Double[] rr = new Rectangle2D.Double[]{new Rectangle2D.Double(prx[0], pry[0], prx[3], pry[1]), new Rectangle2D.Double(prx[0], pry[2], prx[3], pry[3] - pry[2]), new Rectangle2D.Double(prx[0], pry[0], prx[1], pry[3]), new Rectangle2D.Double(prx[2], pry[0], prx[3] - prx[2], pry[3])};
                Rectangle2D.Double rmax = rr[0];
                double maxSurface = rmax.width * rmax.height;
                for (int i = 1; i < rr.length; ++i) {
                    double s = rr[i].width * rr[i].height;
                    if (!(s > maxSurface - 1.0)) continue;
                    if (Math.abs(s - maxSurface) <= 1.0) {
                        boolean b = false;
                        switch (i) {
                            case 1: {
                                b = abc.txtAlign[1] == 2;
                                break;
                            }
                            case 2: {
                                b = abc.txtAlign[0] == 0;
                                break;
                            }
                            case 3: {
                                boolean bl = b = abc.txtAlign[0] == 2;
                            }
                        }
                        if (!b) continue;
                    }
                    maxSurface = s;
                    rmax = rr[i];
                }
                px += rmax.x;
                py += rmax.y;
                pWidth = rmax.width;
                pHeight = rmax.height;
            }
            double ww = Math.max(5.0, pWidth - (double)(2 * bb.textMargin));
            FontRenderContext frc = g2.getFontRenderContext();
            int maxLines = StrUtils.countSpaces(abc.text) + 1;
            while (true) {
                AttributedString atext = new AttributedString(abc.text);
                atext.addAttribute(TextAttribute.FONT, bb.getFont());
                lbm = new LineBreakMeasurer(atext.getIterator(), frc);
                double w = 0.0;
                h = 0.0;
                double hl = 0.0;
                lbm.setPosition(0);
                rt = abc.text.indexOf(10);
                int i = 0;
                while (lbm.getPosition() < abc.text.length() && h < pHeight) {
                    if (rt > lbm.getPosition()) {
                        layout = lbm.nextLayout((float)ww, rt, false);
                        rt = abc.text.indexOf(10, lbm.getPosition());
                    } else {
                        layout = lbm.nextLayout((float)ww);
                    }
                    if (layout == null) break;
                    double wtl = layout.getVisibleAdvance();
                    if (wtl > w) {
                        w = wtl;
                    }
                    hl = layout.getLeading();
                    h += (double)(layout.getAscent() + layout.getDescent()) + hl;
                    ++i;
                }
                if ((h -= hl) <= pHeight && i <= maxLines || !bb.reduceFont()) break;
                JComponent jc = this.getContainerResolve();
                if (jc == null) continue;
                RepaintManager.currentManager(jc).markCompletelyDirty(jc);
            }
            double dy = py + (abc.txtAlign[1] == 0 ? 0.0 : (abc.txtAlign[1] == 2 ? pHeight - h : (pHeight - h) / 2.0));
            g2.setColor(this.isInverted() ? bb.backColor : (this.isAlternative() ? bb.alternativeColor : bb.textColor));
            lbm.setPosition(0);
            rt = abc.text.indexOf(10);
            for (h = 0.0; lbm.getPosition() < abc.text.length() && h < pHeight; h += (double)(layout.getDescent() + layout.getLeading())) {
                if (rt > lbm.getPosition()) {
                    layout = lbm.nextLayout((float)ww, rt, false);
                    rt = abc.text.indexOf(10, lbm.getPosition());
                } else {
                    layout = lbm.nextLayout((float)ww);
                }
                if (layout == null) break;
                double wtl = layout.getVisibleAdvance();
                double dx = px + (double)bb.textMargin + (abc.txtAlign[0] == 0 ? 0.0 : (abc.txtAlign[0] == 2 ? ww - wtl : (ww - wtl) / 2.0));
                h += (double)layout.getAscent();
                if (bb.shadow) {
                    g2.setColor(bb.shadowColor);
                    layout.draw(g2, (float)(dx + (double)(bb.getDynFontSize() / 10.0f)), (float)(dy + h + (double)(bb.getDynFontSize() / 10.0f)));
                    g2.setColor(this.isInverted() ? bb.backColor : (this.isAlternative() ? bb.alternativeColor : bb.textColor));
                }
                layout.draw(g2, (float)dx, (float)(dy + h));
            }
        }
        return true;
    }

    public boolean playMedia(PlayStation ps) {
        ActiveBoxContent abc = this.getCurrentContent();
        if (abc != null) {
            if (abc.animated) {
                Utils.refreshAnimatedImage(abc.img);
                this.repaint();
            }
            if (abc.mediaContent != null) {
                ps.playMedia(abc.mediaContent, this);
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.content == null ? "" : this.content.getDescription();
    }

    @Override
    public void setBounds(Rectangle2D r) {
        super.setBounds(r);
        if (this.hostedMediaPlayer != null) {
            this.hostedMediaPlayer.checkVisualComponentBounds(this);
        }
    }

    @Override
    public void end() {
        this.clear();
        super.end();
    }

    public static void checkOptions(Options options) {
        if (!options.getBoolean("java14") && options.getBoolean("Mac")) {
            USE_TRANSFORM = true;
        }
    }
}

