/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class ActiveBoxBag
extends BoxBag
implements Cloneable {
    private static final int NOT_USED = -12345;

    public ActiveBoxBag(AbstractBox parent, JComponent container, BoxBase boxBase) {
        super(parent, container, boxBase);
    }

    public final void addActiveBox(ActiveBox bx) {
        bx.idOrder = bx.idLoc = this.cells.size();
        super.addBox(bx);
    }

    public ActiveBox getActiveBox(int idLoc) {
        return (ActiveBox)super.getBox(idLoc);
    }

    public ActiveBox getBackgroundActiveBox() {
        return (ActiveBox)this.getBackgroundBox();
    }

    public void setContent(ActiveBagContent abc) {
        this.setContent(abc, null);
    }

    public void setContent(ActiveBagContent abc, ActiveBagContent altAbc) {
        this.setContent(abc, altAbc, 0, 0, this.getNumCells());
    }

    public void setContent(ActiveBagContent abc, ActiveBagContent altAbc, int fromIndex, int toCell, int numCells) {
        ActiveBox bx;
        for (int i = 0; i < numCells; ++i) {
            bx = this.getActiveBox(toCell + i);
            bx.setContent(abc, fromIndex + i);
            bx.setAlternative(false);
            if (altAbc == null) continue;
            bx.setAltContent(altAbc, fromIndex + i);
        }
        if (abc.backgroundContent != null && (bx = this.getBackgroundActiveBox()) != null) {
            bx.setContent(abc.backgroundContent);
            if (abc.bb != bx.getBoxBaseX()) {
                bx.setBoxBase(abc.bb);
            }
        }
    }

    public ActiveBox findActiveBox(Point2D p) {
        return (ActiveBox)super.findBox(p);
    }

    public void clearAll() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getActiveBox(i).clear();
        }
        if (this.backgroundBox != null) {
            this.getBackgroundActiveBox().clear();
        }
    }

    public int countCellsAtPlace() {
        int cellsAtPlace = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getActiveBox(i).isAtPlace()) continue;
            ++cellsAtPlace;
        }
        return cellsAtPlace;
    }

    public ActiveBox getActiveBoxWithIdLoc(int idLoc) {
        for (int i = 0; i < this.cells.size(); ++i) {
            ActiveBox bx = this.getActiveBox(i);
            if (bx.idLoc != idLoc) continue;
            return bx;
        }
        return null;
    }

    public boolean cellIsAtEquivalentPlace(ActiveBox bx, boolean checkCase) {
        return bx.isAtPlace() || bx.isEquivalent(this.getActiveBoxWithIdLoc(bx.idOrder), checkCase);
    }

    public int countCellsAtEquivalentPlace(boolean checkCase) {
        int cellsAtPlace = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.cellIsAtEquivalentPlace(this.getActiveBox(i), checkCase)) continue;
            ++cellsAtPlace;
        }
        return cellsAtPlace;
    }

    public int countCellsWithIdAss(int idAss) {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (this.getActiveBox((int)i).idAss != idAss) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int countInactiveCells() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getActiveBox(i).isInactive()) continue;
            ++n;
        }
        return n;
    }

    public void setDefaultIdAss() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getActiveBox(i).setDefaultIdAss();
        }
    }

    public void scrambleCells(int times, boolean fitInArea) {
        int nc = this.cells.size();
        if (nc >= 2) {
            Point2D[] pos = new Point2D[nc];
            int[] idLoc = new int[nc];
            for (int i = 0; i < nc; ++i) {
                ActiveBox bx = this.getActiveBox(i);
                pos[i] = new Point2D.Double();
                pos[i].setLocation(bx.getLocation());
                idLoc[i] = bx.idLoc;
            }
            Point2D.Double p = new Point2D.Double();
            for (int i = 0; i < times; ++i) {
                int r2;
                int r1 = (int)(Math.random() * (double)nc);
                if (r1 == (r2 = (int)(Math.random() * (double)nc))) continue;
                p.setLocation(pos[r1]);
                pos[r1].setLocation(pos[r2]);
                pos[r2].setLocation(p);
                int j = idLoc[r1];
                idLoc[r1] = idLoc[r2];
                idLoc[r2] = j;
            }
            double maxX = this.x + this.width;
            double maxY = this.y + this.height;
            for (int i = 0; i < nc; ++i) {
                ActiveBox bx = this.getActiveBox(i);
                double px = pos[i].getX();
                double py = pos[i].getY();
                if (fitInArea) {
                    px = Math.min(Math.max(px, this.x), maxX - bx.width);
                    py = Math.min(Math.max(py, this.y), maxY - bx.height);
                }
                bx.setLocation(px, py);
                bx.idLoc = idLoc[i];
            }
        }
    }

    public void resetIds() {
        for (int i = 0; i < this.cells.size(); ++i) {
            ActiveBox bx = (ActiveBox)this.cells.get(i);
            if (bx == null) continue;
            bx.idOrder = i;
            bx.idAss = i;
            bx.idLoc = i;
        }
    }

    public int getNextItem(int currentItem) {
        return this.getNextItem(currentItem, -12345);
    }

    public int getNextItem(int currentItem, int idAssValid) {
        ActiveBox bx;
        int i;
        for (i = currentItem + 1; i < this.cells.size() && (bx = (ActiveBox)this.cells.get(i)) != null && !(idAssValid != -12345 ? idAssValid == bx.idAss : bx.idAss >= 0); ++i) {
        }
        return i;
    }
}

