/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.SystemColor;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class Editor
extends DefaultMutableTreeNode {
    protected HashSet<EditorListener> listeners = new HashSet();
    protected DefaultTreeModel treeModel;
    protected JTree currentTree;
    protected ListSelectionModel listSelectionModel;
    protected LModel listModel;
    private boolean modified;
    public static EditorAction moveUpAction;
    public static EditorAction moveDownAction;
    public static EditorAction copyAction;
    public static EditorAction cutAction;
    public static EditorAction pasteAction;
    public static EditorAction deleteAction;
    protected static Editor clip;
    protected static boolean clipCutted;
    protected static boolean basicActionsCreated;
    protected boolean restrictMoveToSameType = true;
    protected boolean allowCopy = false;
    protected boolean allowCut = false;
    protected boolean allowPaste = false;
    protected boolean allowDelete = false;

    protected Editor(Object data) {
        super(data);
    }

    public static Editor createEditor(String className, Object data, Editor parent) {
        Editor result = null;
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?>[] constructors = cl.getDeclaredConstructors();
            Constructor<?> cn = null;
            for (Constructor<?> constr : constructors) {
                Class<?>[] parameters = constr.getParameterTypes();
                if (parameters == null || parameters.length != 1 || !parameters[0].isInstance(data)) continue;
                cn = constr;
                break;
            }
            if (cn == null) {
                throw new Exception();
            }
            result = (Editor)cn.newInstance(data);
            if (result == null) {
                throw new Exception();
            }
            if (parent != null) {
                parent.add(result);
            }
            result.createChildren();
        }
        catch (Exception ex) {
            System.err.println("Unable to create " + className + " for " + data + "\n" + ex);
        }
        return result;
    }

    protected abstract void createChildren();

    public String getTitleKey() {
        return "edit_data";
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        if (modified) {
            Editor ed = this.getEditorParent();
            if (ed != null) {
                ed.setModified(true);
            }
        } else {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                ((Editor)en.nextElement()).setModified(false);
            }
        }
    }

    public DefaultTreeModel getTreeModel() {
        if (this.isRoot()) {
            if (this.treeModel == null) {
                this.setTreeModel(new DefaultTreeModel(this));
            }
            return this.treeModel;
        }
        return this.treeModel != null ? this.treeModel : this.getEditorParent().getTreeModel();
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void setCurrentTree(JTree currentTree) {
        this.currentTree = currentTree;
    }

    public JTree getCurrentTree() {
        return this.currentTree != null ? this.currentTree : (this.isRoot() ? null : this.getEditorParent().getCurrentTree());
    }

    public JTree createJTree() {
        this.setCurrentTree(new JTree(this.getTreeModel()));
        this.currentTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof Editor) {
                    Icon icon = ((Editor)value).getIcon(leaf, expanded);
                    if (icon != null) {
                        this.setIcon(icon);
                    }
                    if (clip == value && clipCutted) {
                        this.setForeground(SystemColor.textInactiveText);
                    }
                }
                return this;
            }
        });
        return this.currentTree;
    }

    public AbstractListModel<Object> getListModel() {
        if (this.listModel == null) {
            this.listModel = new LModel();
        }
        return this.listModel;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (this.listModel != null) {
            this.listModel.fireIntervalAdded(this.listModel, childIndex, childIndex);
        }
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        if (this.listModel != null) {
            this.listModel.fireIntervalRemoved(this.listModel, childIndex, childIndex);
        }
    }

    public void select() {
        int index;
        Editor p;
        JTree tree = this.getCurrentTree();
        if (tree != null) {
            tree.getSelectionModel().setSelectionPath(new TreePath(this.getPath()));
        }
        if (this.getListSelectionModel() != null && (p = this.getEditorParent()) != null && (index = p.getIndex(this)) >= 0) {
            this.getListSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void reselect() {
        int index;
        Editor p;
        JTree tree = this.getCurrentTree();
        if (tree != null) {
            tree.getSelectionModel().clearSelection();
            tree.getSelectionModel().setSelectionPath(new TreePath(this.getPath()));
        }
        if (this.getListSelectionModel() != null && (p = this.getEditorParent()) != null && (index = p.getIndex(this)) >= 0) {
            this.getListSelectionModel().removeIndexInterval(index, index);
            this.getListSelectionModel().setSelectionInterval(index, index);
        }
    }

    public int getNearestIndex(Editor fromChild, boolean down) {
        int p;
        int result;
        int n = result = down ? this.getChildCount() : 0;
        if (fromChild != null && (p = this.getIndex(fromChild)) >= 0) {
            result = p + (down ? 1 : 0);
        }
        return result;
    }

    protected boolean canClone() {
        return false;
    }

    protected Editor getClone() throws Exception {
        return null;
    }

    protected boolean delete(boolean changeSelection) {
        boolean result = false;
        Editor p = this.getEditorParent();
        if (p != null) {
            int index;
            p.setModified(true);
            if (clip == this) {
                Editor.setClip(null, false);
            }
            if ((index = p.getIndex(this)) == p.getChildCount() - 1) {
                --index;
            }
            this.getTreeModel().removeNodeFromParent(this);
            if (changeSelection) {
                Editor sel;
                Editor editor = sel = index >= 0 ? (Editor)p.getChildAt(index) : p;
                if (sel != null) {
                    sel.select();
                }
            }
            if (index < 0) {
                p.setActionsOwner();
            }
            result = true;
        }
        return result;
    }

    public boolean moveToIndex(int index, boolean updateSelection) {
        boolean result = false;
        DefaultTreeModel model = this.getTreeModel();
        Editor p = this.getEditorParent();
        if (p != null && model != null && (index = Math.min(Math.max(0, index), p.getChildCount())) != p.getIndex(this)) {
            p.setModified(true);
            model.removeNodeFromParent(this);
            model.insertNodeInto(this, p, index);
            result = true;
            if (updateSelection) {
                this.select();
            }
        }
        return result;
    }

    public boolean moveUp(boolean updateSelection) {
        boolean result = false;
        Editor p = this.getEditorParent();
        if (p != null) {
            int index = this.parent.getIndex(this);
            result = this.moveToIndex(index - 1, updateSelection);
        }
        return result;
    }

    public boolean moveDown(boolean updateSelection) {
        boolean result = false;
        Editor p = this.getEditorParent();
        if (p != null) {
            int index = this.parent.getIndex(this);
            result = this.moveToIndex(index + 1, updateSelection);
        }
        return result;
    }

    public boolean copy() {
        boolean result = false;
        if (this.allowCopy && this.canClone()) {
            Editor.setClip(this, false);
            result = true;
        }
        return result;
    }

    protected static void setClip(Editor e, boolean cutted) {
        if (clip != null) {
            Editor c = clip;
            clip = null;
            clipCutted = false;
            c.getTreeModel().nodeChanged(c);
        }
        clip = e;
        clipCutted = cutted;
        if (clip != null) {
            clip.getTreeModel().nodeChanged(clip);
        }
    }

    public boolean cut() {
        boolean result = false;
        if (this.allowCut) {
            Editor.setClip(this, true);
            result = true;
        }
        return result;
    }

    public boolean canBeParentOf(Editor e) {
        return !this.getClass().isInstance(e);
    }

    public boolean canBeSiblingOf(Editor e) {
        return true;
    }

    public boolean insertEditor(Editor e, boolean asChild, int index, boolean updateSelection) {
        boolean result = false;
        if (e != null) {
            if (asChild) {
                this.setModified(true);
                if (index < 0) {
                    index = this.getChildCount();
                }
                this.getTreeModel().insertNodeInto(e, this, index);
                result = true;
                if (updateSelection) {
                    e.select();
                }
            } else {
                Editor p = this.getEditorParent();
                if (p != null) {
                    p.setModified(true);
                    if (index < 0) {
                        index = p.getIndex(this);
                    }
                    result = p.insertEditor(e, true, index, updateSelection);
                }
            }
        }
        return result;
    }

    protected boolean canPasteHere() {
        return !(!this.allowPaste || clip == null || clipCutted && clip == this || !clipCutted && !clip.canClone() || !this.canBeParentOf(clip) && (!this.canBeSiblingOf(clip) || this.getEditorParent() == null));
    }

    public boolean paste(boolean updateSelection) {
        boolean result = false;
        if (this.canPasteHere()) {
            Editor c = clip;
            if (clipCutted) {
                clip.delete(false);
            } else {
                try {
                    c = clip.getClone();
                }
                catch (Exception ex) {
                    System.err.println("Unable to clone " + clip + "\n" + ex);
                    return false;
                }
            }
            result = this.insertEditor(c, this.canBeParentOf(c), -1, updateSelection);
            if (result) {
                Editor.setClip(clipCutted ? null : c, false);
                if (updateSelection) {
                    c.select();
                }
            }
        }
        return result;
    }

    public Icon getIcon(boolean leaf, boolean expanded) {
        return null;
    }

    public Editor getEditorParent() {
        return (Editor)this.getParent();
    }

    public Editor getFirstParent(Class cl) {
        Editor result = this.getEditorParent();
        if (result != null && !cl.isInstance(result)) {
            result = result.getFirstParent(cl);
        }
        return result;
    }

    public Editor getFirstChild(Class cl) {
        Editor result = null;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            Editor ed = (Editor)en.nextElement();
            if (!cl.isInstance(ed)) continue;
            result = ed;
            break;
        }
        return result;
    }

    public Object getFirstObject(Class cl) {
        Object result = this.getUserObject();
        if (!(result != null && cl.isInstance(result) || this.isRoot())) {
            result = this.getEditorParent().getFirstObject(cl);
        }
        return result;
    }

    public abstract Class getEditorPanelClass();

    public abstract EditorPanel createEditorPanel(Options var1);

    @Override
    public String toString() {
        return "generic Editor component";
    }

    public Editor getChildByName(String name) {
        Editor result = null;
        if (name != null) {
            Enumeration<TreeNode> en = this.children();
            while (result == null && en.hasMoreElements()) {
                Editor e = (Editor)en.nextElement();
                if (!name.equals(e.toString())) continue;
                result = e;
            }
        }
        return result;
    }

    public static void createBasicActions(Options options) {
        if (!basicActionsCreated) {
            moveUpAction = new EditorAction("editor_moveUp", "icons/up.gif", "editor_moveUp_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    e.moveUp(true);
                }
            };
            moveDownAction = new EditorAction("editor_moveDown", "icons/down.gif", "editor_moveDown_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    e.moveDown(true);
                }
            };
            copyAction = new EditorAction("COPY", "icons/copy.gif", "COPY", options){

                @Override
                protected void doAction(Editor e) {
                    e.copy();
                }
            };
            cutAction = new EditorAction("CUT", "icons/cut.gif", "CUT", options){

                @Override
                protected void doAction(Editor e) {
                    e.cut();
                }
            };
            pasteAction = new EditorAction("PASTE", "icons/paste.gif", "PASTE", options){

                @Override
                protected void doAction(Editor e) {
                    e.paste(true);
                }
            };
            deleteAction = new EditorAction("DELETE", "icons/delete.gif", "DELETE", options){

                @Override
                protected void doAction(Editor e) {
                    e.delete(true);
                }
            };
            basicActionsCreated = true;
        }
    }

    public static void clearBasicActionsOwner() {
        if (basicActionsCreated) {
            moveUpAction.setActionOwner(null);
            moveDownAction.setActionOwner(null);
            copyAction.setActionOwner(null);
            cutAction.setActionOwner(null);
            pasteAction.setActionOwner(null);
            deleteAction.setActionOwner(null);
        }
    }

    public void setActionsOwner() {
        if (basicActionsCreated) {
            boolean eUp = false;
            boolean eDown = false;
            Editor p = this.getEditorParent();
            if (p != null) {
                int i = p.getIndex(this);
                eUp = i > 0;
                boolean bl = eDown = i < p.getChildCount() - 1;
                if (this.restrictMoveToSameType) {
                    eUp = eUp && this.getClass().isInstance(p.getChildAt(i - 1));
                    eDown = eDown && this.getClass().isInstance(p.getChildAt(i + 1));
                }
            }
            moveUpAction.setActionOwner(eUp ? this : null);
            moveDownAction.setActionOwner(eDown ? this : null);
            copyAction.setActionOwner(this.allowCopy && this.canClone() ? this : null);
            cutAction.setActionOwner(this.allowCut ? this : null);
            pasteAction.setActionOwner(this.canPasteHere() ? this : null);
            deleteAction.setActionOwner(this.allowDelete ? this : null);
        }
    }

    public void clearActionsOwner() {
        Editor.clearBasicActionsOwner();
    }

    protected static Component findParentForDlg(AWTEvent ev) {
        if (ev != null && ev.getSource() instanceof Component) {
            return (Component)ev.getSource();
        }
        return null;
    }

    public void addEditorListener(EditorListener ls) {
        this.listeners.add(ls);
    }

    public void removeEditorListener(EditorListener ls) {
        this.listeners.remove(ls);
    }

    public void fireEditorDataChanged(EditorListener agent) {
        this.setModified(true);
        DefaultTreeModel tm = this.getTreeModel();
        if (tm != null) {
            tm.nodeChanged(this);
        }
        for (EditorListener ls : this.listeners) {
            if (ls == agent) continue;
            ls.editorDataChanged(this);
        }
    }

    public void collectData() {
        for (EditorListener o : this.listeners) {
            if (!(o instanceof EditorPanel)) continue;
            ((EditorPanel)o).save();
            break;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode tn = this.getChildAt(i);
            if (!(tn instanceof Editor)) continue;
            ((Editor)tn).collectData();
        }
    }

    public ListSelectionModel getListSelectionModel() {
        ListSelectionModel result = this.listSelectionModel;
        if (result == null && this.getEditorParent() != null) {
            result = this.getEditorParent().getListSelectionModel();
        }
        return result;
    }

    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        this.listSelectionModel = listSelectionModel;
    }

    public boolean editData(Component parent, Options options) {
        boolean result = false;
        EditorPanel panel = this.createEditorPanel(options);
        if (panel != null) {
            panel.attachEditor(this, false);
            result = options.getMessages().showInputDlg(parent, panel, this.getTitleKey());
            panel.attachEditor(null, result);
            if (result) {
                this.setModified(true);
            }
        }
        return result;
    }

    static {
        basicActionsCreated = false;
    }

    public static interface EditorListener {
        public void editorDataChanged(Editor var1);
    }

    protected class LModel
    extends AbstractListModel<Object> {
        protected LModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return index >= 0 && index < Editor.this.getChildCount() ? Editor.this.getChildAt(index) : null;
        }

        @Override
        public int getSize() {
            return Editor.this.getChildCount();
        }

        @Override
        public void fireIntervalAdded(Object src, int index0, int index1) {
            super.fireIntervalAdded(src, index0, index1);
        }

        @Override
        public void fireIntervalRemoved(Object src, int index0, int index1) {
            super.fireIntervalRemoved(src, index0, index1);
        }

        @Override
        public void fireContentsChanged(Object src, int index0, int index1) {
            super.fireContentsChanged(src, index0, index1);
        }
    }
}

