/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class EditorTreePanel
extends JPanel
implements TreeSelectionListener {
    Options options;
    public Editor currentItem;
    protected Map<Class, EditorPanel> editPanels;
    protected boolean onlySelect;
    protected Class selectable;
    protected EditorPanel currentPanel;
    protected JTree tree;
    protected JPanel edit;
    protected Editor root;

    public EditorTreePanel(Editor root, Options options, boolean onlySelect, Class selectable) {
        super(new BorderLayout());
        this.options = options;
        this.onlySelect = onlySelect;
        this.selectable = selectable;
        this.root = root;
        this.editPanels = new HashMap<Class, EditorPanel>();
        this.init();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setRootEditor(Editor root) {
        this.root = root;
        this.tree.setModel(root.getTreeModel());
        root.setCurrentTree(this.tree);
    }

    protected void init() {
        this.tree = this.root.createJTree();
        if (this.onlySelect && this.selectable != null) {
            this.tree.setSelectionModel(new DefaultTreeSelectionModel(){

                @Override
                public void setSelectionPath(TreePath path) {
                    Object u;
                    Object o = path.getLastPathComponent();
                    if (o instanceof Editor && EditorTreePanel.this.selectable.isInstance(u = ((Editor)o).getUserObject())) {
                        super.setSelectionPath(path);
                        return;
                    }
                    this.resetRowSelection();
                }
            });
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        if (this.onlySelect) {
            JScrollPane scroll = new JScrollPane(this.tree);
            scroll.setPreferredSize(new Dimension(250, 300));
            this.add((Component)scroll, "Center");
        } else {
            this.edit = new JPanel();
            this.edit.setLayout(new BorderLayout());
            this.edit.setPreferredSize(new Dimension(250, 300));
            JSplitPane split = new JSplitPane(1, false, new JScrollPane(this.tree), this.edit);
            split.setResizeWeight(1.0);
            split.setPreferredSize(new Dimension(520, 300));
            this.add((Component)split, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorTreePanel.this.tree.setSelectionInterval(0, 0);
                }
            });
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.currentItem = null;
        Editor node = (Editor)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.currentItem = node;
        this.currentItemChanged();
    }

    protected void currentItemChanged() {
        if (this.edit != null) {
            Class pc;
            EditorPanel ep;
            if (this.currentPanel != null) {
                this.currentPanel.removeEditor(true);
            }
            if ((ep = this.editPanels.get(pc = this.currentItem.getEditorPanelClass())) == null) {
                ep = this.currentItem.createEditorPanel(this.options);
                this.editPanels.put(pc, ep);
            }
            ep.attachEditor(this.currentItem, true);
            if (this.currentPanel != ep) {
                if (this.currentPanel != null) {
                    this.edit.remove(this.currentPanel);
                }
                this.edit.add((Component)ep, "Center");
                this.edit.revalidate();
                this.edit.repaint();
            }
            this.currentPanel = ep;
        }
    }

    public EditorPanel getCurrentPanel() {
        return this.currentPanel;
    }
}

